/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.maven;

import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.modeshape.common.SystemFailureException;
import org.modeshape.maven.ArtifactType;
import org.modeshape.maven.MavenDependency;
import org.modeshape.maven.MavenI18n;
import org.modeshape.maven.MavenId;
import org.modeshape.maven.MavenRepository;

class MavenClassLoaders {
    private final MavenRepository repository;
    private final Lock lock = new ReentrantLock();
    private final Map<MavenId, ProjectClassLoader> projectClassLoaders = new HashMap<MavenId, ProjectClassLoader>();

    MavenClassLoaders(MavenRepository repository) {
        this.repository = repository;
    }

    protected ProjectClassLoader getProjectClassLoader(MavenId mavenId) {
        ProjectClassLoader result = null;
        try {
            block4: {
                try {
                    this.lock.lock();
                    result = this.projectClassLoaders.get(mavenId);
                    if (result != null) break block4;
                    URL jarFileUrl = this.repository.getUrl(mavenId, ArtifactType.JAR, null);
                    URLClassLoader jarFileLoader = new URLClassLoader(new URL[]{jarFileUrl}, null);
                    List<MavenDependency> dependencies = this.repository.getDependencies(mavenId);
                    result = new ProjectClassLoader(mavenId, jarFileLoader);
                    result.setDependencies(dependencies);
                    this.projectClassLoaders.put(mavenId, result);
                }
                catch (MalformedURLException e) {
                    throw new SystemFailureException(MavenI18n.errorGettingUrlForMavenProject.text(new Object[]{mavenId}), (Throwable)e);
                }
            }
            Object var7_7 = null;
            this.lock.unlock();
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            this.lock.unlock();
            throw throwable;
        }
        return result;
    }

    public ProjectClassLoader getClassLoader(ClassLoader parent, MavenId ... mavenIds) {
        if (parent == null) {
            parent = Thread.currentThread().getContextClassLoader();
        }
        if (parent == null) {
            parent = this.getClass().getClassLoader();
        }
        ProjectClassLoader result = new ProjectClassLoader(parent);
        ArrayList<MavenDependency> dependencies = new ArrayList<MavenDependency>();
        for (MavenId mavenId : mavenIds) {
            if (dependencies.contains(mavenId)) continue;
            MavenDependency dependency = new MavenDependency(mavenId);
            dependencies.add(dependency);
        }
        result.setDependencies(dependencies);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyChangeInDependencies(MavenId mavenId) {
        List<MavenDependency> dependencies = this.repository.getDependencies(mavenId);
        try {
            this.lock.lock();
            ProjectClassLoader existingLoader = this.projectClassLoaders.get(mavenId);
            if (existingLoader != null) {
                existingLoader.setDependencies(dependencies);
            }
            Object var5_4 = null;
            this.lock.unlock();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.lock.unlock();
            throw throwable;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class ProjectClassLoader
    extends ClassLoader {
        private final MavenId mavenId;
        private final URLClassLoader jarFileClassLoader;
        private final Map<MavenId, ProjectClassLoader> dependencies;
        private final Map<MavenId, Set<MavenId>> exclusions;
        private final ReadWriteLock dependencyLock;

        protected ProjectClassLoader(MavenId mavenId, URLClassLoader jarFileClassLoader) {
            super(null);
            this.dependencies = new LinkedHashMap<MavenId, ProjectClassLoader>();
            this.exclusions = new HashMap<MavenId, Set<MavenId>>();
            this.dependencyLock = new ReentrantReadWriteLock();
            this.mavenId = mavenId;
            this.jarFileClassLoader = jarFileClassLoader;
        }

        protected ProjectClassLoader(ClassLoader parent) {
            super(parent);
            this.dependencies = new LinkedHashMap<MavenId, ProjectClassLoader>();
            this.exclusions = new HashMap<MavenId, Set<MavenId>>();
            this.dependencyLock = new ReentrantReadWriteLock();
            this.mavenId = null;
            this.jarFileClassLoader = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void setDependencies(List<MavenDependency> dependencies) {
            try {
                this.dependencyLock.writeLock().lock();
                this.dependencies.clear();
                if (dependencies != null) {
                    for (MavenDependency dependency : dependencies) {
                        ProjectClassLoader dependencyClassLoader = MavenClassLoaders.this.getProjectClassLoader(dependency.getId());
                        if (dependencyClassLoader == null) continue;
                        MavenId dependencyId = dependency.getId();
                        this.dependencies.put(dependencyId, dependencyClassLoader);
                        this.exclusions.put(dependencyId, Collections.unmodifiableSet(dependency.getExclusions()));
                    }
                }
                Object var7_6 = null;
                this.dependencyLock.writeLock().unlock();
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                this.dependencyLock.writeLock().unlock();
                throw throwable;
            }
        }

        @Override
        protected URL findResource(String name) {
            return this.findResource(name, (List<MavenId>)null);
        }

        protected URL findResource(String name, List<MavenId> debugSearchPath) {
            HashSet<MavenId> processed = new HashSet<MavenId>();
            URL result = null;
            if (this.jarFileClassLoader != null) {
                result = this.jarFileClassLoader.getResource(name);
                processed.add(this.mavenId);
            }
            if (debugSearchPath != null && this.mavenId != null) {
                debugSearchPath.add(this.mavenId);
            }
            if (result == null) {
                result = this.findResource(name, processed, null, debugSearchPath);
            }
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected URL findResource(String name, Set<MavenId> processed, Set<MavenId> exclusions, List<MavenId> debugSearchPath) {
            if (exclusions != null && exclusions.contains(this.mavenId)) {
                return null;
            }
            URL result = null;
            try {
                this.dependencyLock.readLock().lock();
                for (Map.Entry<MavenId, ProjectClassLoader> entry : this.dependencies.entrySet()) {
                    ProjectClassLoader loader = entry.getValue();
                    MavenId id = loader.mavenId;
                    if (processed.contains(id) || exclusions != null && exclusions.contains(id)) continue;
                    result = loader.jarFileClassLoader.findResource(name);
                    processed.add(id);
                    if (debugSearchPath != null && id != null) {
                        debugSearchPath.add(id);
                    }
                    if (result == null) continue;
                    break;
                }
                if (result == null) {
                    for (Map.Entry<MavenId, ProjectClassLoader> entry : this.dependencies.entrySet()) {
                        MavenId dependency = entry.getKey();
                        ProjectClassLoader loader = entry.getValue();
                        Set<MavenId> dependencyExclusions = this.exclusions.get(dependency);
                        if (!dependencyExclusions.isEmpty()) {
                            exclusions = exclusions == null ? new HashSet<MavenId>() : new HashSet<MavenId>(exclusions);
                            exclusions.addAll(dependencyExclusions);
                        }
                        if ((result = loader.findResource(name, processed, exclusions, debugSearchPath)) == null) continue;
                        break;
                    }
                }
                Object var12_11 = null;
                this.dependencyLock.readLock().unlock();
            }
            catch (Throwable throwable) {
                Object var12_12 = null;
                this.dependencyLock.readLock().unlock();
                throw throwable;
            }
            return super.findResource(name);
        }
    }
}

