/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.maven;

import java.util.LinkedHashSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.modeshape.common.text.NoOpEncoder;
import org.modeshape.common.text.TextEncoder;
import org.modeshape.common.util.CheckArg;
import org.modeshape.common.util.HashCode;
import org.modeshape.common.util.StringUtil;
import org.modeshape.maven.MavenI18n;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MavenId
implements Comparable<MavenId>,
Cloneable {
    private final String groupId;
    private final String artifactId;
    private final Version version;
    private final String classifier;

    public static MavenId[] createClasspath(String commaSeparatedCoordinates) {
        if (commaSeparatedCoordinates == null) {
            return new MavenId[0];
        }
        String[] coordinates = commaSeparatedCoordinates.split(",");
        return MavenId.createClasspath(coordinates);
    }

    public static MavenId[] createClasspath(String ... mavenCoordinates) {
        if (mavenCoordinates == null) {
            return new MavenId[0];
        }
        LinkedHashSet<MavenId> result = new LinkedHashSet<MavenId>();
        for (int i = 0; i < mavenCoordinates.length; ++i) {
            String coordinateStr = mavenCoordinates[i];
            if (coordinateStr == null || (coordinateStr = coordinateStr.trim()).length() == 0) continue;
            result.add(new MavenId(coordinateStr));
        }
        return result.toArray(new MavenId[result.size()]);
    }

    public static MavenId[] createClasspath(MavenId ... mavenIds) {
        LinkedHashSet<MavenId> result = new LinkedHashSet<MavenId>();
        for (MavenId mavenId : mavenIds) {
            if (mavenId == null) continue;
            result.add(mavenId);
        }
        return result.toArray(new MavenId[result.size()]);
    }

    public MavenId(String coordinates) {
        CheckArg.isNotNull((Object)coordinates, (String)"coordinates");
        coordinates = coordinates.trim();
        CheckArg.isNotEmpty((String)coordinates, (String)"coordinates");
        Pattern urlPattern = Pattern.compile("([^:]+)(:([^:]+)(:([^:]*)(:([^:]*))?)?)?");
        Matcher matcher = urlPattern.matcher(coordinates);
        if (!matcher.find()) {
            throw new IllegalArgumentException(MavenI18n.unsupportedMavenCoordinateFormat.text(new Object[]{coordinates}));
        }
        String groupId = matcher.group(1);
        String artifactId = matcher.group(3);
        String version = matcher.group(5);
        String classifier = matcher.group(7);
        CheckArg.isNotEmpty((String)groupId, (String)"groupId");
        CheckArg.isNotEmpty((String)artifactId, (String)"artifactId");
        this.groupId = groupId.trim();
        this.artifactId = artifactId.trim();
        this.classifier = classifier != null ? classifier.trim() : "";
        this.version = version != null ? new Version(version) : new Version("");
    }

    public MavenId(String groupId, String artifactId) {
        this(groupId, artifactId, null, null);
    }

    public MavenId(String groupId, String artifactId, String version) {
        this(groupId, artifactId, version, null);
    }

    public MavenId(String groupId, String artifactId, String version, String classifier) {
        CheckArg.isNotEmpty((String)groupId, (String)"groupId");
        CheckArg.isNotEmpty((String)artifactId, (String)"artifactId");
        this.groupId = groupId.trim();
        this.artifactId = artifactId.trim();
        this.classifier = classifier != null ? classifier.trim() : "";
        this.version = version != null ? new Version(version) : new Version("");
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getClassifier() {
        return this.classifier;
    }

    public String getVersion() {
        return this.version.toString();
    }

    public String getRelativePath() {
        return this.getRelativePath((TextEncoder)NoOpEncoder.getInstance());
    }

    public String getRelativePath(TextEncoder escapingStrategy) {
        return this.getRelativePath((TextEncoder)NoOpEncoder.getInstance(), true);
    }

    public String getRelativePath(boolean includeVersion) {
        return this.getRelativePath((TextEncoder)NoOpEncoder.getInstance(), includeVersion);
    }

    public String getRelativePath(TextEncoder escapingStrategy, boolean includeVersion) {
        String[] groupComponents;
        StringBuilder sb = new StringBuilder();
        for (String groupComponent : groupComponents = this.getGroupId().split("[\\.]")) {
            if (sb.length() != 0) {
                sb.append("/");
            }
            sb.append(escapingStrategy.encode(groupComponent));
        }
        sb.append("/").append(escapingStrategy.encode(this.getArtifactId()));
        if (includeVersion) {
            sb.append("/").append(escapingStrategy.encode(this.getVersion()));
        }
        return sb.toString();
    }

    public String getCoordinates() {
        return StringUtil.createString((String)"{0}:{1}:{2}:{3}", (Object[])new Object[]{this.groupId, this.artifactId, this.version, this.classifier});
    }

    public static MavenId createFromCoordinates(String coordinates) {
        String[] parts = coordinates.split("[:]");
        String groupId = null;
        String artifactId = null;
        String version = null;
        String classifier = null;
        if (parts.length > 0) {
            groupId = parts[0];
        }
        if (parts.length > 1) {
            artifactId = parts[1];
        }
        if (parts.length > 2) {
            version = parts[2];
        }
        if (parts.length > 3) {
            classifier = parts[3];
        }
        return new MavenId(groupId, artifactId, classifier, version);
    }

    protected boolean isAnyVersion() {
        return this.version.isAnyVersion();
    }

    public int hashCode() {
        return HashCode.compute((Object[])new Object[]{this.groupId, this.artifactId, this.classifier});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof MavenId) {
            MavenId that = (MavenId)obj;
            if (!this.groupId.equalsIgnoreCase(that.groupId)) {
                return false;
            }
            if (!this.artifactId.equalsIgnoreCase(that.artifactId)) {
                return false;
            }
            if (!this.version.equals(that.version)) {
                return false;
            }
            return this.classifier.equalsIgnoreCase(that.classifier);
        }
        return false;
    }

    @Override
    public int compareTo(MavenId that) {
        if (that == null) {
            return 1;
        }
        if (this == that) {
            return 0;
        }
        int diff = this.groupId.compareTo(that.groupId);
        if (diff != 0) {
            return diff;
        }
        diff = this.artifactId.compareTo(that.artifactId);
        if (diff != 0) {
            return diff;
        }
        diff = this.version.compareTo(that.version);
        if (diff != 0) {
            return diff;
        }
        diff = this.classifier.compareTo(that.classifier);
        return diff;
    }

    public String toString() {
        return this.getCoordinates();
    }

    protected static Object[] getVersionComponents(String version) {
        if (version == null) {
            return new Object[0];
        }
        if ((version = version.trim()).length() == 0) {
            return new Object[0];
        }
        String[] parts = version.split("[\\.\\-/,]");
        if (parts == null) {
            return new Object[0];
        }
        Object[] components = new Object[parts.length];
        int len = parts.length;
        for (int i = 0; i < len; ++i) {
            String part = parts[i].trim();
            Object component = part;
            try {
                component = Integer.parseInt(part);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
            components[i] = component;
        }
        return components;
    }

    public MavenId clone() {
        return new MavenId(this.groupId, this.artifactId, this.version.toString(), this.classifier);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class Version
    implements Comparable<Version> {
        private final String version;
        private final Object[] components;

        protected Version(String version) {
            this.version = version != null ? version.trim() : "";
            this.components = MavenId.getVersionComponents(this.version);
        }

        public Object[] getComponents() {
            return this.components;
        }

        public boolean isAnyVersion() {
            return this.version.length() == 0;
        }

        public String toString() {
            return this.version;
        }

        public int hashCode() {
            return this.version.hashCode();
        }

        @Override
        public int compareTo(Version that) {
            if (that == null) {
                return 1;
            }
            Object[] thisComponents = this.getComponents();
            Object[] thatComponents = that.getComponents();
            int thisLength = thisComponents.length;
            int thatLength = thatComponents.length;
            int minLength = Math.min(thisLength, thatLength);
            for (int i = 0; i != minLength; ++i) {
                Object thisComponent = thisComponents[i];
                Object thatComponent = thatComponents[i];
                int diff = 0;
                if (thisComponent instanceof Integer && thatComponent instanceof Integer) {
                    diff = ((Integer)thisComponent).compareTo((Integer)thatComponent);
                } else {
                    String thisString = thisComponent.toString();
                    String thatString = thatComponent.toString();
                    diff = thisString.compareToIgnoreCase(thatString);
                }
                if (diff == 0) continue;
                return diff;
            }
            return 0;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof Version) {
                Version that = (Version)obj;
                if (this.isAnyVersion() || that.isAnyVersion()) {
                    return true;
                }
                return this.version.equalsIgnoreCase(that.version);
            }
            return false;
        }
    }
}

