/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.maven;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.xml.namespace.NamespaceContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.modeshape.common.component.ClassLoaderFactory;
import org.modeshape.common.util.CheckArg;
import org.modeshape.common.util.Logger;
import org.modeshape.common.xml.SimpleNamespaceContext;
import org.modeshape.maven.ArtifactType;
import org.modeshape.maven.MavenClassLoaders;
import org.modeshape.maven.MavenDependency;
import org.modeshape.maven.MavenI18n;
import org.modeshape.maven.MavenId;
import org.modeshape.maven.MavenRepositoryException;
import org.modeshape.maven.SignatureType;
import org.modeshape.maven.spi.MavenUrlProvider;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MavenRepository
implements ClassLoaderFactory {
    private final MavenUrlProvider urlProvider;
    private final MavenClassLoaders classLoaders;
    private final Logger logger;

    public MavenRepository(MavenUrlProvider urlProvider) {
        CheckArg.isNotNull((Object)urlProvider, (String)"urlProvider");
        this.urlProvider = urlProvider;
        this.classLoaders = new MavenClassLoaders(this);
        this.logger = Logger.getLogger(this.getClass());
        assert (this.logger != null);
        assert (this.urlProvider != null);
    }

    public ClassLoader getClassLoader(ClassLoader parent, MavenId ... mavenIds) {
        CheckArg.isNotEmpty((Object[])mavenIds, (String)"mavenIds");
        CheckArg.containsNoNulls((Object[])mavenIds, (String)"mavenIds");
        return this.classLoaders.getClassLoader(parent, mavenIds);
    }

    public ClassLoader getClassLoader(String ... coordinates) {
        return this.getClassLoader((ClassLoader)null, coordinates);
    }

    public ClassLoader getClassLoader(ClassLoader parent, String ... coordinates) {
        CheckArg.isNotEmpty((Object[])coordinates, (String)"coordinates");
        CheckArg.containsNoNulls((Object[])coordinates, (String)"coordinates");
        MavenId[] mavenIds = new MavenId[coordinates.length];
        for (int i = 0; i < coordinates.length; ++i) {
            String coordinate = coordinates[i];
            mavenIds[i] = new MavenId(coordinate);
        }
        return this.getClassLoader(parent, mavenIds);
    }

    public boolean exists(MavenId mavenId) throws MavenRepositoryException {
        if (mavenId == null) {
            return false;
        }
        Set<MavenId> existing = this.exists(mavenId, new MavenId[]{null});
        return existing.contains(mavenId);
    }

    public Set<MavenId> exists(MavenId firstId, MavenId ... mavenIds) throws MavenRepositoryException {
        if (mavenIds == null || mavenIds.length == 0) {
            return Collections.emptySet();
        }
        HashSet<MavenId> nonNullIds = new HashSet<MavenId>();
        if (firstId != null) {
            nonNullIds.add(firstId);
        }
        for (MavenId mavenId : mavenIds) {
            if (mavenId == null) continue;
            nonNullIds.add(mavenId);
        }
        if (nonNullIds.isEmpty()) {
            return nonNullIds;
        }
        MavenId lastMavenId = null;
        try {
            Iterator iter = nonNullIds.iterator();
            while (iter.hasNext()) {
                lastMavenId = (MavenId)iter.next();
                URL urlToMavenId = this.urlProvider.getUrl(lastMavenId, null, null, false);
                boolean exists = urlToMavenId != null;
                if (exists) continue;
                iter.remove();
            }
        }
        catch (MalformedURLException err) {
            throw new MavenRepositoryException(MavenI18n.errorCreatingUrlForMavenId.text(new Object[]{lastMavenId, err.getMessage()}));
        }
        return nonNullIds;
    }

    public List<MavenDependency> getDependencies(MavenId mavenId) {
        URL pomUrl = null;
        try {
            pomUrl = this.getUrl(mavenId, ArtifactType.POM, null);
            return this.getDependencies(mavenId, pomUrl.openStream(), new MavenDependency.Scope[0]);
        }
        catch (IOException e) {
            throw new MavenRepositoryException(MavenI18n.errorGettingPomFileForMavenIdAtUrl.text(new Object[]{mavenId, pomUrl}), e);
        }
    }

    /*
     * Loose catch block
     */
    protected List<MavenDependency> getDependencies(MavenId mavenId, InputStream pomStream, MavenDependency.Scope ... allowedScopes) throws IOException {
        ArrayList<MavenDependency> results;
        block18: {
            CheckArg.isNotNull((Object)mavenId, (String)"mavenId");
            CheckArg.isNotNull((Object)pomStream, (String)"pomStream");
            EnumSet<MavenDependency.Scope> includedScopes = MavenDependency.Scope.getRuntimeScopes();
            if (allowedScopes != null && allowedScopes.length > 0) {
                includedScopes = EnumSet.of(allowedScopes[0], allowedScopes);
            }
            results = new ArrayList<MavenDependency>();
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.parse(pomStream);
            XPathFactory xpathFactory = XPathFactory.newInstance();
            XPath xpath = xpathFactory.newXPath();
            xpath.setNamespaceContext((NamespaceContext)new SimpleNamespaceContext().setNamespace("m", "http://maven.apache.org/POM/4.0.0"));
            XPathExpression projectExpression = xpath.compile("//m:project");
            XPathExpression dependencyExpression = xpath.compile("//m:project/m:dependencies/m:dependency");
            XPathExpression groupIdExpression = xpath.compile("./m:groupId/text()");
            XPathExpression artifactIdExpression = xpath.compile("./m:artifactId/text()");
            XPathExpression versionExpression = xpath.compile("./m:version/text()");
            XPathExpression classifierExpression = xpath.compile("./m:classifier/text()");
            XPathExpression scopeExpression = xpath.compile("./m:scope/text()");
            XPathExpression typeExpression = xpath.compile("./m:type/text()");
            XPathExpression exclusionExpression = xpath.compile("./m:exclusions/m:exclusion");
            Node projectNode = (Node)projectExpression.evaluate(doc, XPathConstants.NODE);
            String groupId = (String)groupIdExpression.evaluate(projectNode, XPathConstants.STRING);
            String artifactId = (String)artifactIdExpression.evaluate(projectNode, XPathConstants.STRING);
            String version = (String)versionExpression.evaluate(projectNode, XPathConstants.STRING);
            String classifier = (String)classifierExpression.evaluate(projectNode, XPathConstants.STRING);
            if (groupId == null || artifactId == null || version == null) {
                throw new IllegalArgumentException(MavenI18n.pomFileIsInvalid.text(new Object[]{mavenId}));
            }
            MavenId actualMavenId = new MavenId(groupId, artifactId, version, classifier);
            if (!mavenId.equals(actualMavenId)) {
                throw new IllegalArgumentException(MavenI18n.pomFileContainsUnexpectedId.text(new Object[]{actualMavenId, mavenId}));
            }
            NodeList nodes = (NodeList)dependencyExpression.evaluate(doc, XPathConstants.NODESET);
            for (int i = 0; i < nodes.getLength(); ++i) {
                Node dependencyNode = nodes.item(i);
                assert (dependencyNode != null);
                String depGroupId = (String)groupIdExpression.evaluate(dependencyNode, XPathConstants.STRING);
                String depArtifactId = (String)artifactIdExpression.evaluate(dependencyNode, XPathConstants.STRING);
                String depVersion = (String)versionExpression.evaluate(dependencyNode, XPathConstants.STRING);
                String depClassifier = (String)classifierExpression.evaluate(dependencyNode, XPathConstants.STRING);
                String scopeText = (String)scopeExpression.evaluate(dependencyNode, XPathConstants.STRING);
                String depType = (String)typeExpression.evaluate(dependencyNode, XPathConstants.STRING);
                if (depGroupId == null || depArtifactId == null || depVersion == null) {
                    this.logger.trace("Skipping dependency of {1} due to missing groupId, artifactId or version: {2}", new Object[]{mavenId, dependencyNode});
                    continue;
                }
                MavenDependency dependency = new MavenDependency(depGroupId, depArtifactId, depVersion, depClassifier);
                dependency.setType(depType);
                dependency.setScope(scopeText);
                if (!includedScopes.contains((Object)dependency.getScope())) continue;
                NodeList exclusionNodes = (NodeList)exclusionExpression.evaluate(dependencyNode, XPathConstants.NODESET);
                for (int j = 0; j < exclusionNodes.getLength(); ++j) {
                    Node exclusionNode = exclusionNodes.item(j);
                    assert (exclusionNode != null);
                    String excludedGroupId = (String)groupIdExpression.evaluate(exclusionNode, XPathConstants.STRING);
                    String excludedArtifactId = (String)artifactIdExpression.evaluate(exclusionNode, XPathConstants.STRING);
                    if (excludedGroupId == null || excludedArtifactId == null) {
                        this.logger.trace("Skipping exclusion in dependency of {1} due to missing exclusion groupId or artifactId: {2} ", new Object[]{mavenId, exclusionNode});
                        continue;
                    }
                    MavenId excludedId = new MavenId(excludedGroupId, excludedArtifactId);
                    dependency.getExclusions().add(excludedId);
                }
                results.add(dependency);
            }
            Object var43_45 = null;
            try {
                pomStream.close();
            }
            catch (IOException e) {
                this.logger.error((Throwable)e, MavenI18n.errorClosingUrlStreamToPom, new Object[]{mavenId});
            }
            break block18;
            {
                catch (XPathExpressionException err) {
                    throw new MavenRepositoryException(MavenI18n.errorCreatingXpathStatementsToEvaluatePom.text(new Object[]{mavenId}), err);
                }
                catch (ParserConfigurationException err) {
                    throw new MavenRepositoryException(MavenI18n.errorCreatingXpathParserToEvaluatePom.text(new Object[]{mavenId}), err);
                }
                catch (SAXException err) {
                    throw new MavenRepositoryException(MavenI18n.errorReadingXmlDocumentToEvaluatePom.text(new Object[]{mavenId}), err);
                }
            }
            catch (Throwable throwable) {
                Object var43_46 = null;
                try {
                    pomStream.close();
                }
                catch (IOException e) {
                    this.logger.error((Throwable)e, MavenI18n.errorClosingUrlStreamToPom, new Object[]{mavenId});
                }
                throw throwable;
            }
        }
        return results;
    }

    public URL getUrl(MavenId mavenId, ArtifactType artifactType, SignatureType signatureType) throws MalformedURLException {
        return this.urlProvider.getUrl(mavenId, artifactType, signatureType, false);
    }

    public URL getUrl(MavenId mavenId, ArtifactType artifactType, SignatureType signatureType, boolean createIfRequired) throws MalformedURLException {
        return this.urlProvider.getUrl(mavenId, artifactType, signatureType, createIfRequired);
    }

    protected void notifyUpdatedPom(MavenId mavenId) {
        this.classLoaders.notifyChangeInDependencies(mavenId);
    }
}

