/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.maven;

import javax.jcr.Node;
import javax.jcr.Session;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.junit.Assert;
import org.junit.Test;
import org.modeshape.maven.AbstractJcrRepositoryTest;

public class TestAbstractJcrRepositoryTest
extends AbstractJcrRepositoryTest {
    @Test
    public void shouldBeAbleToStartAndShutdownRepository() throws Exception {
        for (int i = 0; i != 3; ++i) {
            this.startRepository();
            Session session = this.getRepository().login(this.getTestCredentials());
            Assert.assertThat((Object)session, Is.is(IsNull.notNullValue()));
            Assert.assertThat((Object)session.getRootNode(), Is.is(IsNull.notNullValue()));
            Node node = session.getRootNode().addNode("testnode", "nt:unstructured");
            Assert.assertThat((Object)node, Is.is(IsNull.notNullValue()));
            Assert.assertThat((Object)node.getName(), Is.is("testnode"));
            Assert.assertThat((Object)node.getPath(), Is.is("/testnode"));
            session.save();
            session.logout();
            this.shutdownRepository();
        }
    }

    @Test
    public void shouldAllowDataPersistedInOneSessionBeAccessibleInOtherSessions() throws Exception {
        this.startRepository();
        Session session = this.getRepository().login(this.getTestCredentials());
        Assert.assertThat((Object)session, Is.is(IsNull.notNullValue()));
        Assert.assertThat((Object)session.getRootNode(), Is.is(IsNull.notNullValue()));
        Node node = session.getRootNode().addNode("testnode", "nt:unstructured");
        Assert.assertThat((Object)node, Is.is(IsNull.notNullValue()));
        Assert.assertThat((Object)node.getName(), Is.is("testnode"));
        Assert.assertThat((Object)node.getPath(), Is.is("/testnode"));
        session.save();
        session.logout();
        for (int i = 0; i != 3; ++i) {
            session = this.getRepository().login(this.getTestCredentials());
            Assert.assertThat((Object)session, Is.is(IsNull.notNullValue()));
            Assert.assertThat((Object)session.getRootNode(), Is.is(IsNull.notNullValue()));
            node = session.getRootNode().getNode("testnode");
            Assert.assertThat((Object)node, Is.is(IsNull.notNullValue()));
            Assert.assertThat((Object)node.getName(), Is.is("testnode"));
            Assert.assertThat((Object)node.getPath(), Is.is("/testnode"));
            session.logout();
        }
    }
}

