/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.maven.spi;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Properties;
import javax.jcr.SimpleCredentials;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.modeshape.common.util.StringUtil;
import org.modeshape.maven.AbstractJcrRepositoryTest;
import org.modeshape.maven.ArtifactType;
import org.modeshape.maven.MavenId;
import org.modeshape.maven.SignatureType;
import org.modeshape.maven.spi.JcrMavenUrlProvider;

public class JcrMavenUrlProviderTest
extends AbstractJcrRepositoryTest {
    private JcrMavenUrlProvider provider;
    private Properties validProperties;
    private MavenId mavenId1;

    @Before
    public void beforeEach() throws Exception {
        File tmpFolder = new File("target/testdata/tmp");
        tmpFolder.mkdirs();
        System.setProperty("java.io.tmpdir", tmpFolder.getAbsolutePath());
        this.validProperties = new Properties();
        this.validProperties.setProperty("unused.property", "whatever");
        this.validProperties.setProperty("dna.maven.urlprovider.repository.workspace", "default");
        this.validProperties.setProperty("dna.maven.urlprovider.repository.path", "/path/to/repository/root");
        this.validProperties.setProperty("dna.maven.urlprovider.username", "superuser");
        this.validProperties.setProperty("dna.maven.urlprovider.password", "secret");
        this.mavenId1 = new MavenId("org.modeshape", "modeshape-maven", "1.0-SNAPSHOT");
        this.provider = new JcrMavenUrlProvider();
        this.provider.setRepository(this.getRepository());
    }

    @Test
    public void shouldHaveNullWorkspaceNameUponDefaultConstruction() {
        Assert.assertThat((Object)this.provider.getWorkspaceName(), Is.is(IsNull.nullValue()));
    }

    @Test
    public void shouldHaveNullCredentialsUponDefaultConstruction() {
        Assert.assertThat((Object)this.provider.getCredentials(), Is.is(IsNull.nullValue()));
    }

    @Test
    public void shouldHaveDefaultRepositoryPathUponDefaultConstruction() {
        Assert.assertThat((Object)this.provider.getPathToTopOfRepository(), Is.is("/dnaMavenRepository"));
    }

    @Test
    public void shouldHaveNonNullPropertiesUponDefaultConstruction() {
        Assert.assertThat((Object)this.provider.getProperties(), Is.is(IsNull.notNullValue()));
    }

    @Test
    public void shouldHaveNonNullPropertiesAfterConfigurationUsingNullProperties() {
        this.provider.configure(null);
        Assert.assertThat((Object)this.provider.getProperties(), Is.is(IsNull.notNullValue()));
    }

    @Test
    public void shouldHaveCorrectPropertiesAfterConfiguration() {
        this.provider.configure(this.validProperties);
        Assert.assertThat((Object)this.provider.getProperties(), Is.is(this.validProperties));
        Assert.assertThat((Object)this.provider.getPathToTopOfRepository(), Is.is("/path/to/repository/root"));
        Assert.assertThat((Object)this.provider.getCredentials(), Is.is(IsNull.notNullValue()));
        Assert.assertThat((Object)(this.provider.getCredentials() instanceof SimpleCredentials), Is.is(true));
        SimpleCredentials simpleCreds = (SimpleCredentials)this.provider.getCredentials();
        Assert.assertThat((Object)simpleCreds.getUserID(), Is.is("superuser"));
        Assert.assertThat((Object)simpleCreds.getPassword(), Is.is("secret".toCharArray()));
    }

    @Test
    public void shouldNotOverwriteNonDefaultValuesWhenNotGivenInConfigurationProperties() {
        this.provider.configure(this.validProperties);
        this.provider.configure(new Properties());
        Assert.assertThat((Object)this.provider.getProperties(), Is.is(new Properties()));
        Assert.assertThat((Object)this.provider.getPathToTopOfRepository(), Is.is("/path/to/repository/root"));
        Assert.assertThat((Object)this.provider.getCredentials(), Is.is(IsNull.notNullValue()));
        Assert.assertThat((Object)(this.provider.getCredentials() instanceof SimpleCredentials), Is.is(true));
        SimpleCredentials simpleCreds = (SimpleCredentials)this.provider.getCredentials();
        Assert.assertThat((Object)simpleCreds.getUserID(), Is.is("superuser"));
        Assert.assertThat((Object)simpleCreds.getPassword(), Is.is("secret".toCharArray()));
    }

    @Test
    public void shouldDetermineProperPathGivenMavenIdAndArtifactType() {
        Assert.assertThat((Object)this.provider.getUrlPath(this.mavenId1, ArtifactType.JAR, null), Is.is("/org/modeshape/modeshape-maven/1.0-SNAPSHOT/modeshape-maven-1.0-SNAPSHOT.jar"));
        Assert.assertThat((Object)this.provider.getUrlPath(this.mavenId1, ArtifactType.JAR, SignatureType.MD5), Is.is("/org/modeshape/modeshape-maven/1.0-SNAPSHOT/modeshape-maven-1.0-SNAPSHOT.jar.md5"));
        Assert.assertThat((Object)this.provider.getUrlPath(this.mavenId1, ArtifactType.JAR, SignatureType.PGP), Is.is("/org/modeshape/modeshape-maven/1.0-SNAPSHOT/modeshape-maven-1.0-SNAPSHOT.jar.asc"));
        Assert.assertThat((Object)this.provider.getUrlPath(this.mavenId1, ArtifactType.JAR, SignatureType.SHA1), Is.is("/org/modeshape/modeshape-maven/1.0-SNAPSHOT/modeshape-maven-1.0-SNAPSHOT.jar.sha1"));
        Assert.assertThat((Object)this.provider.getUrlPath(this.mavenId1, ArtifactType.SOURCE, null), Is.is("/org/modeshape/modeshape-maven/1.0-SNAPSHOT/modeshape-maven-1.0-SNAPSHOT-sources.jar"));
        Assert.assertThat((Object)this.provider.getUrlPath(this.mavenId1, ArtifactType.SOURCE, SignatureType.MD5), Is.is("/org/modeshape/modeshape-maven/1.0-SNAPSHOT/modeshape-maven-1.0-SNAPSHOT-sources.jar.md5"));
        Assert.assertThat((Object)this.provider.getUrlPath(this.mavenId1, ArtifactType.SOURCE, SignatureType.PGP), Is.is("/org/modeshape/modeshape-maven/1.0-SNAPSHOT/modeshape-maven-1.0-SNAPSHOT-sources.jar.asc"));
        Assert.assertThat((Object)this.provider.getUrlPath(this.mavenId1, ArtifactType.SOURCE, SignatureType.SHA1), Is.is("/org/modeshape/modeshape-maven/1.0-SNAPSHOT/modeshape-maven-1.0-SNAPSHOT-sources.jar.sha1"));
        Assert.assertThat((Object)this.provider.getUrlPath(this.mavenId1, ArtifactType.POM, null), Is.is("/org/modeshape/modeshape-maven/1.0-SNAPSHOT/modeshape-maven-1.0-SNAPSHOT.pom"));
        Assert.assertThat((Object)this.provider.getUrlPath(this.mavenId1, ArtifactType.POM, SignatureType.MD5), Is.is("/org/modeshape/modeshape-maven/1.0-SNAPSHOT/modeshape-maven-1.0-SNAPSHOT.pom.md5"));
        Assert.assertThat((Object)this.provider.getUrlPath(this.mavenId1, ArtifactType.POM, SignatureType.PGP), Is.is("/org/modeshape/modeshape-maven/1.0-SNAPSHOT/modeshape-maven-1.0-SNAPSHOT.pom.asc"));
        Assert.assertThat((Object)this.provider.getUrlPath(this.mavenId1, ArtifactType.POM, SignatureType.SHA1), Is.is("/org/modeshape/modeshape-maven/1.0-SNAPSHOT/modeshape-maven-1.0-SNAPSHOT.pom.sha1"));
        Assert.assertThat((Object)this.provider.getUrlPath(this.mavenId1, ArtifactType.METADATA, null), Is.is("/org/modeshape/modeshape-maven/maven-metadata.xml"));
        Assert.assertThat((Object)this.provider.getUrlPath(this.mavenId1, ArtifactType.METADATA, SignatureType.MD5), Is.is("/org/modeshape/modeshape-maven/maven-metadata.xml.md5"));
        Assert.assertThat((Object)this.provider.getUrlPath(this.mavenId1, ArtifactType.METADATA, SignatureType.PGP), Is.is("/org/modeshape/modeshape-maven/maven-metadata.xml.asc"));
        Assert.assertThat((Object)this.provider.getUrlPath(this.mavenId1, ArtifactType.METADATA, SignatureType.SHA1), Is.is("/org/modeshape/modeshape-maven/maven-metadata.xml.sha1"));
    }

    @Test
    public void shouldDeterminePropertPathForMavenIdWithNoArtifactType() {
        Assert.assertThat((Object)this.provider.getUrlPath(this.mavenId1, null, null), Is.is("/org/modeshape/modeshape-maven/1.0-SNAPSHOT/"));
    }

    @Test
    public void shouldReturnValidUrlForMavenIdAndArtifactTypeAndSignatureType() throws Exception {
        Assert.assertThat((Object)this.provider.getUrl(this.mavenId1, ArtifactType.JAR, null, false).toString(), Is.is("jcr://org/modeshape/modeshape-maven/1.0-SNAPSHOT/modeshape-maven-1.0-SNAPSHOT.jar"));
        Assert.assertThat((Object)this.provider.getUrl(this.mavenId1, ArtifactType.JAR, SignatureType.MD5, false).toString(), Is.is("jcr://org/modeshape/modeshape-maven/1.0-SNAPSHOT/modeshape-maven-1.0-SNAPSHOT.jar.md5"));
        Assert.assertThat((Object)this.provider.getUrl(this.mavenId1, ArtifactType.JAR, SignatureType.PGP, false).toString(), Is.is("jcr://org/modeshape/modeshape-maven/1.0-SNAPSHOT/modeshape-maven-1.0-SNAPSHOT.jar.asc"));
        Assert.assertThat((Object)this.provider.getUrl(this.mavenId1, ArtifactType.JAR, SignatureType.SHA1, false).toString(), Is.is("jcr://org/modeshape/modeshape-maven/1.0-SNAPSHOT/modeshape-maven-1.0-SNAPSHOT.jar.sha1"));
        Assert.assertThat((Object)this.provider.getUrl(this.mavenId1, ArtifactType.SOURCE, null, false).toString(), Is.is("jcr://org/modeshape/modeshape-maven/1.0-SNAPSHOT/modeshape-maven-1.0-SNAPSHOT-sources.jar"));
        Assert.assertThat((Object)this.provider.getUrl(this.mavenId1, ArtifactType.SOURCE, SignatureType.MD5, false).toString(), Is.is("jcr://org/modeshape/modeshape-maven/1.0-SNAPSHOT/modeshape-maven-1.0-SNAPSHOT-sources.jar.md5"));
        Assert.assertThat((Object)this.provider.getUrl(this.mavenId1, ArtifactType.SOURCE, SignatureType.PGP, false).toString(), Is.is("jcr://org/modeshape/modeshape-maven/1.0-SNAPSHOT/modeshape-maven-1.0-SNAPSHOT-sources.jar.asc"));
        Assert.assertThat((Object)this.provider.getUrl(this.mavenId1, ArtifactType.SOURCE, SignatureType.SHA1, false).toString(), Is.is("jcr://org/modeshape/modeshape-maven/1.0-SNAPSHOT/modeshape-maven-1.0-SNAPSHOT-sources.jar.sha1"));
        Assert.assertThat((Object)this.provider.getUrl(this.mavenId1, ArtifactType.POM, null, false).toString(), Is.is("jcr://org/modeshape/modeshape-maven/1.0-SNAPSHOT/modeshape-maven-1.0-SNAPSHOT.pom"));
        Assert.assertThat((Object)this.provider.getUrl(this.mavenId1, ArtifactType.POM, SignatureType.MD5, false).toString(), Is.is("jcr://org/modeshape/modeshape-maven/1.0-SNAPSHOT/modeshape-maven-1.0-SNAPSHOT.pom.md5"));
        Assert.assertThat((Object)this.provider.getUrl(this.mavenId1, ArtifactType.POM, SignatureType.PGP, false).toString(), Is.is("jcr://org/modeshape/modeshape-maven/1.0-SNAPSHOT/modeshape-maven-1.0-SNAPSHOT.pom.asc"));
        Assert.assertThat((Object)this.provider.getUrl(this.mavenId1, ArtifactType.POM, SignatureType.SHA1, false).toString(), Is.is("jcr://org/modeshape/modeshape-maven/1.0-SNAPSHOT/modeshape-maven-1.0-SNAPSHOT.pom.sha1"));
        Assert.assertThat((Object)this.provider.getUrl(this.mavenId1, ArtifactType.METADATA, null, false).toString(), Is.is("jcr://org/modeshape/modeshape-maven/maven-metadata.xml"));
        Assert.assertThat((Object)this.provider.getUrl(this.mavenId1, ArtifactType.METADATA, SignatureType.MD5, false).toString(), Is.is("jcr://org/modeshape/modeshape-maven/maven-metadata.xml.md5"));
        Assert.assertThat((Object)this.provider.getUrl(this.mavenId1, ArtifactType.METADATA, SignatureType.PGP, false).toString(), Is.is("jcr://org/modeshape/modeshape-maven/maven-metadata.xml.asc"));
        Assert.assertThat((Object)this.provider.getUrl(this.mavenId1, ArtifactType.METADATA, SignatureType.SHA1, false).toString(), Is.is("jcr://org/modeshape/modeshape-maven/maven-metadata.xml.sha1"));
    }

    @Test
    public void shouldReturnValidUrlForMavenIdWithNoArtifactType() throws Exception {
        Assert.assertThat((Object)this.provider.getUrl(this.mavenId1, null, null, false).toString(), Is.is("jcr://org/modeshape/modeshape-maven/1.0-SNAPSHOT/"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldReturnUrlThatCanBeReadFromAndWrittenTo() throws Exception {
        this.startRepository();
        this.provider.configure(this.validProperties);
        String content = "";
        URL url = this.provider.getUrl(this.mavenId1, ArtifactType.JAR, null, false);
        url = this.provider.getUrl(this.mavenId1, ArtifactType.JAR, null, true);
        Assert.assertThat((Object)url, Is.is(IsNull.notNullValue()));
        URLConnection connection = url.openConnection();
        OutputStream outputStream = connection.getOutputStream();
        try {
            StringUtil.write((String)content, (OutputStream)outputStream);
        }
        finally {
            if (outputStream != null) {
                outputStream.close();
            }
        }
        url = this.provider.getUrl(this.mavenId1, ArtifactType.JAR, null, false);
        Assert.assertThat((Object)url, Is.is(IsNull.notNullValue()));
        connection = url.openConnection();
        InputStream stream = connection.getInputStream();
        try {
            String readContent = StringUtil.read((InputStream)stream);
            Assert.assertThat((Object)readContent, Is.is(content));
        }
        finally {
            if (stream != null) {
                stream.close();
            }
        }
        content = "";
        for (int i = 0; i != 100; ++i) {
            content = content + "The old gray mare just ain't what she used to be. Ain't what she used to be. Ain't what she used to be. ";
        }
        url = this.provider.getUrl(this.mavenId1, ArtifactType.JAR, null, true);
        Assert.assertThat((Object)url, Is.is(IsNull.notNullValue()));
        connection = url.openConnection();
        outputStream = connection.getOutputStream();
        try {
            StringUtil.write((String)content, (OutputStream)outputStream);
        }
        finally {
            if (outputStream != null) {
                outputStream.close();
            }
        }
        url = this.provider.getUrl(this.mavenId1, ArtifactType.JAR, null, false);
        Assert.assertThat((Object)url, Is.is(IsNull.notNullValue()));
        connection = url.openConnection();
        stream = connection.getInputStream();
        try {
            String readContent = StringUtil.read((InputStream)stream);
            Assert.assertThat((Object)readContent, Is.is(content));
        }
        finally {
            if (stream != null) {
                stream.close();
            }
        }
    }
}

