/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.maven;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.jcr.RepositoryException;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.modeshape.common.util.IoUtil;
import org.modeshape.common.util.StringUtil;
import org.modeshape.maven.AbstractJcrRepositoryTest;
import org.modeshape.maven.ArtifactType;
import org.modeshape.maven.MavenClassLoaders;
import org.modeshape.maven.MavenDependency;
import org.modeshape.maven.MavenId;
import org.modeshape.maven.MavenRepository;
import org.modeshape.maven.SignatureType;
import org.modeshape.maven.spi.JcrMavenUrlProvider;
import org.modeshape.maven.spi.MavenUrlProvider;

public class MavenRepositoryTest
extends AbstractJcrRepositoryTest {
    public static final String MAVEN_PATH = "/maven";
    public static final String PATH_TO_TEST_POM_A = "testPomA.xml";
    public static final String PATH_TO_EMPTY_JAR = "empty.jar";
    private Properties urlProviderProperties;
    private JcrMavenUrlProvider urlProvider;
    private MavenRepository maven;
    private MavenId mavenId1;
    private MavenId mavenId2;
    private ClassLoader parentLoader;
    private MavenId projectA;
    private MavenId projectB;
    private MavenId projectC;
    private MavenId projectD;
    private MavenId projectE;
    private MavenId projectF;
    private MavenId projectG;
    private MavenId projectH;
    private MavenId projectI;

    @Before
    public void beforeEach() throws Exception {
        this.urlProviderProperties = new Properties();
        this.urlProviderProperties.setProperty("dna.maven.urlprovider.repository.workspace", "default");
        this.urlProviderProperties.setProperty("dna.maven.urlprovider.repository.path", "/path/to/repository/root");
        this.urlProviderProperties.setProperty("dna.maven.urlprovider.username", "superuser");
        this.urlProviderProperties.setProperty("dna.maven.urlprovider.password", "secret");
        this.urlProvider = new JcrMavenUrlProvider();
        this.urlProvider.setRepository(this.getRepository());
        this.maven = new MavenRepository((MavenUrlProvider)this.urlProvider);
        this.mavenId1 = new MavenId("org.modeshape", "modeshape-maven", "1.0-SNAPSHOT");
        this.mavenId2 = new MavenId("org.modeshape", "dna-common", "1.0.2");
        this.parentLoader = null;
        this.projectA = new MavenId("org.jboss.example:ProjectA:1.0");
        this.projectB = new MavenId("org.jboss.example:ProjectB:1.0");
        this.projectC = new MavenId("org.jboss.example:ProjectC:1.0");
        this.projectD = new MavenId("org.jboss.example:ProjectD:1.0");
        this.projectE = new MavenId("org.jboss.example:ProjectE:1.0");
        this.projectF = new MavenId("org.jboss.example:ProjectF:1.0");
        this.projectG = new MavenId("org.jboss.example:ProjectG:1.0");
        this.projectH = new MavenId("org.jboss.example:ProjectH:1.0");
        this.projectI = new MavenId("org.jboss.example:ProjectI:1.0");
    }

    @Override
    public void startRepository() throws RepositoryException, IOException {
        super.startRepository();
        this.urlProvider.configure(this.urlProviderProperties);
    }

    public void loadTestLibraries() throws Exception {
        this.loadTestLibrary("org.jboss.example:ProjectA:1.0", "test/dependency/case1/testProjectA.xml");
        this.loadTestLibrary("org.jboss.example:ProjectB:1.0", "test/dependency/case1/testProjectB.xml");
        this.loadTestLibrary("org.jboss.example:ProjectC:1.0", "test/dependency/case1/testProjectC.xml");
        this.loadTestLibrary("org.jboss.example:ProjectD:1.0", "test/dependency/case1/testProjectD.xml");
        this.loadTestLibrary("org.jboss.example:ProjectE:1.0", "test/dependency/case1/testProjectE.xml");
        this.loadTestLibrary("org.jboss.example:ProjectF:1.0", "test/dependency/case1/testProjectF.xml");
        this.loadTestLibrary("org.jboss.example:ProjectG:1.0", "test/dependency/case1/testProjectG.xml");
        this.loadTestLibrary("org.jboss.example:ProjectH:1.0", "test/dependency/case1/testProjectH.xml");
        this.loadTestLibrary("org.jboss.example:ProjectI:1.0", "test/dependency/case1/testProjectI.xml");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setRepositoryContent(MavenId mavenId, ArtifactType artifactType, SignatureType signatureType, InputStream content) throws Exception {
        URL url = this.urlProvider.getUrl(mavenId, artifactType, signatureType, true);
        Assert.assertThat((Object)url, Is.is(IsNull.notNullValue()));
        URLConnection connection = url.openConnection();
        OutputStream outputStream = connection.getOutputStream();
        try {
            IoUtil.write((InputStream)content, (OutputStream)outputStream);
        }
        finally {
            try {
                if (outputStream != null) {
                    outputStream.close();
                }
            }
            finally {
                content.close();
            }
        }
    }

    protected void loadTestLibrary(String mavenId, String pathToPomFile) throws Exception {
        MavenId id = new MavenId(mavenId);
        this.setRepositoryContent(id, ArtifactType.POM, null, this.getClass().getClassLoader().getResourceAsStream(pathToPomFile));
        this.setRepositoryContent(id, ArtifactType.JAR, null, this.getClass().getClassLoader().getResourceAsStream(PATH_TO_EMPTY_JAR));
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotAllowZeroIdsWhenGettingClassLoader() {
        this.maven.getClassLoader(this.parentLoader, (MavenId[])null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotAllowNullIdsWhenGettingClassLoader() {
        this.maven.getClassLoader(this.parentLoader, new MavenId[]{this.mavenId1, null, this.mavenId2});
    }

    @Test
    public void shouldConsiderNullIdToNotExist() {
        Assert.assertThat((Object)this.maven.exists((MavenId)null), Is.is(false));
    }

    @Test
    public void shouldReturnEmptySetWhenPassedAllNullIdsForCheckingWhetherProjectsExist() {
        Assert.assertThat((Object)this.maven.exists(null, new MavenId[]{null}), Is.is(IsNull.notNullValue()));
        Assert.assertThat((Object)this.maven.exists(null, new MavenId[]{null}).size(), Is.is(0));
        Assert.assertThat((Object)this.maven.exists(null, new MavenId[]{null}), Is.is(IsNull.notNullValue()));
        Assert.assertThat((Object)this.maven.exists(null, new MavenId[]{null}).size(), Is.is(0));
    }

    @Test
    public void shouldReturnValidUrlForMavenIdAndArtifactTypeAndSignatureType() throws Exception {
        Assert.assertThat((Object)this.maven.getUrl(this.mavenId1, ArtifactType.JAR, null).toString(), Is.is("jcr:/default/org/modeshape/modeshape-maven/1.0-SNAPSHOT/modeshape-maven-1.0-SNAPSHOT.jar"));
        Assert.assertThat((Object)this.maven.getUrl(this.mavenId1, ArtifactType.JAR, SignatureType.MD5).toString(), Is.is("jcr:/default/org/modeshape/modeshape-maven/1.0-SNAPSHOT/modeshape-maven-1.0-SNAPSHOT.jar.md5"));
        Assert.assertThat((Object)this.maven.getUrl(this.mavenId1, ArtifactType.JAR, SignatureType.PGP).toString(), Is.is("jcr:/default/org/modeshape/modeshape-maven/1.0-SNAPSHOT/modeshape-maven-1.0-SNAPSHOT.jar.asc"));
        Assert.assertThat((Object)this.maven.getUrl(this.mavenId1, ArtifactType.JAR, SignatureType.SHA1).toString(), Is.is("jcr:/default/org/modeshape/modeshape-maven/1.0-SNAPSHOT/modeshape-maven-1.0-SNAPSHOT.jar.sha1"));
        Assert.assertThat((Object)this.maven.getUrl(this.mavenId1, ArtifactType.SOURCE, null).toString(), Is.is("jcr:/default/org/modeshape/modeshape-maven/1.0-SNAPSHOT/modeshape-maven-1.0-SNAPSHOT-sources.jar"));
        Assert.assertThat((Object)this.maven.getUrl(this.mavenId1, ArtifactType.SOURCE, SignatureType.MD5).toString(), Is.is("jcr:/default/org/modeshape/modeshape-maven/1.0-SNAPSHOT/modeshape-maven-1.0-SNAPSHOT-sources.jar.md5"));
        Assert.assertThat((Object)this.maven.getUrl(this.mavenId1, ArtifactType.SOURCE, SignatureType.PGP).toString(), Is.is("jcr:/default/org/modeshape/modeshape-maven/1.0-SNAPSHOT/modeshape-maven-1.0-SNAPSHOT-sources.jar.asc"));
        Assert.assertThat((Object)this.maven.getUrl(this.mavenId1, ArtifactType.SOURCE, SignatureType.SHA1).toString(), Is.is("jcr:/default/org/modeshape/modeshape-maven/1.0-SNAPSHOT/modeshape-maven-1.0-SNAPSHOT-sources.jar.sha1"));
        Assert.assertThat((Object)this.maven.getUrl(this.mavenId1, ArtifactType.POM, null).toString(), Is.is("jcr:/default/org/modeshape/modeshape-maven/1.0-SNAPSHOT/modeshape-maven-1.0-SNAPSHOT.pom"));
        Assert.assertThat((Object)this.maven.getUrl(this.mavenId1, ArtifactType.POM, SignatureType.MD5).toString(), Is.is("jcr:/default/org/modeshape/modeshape-maven/1.0-SNAPSHOT/modeshape-maven-1.0-SNAPSHOT.pom.md5"));
        Assert.assertThat((Object)this.maven.getUrl(this.mavenId1, ArtifactType.POM, SignatureType.PGP).toString(), Is.is("jcr:/default/org/modeshape/modeshape-maven/1.0-SNAPSHOT/modeshape-maven-1.0-SNAPSHOT.pom.asc"));
        Assert.assertThat((Object)this.maven.getUrl(this.mavenId1, ArtifactType.POM, SignatureType.SHA1).toString(), Is.is("jcr:/default/org/modeshape/modeshape-maven/1.0-SNAPSHOT/modeshape-maven-1.0-SNAPSHOT.pom.sha1"));
        Assert.assertThat((Object)this.maven.getUrl(this.mavenId1, ArtifactType.METADATA, null).toString(), Is.is("jcr:/default/org/modeshape/modeshape-maven/maven-metadata.xml"));
        Assert.assertThat((Object)this.maven.getUrl(this.mavenId1, ArtifactType.METADATA, SignatureType.MD5).toString(), Is.is("jcr:/default/org/modeshape/modeshape-maven/maven-metadata.xml.md5"));
        Assert.assertThat((Object)this.maven.getUrl(this.mavenId1, ArtifactType.METADATA, SignatureType.PGP).toString(), Is.is("jcr:/default/org/modeshape/modeshape-maven/maven-metadata.xml.asc"));
        Assert.assertThat((Object)this.maven.getUrl(this.mavenId1, ArtifactType.METADATA, SignatureType.SHA1).toString(), Is.is("jcr:/default/org/modeshape/modeshape-maven/maven-metadata.xml.sha1"));
    }

    @Test
    public void shouldReturnValidUrlForMavenIdWithNoArtifactType() throws Exception {
        Assert.assertThat((Object)this.maven.getUrl(this.mavenId1, null, null).toString(), Is.is("jcr:/default/org/modeshape/modeshape-maven/1.0-SNAPSHOT/"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldReturnUrlThatCanBeReadFromAndWrittenTo() throws Exception {
        this.startRepository();
        String content = "";
        this.setRepositoryContent(this.mavenId1, ArtifactType.JAR, null, new ByteArrayInputStream(content.getBytes()));
        URL url = this.maven.getUrl(this.mavenId1, ArtifactType.JAR, null);
        InputStream stream = url.openConnection().getInputStream();
        try {
            String readContent = StringUtil.read((InputStream)stream);
            Assert.assertThat((Object)readContent, Is.is(content));
        }
        finally {
            if (stream != null) {
                stream.close();
            }
        }
        content = "";
        for (int i = 0; i != 100; ++i) {
            content = content + "The old gray mare just ain't what she used to be. Ain't what she used to be. Ain't what she used to be. ";
        }
        this.setRepositoryContent(this.mavenId1, ArtifactType.JAR, null, new ByteArrayInputStream(content.getBytes()));
        url = this.maven.getUrl(this.mavenId1, ArtifactType.JAR, null);
        stream = url.openConnection().getInputStream();
        try {
            String readContent = StringUtil.read((InputStream)stream);
            Assert.assertThat((Object)readContent, Is.is(content));
        }
        finally {
            if (stream != null) {
                stream.close();
            }
        }
        String updatedContent = "Updated! " + content;
        OutputStream ostream = url.openConnection().getOutputStream();
        try {
            StringUtil.write((String)updatedContent, (OutputStream)ostream);
        }
        finally {
            if (ostream != null) {
                ostream.close();
            }
        }
        url = this.maven.getUrl(this.mavenId1, ArtifactType.JAR, null);
        stream = url.openConnection().getInputStream();
        String actualContent = null;
        try {
            actualContent = StringUtil.read((InputStream)stream);
        }
        finally {
            if (stream != null) {
                stream.close();
            }
        }
        Assert.assertThat((Object)actualContent, Is.is(updatedContent));
    }

    @Test
    public void shouldGetAllDependenciesFromInputStreamToPomFile() throws Exception {
        MavenId id = new MavenId("org.modeshape:modeshape-maven:0.1-SNAPSHOT");
        MavenDependency.Scope[] scopes = MavenDependency.Scope.values();
        InputStream stream = this.getClass().getClassLoader().getResourceAsStream(PATH_TO_TEST_POM_A);
        List dependencies = this.maven.getDependencies(id, stream, scopes);
        Assert.assertThat((Object)dependencies, Is.is(IsNull.notNullValue()));
        Assert.assertThat((Object)dependencies.size(), Is.is(11));
        Assert.assertThat((Object)((MavenDependency)dependencies.get(0)).toString(), Is.is("org.modeshape:common:0.1-SNAPSHOT:"));
        Assert.assertThat((Object)((MavenDependency)dependencies.get(0)).getScope(), Is.is(MavenDependency.Scope.getDefault()));
        Assert.assertThat((Object)((MavenDependency)dependencies.get(0)).getExclusions().size(), Is.is(0));
        Assert.assertThat((Object)((MavenDependency)dependencies.get(1)).toString(), Is.is("junit:junit:4.4:"));
        Assert.assertThat((Object)((MavenDependency)dependencies.get(1)).getScope(), Is.is(MavenDependency.Scope.TEST));
        Assert.assertThat((Object)((MavenDependency)dependencies.get(1)).getExclusions().size(), Is.is(0));
        Assert.assertThat((Object)((MavenDependency)dependencies.get(2)).toString(), Is.is("org.jmock:jmock:2.4.0:"));
        Assert.assertThat((Object)((MavenDependency)dependencies.get(2)).getScope(), Is.is(MavenDependency.Scope.TEST));
        Assert.assertThat((Object)((MavenDependency)dependencies.get(2)).getExclusions().size(), Is.is(0));
        Assert.assertThat((Object)((MavenDependency)dependencies.get(3)).toString(), Is.is("org.jmock:jmock-junit4:2.4.0:"));
        Assert.assertThat((Object)((MavenDependency)dependencies.get(3)).getScope(), Is.is(MavenDependency.Scope.TEST));
        Assert.assertThat((Object)((MavenDependency)dependencies.get(3)).getExclusions().size(), Is.is(0));
        Assert.assertThat((Object)((MavenDependency)dependencies.get(4)).toString(), Is.is("org.slf4j:slf4j-api:1.4.3:"));
        Assert.assertThat((Object)((MavenDependency)dependencies.get(4)).getScope(), Is.is(MavenDependency.Scope.COMPILE));
        Assert.assertThat((Object)((MavenDependency)dependencies.get(4)).getExclusions().size(), Is.is(0));
        Assert.assertThat((Object)((MavenDependency)dependencies.get(5)).toString(), Is.is("org.slf4j:slf4j-log4j12:1.4.3:"));
        Assert.assertThat((Object)((MavenDependency)dependencies.get(5)).getScope(), Is.is(MavenDependency.Scope.TEST));
        Assert.assertThat((Object)((MavenDependency)dependencies.get(5)).getExclusions().size(), Is.is(0));
        Assert.assertThat((Object)((MavenDependency)dependencies.get(6)).toString(), Is.is("log4j:log4j:1.2.14:"));
        Assert.assertThat((Object)((MavenDependency)dependencies.get(6)).getScope(), Is.is(MavenDependency.Scope.TEST));
        Assert.assertThat((Object)((MavenDependency)dependencies.get(6)).getExclusions().size(), Is.is(0));
        Assert.assertThat((Object)((MavenDependency)dependencies.get(7)).toString(), Is.is("javax.jcr:jcr:1.0.1:"));
        Assert.assertThat((Object)((MavenDependency)dependencies.get(7)).getScope(), Is.is(MavenDependency.Scope.COMPILE));
        Assert.assertThat((Object)((MavenDependency)dependencies.get(7)).getExclusions().size(), Is.is(0));
        Assert.assertThat((Object)((MavenDependency)dependencies.get(8)).toString(), Is.is("org.apache.jackrabbit:jackrabbit-api:1.3.3:"));
        Assert.assertThat((Object)((MavenDependency)dependencies.get(8)).getScope(), Is.is(MavenDependency.Scope.TEST));
        Assert.assertThat((Object)((MavenDependency)dependencies.get(8)).getExclusions().size(), Is.is(2));
        Assert.assertThat((Object)((MavenDependency)dependencies.get(8)).getExclusions().contains(new MavenId("xml-apis:xml-apis")), Is.is(true));
        Assert.assertThat((Object)((MavenDependency)dependencies.get(8)).getExclusions().contains(new MavenId("xerces:xercesImpl")), Is.is(true));
        Assert.assertThat((Object)((MavenDependency)dependencies.get(9)).toString(), Is.is("org.apache.jackrabbit:jackrabbit-core:1.3.3:"));
        Assert.assertThat((Object)((MavenDependency)dependencies.get(9)).getScope(), Is.is(MavenDependency.Scope.TEST));
        Assert.assertThat((Object)((MavenDependency)dependencies.get(9)).getExclusions().size(), Is.is(2));
        Assert.assertThat((Object)((MavenDependency)dependencies.get(9)).getExclusions().contains(new MavenId("xml-apis:xml-apis")), Is.is(true));
        Assert.assertThat((Object)((MavenDependency)dependencies.get(9)).getExclusions().contains(new MavenId("xerces:xercesImpl")), Is.is(true));
        Assert.assertThat((Object)((MavenDependency)dependencies.get(10)).toString(), Is.is("org.apache.derby:derby:10.2.1.6:"));
        Assert.assertThat((Object)((MavenDependency)dependencies.get(10)).getScope(), Is.is(MavenDependency.Scope.TEST));
        Assert.assertThat((Object)((MavenDependency)dependencies.get(10)).getExclusions().size(), Is.is(0));
    }

    @Test
    public void shouldGetCompileAndRuntimeDependenciesFromInputStreamToPomFile() throws Exception {
        MavenId id = new MavenId("org.modeshape:modeshape-maven:0.1-SNAPSHOT");
        MavenDependency.Scope[] scopes = new MavenDependency.Scope[]{MavenDependency.Scope.COMPILE, MavenDependency.Scope.RUNTIME};
        InputStream stream = this.getClass().getClassLoader().getResourceAsStream(PATH_TO_TEST_POM_A);
        List dependencies = this.maven.getDependencies(id, stream, scopes);
        Assert.assertThat((Object)dependencies, Is.is(IsNull.notNullValue()));
        Assert.assertThat((Object)dependencies.size(), Is.is(3));
        stream = this.getClass().getClassLoader().getResourceAsStream(PATH_TO_TEST_POM_A);
        dependencies = this.maven.getDependencies(id, stream, new MavenDependency.Scope[0]);
        Assert.assertThat((Object)dependencies, Is.is(IsNull.notNullValue()));
        Assert.assertThat((Object)dependencies.size(), Is.is(3));
        Assert.assertThat((Object)((MavenDependency)dependencies.get(0)).toString(), Is.is("org.modeshape:common:0.1-SNAPSHOT:"));
        Assert.assertThat((Object)((MavenDependency)dependencies.get(0)).getScope(), Is.is(MavenDependency.Scope.getDefault()));
        Assert.assertThat((Object)((MavenDependency)dependencies.get(0)).getExclusions().size(), Is.is(0));
        Assert.assertThat((Object)((MavenDependency)dependencies.get(1)).toString(), Is.is("org.slf4j:slf4j-api:1.4.3:"));
        Assert.assertThat((Object)((MavenDependency)dependencies.get(1)).getScope(), Is.is(MavenDependency.Scope.COMPILE));
        Assert.assertThat((Object)((MavenDependency)dependencies.get(1)).getExclusions().size(), Is.is(0));
        Assert.assertThat((Object)((MavenDependency)dependencies.get(2)).toString(), Is.is("javax.jcr:jcr:1.0.1:"));
        Assert.assertThat((Object)((MavenDependency)dependencies.get(2)).getScope(), Is.is(MavenDependency.Scope.COMPILE));
        Assert.assertThat((Object)((MavenDependency)dependencies.get(2)).getExclusions().size(), Is.is(0));
    }

    @Test
    public void shouldBuildCorrectClasspathForOneProjectWithNoDependencies() throws Exception {
        this.startRepository();
        this.loadTestLibraries();
        this.checkClasspath(new MavenId[]{this.projectA}, new MavenId[]{this.projectA});
    }

    @Test
    public void shouldBuildCorrectClasspathForMultipleProjectsWithNoDependencies() throws Exception {
        this.startRepository();
        this.loadTestLibraries();
        this.checkClasspath(new MavenId[]{this.projectA, this.projectB, this.projectC}, new MavenId[]{this.projectA, this.projectB, this.projectC});
    }

    @Test
    public void shouldBuildCorrectClasspathForProjectsWithVariousDependencies() throws Exception {
        this.startRepository();
        this.loadTestLibraries();
        this.checkClasspath(new MavenId[]{this.projectA}, new MavenId[]{this.projectA});
        this.checkClasspath(new MavenId[]{this.projectB}, new MavenId[]{this.projectB});
        this.checkClasspath(new MavenId[]{this.projectC}, new MavenId[]{this.projectC});
        this.checkClasspath(new MavenId[]{this.projectD}, new MavenId[]{this.projectD, this.projectA, this.projectB});
        this.checkClasspath(new MavenId[]{this.projectE}, new MavenId[]{this.projectE, this.projectD, this.projectA, this.projectB});
        this.checkClasspath(new MavenId[]{this.projectF}, new MavenId[]{this.projectF, this.projectE, this.projectC, this.projectD, this.projectA, this.projectB});
        this.checkClasspath(new MavenId[]{this.projectG}, new MavenId[]{this.projectG, this.projectC, this.projectE, this.projectD, this.projectA});
        this.checkClasspath(new MavenId[]{this.projectH}, new MavenId[]{this.projectH, this.projectG, this.projectB, this.projectC, this.projectE, this.projectD, this.projectA});
        this.checkClasspath(new MavenId[]{this.projectI}, new MavenId[]{this.projectI, this.projectH, this.projectF, this.projectG, this.projectB, this.projectC, this.projectE, this.projectD, this.projectA});
    }

    @Test
    public void shouldAdjustClasspathForProjectWhoseDependenciesAreChanged() throws Exception {
        this.startRepository();
        this.loadTestLibraries();
        this.loadTestLibrary("org.jboss.example:ProjectG:1.0", "test/dependency/case1/testProjectG.xml");
        this.checkClasspath(new MavenId[]{this.projectG}, new MavenId[]{this.projectG, this.projectC, this.projectE, this.projectD, this.projectA});
        this.loadTestLibrary("org.jboss.example:ProjectG:1.0", "test/dependency/case1/testProjectG-withNoExclusions.xml");
        this.maven.notifyUpdatedPom(this.projectG);
        this.checkClasspath(new MavenId[]{this.projectG}, new MavenId[]{this.projectG, this.projectC, this.projectE, this.projectD, this.projectA, this.projectB});
    }

    protected void checkClasspath(MavenId[] projectIds, MavenId[] classpathProjects) {
        ArrayList<MavenId> idsExpectedOnClasspath = new ArrayList<MavenId>();
        for (int i = 0; i != classpathProjects.length; ++i) {
            idsExpectedOnClasspath.add(classpathProjects[i]);
        }
        MavenClassLoaders.ProjectClassLoader loader = (MavenClassLoaders.ProjectClassLoader)this.maven.getClassLoader(null, projectIds);
        Assert.assertThat((Object)loader, Is.is(IsNull.notNullValue()));
        ArrayList debugSearchPath = new ArrayList();
        URL result = loader.findResource("non/existant/resource/name", debugSearchPath);
        Assert.assertThat((Object)result, Is.is(IsNull.nullValue()));
        Assert.assertThat(debugSearchPath, Is.is(idsExpectedOnClasspath));
        for (int i = 0; i != 1000; ++i) {
            loader.findResource("non/existant/resource/name/" + i);
        }
    }
}

