/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.maven;

import java.io.IOException;
import javax.jcr.Credentials;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.SimpleCredentials;
import org.junit.After;
import org.modeshape.graph.connector.inmemory.InMemoryRepositorySource;
import org.modeshape.jcr.JcrConfiguration;
import org.modeshape.jcr.JcrEngine;
import org.modeshape.repository.ModeShapeConfiguration;

public abstract class AbstractJcrRepositoryTest {
    public static final String TESTDATA_PATH = "./src/test/resources/";
    public static final String WORKSPACE_NAME = "default";
    public static final String USERNAME = "superuser";
    public static final String PASSWORD = "secret";
    private static JcrEngine engine;
    private static Repository repository;
    protected Credentials simpleCredentials = new SimpleCredentials("superuser", "secret".toCharArray());

    public synchronized void startRepository() throws RepositoryException, IOException {
        if (repository == null) {
            JcrConfiguration config = new JcrConfiguration();
            String repositoryName = "Maven Repository";
            String workspaceName = WORKSPACE_NAME;
            String repositorySource = "ddlRepositorySource";
            config = new JcrConfiguration();
            ((ModeShapeConfiguration.RepositorySourceDefinition)((ModeShapeConfiguration.RepositorySourceDefinition)config.repositorySource(repositorySource).usingClass(InMemoryRepositorySource.class)).setDescription("The repository for our content")).setProperty("defaultWorkspaceName", workspaceName);
            config.repository(repositoryName).setSource(repositorySource);
            config.save();
            engine = config.build();
            engine.start();
            repository = engine.getRepository(repositoryName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @After
    public synchronized void shutdownRepository() {
        if (repository != null && engine != null) {
            try {
                engine.shutdown();
            }
            finally {
                engine = null;
                repository = null;
            }
        }
    }

    public boolean isRepositoryStarted() {
        return repository != null;
    }

    public Repository getRepository() throws RepositoryException, IOException {
        this.startRepository();
        return repository;
    }

    public Credentials getTestCredentials() {
        return this.simpleCredentials;
    }
}

