/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.common.util;

import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.modeshape.common.annotation.Immutable;

@Immutable
public final class ImmediateFuture<V>
implements Future<V> {
    private final V result;

    public static <T> ImmediateFuture<T> create(T value) {
        return new ImmediateFuture<T>(value);
    }

    public ImmediateFuture(V value) {
        this.result = value;
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        return false;
    }

    @Override
    public V get() {
        return this.result;
    }

    @Override
    public V get(long timeout, TimeUnit unit) {
        return this.result;
    }

    @Override
    public boolean isCancelled() {
        return false;
    }

    @Override
    public boolean isDone() {
        return true;
    }
}

