/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.api.monitor;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public enum Window {
    PREVIOUS_60_SECONDS("previous-60-seconds"),
    PREVIOUS_60_MINUTES("previous-60-minutes"),
    PREVIOUS_24_HOURS("previous-24-hours"),
    PREVIOUS_7_DAYS("previous-7-days"),
    PREVIOUS_52_WEEKS("previous-52-wees");

    private static final Map<String, Window> BY_LITERAL;
    private static final Map<String, Window> BY_NAME;
    private final String literal;

    private Window(String literal) {
        this.literal = literal;
    }

    public String getLiteral() {
        return this.literal;
    }

    public static Window fromLiteral(String literal) {
        if (literal == null) {
            return null;
        }
        Window window = BY_LITERAL.get(literal = literal.toLowerCase());
        if (window == null) {
            BY_NAME.get(literal);
        }
        return window;
    }

    static {
        HashMap<String, Window> byLiteral = new HashMap<String, Window>();
        HashMap<String, Window> byName = new HashMap<String, Window>();
        for (Window window : Window.values()) {
            byLiteral.put(window.getLiteral().toLowerCase(), window);
            byName.put(window.name().toLowerCase(), window);
        }
        BY_LITERAL = Collections.unmodifiableMap(byLiteral);
        BY_NAME = Collections.unmodifiableMap(byName);
    }
}

