/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.web.jcr.rest.client.json;

import java.io.File;
import java.io.FileFilter;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.jcr.nodetype.NodeType;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.modeshape.common.logging.Logger;
import org.modeshape.common.util.Base64;
import org.modeshape.web.jcr.rest.client.IJcrConstants;
import org.modeshape.web.jcr.rest.client.IRestClient;
import org.modeshape.web.jcr.rest.client.RestClientI18n;
import org.modeshape.web.jcr.rest.client.Status;
import org.modeshape.web.jcr.rest.client.domain.QueryRow;
import org.modeshape.web.jcr.rest.client.domain.Repository;
import org.modeshape.web.jcr.rest.client.domain.Server;
import org.modeshape.web.jcr.rest.client.domain.Workspace;
import org.modeshape.web.jcr.rest.client.http.HttpClientConnection;
import org.modeshape.web.jcr.rest.client.json.FileNode;
import org.modeshape.web.jcr.rest.client.json.FolderNode;
import org.modeshape.web.jcr.rest.client.json.IJsonConstants;
import org.modeshape.web.jcr.rest.client.json.NodeTypeNode;
import org.modeshape.web.jcr.rest.client.json.RepositoryNode;
import org.modeshape.web.jcr.rest.client.json.ServerNode;
import org.modeshape.web.jcr.rest.client.json.WorkspaceNode;

public final class JsonRestClient
implements IRestClient {
    private static final Logger LOGGER = Logger.getLogger(JsonRestClient.class);
    private static final String VERSION_2_REPOSITORIES_KEY = "repositories";
    private static final String SERVER_PARM = "--server";
    private static final String REPO_PARM = "--repo";
    private static final String WORKSPACENAME_PARM = "--workspacename";
    private static final String WORKSPACEPATH_PARM = "--workspacepath";
    private static final String FILE_PARM = "--file";
    private static final String DIR_PARM = "--dir";
    private static final String USERNAME_PARM = "--username";
    private static final String PWD_PARM = "--pwd";
    private static final String UNPUBLISH = "--unpublish";
    private static final String HELP_PARM = "--help";

    private HttpClientConnection connect(Server server, URL url, IJsonConstants.RequestMethod method) throws Exception {
        LOGGER.trace("connect: url={0}, method={1}", new Object[]{url, method});
        return new HttpClientConnection(server, url, method);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createFileNode(Workspace workspace, String path, File file, boolean useVersioning) throws Exception {
        LOGGER.trace("createFileNode: workspace={0}, path={1}, file={2}", workspace.getName(), path, file.getAbsolutePath());
        FileNode fileNode = new FileNode(workspace, path, file, useVersioning);
        URL fileNodeUrl = fileNode.getUrl();
        URL fileNodeUrlWithTerseResponse = new URL(fileNodeUrl.toString() + "?mode:includeNode=false");
        HttpClientConnection connection = this.connect(workspace.getServer(), fileNodeUrlWithTerseResponse, IJsonConstants.RequestMethod.POST);
        try {
            LOGGER.trace("createFileNode: create node={0}", fileNode);
            connection.write(fileNode.getContent());
            int responseCode = connection.getResponseCode();
            if (responseCode != 201) {
                LOGGER.error(RestClientI18n.connectionErrorMsg, responseCode, "createFileNode");
                String msg = RestClientI18n.createFileFailedMsg.text(file.getName(), path, workspace.getName(), responseCode);
                throw new RuntimeException(msg);
            }
        }
        finally {
            if (connection != null) {
                LOGGER.trace("createFileNode: leaving", new Object[0]);
                connection.disconnect();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateFileNode(Workspace workspace, String path, File file, boolean useVersioning) throws Exception {
        LOGGER.trace("updateFileNode: workspace={0}, path={1}, file={2}", workspace.getName(), path, file.getAbsolutePath());
        FileNode fileNode = new FileNode(workspace, path, file, useVersioning);
        URL fileNodeUrl = fileNode.getUrl();
        URL fileNodeUrlWithTerseResponse = new URL(fileNodeUrl.toString() + "?mode:includeNode=false");
        HttpClientConnection connection = this.connect(workspace.getServer(), fileNodeUrlWithTerseResponse, IJsonConstants.RequestMethod.PUT);
        try {
            LOGGER.trace("updateFileNode: update node={0}", fileNode);
            connection.write(fileNode.getContent());
            int responseCode = connection.getResponseCode();
            if (responseCode != 200) {
                LOGGER.error(RestClientI18n.connectionErrorMsg, responseCode, "updateFileNode");
                String msg = RestClientI18n.updateFileFailedMsg.text(file.getName(), path, workspace.getName(), responseCode);
                throw new RuntimeException(msg);
            }
        }
        finally {
            if (connection != null) {
                LOGGER.trace("updateFileNode: leaving", new Object[0]);
                connection.disconnect();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createFolderNode(Workspace workspace, String path) throws Exception {
        LOGGER.trace("createFolderNode: workspace={0}, path={1}", workspace.getName(), path);
        FolderNode folderNode = new FolderNode(workspace, path);
        HttpClientConnection connection = this.connect(workspace.getServer(), folderNode.getUrl(), IJsonConstants.RequestMethod.POST);
        try {
            LOGGER.trace("createFolderNode: create node={0}", folderNode);
            connection.write(folderNode.getContent());
            int responseCode = connection.getResponseCode();
            if (responseCode != 201) {
                LOGGER.error(RestClientI18n.connectionErrorMsg, responseCode, "createFolderNode");
                String msg = RestClientI18n.createFolderFailedMsg.text(path, workspace.getName(), responseCode);
                throw new RuntimeException(msg);
            }
        }
        finally {
            if (connection != null) {
                LOGGER.trace("createFolderNode: leaving", new Object[0]);
                connection.disconnect();
            }
        }
    }

    private void ensureFolderExists(Workspace workspace, String folderPath) throws Exception {
        LOGGER.trace("ensureFolderExists: workspace={0}, path={1}", workspace.getName(), folderPath);
        FolderNode folderNode = new FolderNode(workspace, folderPath);
        if (!this.pathExists(workspace.getServer(), folderNode.getUrl())) {
            StringBuilder path = new StringBuilder();
            for (char c : folderPath.toCharArray()) {
                if (c == '/') {
                    if (path.length() > 1) {
                        folderNode = new FolderNode(workspace, path.toString());
                        if (!this.pathExists(workspace.getServer(), folderNode.getUrl())) {
                            this.createFolderNode(workspace, folderNode.getPath());
                        }
                    }
                    path.append(c);
                    continue;
                }
                path.append(c);
                if (path.length() != folderPath.length()) continue;
                folderNode = new FolderNode(workspace, path.toString());
                if (this.pathExists(workspace.getServer(), folderNode.getUrl())) continue;
                this.createFolderNode(workspace, folderNode.getPath());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Server validate(Server server) throws Exception {
        assert (server != null);
        LOGGER.trace("validate: server={0}", server);
        ServerNode serverNode = new ServerNode(server);
        URL url = serverNode.getFindRepositoriesUrl();
        HttpClientConnection connection = this.connect(server, url, IJsonConstants.RequestMethod.GET);
        try {
            int responseCode = connection.getResponseCode();
            if (responseCode != 200) {
                LOGGER.error(RestClientI18n.connectionErrorMsg, responseCode, "validate");
                String msg = RestClientI18n.validateFailedMsg.text(server.getName(), responseCode);
                throw new RuntimeException(msg);
            }
            String response = connection.read();
            Version version = this.determineVersion(response);
            switch (version) {
                case VERSION_1: {
                    LOGGER.trace("validate: Found version 2.x server at " + server, new Object[0]);
                    Server server2 = server.asValidated(server.getUrl());
                    return server2;
                }
                case VERSION_2: {
                    LOGGER.trace("validate: Found version 3.x server at " + server, new Object[0]);
                    String original = server.getUrl().trim();
                    if (!original.endsWith("/")) {
                        original = original + "/";
                    }
                    String v1Url = original + "v1";
                    Server server3 = server.asValidated(v1Url);
                    return server3;
                }
            }
        }
        finally {
            if (connection != null) {
                LOGGER.trace("validate: leaving", new Object[0]);
                connection.disconnect();
            }
        }
        assert (false) : "Should not get here";
        return server;
    }

    protected Version determineVersion(String getRepositoriesResponse) throws Exception {
        JSONObject doc = new JSONObject(getRepositoriesResponse);
        try {
            if (doc.has(VERSION_2_REPOSITORIES_KEY)) {
                doc.getJSONArray(VERSION_2_REPOSITORIES_KEY);
                return Version.VERSION_2;
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return Version.VERSION_1;
    }

    @Override
    public Collection<Repository> getRepositories(Server server) throws Exception {
        assert (server != null);
        LOGGER.trace("getRepositories: server={0}", server);
        ServerNode serverNode = new ServerNode(server);
        HttpClientConnection connection = this.connect(server, serverNode.getFindRepositoriesUrl(), IJsonConstants.RequestMethod.GET);
        try {
            int responseCode = connection.getResponseCode();
            if (responseCode == 200) {
                Collection<Repository> collection = serverNode.getRepositories(connection.read());
                return collection;
            }
            LOGGER.error(RestClientI18n.connectionErrorMsg, responseCode, "getRepositories");
            String msg = RestClientI18n.getRepositoriesFailedMsg.text(server.getName(), responseCode);
            throw new RuntimeException(msg);
        }
        finally {
            if (connection != null) {
                LOGGER.trace("getRepositories: leaving", new Object[0]);
                connection.disconnect();
            }
        }
    }

    @Override
    public Map<String, NodeType> getNodeTypes(Repository repository) throws Exception {
        assert (repository != null);
        LOGGER.trace("getNodeTypes: workspace={0}", repository);
        Collection<Workspace> workspaces = this.getWorkspaces(repository);
        Workspace workspace = null;
        Workspace systemWs = null;
        for (Workspace wspace : workspaces) {
            if (wspace.getName().equalsIgnoreCase("default")) {
                workspace = wspace;
                break;
            }
            if (workspace == null && !wspace.getName().equalsIgnoreCase("system")) {
                workspace = wspace;
            }
            if (!wspace.getName().equalsIgnoreCase("system")) continue;
            systemWs = wspace;
        }
        if (workspace == null) {
            workspace = systemWs;
        }
        NodeTypeNode nodetypeNode = new NodeTypeNode(workspace);
        HttpClientConnection connection = this.connect(workspace.getServer(), nodetypeNode.getUrl(), IJsonConstants.RequestMethod.GET);
        try {
            int responseCode = connection.getResponseCode();
            if (responseCode == 200) {
                Map<String, NodeType> map = nodetypeNode.getNodeTypes(connection.read());
                return map;
            }
            LOGGER.error(RestClientI18n.connectionErrorMsg, responseCode, "getNodeTypes");
            String msg = RestClientI18n.getNodeTypesFailedMsg.text(nodetypeNode.getUrl(), responseCode);
            throw new RuntimeException(msg);
        }
        finally {
            if (connection != null) {
                LOGGER.trace("getNodeTypes: leaving", new Object[0]);
                connection.disconnect();
            }
        }
    }

    @Override
    public URL getUrl(File file, String path, Workspace workspace) throws Exception {
        assert (file != null);
        assert (path != null);
        assert (workspace != null);
        if (file.isDirectory()) {
            throw new IllegalArgumentException();
        }
        return new FileNode(workspace, path, file).getUrl();
    }

    @Override
    public Collection<Workspace> getWorkspaces(Repository repository) throws Exception {
        assert (repository != null);
        LOGGER.trace("getWorkspaces: repository={0}", repository);
        RepositoryNode repositoryNode = new RepositoryNode(repository);
        HttpClientConnection connection = this.connect(repository.getServer(), repositoryNode.getUrl(), IJsonConstants.RequestMethod.GET);
        try {
            int responseCode = connection.getResponseCode();
            if (responseCode == 200) {
                Collection<Workspace> collection = repositoryNode.getWorkspaces(connection.read());
                return collection;
            }
            LOGGER.error(RestClientI18n.connectionErrorMsg, responseCode, "getWorkspaces");
            String msg = RestClientI18n.getWorkspacesFailedMsg.text(repository.getName(), repository.getServer().getName(), responseCode);
            throw new RuntimeException(msg);
        }
        finally {
            if (connection != null) {
                LOGGER.trace("getWorkspaces: leaving", new Object[0]);
                connection.disconnect();
            }
        }
    }

    String getFileContents(Workspace workspace, String path, File file) throws Exception {
        FileNode fileNode = new FileNode(workspace, path, file);
        HttpClientConnection connection = this.connect(workspace.getServer(), fileNode.getFileContentsUrl(), IJsonConstants.RequestMethod.GET);
        int responseCode = connection.getResponseCode();
        if (responseCode == 200) {
            String result = connection.read();
            return fileNode.getFileContents(result);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean pathExists(Server server, URL url) throws Exception {
        LOGGER.trace("pathExists: url={0}", url);
        HttpClientConnection connection = this.connect(server, url, IJsonConstants.RequestMethod.GET);
        try {
            int responseCode = connection.getResponseCode();
            LOGGER.trace("pathExists: responseCode={0}", responseCode);
            boolean bl = responseCode == 200;
            return bl;
        }
        finally {
            if (connection != null) {
                LOGGER.trace("pathExists: leaving", new Object[0]);
                connection.disconnect();
            }
        }
    }

    public boolean pathExists(Workspace workspace, String path, File file) throws Exception {
        FileNode fileNode = new FileNode(workspace, path, file);
        return this.pathExists(workspace.getServer(), fileNode.getUrl());
    }

    @Override
    public Status publish(Workspace workspace, String path, File file) {
        return this.publish(workspace, path, file, false);
    }

    @Override
    public boolean fileExists(File file, Workspace workspace, String path) throws Exception {
        return this.pathExists(workspace, path, file);
    }

    @Override
    public Status publish(Workspace workspace, String path, File file, boolean useVersioning) {
        assert (workspace != null);
        assert (path != null);
        assert (file != null);
        LOGGER.trace("publish: workspace={0}, path={1}, file={2}", workspace.getName(), path, file.getAbsolutePath());
        try {
            if (this.pathExists(workspace, path, file)) {
                this.updateFileNode(workspace, path, file, useVersioning);
            } else {
                this.ensureFolderExists(workspace, path);
                this.createFileNode(workspace, path, file, useVersioning);
            }
        }
        catch (Exception e) {
            String msg = RestClientI18n.publishFailedMsg.text(file.getAbsolutePath(), path, workspace.getName());
            return new Status(Status.Severity.ERROR, msg, e);
        }
        return Status.OK_STATUS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Status unpublish(Workspace workspace, String path, File file) {
        assert (workspace != null);
        assert (path != null);
        assert (file != null);
        LOGGER.trace("unpublish: workspace={0}, path={1}, file={2}", workspace.getName(), path, file.getAbsolutePath());
        HttpClientConnection connection = null;
        try {
            FileNode fileNode = new FileNode(workspace, path, file);
            connection = this.connect(workspace.getServer(), fileNode.getUrl(), IJsonConstants.RequestMethod.DELETE);
            int responseCode = connection.getResponseCode();
            LOGGER.trace("responseCode={0}", responseCode);
            if (responseCode != 204) {
                if (!this.pathExists(workspace.getServer(), fileNode.getUrl())) {
                    String msg = RestClientI18n.unpublishNeverPublishedMsg.text(file.getAbsolutePath(), workspace.getName(), path);
                    Status status = new Status(Status.Severity.INFO, msg, null);
                    return status;
                }
                LOGGER.error(RestClientI18n.connectionErrorMsg, responseCode, "unpublish");
                String msg = RestClientI18n.unpublishFailedMsg.text(file.getName(), workspace.getName(), path);
                throw new RuntimeException(msg);
            }
            Status status = Status.OK_STATUS;
            return status;
        }
        catch (Exception e) {
            String msg = RestClientI18n.unpublishFailedMsg.text(file.getAbsolutePath(), workspace.getName(), path);
            Status status = new Status(Status.Severity.ERROR, msg, e);
            return status;
        }
        finally {
            if (connection != null) {
                LOGGER.trace("unpublish: leaving", new Object[0]);
                connection.disconnect();
            }
        }
    }

    @Override
    public List<QueryRow> query(Workspace workspace, String language, String statement) throws Exception {
        return this.query(workspace, language, statement, 0, -1, null);
    }

    @Override
    public List<QueryRow> query(Workspace workspace, String language, String statement, int offset, int limit) throws Exception {
        return this.query(workspace, language, statement, 0, -1, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<QueryRow> query(Workspace workspace, String language, String statement, int offset, int limit, Map<String, String> variables) throws Exception {
        assert (workspace != null);
        assert (language != null);
        assert (statement != null);
        LOGGER.trace("query: workspace={0}, language={1}, file={2}, offset={3}, limit={4}", workspace.getName(), language, statement, offset, limit);
        HttpClientConnection connection = null;
        try {
            Object types;
            String response;
            WorkspaceNode workspaceNode = new WorkspaceNode(workspace);
            StringBuilder url = new StringBuilder(workspaceNode.getQueryUrl().toString());
            boolean hasOffset = offset > 0;
            boolean firstQueryParam = true;
            if (hasOffset) {
                url.append("?offset=").append(offset);
                firstQueryParam = false;
            }
            if (limit >= 0) {
                if (hasOffset) {
                    url.append("&");
                } else {
                    url.append("?");
                }
                url.append("limit=").append(limit);
                firstQueryParam = false;
            }
            if (variables != null && !variables.isEmpty()) {
                for (Map.Entry<String, String> varEntry : variables.entrySet()) {
                    String varName = varEntry.getKey();
                    String varValue = varEntry.getValue();
                    if (varName == null || varName.trim().length() == 0 || varValue == null || varValue.trim().length() == 0) continue;
                    if (firstQueryParam) {
                        firstQueryParam = false;
                        url.append("?");
                    } else {
                        url.append("&");
                    }
                    url.append(varName);
                    url.append('=');
                    url.append(varValue);
                }
            }
            connection = this.connect(workspace.getServer(), new URL(url.toString()), IJsonConstants.RequestMethod.POST);
            connection.setContentType(this.contentTypeFor(language));
            connection.write(statement.getBytes());
            int responseCode = connection.getResponseCode();
            LOGGER.trace("responseCode={0}", responseCode);
            if (responseCode != 200) {
                response = connection.read();
                String msg = "Error while executiong {0} query \"{1}\" with offset {2} and limit {3}: {4}";
                LOGGER.debug(msg, language, statement, offset, limit, response);
                throw new RuntimeException(RestClientI18n.invalidQueryMsg.text(response));
            }
            response = connection.read();
            JSONObject result = new JSONObject(response);
            HashMap<String, String> columnTypes = new HashMap<String, String>();
            if (result.has("types")) {
                types = (JSONObject)result.get("types");
                Iterator iter = ((JSONObject)types).keys();
                while (iter.hasNext()) {
                    String columnName = (String)iter.next();
                    columnTypes.put(columnName, ((JSONObject)types).getString(columnName));
                }
            }
            types = Collections.unmodifiableMap(columnTypes);
            JSONArray rows = (JSONArray)result.get("rows");
            LinkedList<QueryRow> queryRows = new LinkedList<QueryRow>();
            for (int i = 0; i < rows.length(); ++i) {
                JSONObject row = (JSONObject)rows.get(i);
                HashMap<String, Object> values = new HashMap<String, Object>();
                Iterator valueIter = row.keys();
                while (valueIter.hasNext()) {
                    String valueName = (String)valueIter.next();
                    if (valueName.endsWith("/base64/")) {
                        byte[] data = Base64.decode(row.getString(valueName));
                        valueName = valueName.substring(0, valueName.length() - "/base64/".length());
                        values.put(valueName, data);
                        continue;
                    }
                    values.put(valueName, row.getString(valueName));
                }
                queryRows.add(new QueryRow((Map<String, String>)types, values));
            }
            LinkedList<QueryRow> linkedList = queryRows;
            return linkedList;
        }
        finally {
            if (connection != null) {
                LOGGER.trace("query: leaving", new Object[0]);
                connection.disconnect();
            }
        }
    }

    private String contentTypeFor(String language) throws Exception {
        if ("xpath".equalsIgnoreCase(language)) {
            return "application/jcr+xpath";
        }
        if ("sql".equalsIgnoreCase(language)) {
            return "application/jcr+sql";
        }
        if ("JCR-SQL2".equalsIgnoreCase(language)) {
            return "application/jcr+sql2";
        }
        if ("Search".equalsIgnoreCase(language)) {
            return "application/jcr+search";
        }
        throw new IllegalStateException(RestClientI18n.invalidQueryLanguageMsg.text(language, IJcrConstants.VALID_QUERY_LANGUAGES));
    }

    public static void main(String[] args) {
        block37: {
            File[] files;
            Workspace workspace;
            JsonRestClient client;
            String dir_loc;
            String workspace_path;
            String workspace_name;
            block38: {
                Status status;
                String file_name;
                block35: {
                    block36: {
                        if (args == null || args.length == 0 || args[0].equals(HELP_PARM)) {
                            System.out.println("Running the ModeShape Rest Client");
                            System.out.println("\trequired arguments are:");
                            System.out.println("  \t \t--server");
                            System.out.println("  \t \t--file or --dir");
                            System.out.println("  \t\t--workspacepath");
                            System.out.println("  \t\t--repo");
                            System.out.println("\toptional arguments are:");
                            System.out.println("  \t \t--workspacename (default=default)");
                            System.out.println(" \t\t--username(default=admin");
                            System.out.println("  \t \t--pwd (default=admin");
                            System.out.println("  \t \t--unpublish with no parameter, will remove file(s)");
                            System.exit(0);
                        }
                        String server_name = null;
                        workspace_name = "default";
                        workspace_path = null;
                        file_name = null;
                        dir_loc = null;
                        String user = "admin";
                        String pwd = "admin";
                        String repo_name = null;
                        boolean publish = true;
                        int pos = 0;
                        for (String arg : args) {
                            if ((arg = arg.trim()).equals(SERVER_PARM)) {
                                server_name = args[pos + 1];
                            } else if (arg.equals(REPO_PARM)) {
                                repo_name = args[pos + 1];
                            } else if (arg.equals(WORKSPACENAME_PARM)) {
                                workspace_name = args[pos + 1];
                            } else if (arg.equals(WORKSPACEPATH_PARM)) {
                                workspace_path = args[pos + 1];
                            } else if (arg.equals(FILE_PARM)) {
                                file_name = args[pos + 1];
                            } else if (arg.equals(DIR_PARM)) {
                                dir_loc = args[pos + 1];
                            } else if (arg.equals(USERNAME_PARM)) {
                                user = args[pos + 1];
                            } else if (arg.equals(PWD_PARM)) {
                                pwd = args[pos + 1];
                            } else if (arg.equals(UNPUBLISH)) {
                                publish = false;
                            }
                            ++pos;
                        }
                        String errparm = null;
                        if (server_name == null) {
                            errparm = SERVER_PARM;
                        } else if (repo_name == null) {
                            errparm = REPO_PARM;
                        } else if (file_name == null && dir_loc == null) {
                            errparm = "[--file | --dir]";
                        } else if (user == null) {
                            errparm = USERNAME_PARM;
                        } else if (pwd == null) {
                            errparm = PWD_PARM;
                        } else if (workspace_path == null) {
                            errparm = WORKSPACEPATH_PARM;
                        }
                        if (errparm != null) {
                            LOGGER.error(RestClientI18n.nullArgumentMsg, errparm);
                            System.exit(-1);
                        }
                        client = new JsonRestClient();
                        Server server = new Server(server_name, user, pwd);
                        workspace = null;
                        try {
                            server = client.validate(server);
                            Repository repository = new Repository(repo_name, server);
                            workspace = new Workspace(workspace_name, repository);
                            client.getRepositories(server);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            System.exit(-1);
                        }
                        if (!publish) break block35;
                        if (file_name == null) break block36;
                        status = client.publish(workspace, workspace_path, new File(file_name));
                        if (!JsonRestClient.checkStatus(status)) break block37;
                        LOGGER.info(RestClientI18n.publishSucceededMsg, file_name, workspace_path, workspace_name);
                        break block37;
                    }
                    for (File f : files = JsonRestClient.findAllFilesInDirectory(dir_loc)) {
                        Status status2 = client.publish(workspace, workspace_path, f);
                        if (!JsonRestClient.checkStatus(status2)) continue;
                        LOGGER.info(RestClientI18n.publishSucceededMsg, f.getName(), workspace_path, workspace_name);
                    }
                    break block37;
                }
                if (file_name == null) break block38;
                status = client.unpublish(workspace, workspace_path, new File(file_name));
                if (!JsonRestClient.checkStatus(status)) break block37;
                LOGGER.info(RestClientI18n.unpublishSucceededMsg, file_name, workspace_path, workspace_name);
                break block37;
            }
            for (File f : files = JsonRestClient.findAllFilesInDirectory(dir_loc)) {
                Status status = client.unpublish(workspace, workspace_path, f);
                if (!JsonRestClient.checkStatus(status)) continue;
                LOGGER.info(RestClientI18n.unpublishSucceededMsg, f.getName(), workspace_path, workspace_name);
            }
        }
    }

    private static boolean checkStatus(Status status) {
        if (status.isError()) {
            System.err.println(status.getMessage());
            status.getException().printStackTrace(System.err);
            return false;
        }
        return true;
    }

    private static File[] findAllFilesInDirectory(String dir) {
        File modelsDirFile = new File(dir);
        FileFilter fileFilter = new FileFilter(){

            @Override
            public boolean accept(File file) {
                if (file.isDirectory()) {
                    return false;
                }
                String fileName = file.getName();
                return fileName != null && fileName.length() != 0;
            }
        };
        return modelsDirFile.listFiles(fileFilter);
    }

    private static enum Version {
        VERSION_1,
        VERSION_2;

    }
}

