/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.jboss.resteasy.util.HeaderParameterParser;

public class AcceptCharsetParser {
    private static Charset parseCharset(String charset) {
        String params = null;
        int idx = charset.indexOf(";");
        if (idx > -1) {
            params = charset.substring(idx + 1).trim();
            charset = charset.substring(0, idx);
        }
        float q = 1.0f;
        if (params != null && !params.equals("")) {
            HashMap<String, String> typeParams = new HashMap<String, String>();
            int start = 0;
            while (start < params.length()) {
                start = HeaderParameterParser.setParam(typeParams, params, start);
            }
            String qval = (String)typeParams.get("q");
            if (qval != null) {
                q = Float.valueOf(qval).floatValue();
            }
        }
        return new Charset(charset, q);
    }

    public static List<String> parseAcceptHeader(String header) {
        String[] sets;
        ArrayList<Charset> set = new ArrayList<Charset>();
        for (String charset : sets = header.split(",")) {
            set.add(AcceptCharsetParser.parseCharset(charset.trim()));
        }
        Collections.sort(set);
        ArrayList<String> rtn = new ArrayList<String>();
        for (Charset c : set) {
            rtn.add(c.value);
        }
        return rtn;
    }

    private static class Charset
    implements Comparable<Charset> {
        private String value;
        private float q = 1.0f;

        private Charset(String value, float q) {
            this.value = value;
            this.q = q;
        }

        @Override
        public int compareTo(Charset charset) {
            if (this == charset) {
                return 0;
            }
            if (this.q == charset.q) {
                return 0;
            }
            if (this.q < charset.q) {
                return 1;
            }
            if (this.q > charset.q) {
                return -1;
            }
            return 0;
        }
    }
}

