/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.core.registry;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.jboss.resteasy.core.ResourceInvoker;
import org.jboss.resteasy.core.ResourceLocator;
import org.jboss.resteasy.core.ResourceMethod;
import org.jboss.resteasy.spi.DefaultOptionsMethodException;
import org.jboss.resteasy.spi.HttpRequest;
import org.jboss.resteasy.spi.MethodNotAllowedException;
import org.jboss.resteasy.spi.NotAcceptableException;
import org.jboss.resteasy.spi.NotFoundException;
import org.jboss.resteasy.spi.UnsupportedMediaTypeException;
import org.jboss.resteasy.util.WeightedMediaType;

public class Segment {
    public static final String RESTEASY_CHOSEN_ACCEPT = "RESTEASY_CHOSEN_ACCEPT";
    protected List<ResourceMethod> methods = new ArrayList<ResourceMethod>();
    protected ResourceLocator locator;

    protected boolean isEmpty() {
        return this.methods.size() == 0 && this.locator == null;
    }

    protected ResourceInvoker match(String httpMethod, HttpRequest request) {
        MediaType contentType = request.getHttpHeaders().getMediaType();
        List<MediaType> oldaccepts = request.getHttpHeaders().getAcceptableMediaTypes();
        ArrayList<WeightedMediaType> accepts = new ArrayList<WeightedMediaType>();
        for (MediaType accept : oldaccepts) {
            accepts.add(WeightedMediaType.parse(accept));
        }
        ArrayList<ResourceMethod> list = new ArrayList<ResourceMethod>();
        boolean methodMatch = false;
        boolean consumeMatch = false;
        for (ResourceMethod invoker : this.methods) {
            if (!invoker.getHttpMethods().contains(httpMethod)) continue;
            methodMatch = true;
            if (!invoker.doesConsume(contentType)) continue;
            consumeMatch = true;
            if (!invoker.doesProduce(accepts)) continue;
            list.add(invoker);
        }
        if (list.size() == 0) {
            if (this.locator != null) {
                return this.locator;
            }
            if (this.methods == null || this.methods.size() == 0) {
                throw new NotFoundException("Could not find resource for full path: " + request.getUri().getRequestUri());
            }
            if (!methodMatch) {
                Response res;
                HashSet<String> allowed = new HashSet<String>();
                for (ResourceMethod invoker : this.methods) {
                    allowed.addAll(invoker.getHttpMethods());
                }
                if (httpMethod.equalsIgnoreCase("HEAD") && allowed.contains("GET")) {
                    return this.match("GET", request);
                }
                if (allowed.contains("GET")) {
                    allowed.add("HEAD");
                }
                allowed.add("OPTIONS");
                String allowHeaderValue = "";
                boolean first = true;
                for (String allow : allowed) {
                    if (first) {
                        first = false;
                    } else {
                        allowHeaderValue = allowHeaderValue + ", ";
                    }
                    allowHeaderValue = allowHeaderValue + allow;
                }
                if (httpMethod.equals("OPTIONS")) {
                    res = Response.ok().header("Allow", allowHeaderValue).build();
                    throw new DefaultOptionsMethodException("No resource method found for options, return OK with Allow header", res);
                }
                res = Response.status(405).header("Allow", allowHeaderValue).build();
                throw new MethodNotAllowedException("No resource method found for " + httpMethod + ", return 405 with Allow header", res);
            }
            if (!consumeMatch) {
                throw new UnsupportedMediaTypeException("Cannot consume content type");
            }
            throw new NotAcceptableException("No match for accept header");
        }
        if (list.size() == 1) {
            return (ResourceInvoker)list.get(0);
        }
        IdentityHashMap<WeightedMediaType, ResourceMethod> consumesMap = new IdentityHashMap<WeightedMediaType, ResourceMethod>();
        for (ResourceMethod invoker : list) {
            if (invoker.getConsumes() == null) {
                WeightedMediaType defaultConsumes = WeightedMediaType.valueOf("*/*;q=0.0");
                consumesMap.put(defaultConsumes, invoker);
                continue;
            }
            for (WeightedMediaType consume : invoker.getPreferredConsumes()) {
                consumesMap.put(consume, invoker);
            }
        }
        list = new ArrayList();
        ArrayList consumes = new ArrayList();
        consumes.addAll(consumesMap.keySet());
        Collections.sort(consumes);
        boolean first = true;
        WeightedMediaType current = null;
        for (WeightedMediaType type : consumes) {
            if (first) {
                list.add((ResourceMethod)consumesMap.get(type));
                current = type;
                first = false;
                continue;
            }
            if (current.compareTo(type) != 0) break;
            list.add((ResourceMethod)consumesMap.get(type));
        }
        if (list.size() == 1) {
            return (ResourceInvoker)list.get(0);
        }
        IdentityHashMap<WeightedMediaType, ResourceMethod> producesMap = new IdentityHashMap<WeightedMediaType, ResourceMethod>();
        for (ResourceMethod invoker : list) {
            if (invoker.getProduces() == null) {
                WeightedMediaType defaultProduces = WeightedMediaType.valueOf("*/*;q=0.0");
                producesMap.put(defaultProduces, invoker);
                continue;
            }
            for (WeightedMediaType produce : invoker.getPreferredProduces()) {
                producesMap.put(produce, invoker);
            }
        }
        if (accepts == null || accepts.size() == 0) {
            accepts = new ArrayList(1);
            accepts.add(WeightedMediaType.valueOf("*/*"));
        }
        ArrayList produces = new ArrayList();
        produces.addAll(producesMap.keySet());
        Collections.sort(produces);
        Collections.sort(accepts);
        for (WeightedMediaType accept : accepts) {
            for (WeightedMediaType produce : produces) {
                if (!accept.isCompatible(produce)) continue;
                request.setAttribute(RESTEASY_CHOSEN_ACCEPT, accept);
                return (ResourceInvoker)producesMap.get(produce);
            }
        }
        return null;
    }
}

