/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.web.jcr.rest.client.json;

import java.io.File;
import java.io.FileInputStream;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.TimeZone;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.modeshape.common.annotation.Immutable;
import org.modeshape.common.util.Base64;
import org.modeshape.web.jcr.rest.client.Utils;
import org.modeshape.web.jcr.rest.client.domain.Workspace;
import org.modeshape.web.jcr.rest.client.json.FolderNode;
import org.modeshape.web.jcr.rest.client.json.JsonNode;
import org.modeshape.web.jcr.rest.client.json.JsonUtils;

@Deprecated
@Immutable
public final class FileNode
extends JsonNode {
    private static final long serialVersionUID = 1L;
    private final File file;
    private final String path;
    private final Workspace workspace;

    public FileNode(Workspace workspace, String path, File file) throws Exception {
        this(workspace, path, file, false);
    }

    public FileNode(Workspace workspace, String path, File file, boolean versionable) throws Exception {
        super(file.getName());
        assert (workspace != null);
        assert (path != null);
        this.file = file;
        this.path = path;
        this.workspace = workspace;
        this.withPrimaryType("nt:file");
        if (versionable) {
            this.withMixin("mix:versionable");
        }
        JSONObject content = this.createContent(file);
        this.withChild("jcr:content", content);
    }

    private JSONObject createContent(File file) throws JSONException {
        JSONObject content = new JSONObject();
        JSONObject properties = new JSONObject();
        content.put("properties", properties);
        properties.put("jcr:primaryType", "nt:resource");
        Calendar lastModified = Calendar.getInstance();
        lastModified.setTimeInMillis(file.lastModified());
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
        formatter.setTimeZone(TimeZone.getTimeZone("GMT"));
        properties.put("jcr:lastModified", formatter.format(lastModified.getTime()));
        properties.put("jcr:mimeType", Utils.getMimeType(file));
        return content;
    }

    @Override
    public byte[] getContent() throws Exception {
        JSONObject children = this.children();
        JSONObject kid = (JSONObject)children.get("jcr:content");
        JSONObject props = (JSONObject)kid.get("properties");
        props.put("jcr:data/base64/", this.readFile());
        return super.getContent();
    }

    String getFileContents(String jsonResponse) throws Exception {
        assert (jsonResponse != null);
        JSONObject contentNode = new JSONObject(jsonResponse);
        JSONObject props = (JSONObject)contentNode.get("properties");
        return props.getString("jcr:data/base64/");
    }

    URL getFileContentsUrl() throws Exception {
        StringBuilder url = new StringBuilder(this.getUrl().toString());
        url.append('/').append("jcr:content");
        return new URL(url.toString());
    }

    public String getPath() {
        return this.path;
    }

    @Override
    public URL getUrl() throws Exception {
        FolderNode folderNode = new FolderNode(this.workspace, this.getPath());
        StringBuilder url = new StringBuilder(folderNode.getUrl().toString());
        url.append('/').append(JsonUtils.encode(this.file.getName()));
        return new URL(url.toString());
    }

    String readFile() throws Exception {
        return Base64.encode(new FileInputStream(this.file.getAbsoluteFile()));
    }
}

