/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.web.jcr.rest.client.json;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jcr.PropertyType;
import javax.jcr.nodetype.NodeType;
import javax.jcr.version.OnParentVersionAction;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONObject;
import org.modeshape.common.annotation.Immutable;
import org.modeshape.common.util.CheckArg;
import org.modeshape.web.jcr.rest.client.domain.ChildNodeDefinition;
import org.modeshape.web.jcr.rest.client.domain.ItemDefinition;
import org.modeshape.web.jcr.rest.client.domain.PropertyDefinition;
import org.modeshape.web.jcr.rest.client.domain.Workspace;
import org.modeshape.web.jcr.rest.client.json.JsonNode;
import org.modeshape.web.jcr.rest.client.json.JsonUtils;
import org.modeshape.web.jcr.rest.client.json.WorkspaceNode;

@Deprecated
@Immutable
public final class NodeTypeNode
extends JsonNode {
    private static final long serialVersionUID = 1L;
    protected static final String NODE_TYPES_PATH = "jcr:system/jcr:nodeTypes";
    protected static final int NODE_TYPE_DEPTH = 5;
    private static final Map<String, Integer> PROPERTY_TYPES_BY_LOWERCASE_NAME;
    private static Set<String> EXCLUDE_TYPES;
    private final Workspace workspace;
    private Map<String, NodeType> nodeTypeMap = new HashMap<String, NodeType>();

    private static void registerType(Map<String, Integer> typesByLowerCaseName, int propertyType) {
        String name = PropertyType.nameFromValue(propertyType);
        typesByLowerCaseName.put(name.toLowerCase(), propertyType);
    }

    public NodeTypeNode(Workspace workspace) throws Exception {
        super(NODE_TYPES_PATH);
        assert (workspace != null);
        this.workspace = workspace;
    }

    public NodeTypeNode(Workspace workspace, String nodeTypeName) throws Exception {
        super("jcr:system/jcr:nodeTypes/" + nodeTypeName);
        assert (workspace != null);
        this.workspace = workspace;
    }

    public String getPath() {
        return this.getId();
    }

    @Override
    public URL getUrl() throws Exception {
        WorkspaceNode workspaceNode = new WorkspaceNode(this.workspace);
        StringBuilder url = new StringBuilder(workspaceNode.getUrl().toString());
        String path = this.getPath();
        if (!path.startsWith("/")) {
            path = '/' + path;
        }
        path = path.replaceAll("[/]+$", "");
        url.append(JsonUtils.encode(path));
        url.append("?depth=").append(5);
        return new URL(url.toString());
    }

    public Map<String, NodeType> getNodeTypes(String jsonResponse) throws Exception {
        CheckArg.isNotNull(jsonResponse, "jsonResponse");
        HashMap<String, org.modeshape.web.jcr.rest.client.domain.NodeType> nodeTypesByName = new HashMap<String, org.modeshape.web.jcr.rest.client.domain.NodeType>();
        JSONObject body = new JSONObject(jsonResponse);
        if (body.has("children")) {
            Object obj = body.get("children");
            JSONObject children = (JSONObject)obj;
            Iterator itr = children.keys();
            while (itr.hasNext()) {
                String key = JsonUtils.decode(itr.next().toString());
                Object child = children.get(key);
                if (child == null) continue;
                this.createNodeType(key, (JSONObject)child, nodeTypesByName);
            }
        }
        HashMap<String, NodeType> result = new HashMap<String, NodeType>();
        for (org.modeshape.web.jcr.rest.client.domain.NodeType nodeType : nodeTypesByName.values()) {
            result.put(nodeType.getName(), nodeType);
        }
        this.nodeTypeMap = result;
        return this.nodeTypeMap;
    }

    protected void createNodeType(String name, JSONObject body, Map<String, org.modeshape.web.jcr.rest.client.domain.NodeType> nodeTypes) throws Exception {
        JSONObject props = (JSONObject)body.get("properties");
        String nodeTypeName = this.valueFrom(props, "jcr:nodeTypeName");
        if (EXCLUDE_TYPES.contains(nodeTypeName)) {
            return;
        }
        boolean isMixin = this.valueFrom(props, "jcr:isMixin", false);
        boolean isAbstract = this.valueFrom(props, "jcr:isAbstract", false);
        boolean orderableChildren = this.valueFrom(props, "jcr:hasOrderableChildNodes", false);
        boolean queryable = this.valueFrom(props, "jcr:isQueryable", false);
        String primaryItemName = this.valueFrom(props, "jcr:primaryItemName");
        List<String> superTypeNames = this.valuesFrom(props, "jcr:supertypes");
        superTypeNames.removeAll(EXCLUDE_TYPES);
        ArrayList<PropertyDefinition> propDefns = new ArrayList<PropertyDefinition>();
        ArrayList<ChildNodeDefinition> childDefns = new ArrayList<ChildNodeDefinition>();
        if (body.has("children")) {
            Object obj = body.get("children");
            JSONObject children = (JSONObject)obj;
            Iterator itr = children.keys();
            while (itr.hasNext()) {
                ItemDefinition defn;
                String key = JsonUtils.decode(itr.next().toString());
                Object child = children.get(key);
                if (!(child instanceof JSONObject)) continue;
                JSONObject childObj = (JSONObject)child;
                String type = this.getPrimaryType(key, childObj);
                if (type.startsWith("nt:propertyDefinition") || type.startsWith("jcr:propertyDefinition")) {
                    defn = this.createPropertyDefinition(key, childObj, nodeTypeName, nodeTypes);
                    if (defn == null) continue;
                    propDefns.add((PropertyDefinition)defn);
                    continue;
                }
                if (!type.startsWith("nt:childNodeDefinition") && !type.startsWith("jcr:childNodeDefinition") || (defn = this.createChildNodeDefinition(key, childObj, nodeTypeName, nodeTypes)) == null) continue;
                childDefns.add((ChildNodeDefinition)defn);
            }
        }
        new org.modeshape.web.jcr.rest.client.domain.NodeType(nodeTypeName, isMixin, isAbstract, superTypeNames, propDefns, childDefns, primaryItemName, orderableChildren, queryable, nodeTypes);
    }

    protected String getPrimaryType(String key, JSONObject child) throws Exception {
        JSONObject childProps;
        String type = key;
        if (child.has("properties") && (childProps = child.getJSONObject("properties")).has("jcr:primaryType")) {
            type = childProps.getString("jcr:primaryType");
        }
        return type;
    }

    protected PropertyDefinition createPropertyDefinition(String defnName, JSONObject body, String declaringNodeTypeName, Map<String, org.modeshape.web.jcr.rest.client.domain.NodeType> nodeTypes) throws Exception {
        JSONObject props = (JSONObject)body.get("properties");
        String name = this.valueFrom(props, "jcr:name", "*");
        int requiredType = this.typeValueFrom(props, "jcr:requiredType", 0);
        boolean isAutoCreated = this.valueFrom(props, "jcr:autoCreated", false);
        boolean isMandatory = this.valueFrom(props, "jcr:mandatory", false);
        boolean isProtected = this.valueFrom(props, "jcr:protected", false);
        boolean isFullTextSearchable = this.valueFrom(props, "jcr:isFullTextSearchable", false);
        boolean isMultiple = this.valueFrom(props, "jcr:multiple", false);
        boolean isQueryOrderable = this.valueFrom(props, "jcr:isQueryOrderable", false);
        int onParentVersion = OnParentVersionAction.valueFromName(props.getString("jcr:onParentVersion"));
        List<String> defaultValues = this.valuesFrom(props, "jcr:defaultValues");
        List<String> valueConstraints = this.valuesFrom(props, "jcr:valueConstraints");
        List<String> availableQueryOperations = this.valuesFrom(props, "jcr:availableQueryOperators");
        return new PropertyDefinition(declaringNodeTypeName, name, requiredType, isAutoCreated, isMandatory, isProtected, isFullTextSearchable, isMultiple, isQueryOrderable, onParentVersion, defaultValues, valueConstraints, availableQueryOperations, nodeTypes);
    }

    protected ChildNodeDefinition createChildNodeDefinition(String defnName, JSONObject body, String declaringNodeTypeName, Map<String, org.modeshape.web.jcr.rest.client.domain.NodeType> nodeTypes) throws Exception {
        JSONObject props = (JSONObject)body.get("properties");
        String name = this.valueFrom(props, "jcr:name", "*");
        boolean isAutoCreated = this.valueFrom(props, "jcr:autoCreated", false);
        boolean isMandatory = this.valueFrom(props, "jcr:mandatory", false);
        boolean isProtected = this.valueFrom(props, "jcr:protected", false);
        boolean allowsSns = this.valueFrom(props, "jcr:sameNameSiblings", false);
        HashSet<String> requiredTypes = new HashSet<String>(this.valuesFrom(props, "jcr:requiredPrimaryTypes"));
        String defaultPrimaryType = this.valueFrom(props, "jcr:defaultPrimaryType");
        int onParentVersion = OnParentVersionAction.valueFromName(props.getString("jcr:onParentVersion"));
        return new ChildNodeDefinition(declaringNodeTypeName, name, requiredTypes, isAutoCreated, isMandatory, isProtected, allowsSns, onParentVersion, defaultPrimaryType, nodeTypes);
    }

    protected List<String> valuesFrom(JSONObject properties, String name) throws Exception {
        if (!properties.has(name)) {
            return Collections.emptyList();
        }
        Object prop = properties.get(name);
        if (prop instanceof JSONArray) {
            JSONArray superArray = (JSONArray)prop;
            int length = superArray.length();
            if (length == 0) {
                return Collections.emptyList();
            }
            ArrayList<String> result = new ArrayList<String>(length);
            for (int i = 0; i < length; ++i) {
                String value = superArray.getString(i);
                result.add(value);
            }
            return result;
        }
        return Collections.singletonList(prop.toString());
    }

    protected boolean valueFrom(JSONObject properties, String name, boolean defaultValue) throws Exception {
        if (!properties.has(name)) {
            return defaultValue;
        }
        return properties.getBoolean(name);
    }

    protected String valueFrom(JSONObject properties, String name) throws Exception {
        return this.valueFrom(properties, name, null);
    }

    protected String valueFrom(JSONObject properties, String name, String defaultValue) throws Exception {
        if (!properties.has(name)) {
            return defaultValue;
        }
        return properties.getString(name);
    }

    protected int typeValueFrom(JSONObject properties, String name, int defaultType) throws Exception {
        if (!properties.has(name)) {
            return defaultType;
        }
        String typeName = properties.getString(name);
        Integer result = PROPERTY_TYPES_BY_LOWERCASE_NAME.get(typeName.toLowerCase());
        return result != null ? result : defaultType;
    }

    static {
        HashMap<String, Integer> types = new HashMap<String, Integer>();
        NodeTypeNode.registerType(types, 2);
        NodeTypeNode.registerType(types, 6);
        NodeTypeNode.registerType(types, 5);
        NodeTypeNode.registerType(types, 12);
        NodeTypeNode.registerType(types, 4);
        NodeTypeNode.registerType(types, 3);
        NodeTypeNode.registerType(types, 7);
        NodeTypeNode.registerType(types, 8);
        NodeTypeNode.registerType(types, 9);
        NodeTypeNode.registerType(types, 1);
        NodeTypeNode.registerType(types, 0);
        NodeTypeNode.registerType(types, 11);
        NodeTypeNode.registerType(types, 10);
        PROPERTY_TYPES_BY_LOWERCASE_NAME = Collections.unmodifiableMap(types);
        EXCLUDE_TYPES = Collections.singleton("mode:defined");
    }
}

