/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jdbc;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;
import javax.jcr.Binary;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.ValueFormatException;

public final class JdbcJcrValueFactory {
    private JdbcJcrValueFactory() {
    }

    public static Value createValue(Object value) {
        return value == null ? null : new JdbcJcrValue(value);
    }

    private static class JdbcJcrValue
    implements Value {
        private Object value;

        protected JdbcJcrValue(Object value) {
            this.value = value;
        }

        @Override
        public boolean getBoolean() throws ValueFormatException, IllegalStateException, RepositoryException {
            if (this.value instanceof Boolean) {
                return (Boolean)this.value;
            }
            throw new ValueFormatException("Value not a Boolean");
        }

        @Override
        public Calendar getDate() throws ValueFormatException, IllegalStateException, RepositoryException {
            if (this.value instanceof Date) {
                Calendar c = Calendar.getInstance();
                c.setTime((Date)this.value);
                return c;
            }
            throw new ValueFormatException("Value not instance of Date");
        }

        @Override
        public double getDouble() throws ValueFormatException, IllegalStateException, RepositoryException {
            if (this.value instanceof Double) {
                return (Double)this.value;
            }
            throw new ValueFormatException("Value not a Double");
        }

        @Override
        public long getLong() throws ValueFormatException, IllegalStateException, RepositoryException {
            if (this.value instanceof Long) {
                return (Long)this.value;
            }
            throw new ValueFormatException("Value not a Long");
        }

        @Override
        public Binary getBinary() throws RepositoryException {
            if (this.value instanceof Binary) {
                return (Binary)this.value;
            }
            if (this.value instanceof byte[]) {
                final byte[] bytes = (byte[])this.value;
                return new Binary(){

                    @Override
                    public void dispose() {
                    }

                    @Override
                    public long getSize() {
                        return bytes.length;
                    }

                    @Override
                    public InputStream getStream() {
                        return new ByteArrayInputStream(bytes);
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public int read(byte[] b, long position) throws IOException {
                        if (this.getSize() <= position) {
                            return -1;
                        }
                        InputStream stream = null;
                        try {
                            long skipped;
                            stream = this.getStream();
                            for (long skip = position; skip > 0L; skip -= skipped) {
                                skipped = stream.skip(skip);
                                if (skipped > 0L) continue;
                                int n = -1;
                                return n;
                            }
                            int n = stream.read(b);
                            return n;
                        }
                        finally {
                            if (stream != null) {
                                try {
                                    stream.close();
                                }
                                catch (Exception e) {}
                            }
                        }
                    }
                };
            }
            throw new ValueFormatException("Value not a Binary");
        }

        @Override
        public BigDecimal getDecimal() throws ValueFormatException, RepositoryException {
            if (this.value instanceof BigDecimal) {
                return (BigDecimal)this.value;
            }
            throw new ValueFormatException("Value not a Decimal");
        }

        @Override
        public InputStream getStream() throws IllegalStateException, RepositoryException {
            if (this.value instanceof Binary) {
                return ((Binary)this.value).getStream();
            }
            if (this.value instanceof InputStream) {
                return (InputStream)this.value;
            }
            throw new ValueFormatException("Value not an InputStream");
        }

        @Override
        public String getString() throws IllegalStateException {
            if (this.value instanceof String) {
                return (String)this.value;
            }
            return this.value.toString();
        }

        @Override
        public int getType() {
            if (this.value instanceof String) {
                return 1;
            }
            if (this.value instanceof Boolean) {
                return 6;
            }
            if (this.value instanceof Date) {
                return 5;
            }
            if (this.value instanceof Double) {
                return 4;
            }
            if (this.value instanceof Long) {
                return 3;
            }
            if (this.value instanceof BigDecimal) {
                return 12;
            }
            if (this.value instanceof byte[] || this.value instanceof Binary || this.value instanceof InputStream) {
                return 2;
            }
            return 0;
        }
    }
}

