/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.common.collection;

import java.util.Map;
import org.modeshape.common.annotation.Immutable;
import org.modeshape.common.util.HashCode;
import org.modeshape.common.util.ObjectUtil;

@Immutable
public class ImmutableMapEntry<K, V>
implements Map.Entry<K, V> {
    private final K key;
    private final V value;

    public ImmutableMapEntry(K key, V value) {
        this.key = key;
        this.value = value;
    }

    public ImmutableMapEntry(Map.Entry<K, V> entry) {
        this.key = entry.getKey();
        this.value = entry.getValue();
    }

    @Override
    public K getKey() {
        return this.key;
    }

    @Override
    public V getValue() {
        return this.value;
    }

    @Override
    public V setValue(V newValue) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int hashCode() {
        return HashCode.compute(this.key, this.value);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Map.Entry) {
            Map.Entry that = (Map.Entry)obj;
            if (!ObjectUtil.isEqualWithNulls(this.getKey(), that.getKey())) {
                return false;
            }
            return ObjectUtil.isEqualWithNulls(this.getValue(), that.getValue());
        }
        return false;
    }

    public String toString() {
        return "" + this.key + " = " + this.getValue();
    }
}

