/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.common.collection;

import java.util.Iterator;
import org.modeshape.common.collection.DelegateIterator;
import org.modeshape.common.function.Function;

public class DelegateIterable<T, V>
implements Iterable<T> {
    private final Function<V, T> converter;
    private final Iterable<V> delegate;

    public static <T, V> Iterable<T> around(Iterable<V> delegate, Function<V, T> converter) {
        return new DelegateIterable<T, V>(delegate, converter);
    }

    protected DelegateIterable(Iterable<V> delegate, Function<V, T> converter) {
        this.converter = converter;
        this.delegate = delegate;
    }

    @Override
    public Iterator<T> iterator() {
        return DelegateIterator.around(this.delegate.iterator(), this.converter);
    }
}

