/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jdbc.delegate;

import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicReference;
import javax.jcr.RepositoryException;
import javax.jcr.nodetype.NodeType;
import org.modeshape.jdbc.JdbcLocalI18n;
import org.modeshape.jdbc.LocalJcrDriver;
import org.modeshape.jdbc.delegate.AbstractRepositoryDelegate;
import org.modeshape.jdbc.delegate.ConnectionInfo;
import org.modeshape.jdbc.delegate.HttpQueryResult;
import org.modeshape.jdbc.delegate.RepositoryDelegate;
import org.modeshape.jdbc.delegate.RepositoryDelegateFactory;
import org.modeshape.jdbc.rest.ModeShapeRestClient;
import org.modeshape.jdbc.rest.NodeTypes;
import org.modeshape.jdbc.rest.QueryResult;
import org.modeshape.jdbc.rest.Repositories;

public class HttpRepositoryDelegate
extends AbstractRepositoryDelegate {
    protected static final int PROTOCOL_HTTP = 2;
    public static final RepositoryDelegateFactory FACTORY = new RepositoryDelegateFactory(){

        @Override
        protected int determineProtocol(String url) {
            if (url.startsWith("jdbc:jcr:http://") && url.length() > "jdbc:jcr:http://".length()) {
                return 2;
            }
            return super.determineProtocol(url);
        }

        @Override
        protected RepositoryDelegate create(int protocol, String url, Properties info, LocalJcrDriver.JcrContextFactory contextFactory) {
            if (protocol == 2) {
                return new HttpRepositoryDelegate(url, info);
            }
            return super.create(protocol, url, info, contextFactory);
        }
    };
    private static final String HTTP_EXAMPLE_URL = "jdbc:jcr:http://{hostname}:{port}/{context root}";
    private AtomicReference<Map<String, NodeType>> nodeTypes = new AtomicReference();
    private AtomicReference<Repositories.Repository> repository = new AtomicReference();
    private ModeShapeRestClient restClient;

    protected HttpRepositoryDelegate(String url, Properties info) {
        super(url, info);
    }

    @Override
    protected ConnectionInfo createConnectionInfo(String url, Properties info) {
        return new HttpConnectionInfo(url, info);
    }

    protected Repositories.Repository repository() {
        return this.repository.get();
    }

    @Override
    public javax.jcr.query.QueryResult execute(String query, String language) throws RepositoryException {
        this.logger.trace("Executing query: {0}", query);
        try {
            QueryResult result = this.restClient.query(query, language);
            return new HttpQueryResult(result);
        }
        catch (Exception e) {
            throw new RepositoryException(e.getMessage(), e);
        }
    }

    @Override
    public String explain(String query, String language) throws RepositoryException {
        this.logger.trace("Explaining query: {0}", query);
        try {
            return this.restClient.queryPlan(query, language);
        }
        catch (Exception e) {
            throw new RepositoryException(e.getMessage(), e);
        }
    }

    @Override
    public String getDescriptor(String descriptorKey) {
        return this.repository() != null ? this.repository().getMetadata().get(descriptorKey).toString() : "";
    }

    @Override
    public NodeType nodeType(String name) throws RepositoryException {
        NodeType nodetype;
        if (this.nodeTypes.get() == null) {
            this.nodeTypes();
        }
        if ((nodetype = this.nodeTypes.get().get(name)) == null) {
            throw new RepositoryException(JdbcLocalI18n.unableToGetNodeType.text(name));
        }
        return nodetype;
    }

    @Override
    public Collection<NodeType> nodeTypes() throws RepositoryException {
        Map<String, NodeType> nodeTypes = this.nodeTypes.get();
        if (nodeTypes == null) {
            NodeTypes restNodeTypes = this.restClient.getNodeTypes();
            if (restNodeTypes.isEmpty()) {
                throw new RepositoryException(JdbcLocalI18n.noNodeTypesReturned.text(this.restClient.serverUrl()));
            }
            nodeTypes = new HashMap<String, NodeType>();
            for (org.modeshape.jdbc.rest.NodeType nodeType : restNodeTypes) {
                nodeTypes.put(nodeType.getName(), nodeType);
            }
            this.nodeTypes.compareAndSet(null, nodeTypes);
        }
        return this.nodeTypes.get().values();
    }

    @Override
    protected void initRepository() throws SQLException {
        if (this.repository() != null) {
            return;
        }
        this.logger.debug("Creating repository for HttpRepositoryDelegate", new Object[0]);
        ConnectionInfo info = this.getConnectionInfo();
        assert (info != null);
        String path = info.getRepositoryPath();
        if (path == null) {
            throw new SQLException("Missing repo path from " + info.getUrl());
        }
        String username = info.getUsername();
        if (username == null) {
            throw new SQLException("Missing username from " + info.getUrl());
        }
        char[] password = info.getPassword();
        if (password == null) {
            throw new SQLException("Missing password path from " + info.getUrl());
        }
        String repositoryName = info.getRepositoryName();
        if (repositoryName == null) {
            throw new SQLException("Missing repository name from " + info.getUrl());
        }
        String serverUrl = "http://" + path + "/" + repositoryName;
        String workspaceName = info.getWorkspaceName();
        if (workspaceName == null) {
            ModeShapeRestClient client = new ModeShapeRestClient(serverUrl, username, String.valueOf(password));
            List<String> allWorkspaces = client.getWorkspaces(repositoryName).getWorkspaces();
            if (allWorkspaces.isEmpty()) {
                throw new SQLException("No workspaces found for the " + repositoryName + " repository");
            }
            workspaceName = allWorkspaces.get(0);
        }
        serverUrl = serverUrl + "/" + workspaceName;
        this.logger.debug("Using server url: {0}", serverUrl);
        try {
            this.restClient = new ModeShapeRestClient(serverUrl, username, String.valueOf(password));
            Repositories repositories = this.restClient.getRepositories();
            this.setRepositoryNames(repositories.getRepositoryNames());
            Repositories.Repository repository = repositories.getRepository(repositoryName);
            if (repository == null) {
                throw new SQLException(JdbcLocalI18n.unableToFindNamedRepository.text(path, repositoryName));
            }
            this.repository.compareAndSet(null, repository);
        }
        catch (Exception e) {
            throw new SQLException(JdbcLocalI18n.noRepositoryNamesFound.text(new Object[0]), e);
        }
    }

    @Override
    public boolean isValid(int timeout) {
        try {
            this.restClient.getWorkspaces(this.getConnectionInfo().getRepositoryName());
            return true;
        }
        catch (Throwable e) {
            return false;
        }
    }

    @Override
    public void close() {
        super.close();
        this.restClient = null;
        this.nodeTypes.set(null);
        this.repository.set(null);
    }

    private class HttpConnectionInfo
    extends ConnectionInfo {
        protected HttpConnectionInfo(String url, Properties properties) {
            super(url, properties);
        }

        @Override
        protected void init() {
            super.init();
            StringBuilder url = new StringBuilder();
            String[] urlsections = this.repositoryPath.split("/");
            if (urlsections.length < 3) {
                return;
            }
            int workspacePos = -1;
            int repositoryPos = -1;
            int repoPos = 1;
            if (this.getWorkspaceName() == null && urlsections.length > 3) {
                workspacePos = urlsections.length - 1;
                String workspaceName = urlsections[workspacePos];
                this.setWorkspaceName(workspaceName);
                repoPos = 2;
            }
            if (this.getRepositoryName() == null && urlsections.length > 2) {
                repositoryPos = urlsections.length - repoPos;
                String repositoryName = urlsections[repositoryPos];
                this.setRepositoryName(repositoryName);
            }
            for (int i = 0; i < repositoryPos; ++i) {
                url.append(urlsections[i]);
                if (i >= repositoryPos - 1) continue;
                url.append("/");
            }
            this.repositoryPath = url.toString();
        }

        @Override
        public String getUrlExample() {
            return HttpRepositoryDelegate.HTTP_EXAMPLE_URL;
        }

        @Override
        public String getUrlPrefix() {
            return "jdbc:jcr:http://";
        }

        @Override
        protected void addUrlPropertyInfo(List<DriverPropertyInfo> results) {
            if (!this.repositoryPath.contains("/")) {
                this.setUrl(null);
            }
            super.addUrlPropertyInfo(results);
        }
    }
}

