/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.common.collection.ring;

import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.modeshape.common.collection.ring.Cursor;
import org.modeshape.common.collection.ring.GarbageCollectingConsumer;
import org.modeshape.common.collection.ring.Pointer;
import org.modeshape.common.collection.ring.PointerBarrier;
import org.modeshape.common.logging.Logger;
import org.modeshape.common.util.CheckArg;

public final class RingBuffer<T, C> {
    private final int bufferSize;
    private final int mask;
    protected final Cursor cursor;
    private final Object[] buffer;
    private final Executor executor;
    protected final AtomicBoolean addEntries = new AtomicBoolean(true);
    protected final ConsumerAdapter<T, C> consumerAdapter;
    private final Set<ConsumerRunner> consumers = new CopyOnWriteArraySet<ConsumerRunner>();
    private final GarbageCollectingConsumer gcConsumer;
    private final Lock producerLock;
    protected final Logger logger = Logger.getLogger(this.getClass());

    RingBuffer(String name, Cursor cursor, Executor executor, ConsumerAdapter<T, C> consumerAdapter, boolean gcEntries, boolean singleProducer) {
        this.cursor = cursor;
        this.bufferSize = cursor.getBufferSize();
        CheckArg.isPositive(this.bufferSize, "cursor.getBufferSize()");
        CheckArg.isPowerOfTwo(this.bufferSize, "cursor.getBufferSize()");
        this.mask = this.bufferSize - 1;
        this.buffer = new Object[this.bufferSize];
        this.executor = executor;
        this.consumerAdapter = consumerAdapter;
        if (gcEntries) {
            this.gcConsumer = this.cursor.createGarbageCollectingConsumer(new GarbageCollectingConsumer.Collectable(){

                @Override
                public void collect(long position) {
                    RingBuffer.this.clearEntry(position);
                }
            });
            this.executor.execute(this.gcConsumer);
        } else {
            this.gcConsumer = null;
        }
        this.producerLock = singleProducer ? new NoOpLock() : new ReentrantLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(T entry) {
        assert (entry != null);
        if (!this.addEntries.get()) {
            return false;
        }
        try {
            this.producerLock.lock();
            long position = this.cursor.claim();
            int index = (int)(position & (long)this.mask);
            this.buffer[index] = entry;
            boolean bl = this.cursor.publish(position);
            return bl;
        }
        finally {
            this.producerLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(T[] entries) {
        assert (entries != null);
        if (entries.length == 0 || !this.addEntries.get()) {
            return false;
        }
        try {
            this.producerLock.lock();
            long position = this.cursor.claim(entries.length);
            for (int i = 0; i != entries.length; ++i) {
                int index = (int)(position & (long)this.mask);
                this.buffer[index] = entries[i];
            }
            boolean bl = this.cursor.publish(position);
            return bl;
        }
        finally {
            this.producerLock.unlock();
        }
    }

    protected T getEntry(long position) {
        if (position < this.cursor.getCurrent() - (long)this.bufferSize) {
            return null;
        }
        int index = (int)(position & (long)this.mask);
        return (T)this.buffer[index];
    }

    protected void clearEntry(long position) {
        if (position < this.cursor.getCurrent() - (long)this.bufferSize) {
            return;
        }
        int index = (int)(position & (long)this.mask);
        this.buffer[index] = null;
    }

    public boolean addConsumer(C consumer) {
        return this.addConsumer(consumer, 1);
    }

    public boolean addConsumer(C consumer, int timesToRetryUponTimeout) {
        if (!this.addEntries.get()) {
            throw new IllegalStateException();
        }
        ConsumerRunner runner = new ConsumerRunner(consumer, timesToRetryUponTimeout);
        if (this.gcConsumer != null) {
            this.gcConsumer.stayBehind(runner.getPointer());
        }
        if (!this.consumers.add(runner)) {
            return false;
        }
        this.executor.execute(runner);
        return true;
    }

    public boolean remove(C consumer) {
        if (consumer != null) {
            ConsumerRunner match = null;
            for (ConsumerRunner runner : this.consumers) {
                if (!runner.getConsumer().equals(consumer)) continue;
                match = runner;
                break;
            }
            if (match != null) {
                match.close();
                return true;
            }
        }
        return false;
    }

    protected void disconnect(ConsumerRunner runner) {
        this.consumers.remove(runner);
        if (this.gcConsumer != null) {
            this.gcConsumer.ignore(runner.getPointer());
        }
    }

    public boolean hasConsumers() {
        return !this.consumers.isEmpty();
    }

    public void shutdown() {
        this.addEntries.set(false);
        this.cursor.complete();
        if (this.gcConsumer != null) {
            this.gcConsumer.close();
        }
        for (ConsumerRunner runner : new HashSet<ConsumerRunner>(this.consumers)) {
            runner.waitForCompletion();
        }
        assert (this.consumers.isEmpty());
    }

    protected static final class NoOpLock
    implements Lock {
        protected NoOpLock() {
        }

        @Override
        public void lock() {
        }

        @Override
        public void unlock() {
        }

        @Override
        public void lockInterruptibly() {
        }

        @Override
        public boolean tryLock() {
            return false;
        }

        @Override
        public boolean tryLock(long time, TimeUnit unit) {
            return false;
        }

        @Override
        public Condition newCondition() {
            return null;
        }
    }

    protected class ConsumerRunner
    implements Runnable {
        private final C consumer;
        private final PointerBarrier barrier;
        private final Pointer pointer;
        private final int timesToRetryUponTimeout;
        private final AtomicBoolean runThread = new AtomicBoolean(true);
        private final CountDownLatch stopLatch = new CountDownLatch(1);

        protected ConsumerRunner(C consumer, int timesToRetryUponTimeout) {
            this.consumer = consumer;
            this.timesToRetryUponTimeout = timesToRetryUponTimeout;
            this.barrier = RingBuffer.this.cursor.newBarrier();
            this.pointer = RingBuffer.this.cursor.newPointer();
        }

        protected Pointer getPointer() {
            return this.pointer;
        }

        protected C getConsumer() {
            return this.consumer;
        }

        public int hashCode() {
            return this.consumer.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof ConsumerRunner) {
                ConsumerRunner that = (ConsumerRunner)obj;
                return this.consumer.equals(that.consumer);
            }
            return false;
        }

        public void close() {
            if (this.runThread.compareAndSet(true, false)) {
                try {
                    this.barrier.close();
                    RingBuffer.this.cursor.signalConsumers();
                    this.stopLatch.await();
                }
                catch (InterruptedException e) {
                    Thread.interrupted();
                }
            }
        }

        protected void waitForCompletion() {
            try {
                this.stopLatch.await();
            }
            catch (InterruptedException e) {
                Thread.interrupted();
            }
        }

        /*
         * Exception decompiling
         */
        @Override
        public void run() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 114[WHILELOOP]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }

    public static interface ConsumerAdapter<EntryType, ConsumerType> {
        public boolean consume(ConsumerType var1, EntryType var2, long var3, long var5);

        public void close(ConsumerType var1);

        public void handleException(ConsumerType var1, Throwable var2, EntryType var3, long var4, long var6);
    }
}

