/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.api;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.jcr.Binary;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.RangeIterator;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.nodetype.NodeType;
import javax.jcr.observation.EventIterator;
import javax.jcr.observation.EventListener;
import javax.jcr.query.Query;
import javax.jcr.query.QueryResult;
import org.modeshape.jcr.api.nodetype.NodeTypeManager;

public class JcrTools {
    private boolean debug = false;

    public JcrTools() {
    }

    public JcrTools(boolean debug) {
        this.debug = debug;
    }

    public int removeAllChildren(Node node) throws RepositoryException {
        JcrTools.isNotNull(node, "node");
        int childrenRemoved = 0;
        NodeIterator iter = node.getNodes();
        while (iter.hasNext()) {
            Node child = iter.nextNode();
            child.remove();
            ++childrenRemoved;
        }
        return childrenRemoved;
    }

    public int removeAllChildren(Session session, String absPath) throws RepositoryException {
        try {
            Node node = session.getNode(absPath);
            return this.removeAllChildren(node);
        }
        catch (PathNotFoundException pathNotFoundException) {
            return 0;
        }
    }

    public Node getNode(Node node, String relativePath, boolean required) throws RepositoryException {
        Node result;
        block2: {
            JcrTools.isNotNull(node, "node");
            JcrTools.isNotNull(relativePath, "relativePath");
            result = null;
            try {
                result = node.getNode(relativePath);
            }
            catch (PathNotFoundException e) {
                if (!required) break block2;
                throw e;
            }
        }
        return result;
    }

    public String getReadable(Node node) {
        if (node == null) {
            return "";
        }
        try {
            return node.getPath();
        }
        catch (RepositoryException err) {
            return node.toString();
        }
    }

    public Node uploadFile(Session session, String path, InputStream stream) throws RepositoryException, IOException {
        JcrTools.isNotNull(session, "session");
        JcrTools.isNotNull(path, "path");
        JcrTools.isNotNull(stream, "stream");
        Node fileNode = null;
        boolean error = false;
        try {
            fileNode = this.findOrCreateNode(session.getRootNode(), path, "nt:folder", "nt:file");
            Node contentNode = this.findOrCreateChild(fileNode, "jcr:content", "nt:resource");
            Binary binary = session.getValueFactory().createBinary(stream);
            contentNode.setProperty("jcr:data", binary);
        }
        catch (RepositoryException e) {
            error = true;
            throw e;
        }
        catch (RuntimeException e) {
            error = true;
            throw e;
        }
        finally {
            block11: {
                try {
                    stream.close();
                }
                catch (RuntimeException e) {
                    if (error) break block11;
                    throw e;
                }
            }
        }
        return fileNode;
    }

    public Node uploadFile(Session session, String path, URL contentUrl) throws RepositoryException, IOException {
        JcrTools.isNotNull(session, "session");
        JcrTools.isNotNull(path, "path");
        JcrTools.isNotNull(contentUrl, "contentUrl");
        InputStream stream = contentUrl.openStream();
        return this.uploadFile(session, path, stream);
    }

    public Node uploadFile(Session session, String path, File file) throws RepositoryException, IOException {
        JcrTools.isNotNull(session, "session");
        JcrTools.isNotNull(path, "path");
        JcrTools.isNotNull(file, "file");
        if (!file.exists()) {
            throw new IllegalArgumentException("The file \"" + file.getCanonicalPath() + "\" does not exist");
        }
        if (!file.canRead()) {
            throw new IllegalArgumentException("The file \"" + file.getCanonicalPath() + "\" is not readable");
        }
        Calendar lastModified = Calendar.getInstance();
        lastModified.setTimeInMillis(file.lastModified());
        BufferedInputStream stream = new BufferedInputStream(new FileInputStream(file));
        return this.uploadFile(session, path, stream);
    }

    public void uploadFileAndBlock(Session session, String resourceFilePath, String parentPath) throws RepositoryException, IOException {
        this.uploadFileAndBlock(session, this.resourceUrl(resourceFilePath), parentPath);
    }

    public void uploadFileAndBlock(Session session, String folder, String fileName, String parentPath) throws RepositoryException, IOException {
        this.uploadFileAndBlock(session, this.resourceUrl(folder + fileName), parentPath);
    }

    public void uploadFileAndBlock(Session session, URL url, String parentPath) throws RepositoryException, IOException {
        String filename = url.getPath().replaceAll("([^/]*/)*", "");
        if (!parentPath.startsWith("/")) {
            parentPath = "/" + parentPath;
        }
        if (!parentPath.endsWith("/")) {
            parentPath = parentPath + "/";
        }
        final String nodePath = parentPath + filename;
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e.getMessage());
        }
        this.print("---> Uploading '" + filename + "' into '" + nodePath + "'");
        final CountDownLatch latch = new CountDownLatch(1);
        EventListener listener = new EventListener(){

            @Override
            public void onEvent(EventIterator events) {
                while (events.hasNext()) {
                    try {
                        if (!events.nextEvent().getPath().equals(nodePath)) continue;
                        latch.countDown();
                    }
                    catch (Throwable e) {
                        latch.countDown();
                        throw new RuntimeException(e.getMessage());
                    }
                }
            }
        };
        session.getWorkspace().getObservationManager().addEventListener(listener, 1, parentPath, true, null, null, false);
        this.uploadFile(session, nodePath, url);
        session.save();
        try {
            latch.await(2L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    public void uploadFilesAndBlock(String destinationPath, String ... resourcePaths) throws Exception {
        for (String resourcePath : resourcePaths) {
            this.uploadFilesAndBlock(resourcePath, destinationPath);
        }
    }

    public Node findOrCreateNode(Session session, String path) throws RepositoryException {
        return this.findOrCreateNode(session, path, null, null);
    }

    public Node findOrCreateNode(Session session, String path, String nodeType) throws RepositoryException {
        return this.findOrCreateNode(session, path, nodeType, nodeType);
    }

    public Node findOrCreateNode(Session session, String path, String defaultNodeType, String finalNodeType) throws RepositoryException {
        JcrTools.isNotNull(session, "session");
        Node root = session.getRootNode();
        return this.findOrCreateNode(root, path, defaultNodeType, finalNodeType);
    }

    public Node findOrCreateNode(Node parentNode, String path, String defaultNodeType, String finalNodeType) throws RepositoryException {
        JcrTools.isNotNull(parentNode, "parentNode");
        JcrTools.isNotNull(path, "path");
        String relPath = path.replaceAll("^/+", "").replaceAll("/+$", "");
        try {
            return parentNode.getNode(relPath);
        }
        catch (PathNotFoundException e) {
            Node node;
            String[] pathSegments = relPath.split("/");
            String parentPath = parentNode.getPath();
            StringBuilder existingNodePath = new StringBuilder(parentPath.length() + relPath.length());
            boolean isRootParent = true;
            if (parentNode.getPath().length() > 1) {
                isRootParent = false;
            }
            Session session = parentNode.getSession();
            existingNodePath.append(parentPath);
            int len = pathSegments.length;
            for (int i = 0; i != len; ++i) {
                String pathSegment = pathSegments[i];
                if ((pathSegment = pathSegment.trim()).length() == 0) continue;
                if (session.nodeExists(existingNodePath.toString() + "/" + pathSegment)) {
                    if (!isRootParent || i > 0) {
                        existingNodePath.append("/");
                    }
                    existingNodePath.append(pathSegment);
                    continue;
                }
                node = session.getNode(existingNodePath.toString());
                String pathSegmentWithNoIndex = pathSegment.replaceAll("(\\[\\d+\\])+$", "");
                String nodeType = defaultNodeType;
                if (i == len - 1 && finalNodeType != null) {
                    nodeType = finalNodeType;
                }
                node = nodeType != null ? node.addNode(pathSegmentWithNoIndex, nodeType) : node.addNode(pathSegmentWithNoIndex);
                if (!isRootParent || i > 0) {
                    existingNodePath.append("/");
                }
                existingNodePath.append(pathSegmentWithNoIndex);
            }
            node = session.getNode(existingNodePath.toString());
            return node;
        }
    }

    public Node findOrCreateChild(Node parent, String name) throws RepositoryException {
        return this.findOrCreateChild(parent, name, null);
    }

    public Node findOrCreateChild(Node parent, String name, String nodeType) throws RepositoryException {
        return this.findOrCreateNode(parent, name, nodeType, nodeType);
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public void print(Object msg) {
        if (this.debug && msg != null) {
            System.out.println(msg.toString());
        }
    }

    public void printSubgraph(Node node) throws RepositoryException {
        this.printSubgraph(node, Integer.MAX_VALUE);
    }

    public void printSubgraph(Node node, int maxDepth) throws RepositoryException {
        this.printSubgraph(node, " ", node.getDepth(), maxDepth);
    }

    public void printNode(Node node) throws RepositoryException {
        this.printSubgraph(node, " ", node.getDepth(), 1);
    }

    public void printSubgraph(Node node, String lead, int depthOfSubgraph, int maxDepthOfSubgraph) throws RepositoryException {
        int currentDepth = node.getDepth() - depthOfSubgraph + 1;
        if (currentDepth > maxDepthOfSubgraph) {
            return;
        }
        if (lead == null) {
            lead = "";
        }
        String nodeLead = lead + JcrTools.createString(' ', (currentDepth - 1) * 2);
        StringBuilder sb = new StringBuilder();
        sb.append(nodeLead);
        if (node.getDepth() == 0) {
            sb.append("/");
        } else {
            sb.append(node.getName());
            if (node.getIndex() != 1) {
                sb.append('[').append(node.getIndex()).append(']');
            }
        }
        sb.append(" jcr:primaryType=" + node.getPrimaryNodeType().getName());
        boolean referenceable = node.isNodeType("mix:referenceable");
        if (node.getMixinNodeTypes().length != 0) {
            sb.append(" jcr:mixinTypes=[");
            boolean first = true;
            for (NodeType mixin : node.getMixinNodeTypes()) {
                if (first) {
                    first = false;
                } else {
                    sb.append(',');
                }
                sb.append(mixin.getName());
            }
            sb.append(']');
        }
        if (referenceable) {
            sb.append(" jcr:uuid=" + node.getIdentifier());
        }
        this.print(sb);
        LinkedList<String> propertyNames = new LinkedList<String>();
        RangeIterator iter = node.getProperties();
        while (iter.hasNext()) {
            Property property = iter.nextProperty();
            String name = property.getName();
            if (name.equals("jcr:primaryType") || name.equals("jcr:mixinTypes") || name.equals("jcr:uuid")) continue;
            propertyNames.add(property.getName());
        }
        Collections.sort(propertyNames);
        for (String propertyName : propertyNames) {
            boolean binary;
            Property property = node.getProperty(propertyName);
            sb = new StringBuilder();
            sb.append(nodeLead).append("  - ").append(propertyName).append('=');
            int type = property.getType();
            boolean bl = binary = type == 2;
            if (property.isMultiple()) {
                sb.append('[');
                boolean first = true;
                for (Value value : property.getValues()) {
                    if (first) {
                        first = false;
                    } else {
                        sb.append(',');
                    }
                    if (binary) {
                        sb.append(value.getBinary());
                        continue;
                    }
                    sb.append(this.getStringValue(value, type));
                }
                sb.append(']');
            } else {
                Value value = property.getValue();
                if (binary) {
                    sb.append(value.getBinary());
                } else {
                    sb.append(this.getStringValue(value, type));
                }
            }
            this.print(sb);
        }
        if (currentDepth < maxDepthOfSubgraph) {
            iter = node.getNodes();
            while (iter.hasNext()) {
                Node child = iter.nextNode();
                this.printSubgraph(child, lead, depthOfSubgraph, maxDepthOfSubgraph);
            }
        }
    }

    public QueryResult printQuery(Session session, String jcrSql2) throws RepositoryException {
        return this.printQuery(session, jcrSql2, "JCR-SQL2", -1L, null);
    }

    public QueryResult printQuery(Session session, String jcrSql2, long expectedNumberOfResults, Variable ... variables) throws RepositoryException {
        HashMap<String, String> keyValuePairs = new HashMap<String, String>();
        for (Variable var : variables) {
            keyValuePairs.put(var.key, var.value);
        }
        return this.printQuery(session, jcrSql2, "JCR-SQL2", expectedNumberOfResults, keyValuePairs);
    }

    public QueryResult printQuery(Session session, String jcrSql2, long expectedNumberOfResults, Map<String, String> variables) throws RepositoryException {
        return this.printQuery(session, jcrSql2, "JCR-SQL2", expectedNumberOfResults, variables);
    }

    public QueryResult printQuery(Session session, String queryExpression, String queryLanguage, long expectedNumberOfResults, Map<String, String> variables) throws RepositoryException {
        QueryResult results = null;
        for (int i = 0; i != 10; ++i) {
            Query query = session.getWorkspace().getQueryManager().createQuery(queryExpression, queryLanguage);
            if (variables != null && !variables.isEmpty()) {
                for (Map.Entry<String, String> entry : variables.entrySet()) {
                    String key = entry.getKey();
                    Value value = session.getValueFactory().createValue(entry.getValue());
                    query.bindValue(key, value);
                }
            }
            if ((results = query.execute()).getRows().getSize() == expectedNumberOfResults) break;
            try {
                this.print("---> Waiting for query: " + queryExpression + (variables != null ? " using " + variables : ""));
                Thread.sleep(500L);
                continue;
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e.getMessage());
            }
        }
        assert (results != null);
        if (expectedNumberOfResults >= 0L && expectedNumberOfResults != results.getRows().getSize()) {
            throw new AssertionError((Object)("Expected different number of rows from '" + queryExpression + "': got " + results.getRows().getSize() + " but expected " + expectedNumberOfResults));
        }
        if (this.debug) {
            this.print(queryExpression);
            this.print(results);
            this.print("");
        }
        return results;
    }

    public Variable var(String key, String value) {
        return new Variable(key, value);
    }

    public Map<String, String> vars(String ... keyValuePairs) {
        assert (keyValuePairs.length % 2 == 0) : "Must provide an even number of keys and values";
        HashMap<String, String> map = new HashMap<String, String>();
        for (int i = 0; i != keyValuePairs.length; ++i) {
            String key = keyValuePairs[i];
            String value = keyValuePairs[++i];
            map.put(key, value);
        }
        return map;
    }

    protected String getStringValue(Value value, int type) throws RepositoryException {
        String result = value.getString();
        if (type == 1) {
            result = "\"" + result + "\"";
        }
        return result;
    }

    public void registerNodeTypes(Session session, String pathToCndResourceFile) {
        InputStream stream = this.getClass().getClassLoader().getResourceAsStream(pathToCndResourceFile);
        if (stream == null) {
            String msg = "\"" + pathToCndResourceFile + "\" does not reference an existing file";
            System.err.println(msg);
            throw new IllegalArgumentException(msg);
        }
        assert (stream != null);
        try {
            NodeTypeManager nodeTypeMgr = (NodeTypeManager)session.getWorkspace().getNodeTypeManager();
            nodeTypeMgr.registerNodeTypes(stream, true);
        }
        catch (RepositoryException re) {
            throw new IllegalStateException("Could not load node type definition files", re);
        }
        catch (IOException ioe) {
            throw new IllegalStateException("Could not access node type definition files", ioe);
        }
        catch (ClassCastException e) {
            throw new IllegalStateException("Unknown repository implementation; unable to import CND files", e);
        }
        finally {
            try {
                stream.close();
            }
            catch (IOException closer) {}
        }
    }

    public void importContent(Session session, String pathToResourceFile) throws Exception {
        JcrTools.importContent(session, this.getClass(), pathToResourceFile);
    }

    public void importContent(Session session, String pathToResourceFile, int importBehavior) throws Exception {
        JcrTools.importContent(session, this.getClass(), pathToResourceFile, null, importBehavior);
    }

    public void importContent(Session session, String pathToResourceFile, String jcrPathToImportUnder) throws Exception {
        JcrTools.importContent(session, this.getClass(), pathToResourceFile, jcrPathToImportUnder);
    }

    public void importContent(Session session, String pathToResourceFile, String jcrPathToImportUnder, int importBehavior) throws Exception {
        JcrTools.importContent(session, this.getClass(), pathToResourceFile, jcrPathToImportUnder, importBehavior);
    }

    public static void importContent(Session session, Class<?> testClass, String pathToResourceFile) throws Exception {
        JcrTools.importContent(session, testClass, pathToResourceFile, null);
    }

    public static void importContent(Session session, Class<?> testClass, String pathToResourceFile, String jcrPathToImportUnder) throws Exception {
        int behavior = 0;
        JcrTools.importContent(session, testClass, pathToResourceFile, null, behavior);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void importContent(Session session, Class<?> testClass, String pathToResourceFile, String jcrPathToImportUnder, int importBehavior) throws Exception {
        try {
            InputStream stream = testClass.getClassLoader().getResourceAsStream(pathToResourceFile);
            if (stream == null) {
                String msg = "\"" + pathToResourceFile + "\" does not reference an existing file";
                System.err.println(msg);
                throw new IllegalArgumentException(msg);
            }
            assert (stream != null);
            if (jcrPathToImportUnder == null || jcrPathToImportUnder.trim().length() == 0) {
                jcrPathToImportUnder = "/";
            }
            try {
                session.getWorkspace().importXML(jcrPathToImportUnder, stream, importBehavior);
            }
            finally {
                try {
                    session.save();
                }
                finally {
                    stream.close();
                    session.logout();
                }
            }
            session.save();
        }
        catch (RuntimeException t) {
            t.printStackTrace();
            throw t;
        }
        catch (Exception t) {
            t.printStackTrace();
            throw t;
        }
    }

    protected URL resourceUrl(String name) {
        return this.getClass().getClassLoader().getResource(name);
    }

    public void onEachNode(Session session, boolean includeSystemNodes, NodeOperation operation) throws Exception {
        Node node = session.getRootNode();
        operation.run(node);
        NodeIterator iter = node.getNodes();
        while (iter.hasNext()) {
            Node child = iter.nextNode();
            if (!includeSystemNodes && child.getName().equals("jcr:system")) continue;
            operation.run(child);
            this.onEachNodeBelow(child, operation);
        }
    }

    protected void onEachNodeBelow(Node parent, NodeOperation operation) throws Exception {
        NodeIterator iter = parent.getNodes();
        while (iter.hasNext()) {
            Node child = iter.nextNode();
            operation.run(child);
            this.onEachNodeBelow(child, operation);
        }
    }

    public void repeatedlyWithSession(Repository repository, int times, Operation operation) throws Exception {
        for (int i = 0; i != times; ++i) {
            double time = this.withSession(repository, operation);
            this.print("Time to execute \"" + operation.getClass().getSimpleName() + "\": " + time + " ms");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double withSession(Repository repository, Operation operation) throws Exception {
        long startTime = System.nanoTime();
        Session session = repository.login();
        try {
            operation.run(session);
        }
        finally {
            session.logout();
        }
        return TimeUnit.MILLISECONDS.convert(Math.abs(System.nanoTime() - startTime), TimeUnit.NANOSECONDS);
    }

    private static String createString(char charToRepeat, int numberOfRepeats) {
        assert (numberOfRepeats >= 0);
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < numberOfRepeats; ++i) {
            sb.append(charToRepeat);
        }
        return sb.toString();
    }

    private static void isNotNull(Object argument, String name) {
        if (argument == null) {
            throw new IllegalArgumentException("The argument \"" + name + "\" may not be null");
        }
    }

    public static class PrintNodes
    extends BasicOperation {
        public PrintNodes(JcrTools tools) {
            super(tools);
        }

        @Override
        public void run(Session s) throws RepositoryException {
            String queryStr = "SELECT [jcr:path] FROM [nt:base] ORDER BY [jcr:path]";
            Query query = s.getWorkspace().getQueryManager().createQuery(queryStr, "JCR-SQL2");
            if (this.tools != null) {
                this.tools.print(query.execute());
            }
        }
    }

    public static class CountNodes
    extends BasicOperation {
        public long numNonSystemNodes = 0L;

        public CountNodes(JcrTools tools) {
            super(tools);
        }

        @Override
        public void run(Session s) throws RepositoryException {
            String queryStr = "SELECT [jcr:primaryType] FROM [nt:base]";
            Query query = s.getWorkspace().getQueryManager().createQuery(queryStr, "JCR-SQL2");
            this.numNonSystemNodes += query.execute().getRows().getSize();
            if (this.tools != null) {
                this.tools.print("  # nodes NOT in '/jcr:system' branch: " + this.numNonSystemNodes);
            }
        }
    }

    public static class BrowseContent
    extends BasicOperation {
        private String path;

        public BrowseContent(JcrTools tools, String path) {
            super(tools);
            this.path = path;
        }

        @Override
        public void run(Session s) throws RepositoryException {
            Node node = s.getNode(this.path);
            assert (node != null) : "Node at " + this.path + " is null";
        }
    }

    public static abstract class BasicOperation
    implements Operation {
        protected JcrTools tools;

        protected BasicOperation(JcrTools tools) {
            this.tools = tools;
        }

        protected Node assertNode(Session session, String path, String primaryType, String ... mixinTypes) throws RepositoryException {
            Node node = session.getNode(path);
            assert (node.getPrimaryNodeType().getName().equals(primaryType));
            HashSet<String> expectedMixinTypes = new HashSet<String>(Arrays.asList(mixinTypes));
            HashSet<String> actualMixinTypes = new HashSet<String>();
            for (NodeType mixin : node.getMixinNodeTypes()) {
                actualMixinTypes.add(mixin.getName());
            }
            assert (actualMixinTypes.equals(expectedMixinTypes)) : "Mixin types do not match";
            return node;
        }
    }

    public static interface NodeOperation {
        public void run(Node var1) throws Exception;
    }

    public static interface Operation {
        public void run(Session var1) throws Exception;
    }

    public static class Variable {
        protected final String key;
        protected final String value;

        public Variable(String key, String value) {
            this.key = key;
            this.value = value;
        }
    }
}

