/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.common.collection;

import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSequentialList;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.modeshape.common.collection.ImmutableMapEntry;
import org.modeshape.common.collection.ListMultimap;
import org.modeshape.common.collection.Multimap;
import org.modeshape.common.util.ObjectUtil;

public final class LinkedListMultimap<K, V>
implements ListMultimap<K, V> {
    protected Entry<K, V> firstEntry;
    protected Entry<K, V> lastEntry;
    protected int length;
    protected final Map<K, AtomicInteger> numberOfEntriesForKey;
    protected final Map<K, Entry<K, V>> firstEntryWithKey = new HashMap<K, Entry<K, V>>();
    protected final Map<K, Entry<K, V>> lastEntryWithKey = new HashMap<K, Entry<K, V>>();
    private transient Map<K, Collection<V>> mapView;

    public static <K, V> LinkedListMultimap<K, V> create() {
        return new LinkedListMultimap<K, V>();
    }

    protected LinkedListMultimap() {
        this.numberOfEntriesForKey = new HashMap<K, AtomicInteger>();
    }

    @Override
    public void clear() {
        this.length = 0;
        this.firstEntryWithKey.clear();
        this.lastEntryWithKey.clear();
    }

    @Override
    public int size() {
        return this.length;
    }

    @Override
    public boolean isEmpty() {
        return this.length == 0;
    }

    @Override
    public boolean containsKey(K key) {
        return this.firstEntryWithKey.containsKey(key);
    }

    @Override
    public boolean containsEntry(Object key, Object value) {
        ValueIterator values = new ValueIterator(key);
        while (values.hasNext()) {
            if (!ObjectUtil.isEqualWithNulls(values.next(), value)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsValue(Object value) {
        EntryIterator entries = new EntryIterator();
        while (entries.hasNext()) {
            if (!ObjectUtil.isEqualWithNulls(((Entry)entries.next()).value, value)) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<V> get(final K key) {
        return new AbstractSequentialList<V>(){

            @Override
            public int size() {
                return LinkedListMultimap.this.currentCountFor(key);
            }

            @Override
            public ListIterator<V> listIterator(int index) {
                return new ValueIterator(key, index);
            }
        };
    }

    @Override
    public boolean put(K key, V value) {
        this.addEntryFor(key, value);
        return true;
    }

    @Override
    public boolean remove(K key, V value) {
        ValueIterator values = new ValueIterator(key);
        while (values.hasNext()) {
            if (!ObjectUtil.isEqualWithNulls(values.next(), value)) continue;
            values.remove();
            return true;
        }
        return false;
    }

    @Override
    public Collection<V> removeAll(K key) {
        ArrayList result = new ArrayList(this.currentCountFor(key));
        ValueIterator values = new ValueIterator(key);
        while (values.hasNext()) {
            result.add(values.next());
            values.remove();
        }
        return result;
    }

    @Override
    public Collection<Map.Entry<K, V>> entries() {
        return new AbstractCollection<Map.Entry<K, V>>(){

            @Override
            public int size() {
                return LinkedListMultimap.this.length;
            }

            @Override
            public Iterator<Map.Entry<K, V>> iterator() {
                return new Iterator<Map.Entry<K, V>>(){
                    private final EntryIterator iter;
                    {
                        this.iter = new EntryIterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.iter.hasNext();
                    }

                    @Override
                    public Map.Entry<K, V> next() {
                        Object next = this.iter.next();
                        return new ImmutableMapEntry(((Entry)next).key, ((Entry)next).value);
                    }

                    @Override
                    public void remove() {
                        this.iter.remove();
                    }
                };
            }
        };
    }

    @Override
    public Set<K> keySet() {
        return new AbstractSet<K>(){

            @Override
            public int size() {
                return LinkedListMultimap.this.numberOfEntriesForKey.size();
            }

            @Override
            public Iterator<K> iterator() {
                return new KeyIterator();
            }
        };
    }

    @Override
    public Collection<V> values() {
        return new AbstractCollection<V>(){

            @Override
            public int size() {
                return LinkedListMultimap.this.length;
            }

            @Override
            public Iterator<V> iterator() {
                return new Iterator<V>(){
                    private final EntryIterator iter;
                    {
                        this.iter = new EntryIterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.iter.hasNext();
                    }

                    @Override
                    public V next() {
                        Object next = this.iter.next();
                        return ((Entry)next).value;
                    }

                    @Override
                    public void remove() {
                        this.iter.remove();
                    }
                };
            }
        };
    }

    @Override
    public Map<K, Collection<V>> asMap() {
        if (this.mapView == null) {
            this.mapView = new MapView();
        }
        return this.mapView;
    }

    public int hashCode() {
        return this.asMap().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Multimap) {
            Multimap that = (Multimap)obj;
            return this.asMap().equals(that.asMap());
        }
        return false;
    }

    public String toString() {
        return this.asMap().toString();
    }

    protected int incrementEntryCountFor(K key) {
        AtomicInteger count = this.numberOfEntriesForKey.get(key);
        if (count == null) {
            count = new AtomicInteger(0);
            this.numberOfEntriesForKey.put(key, count);
        }
        ++this.length;
        return count.incrementAndGet();
    }

    protected int decrementEntryCountFor(K key) {
        AtomicInteger count = this.numberOfEntriesForKey.get(key);
        assert (count != null);
        int result = count.decrementAndGet();
        if (result == 0) {
            this.numberOfEntriesForKey.remove(key);
        }
        --this.length;
        return result;
    }

    protected int currentCountFor(K key) {
        AtomicInteger count = this.numberOfEntriesForKey.get(key);
        return count != null ? count.get() : 0;
    }

    protected Entry<K, V> addEntryFor(K key, V value) {
        Entry<K, V> entry = new Entry<K, V>(key, value);
        if (this.firstEntry == null) {
            assert (this.length == 0);
            this.firstEntry = entry;
            this.firstEntryWithKey.put(key, entry);
        } else {
            this.lastEntry.next = entry;
            entry.previous = this.lastEntry;
            Entry<K, V> lastWithKey = this.lastEntryWithKey.get(key);
            if (lastWithKey == null) {
                this.firstEntryWithKey.put(key, entry);
            }
        }
        Entry<K, V> previousLastWithKey = this.lastEntryWithKey.put(key, entry);
        if (previousLastWithKey != null) {
            previousLastWithKey.nextWithKey = entry;
            entry.previousWithKey = previousLastWithKey;
        }
        this.lastEntry = entry;
        this.incrementEntryCountFor(key);
        return entry;
    }

    protected Entry<K, V> insertEntryBefore(K key, V value, Entry<K, V> nextEntryWithKey) {
        if (nextEntryWithKey == null) {
            return this.addEntryFor(key, value);
        }
        Entry<K, V> entry = new Entry<K, V>(key, value);
        assert (this.firstEntry != null);
        assert (this.length != 0);
        entry.next = nextEntryWithKey;
        entry.nextWithKey = nextEntryWithKey;
        entry.previous = nextEntryWithKey.previous;
        entry.previousWithKey = nextEntryWithKey.previousWithKey;
        if (nextEntryWithKey.previousWithKey != null) {
            nextEntryWithKey.previousWithKey.nextWithKey = entry;
        } else {
            this.firstEntryWithKey.put(key, entry);
        }
        if (nextEntryWithKey.previous != null) {
            nextEntryWithKey.previous.next = entry;
        } else {
            this.firstEntry = entry;
        }
        nextEntryWithKey.previousWithKey = entry;
        nextEntryWithKey.previous = entry;
        this.incrementEntryCountFor(key);
        return entry;
    }

    protected void removeEntry(Entry<K, V> entry) {
        if (entry.previous == null) {
            assert (this.firstEntry == entry);
            this.firstEntry = entry.next;
        } else {
            entry.previous.next = entry.next;
        }
        if (entry.next == null) {
            assert (this.lastEntry == entry);
            this.lastEntry = entry.previous;
        } else {
            entry.next.previous = entry.previous;
        }
        if (entry.previousWithKey != null) {
            entry.previousWithKey.nextWithKey = entry.nextWithKey;
        } else if (entry.nextWithKey != null) {
            this.firstEntryWithKey.put(entry.key, entry.nextWithKey);
        } else {
            this.firstEntryWithKey.remove(entry.key);
        }
        if (entry.nextWithKey != null) {
            entry.nextWithKey.previousWithKey = entry.previousWithKey;
        } else if (entry.previousWithKey != null) {
            this.lastEntryWithKey.put(entry.key, entry.previousWithKey);
        } else {
            this.lastEntryWithKey.remove(entry.key);
        }
        this.decrementEntryCountFor(entry.key);
    }

    protected void isValid(Entry<K, V> entry) {
        if (entry == null) {
            throw new NoSuchElementException();
        }
    }

    protected class KeyIterator
    implements Iterator<K> {
        private final Set<K> seen = new HashSet();
        private Entry<K, V> next;
        private Entry<K, V> current;

        protected KeyIterator() {
            this.next = LinkedListMultimap.this.firstEntry;
            this.current = null;
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public K next() {
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            this.current = this.next;
            this.seen.add(this.current.key);
            do {
                this.next = this.next.next;
            } while (this.next != null && !this.seen.add(this.next.key));
            return this.current.key;
        }

        @Override
        public void remove() {
            if (this.current == null) {
                throw new NoSuchElementException();
            }
            LinkedListMultimap.this.removeAll(this.current.key);
            this.current = null;
        }
    }

    protected class ValueIterator
    implements ListIterator<V> {
        private Entry<K, V> previous;
        private Entry<K, V> current;
        private Entry<K, V> next;
        private int nextIndex;
        private final K key;

        protected ValueIterator(K key) {
            this.key = key;
            this.next = LinkedListMultimap.this.firstEntryWithKey.get(key);
            this.nextIndex = 0;
        }

        protected ValueIterator(K key, int index) {
            this.key = key;
            int count = LinkedListMultimap.this.currentCountFor(key);
            if (index > count / 2) {
                this.previous = LinkedListMultimap.this.lastEntryWithKey.get(key);
                this.nextIndex = count;
                while (index++ < count) {
                    this.previous();
                }
            } else {
                this.next = LinkedListMultimap.this.firstEntryWithKey.get(key);
                this.nextIndex = 0;
                while (index-- > 0) {
                    this.next();
                }
            }
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public V next() {
            LinkedListMultimap.this.isValid(this.next);
            this.current = this.next;
            this.previous = this.next;
            this.next = this.current.nextWithKey;
            ++this.nextIndex;
            return this.current.value;
        }

        @Override
        public int nextIndex() {
            return this.nextIndex;
        }

        @Override
        public boolean hasPrevious() {
            return this.previous != null;
        }

        @Override
        public V previous() {
            LinkedListMultimap.this.isValid(this.previous);
            this.current = this.previous;
            this.next = this.previous;
            this.previous = this.current.previousWithKey;
            --this.nextIndex;
            return this.current.value;
        }

        @Override
        public int previousIndex() {
            return this.nextIndex - 1;
        }

        @Override
        public void remove() {
            if (this.current == null) {
                throw new IllegalStateException();
            }
            if (this.current != this.next) {
                this.previous = this.current.previousWithKey;
                --this.nextIndex;
            } else {
                this.next = this.current.nextWithKey;
            }
            LinkedListMultimap.this.removeEntry(this.current);
            this.current = null;
        }

        @Override
        public void add(V value) {
            this.previous = this.next == null ? LinkedListMultimap.this.addEntryFor(this.key, value) : LinkedListMultimap.this.insertEntryBefore(this.key, value, this.next);
            ++this.nextIndex;
            this.current = null;
        }

        @Override
        public void set(V value) {
            if (this.current == null) {
                throw new IllegalStateException();
            }
            this.current.value = value;
        }
    }

    protected class EntryIterator
    implements Iterator<Entry<K, V>> {
        private Entry<K, V> nextEntry;
        private Entry<K, V> currentEntry;

        protected EntryIterator() {
            this.nextEntry = LinkedListMultimap.this.firstEntry;
        }

        protected EntryIterator(Entry<K, V> first) {
            this.nextEntry = first;
        }

        @Override
        public boolean hasNext() {
            return this.nextEntry != null;
        }

        @Override
        public Entry<K, V> next() {
            LinkedListMultimap.this.isValid(this.nextEntry);
            this.currentEntry = this.nextEntry;
            this.nextEntry = this.nextEntry.next;
            return this.currentEntry;
        }

        @Override
        public void remove() {
            if (this.currentEntry == null) {
                throw new IllegalStateException();
            }
            LinkedListMultimap.this.removeEntry(this.currentEntry);
            this.currentEntry = null;
        }
    }

    protected class MapEntries
    extends AbstractSet<Map.Entry<K, Collection<V>>> {
        protected MapEntries() {
        }

        @Override
        public int size() {
            return LinkedListMultimap.this.length;
        }

        @Override
        public Iterator<Map.Entry<K, Collection<V>>> iterator() {
            return new Iterator<Map.Entry<K, Collection<V>>>(){
                private KeyIterator iter;
                {
                    this.iter = new KeyIterator();
                }

                @Override
                public boolean hasNext() {
                    return this.iter.hasNext();
                }

                @Override
                public Map.Entry<K, Collection<V>> next() {
                    final Object nextKey = this.iter.next();
                    return new ImmutableMapEntry<K, Collection<V>>(nextKey, null){

                        @Override
                        public Collection<V> getValue() {
                            return LinkedListMultimap.this.get(nextKey);
                        }
                    };
                }

                @Override
                public void remove() {
                    this.iter.remove();
                }
            };
        }
    }

    protected class MapView
    extends AbstractMap<K, Collection<V>> {
        private Set<Map.Entry<K, Collection<V>>> entries;

        protected MapView() {
        }

        @Override
        public Set<Map.Entry<K, Collection<V>>> entrySet() {
            if (this.entries == null) {
                this.entries = new MapEntries();
            }
            return this.entries;
        }
    }

    protected static final class Entry<K, V> {
        final K key;
        V value;
        Entry<K, V> nextWithKey;
        Entry<K, V> previousWithKey;
        Entry<K, V> next;
        Entry<K, V> previous;

        protected Entry(K key, V value) {
            this.key = key;
            this.value = value;
        }

        public String toString() {
            return "[" + this.key + "=" + this.value + "]";
        }
    }
}

