/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.api.sequencer;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import javax.jcr.NamespaceException;
import javax.jcr.NamespaceRegistry;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import org.modeshape.jcr.api.Logger;
import org.modeshape.jcr.api.ValueFactory;
import org.modeshape.jcr.api.nodetype.NodeTypeManager;

public abstract class Sequencer {
    private final UUID uuid = UUID.randomUUID();
    private Logger logger;
    private String name;
    private String repositoryName;
    private Object[] pathExpressions;
    private String pathExpression;
    private String[] acceptedMimeTypes = new String[0];
    private Set<String> acceptedMimeTypesSet = null;
    private boolean initialized = false;

    public final UUID getUniqueId() {
        return this.uuid;
    }

    public final String getName() {
        return this.name;
    }

    public final String getRepositoryName() {
        return this.repositoryName;
    }

    public final String[] getPathExpressions() {
        String pathExpression = this.pathExpression;
        Object[] pathExpressions = this.pathExpressions;
        if (pathExpression == null && (pathExpressions == null || pathExpressions.length == 0)) {
            return new String[0];
        }
        if (pathExpression != null && (pathExpressions == null || pathExpressions.length == 0)) {
            return new String[]{pathExpression};
        }
        ArrayList<String> expressions = new ArrayList<String>(pathExpressions.length + 1);
        this.addExpression(expressions, pathExpression);
        for (Object value : pathExpressions) {
            this.addExpression(expressions, value);
        }
        return expressions.toArray(new String[expressions.size()]);
    }

    private void addExpression(List<String> values, Object value) {
        assert (!this.initialized) : "No expressions can be added after the sequencer has been initialized";
        if (value instanceof String) {
            String str = (String)value;
            if ((str = str.trim()).length() != 0) {
                values.add(str);
            }
        }
    }

    public void initialize(NamespaceRegistry registry, NodeTypeManager nodeTypeManager) throws RepositoryException, IOException {
        assert (!this.initialized) : "The Sequencer.initialize(...) method should not be called by subclasses; ModeShape has already (and automatically) initialized the Sequencer";
    }

    private void postInitialize() {
        if (!this.initialized) {
            this.initialized = true;
            this.acceptedMimeTypesSet = Collections.unmodifiableSet(this.getAcceptedMimeTypes());
        }
    }

    public abstract boolean execute(Property var1, Node var2, Context var3) throws Exception;

    public String toString() {
        return this.repositoryName + " -> " + this.getClass().getName() + " uuid=" + this.uuid + (this.name != null ? " : " + this.name : "");
    }

    protected boolean registerNamespace(String namespacePrefix, String namespaceUri, NamespaceRegistry namespaceRegistry) throws RepositoryException {
        if (namespacePrefix == null || namespaceUri == null) {
            throw new IllegalArgumentException("Neither the namespace prefix, nor the uri should be null");
        }
        try {
            namespaceRegistry.getPrefix(namespaceUri);
            return false;
        }
        catch (NamespaceException e) {
            namespaceRegistry.registerNamespace(namespacePrefix, namespaceUri);
            return true;
        }
    }

    protected void registerNodeTypes(String cndFile, NodeTypeManager nodeTypeManager, boolean allowUpdate) throws RepositoryException, IOException {
        InputStream cndStream = this.getClass().getResourceAsStream(cndFile);
        this.registerNodeTypes(cndStream, nodeTypeManager, allowUpdate);
    }

    protected void registerNodeTypes(InputStream cndStream, NodeTypeManager nodeTypeManager, boolean allowUpdate) throws RepositoryException, IOException {
        if (cndStream == null) {
            throw new IllegalArgumentException("The stream to the given cnd file is null");
        }
        nodeTypeManager.registerNodeTypes(cndStream, allowUpdate);
    }

    protected final Logger getLogger() {
        return this.logger;
    }

    protected final void registerDefaultMimeTypes(String ... mimeTypes) {
        assert (!this.initialized) : "No default MIME types can be registered after the sequencer has been initialized";
        if (mimeTypes != null && mimeTypes.length != 0 && this.acceptedMimeTypes.length == 0) {
            if (this.acceptedMimeTypesSet == null) {
                this.acceptedMimeTypesSet = new HashSet<String>();
            }
            for (String mimeType : mimeTypes) {
                if (mimeType == null || (mimeType = mimeType.trim()).length() == 0) continue;
                this.acceptedMimeTypesSet.add(mimeType);
            }
        }
    }

    protected final Set<String> getAcceptedMimeTypes() {
        if (this.acceptedMimeTypesSet == null) {
            this.acceptedMimeTypesSet = new HashSet<String>();
            for (String mimeType : this.acceptedMimeTypes) {
                if (mimeType == null || (mimeType = mimeType.trim()).length() == 0) continue;
                this.acceptedMimeTypesSet.add(mimeType);
            }
        }
        return this.acceptedMimeTypesSet;
    }

    public final boolean hasAcceptedMimeTypes() {
        return !this.getAcceptedMimeTypes().isEmpty();
    }

    public final boolean isAccepted(String mimeType) {
        if (mimeType != null && this.hasAcceptedMimeTypes()) {
            return this.getAcceptedMimeTypes().contains(mimeType.trim());
        }
        return true;
    }

    public static interface Context {
        public Calendar getTimestamp();

        public ValueFactory valueFactory();
    }
}

