/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.common.collection;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import org.modeshape.common.annotation.Immutable;
import org.modeshape.common.util.CheckArg;

@Immutable
public class ImmutableAppendedList<T>
implements List<T> {
    private final List<T> parent;
    private final T element;
    private final int size;
    private transient int hc;

    public ImmutableAppendedList(List<T> parent, T element) {
        CheckArg.isNotNull(parent, "parent");
        this.parent = parent;
        this.element = element;
        this.size = parent.size() + 1;
    }

    @Override
    public boolean contains(Object o) {
        return this.element == o || this.element != null && this.element.equals(o) || this.parent.contains(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        Iterator<?> e = c.iterator();
        while (e.hasNext()) {
            if (this.contains(e.next())) continue;
            return false;
        }
        return true;
    }

    @Override
    public T get(int index) {
        if (index == this.size - 1) {
            return this.element;
        }
        return this.parent.get(index);
    }

    @Override
    public int indexOf(Object o) {
        int index = this.parent.indexOf(o);
        if (index == -1) {
            return this.element == o || this.element != null && this.element.equals(o) ? this.size - 1 : -1;
        }
        return -1;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public Iterator<T> iterator() {
        final Iterator<T> parentIterator = this.parent.iterator();
        return new Iterator<T>(){
            boolean finished = false;

            @Override
            public boolean hasNext() {
                return parentIterator.hasNext() || !this.finished;
            }

            @Override
            public T next() {
                if (parentIterator.hasNext()) {
                    return parentIterator.next();
                }
                if (this.finished) {
                    throw new NoSuchElementException();
                }
                this.finished = true;
                return ImmutableAppendedList.this.element;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public int lastIndexOf(Object o) {
        if (this.element == o || this.element != null && this.element.equals(o)) {
            return this.size - 1;
        }
        return this.parent.lastIndexOf(o);
    }

    @Override
    public ListIterator<T> listIterator() {
        return this.listIterator(0);
    }

    @Override
    public ListIterator<T> listIterator(final int index) {
        return new ListIterator<T>(){
            int cursor;
            {
                this.cursor = index;
            }

            @Override
            public boolean hasNext() {
                return this.cursor < ImmutableAppendedList.this.size;
            }

            @Override
            public T next() {
                try {
                    Object next = ImmutableAppendedList.this.get(this.cursor);
                    ++this.cursor;
                    return next;
                }
                catch (IndexOutOfBoundsException e) {
                    throw new NoSuchElementException();
                }
            }

            @Override
            public boolean hasPrevious() {
                return this.cursor != 0;
            }

            @Override
            public int nextIndex() {
                return this.cursor;
            }

            @Override
            public T previous() {
                try {
                    int i = this.cursor - 1;
                    Object previous = ImmutableAppendedList.this.get(i);
                    this.cursor = i;
                    return previous;
                }
                catch (IndexOutOfBoundsException e) {
                    throw new NoSuchElementException();
                }
            }

            @Override
            public int previousIndex() {
                return this.cursor - 1;
            }

            @Override
            public void set(T o) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            @Override
            public void add(T o) {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public List<T> subList(int fromIndex, int toIndex) {
        if (fromIndex == 0 && toIndex == this.size) {
            return this;
        }
        if (toIndex == this.size && fromIndex == this.size - 1) {
            return Collections.singletonList(this.element);
        }
        if (toIndex < this.size) {
            return this.parent.subList(fromIndex, toIndex);
        }
        List<T> sublist = this.parent.subList(fromIndex, toIndex - 1);
        return new ImmutableAppendedList<T>(sublist, this.element);
    }

    @Override
    public Object[] toArray() {
        Object[] result = new Object[this.size];
        int i = 0;
        for (T e : this.parent) {
            result[i++] = e;
        }
        result[i] = this.element;
        return result;
    }

    @Override
    public <X> X[] toArray(X[] a) {
        if (a.length < this.size) {
            a = (Object[])Array.newInstance(a.getClass().getComponentType(), this.size);
        }
        a = this.parent.toArray(a);
        a[this.size - 1] = this.element;
        return a;
    }

    @Override
    public int hashCode() {
        if (this.hc == 0) {
            int hashCode = 1;
            for (T element : this) {
                hashCode = 31 * hashCode + (element == null ? 0 : element.hashCode());
            }
            this.hc = hashCode;
        }
        return this.hc;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof List) {
            List that = (List)obj;
            if (this.size() != that.size()) {
                return false;
            }
            Iterator<T> thisIter = this.iterator();
            Iterator thatIter = that.iterator();
            while (thisIter.hasNext()) {
                T thisValue = thisIter.next();
                Object thatValue = thatIter.next();
                if (!(thisValue == null ? thatValue != null : !thisValue.equals(thatValue))) continue;
                return false;
            }
            return true;
        }
        return super.equals(obj);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        Iterator<T> i = this.iterator();
        boolean hasNext = i.hasNext();
        while (hasNext) {
            T o = i.next();
            sb.append(o == this ? "(this Collection)" : String.valueOf(o));
            hasNext = i.hasNext();
            if (!hasNext) continue;
            sb.append(", ");
        }
        sb.append("]");
        return sb.toString();
    }

    @Override
    public void add(int index, T element) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean add(T o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(int index, Collection<? extends T> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public T remove(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public T set(int index, T element) {
        throw new UnsupportedOperationException();
    }
}

