/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.common.collection.ring;

import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.modeshape.common.collection.ring.Pointer;
import org.modeshape.common.collection.ring.PointerBarrier;
import org.modeshape.common.collection.ring.WaitStrategy;

public class BlockingWaitStrategy
implements WaitStrategy {
    private final Lock lock = new ReentrantLock();
    private final Condition waitCondition = this.lock.newCondition();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long waitFor(long position, Pointer pointer, Pointer dependentPointer, PointerBarrier barrier) throws InterruptedException {
        long availablePosition = pointer.get();
        if (availablePosition < position) {
            this.lock.lock();
            try {
                while (!barrier.isComplete() && (availablePosition = pointer.get()) < position) {
                    this.waitCondition.await();
                }
            }
            finally {
                this.lock.unlock();
            }
        }
        return availablePosition;
    }

    @Override
    public void signalAllWhenBlocking() {
        this.lock.lock();
        try {
            this.waitCondition.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }
}

