/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jdbc.rest;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.modeshape.common.annotation.Immutable;
import org.modeshape.jdbc.rest.NodeType;

@Immutable
public final class NodeTypes
implements Iterable<NodeType> {
    private final Map<String, NodeType> typesByName = new HashMap<String, NodeType>();

    protected NodeTypes(JSONObject object) {
        try {
            if (!object.has("children")) {
                throw new RuntimeException("Invalid JSON object: " + object);
            }
            JSONObject children = object.getJSONObject("children");
            Iterator itr = children.keys();
            while (itr.hasNext()) {
                String key = (String)itr.next();
                JSONObject child = children.getJSONObject(key);
                if (child == null) continue;
                NodeType nodeType = new NodeType(child, this);
                this.typesByName.put(nodeType.getName(), nodeType);
            }
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
    }

    protected NodeType getNodeType(String name) {
        return this.typesByName.get(name);
    }

    @Override
    public Iterator<NodeType> iterator() {
        return this.nodeTypes().iterator();
    }

    public boolean isEmpty() {
        return this.typesByName.isEmpty();
    }

    protected Collection<NodeType> nodeTypes() {
        return this.typesByName.values();
    }

    protected NodeType[] toNodeTypes(Collection<String> nodeTypeNames) {
        if (this.typesByName.isEmpty()) {
            return new NodeType[0];
        }
        int numValues = nodeTypeNames.size();
        int i = 0;
        NodeType[] result = new NodeType[numValues];
        for (String typeName : nodeTypeNames) {
            result[i++] = this.getNodeType(typeName);
        }
        return result;
    }
}

