/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jdbc.rest;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeParseException;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jcr.Binary;
import javax.jcr.PropertyType;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.ValueFormatException;
import javax.jcr.version.OnParentVersionAction;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.modeshape.common.annotation.Immutable;
import org.modeshape.common.util.DateTimeUtil;
import org.modeshape.common.util.HashCode;
import org.modeshape.jdbc.JdbcI18n;
import org.modeshape.jdbc.rest.ItemDefinition;
import org.modeshape.jdbc.rest.JSONHelper;
import org.modeshape.jdbc.rest.NodeTypes;

@Immutable
public class PropertyDefinition
extends ItemDefinition
implements javax.jcr.nodetype.PropertyDefinition {
    private static final Map<String, Integer> PROPERTY_TYPES_BY_LOWERCASE_NAME;
    private final Id id;
    private final List<String> queryOps;
    private final List<String> defaultValues;
    private final List<String> valueConstraints;
    private final boolean isFullTextSearchable;
    private final boolean isQueryOrderable;

    private static void registerType(int propertyType, Map<String, Integer> types) {
        String name = PropertyType.nameFromValue(propertyType);
        types.put(name.toLowerCase(), propertyType);
    }

    protected PropertyDefinition(String declaringNodeTypeName, JSONObject json, NodeTypes nodeTypes) {
        super(declaringNodeTypeName, json, nodeTypes);
        String name = JSONHelper.valueFrom(json, "jcr:name", "*");
        boolean isMultiple = JSONHelper.valueFrom(json, "jcr:multiple", false);
        int requiredType = this.typeValueFrom(json, "jcr:requiredType", 0);
        this.id = new Id(name, isMultiple, requiredType);
        this.isFullTextSearchable = JSONHelper.valueFrom(json, "jcr:isFullTextSearchable", false);
        this.isQueryOrderable = JSONHelper.valueFrom(json, "jcr:isQueryOrderable", false);
        this.queryOps = JSONHelper.valuesFrom(json, "jcr:availableQueryOperators");
        this.defaultValues = JSONHelper.valuesFrom(json, "jcr:defaultValues");
        this.valueConstraints = JSONHelper.valuesFrom(json, "jcr:valueConstraints");
    }

    protected Id id() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.id.name;
    }

    @Override
    public String[] getAvailableQueryOperators() {
        return this.queryOps.toArray(new String[this.queryOps.size()]);
    }

    @Override
    public Value[] getDefaultValues() {
        if (this.defaultValues.isEmpty()) {
            return new Value[0];
        }
        int numValues = this.defaultValues.size();
        int i = 0;
        Value[] result = new Value[numValues];
        for (String value : this.defaultValues) {
            result[i++] = new StringValue(value);
        }
        return result;
    }

    @Override
    public int getRequiredType() {
        return this.id.requiredType;
    }

    @Override
    public String[] getValueConstraints() {
        return this.valueConstraints.toArray(new String[this.valueConstraints.size()]);
    }

    @Override
    public boolean isFullTextSearchable() {
        return this.isFullTextSearchable;
    }

    @Override
    public boolean isMultiple() {
        return this.id.isMultiple;
    }

    @Override
    public boolean isQueryOrderable() {
        return this.isQueryOrderable;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof PropertyDefinition) {
            PropertyDefinition that = (PropertyDefinition)obj;
            return this.id.equals(that.id);
        }
        return false;
    }

    protected int typeValueFrom(JSONObject json, String name, int defaultType) {
        try {
            if (!json.has(name)) {
                return defaultType;
            }
            String typeName = json.getString(name);
            Integer result = PROPERTY_TYPES_BY_LOWERCASE_NAME.get(typeName.toLowerCase());
            return result != null ? result : defaultType;
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
    }

    public String toString() {
        boolean first;
        StringBuilder sb = new StringBuilder();
        sb.append(" - ");
        sb.append(this.id.name);
        sb.append(" (");
        sb.append(PropertyType.nameFromValue(this.id.requiredType));
        sb.append(')');
        if (this.getDefaultValues().length != 0) {
            sb.append(" = ");
            first = true;
            for (Value value : this.getDefaultValues()) {
                if (value == null) continue;
                if (first) {
                    first = false;
                } else {
                    sb.append(',');
                }
                sb.append(value);
            }
        }
        if (this.isAutoCreated()) {
            sb.append(" autocreated");
        }
        if (this.isMandatory()) {
            sb.append(" mandatory");
        }
        if (!this.isFullTextSearchable()) {
            sb.append(" nofulltext");
        }
        if (!this.isQueryOrderable()) {
            sb.append(" noqueryorder");
        }
        if (this.isMultiple()) {
            sb.append(" multiple");
        }
        if (this.isProtected()) {
            sb.append(" protected");
        }
        sb.append(' ').append(OnParentVersionAction.nameFromValue(this.getOnParentVersion()));
        if (this.getAvailableQueryOperators().length != 0) {
            sb.append(" queryops ");
            first = true;
            for (String string : this.getAvailableQueryOperators()) {
                if (string == null) continue;
                if (first) {
                    first = false;
                } else {
                    sb.append(',');
                }
                sb.append('\'');
                sb.append(string);
                sb.append('\'');
            }
        }
        if (this.getValueConstraints().length != 0) {
            sb.append(" < ");
            first = true;
            for (String string : this.getValueConstraints()) {
                if (string == null) continue;
                if (first) {
                    first = false;
                } else {
                    sb.append(',');
                }
                sb.append(string);
            }
        }
        return sb.toString();
    }

    static {
        HashMap<String, Integer> types = new HashMap<String, Integer>();
        PropertyDefinition.registerType(2, types);
        PropertyDefinition.registerType(6, types);
        PropertyDefinition.registerType(5, types);
        PropertyDefinition.registerType(12, types);
        PropertyDefinition.registerType(4, types);
        PropertyDefinition.registerType(3, types);
        PropertyDefinition.registerType(7, types);
        PropertyDefinition.registerType(8, types);
        PropertyDefinition.registerType(9, types);
        PropertyDefinition.registerType(1, types);
        PropertyDefinition.registerType(0, types);
        PropertyDefinition.registerType(11, types);
        PropertyDefinition.registerType(10, types);
        PROPERTY_TYPES_BY_LOWERCASE_NAME = Collections.unmodifiableMap(types);
    }

    protected static class Id {
        protected final String name;
        protected final boolean isMultiple;
        protected final int requiredType;

        protected Id(String name, boolean isMultiple, int requiredType) {
            this.name = name;
            this.isMultiple = isMultiple;
            this.requiredType = requiredType;
            assert (this.name != null);
        }

        public int hashCode() {
            return HashCode.compute(this.isMultiple, this.requiredType, this.name);
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof Id) {
                Id that = (Id)obj;
                if (this.isMultiple != that.isMultiple) {
                    return false;
                }
                if (this.requiredType != that.requiredType) {
                    return false;
                }
                return this.name.equals(that.name);
            }
            return false;
        }

        public String toString() {
            return this.name + "(" + PropertyType.nameFromValue(this.requiredType) + ")" + (this.isMultiple ? (char)'*' : '1');
        }
    }

    protected final class StringValue
    implements Value {
        protected final String value;

        protected StringValue(String value) {
            this.value = value;
            assert (this.value != null);
        }

        @Override
        public boolean getBoolean() {
            return Boolean.parseBoolean(this.value.trim());
        }

        @Override
        public Calendar getDate() throws ValueFormatException {
            return this.valueToCalendar(null);
        }

        private Calendar valueToCalendar(String zoneId) throws ValueFormatException {
            try {
                ZonedDateTime zonedDateTime = zoneId == null ? DateTimeUtil.jodaParse(this.value) : DateTimeUtil.jodaParse(this.value).withZoneSameInstant(ZoneId.of(zoneId));
                Calendar calendar = Calendar.getInstance();
                calendar.setTimeInMillis(zonedDateTime.toInstant().toEpochMilli());
                return calendar;
            }
            catch (DateTimeParseException e) {
                String from = PropertyType.nameFromValue(this.getType());
                String to = PropertyType.nameFromValue(3);
                throw new ValueFormatException(JdbcI18n.unableToConvertValue.text(this.value, from, to), e);
            }
        }

        public Calendar getDateInUtc() throws ValueFormatException {
            return this.valueToCalendar("UTC");
        }

        @Override
        public BigDecimal getDecimal() throws ValueFormatException {
            try {
                if (PropertyDefinition.this.getRequiredType() == 5) {
                    return new BigDecimal(this.getDateInUtc().getTime().getTime());
                }
                return new BigDecimal(this.value);
            }
            catch (NumberFormatException t) {
                String from = PropertyType.nameFromValue(this.getType());
                String to = PropertyType.nameFromValue(12);
                throw new ValueFormatException(JdbcI18n.unableToConvertValue.text(this.value, from, to), t);
            }
        }

        @Override
        public double getDouble() throws ValueFormatException {
            try {
                if (PropertyDefinition.this.getRequiredType() == 5) {
                    return this.getDateInUtc().getTime().getTime();
                }
                return Double.parseDouble(this.value);
            }
            catch (NumberFormatException t) {
                String from = PropertyType.nameFromValue(this.getType());
                String to = PropertyType.nameFromValue(4);
                throw new ValueFormatException(JdbcI18n.unableToConvertValue.text(this.value, from, to), t);
            }
        }

        @Override
        public long getLong() throws ValueFormatException {
            try {
                if (PropertyDefinition.this.getRequiredType() == 5) {
                    return this.getDateInUtc().getTime().getTime();
                }
                return Long.parseLong(this.value);
            }
            catch (NumberFormatException t) {
                String from = PropertyType.nameFromValue(this.getType());
                String to = PropertyType.nameFromValue(3);
                throw new ValueFormatException(JdbcI18n.unableToConvertValue.text(this.value, from, to), t);
            }
        }

        @Override
        public InputStream getStream() throws RepositoryException {
            return this.getBinary().getStream();
        }

        @Override
        public String getString() {
            return this.value;
        }

        @Override
        public int getType() {
            int type = PropertyDefinition.this.getRequiredType();
            return type == 0 ? 1 : type;
        }

        @Override
        public Binary getBinary() {
            return new Binary(){
                private byte[] bytes;
                {
                    this.bytes = StringValue.this.value.getBytes();
                }

                @Override
                public void dispose() {
                    this.bytes = null;
                }

                @Override
                public long getSize() {
                    return this.bytes.length;
                }

                @Override
                public InputStream getStream() {
                    return new ByteArrayInputStream(this.bytes);
                }

                @Override
                public int read(byte[] b, long position) throws IOException {
                    if (this.getSize() <= position) {
                        return -1;
                    }
                    try (InputStream stream = this.getStream();){
                        long skipped;
                        for (long skip = position; skip > 0L; skip -= skipped) {
                            skipped = stream.skip(skip);
                            if (skipped > 0L) continue;
                            int n = -1;
                            return n;
                        }
                        int n = stream.read(b);
                        return n;
                    }
                }
            };
        }

        public String toString() {
            return this.value;
        }
    }
}

