/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.common.util;

import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.DateTimeParseException;
import java.time.format.SignStyle;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import org.modeshape.common.util.CheckArg;

public final class DateTimeUtil {
    public static final ZoneId UTC = ZoneId.of("UTC");
    private static DateTimeFormatter JODA_ISO8601_FORMATTER = new DateTimeFormatterBuilder().parseLenient().appendPattern("uuuu-MM-dd['T'HH:mm:ss][.").appendValue(ChronoField.MILLI_OF_SECOND, 3, 3, SignStyle.NEVER).optionalEnd().appendPattern("[XXXXX]").toFormatter();

    private DateTimeUtil() {
    }

    public static ZonedDateTime jodaParse(String iso8601) throws DateTimeParseException {
        CheckArg.isNotNull(iso8601, "iso8601");
        TemporalAccessor parse = JODA_ISO8601_FORMATTER.parse(iso8601);
        LocalDate localDate = LocalDate.from(parse);
        LocalTime localTime = parse.isSupported(ChronoField.HOUR_OF_DAY) ? LocalTime.from(parse) : LocalTime.MIDNIGHT;
        ZoneId zoneId = parse.isSupported(ChronoField.OFFSET_SECONDS) ? ZoneId.from(parse) : UTC;
        return ZonedDateTime.of(localDate, localTime, zoneId);
    }

    public static String jodaFormat(ZonedDateTime dateTime) {
        CheckArg.isNotNull(dateTime, "dateTime");
        return dateTime.format(JODA_ISO8601_FORMATTER);
    }

    public static LocalDateTime localDateTimeUTC(long millis) {
        CheckArg.isPositive(millis, "millis");
        return LocalDateTime.ofInstant(Instant.ofEpochMilli(millis), UTC);
    }
}

