/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jdbc.rest;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.BufferedHttpEntity;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.modeshape.common.text.UrlEncoder;
import org.modeshape.common.util.CheckArg;
import org.modeshape.common.util.StringUtil;

public final class JSONRestClient {
    private static final UrlEncoder URL_ENCODER = new UrlEncoder().setSlashEncoded(false);
    protected final HttpClient httpClient;
    private final HttpClientContext httpContext;
    private final HttpHost host;
    private final String url;
    private final String baseUrl;

    protected JSONRestClient(String url, String username, String password) {
        CheckArg.isNotNull(url, "url");
        try {
            this.url = url;
            URL connectionUrl = new URL(url);
            this.host = new HttpHost(connectionUrl.getHost(), connectionUrl.getPort(), connectionUrl.getProtocol());
            String urlPath = connectionUrl.getPath();
            if (urlPath.length() > 0) {
                String[] segments = urlPath.split("\\/");
                this.baseUrl = this.host.toURI() + "/" + (segments[0].length() > 0 ? segments[0] : segments[1]);
            } else {
                this.baseUrl = this.host.toURI();
            }
            this.httpClient = HttpClientBuilder.create().build();
            this.httpContext = HttpClientContext.create();
            if (!StringUtil.isBlank(username)) {
                BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
                credentialsProvider.setCredentials(new AuthScope(this.host()), new UsernamePasswordCredentials(username, password));
                this.httpContext.setCredentialsProvider(credentialsProvider);
            }
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Invalid URL string: " + url, e);
        }
    }

    protected String url() {
        return this.url;
    }

    protected HttpHost host() {
        return this.host;
    }

    protected Response doGet() {
        return new Response(this.newJSONRequest(HttpGet.class, null, null, null));
    }

    protected Response doGet(String url) {
        return new Response(this.newJSONRequest(HttpGet.class, null, null, url));
    }

    protected Response postStream(InputStream is, String url, String requestContentType) {
        HttpPost post = this.newJSONRequest(HttpPost.class, is, requestContentType, url);
        return new Response(post);
    }

    protected Response postStreamTextPlain(InputStream is, String url, String requestContentType) {
        HttpPost post = this.newRequest(HttpPost.class, is, requestContentType, "text/plain;", url);
        return new Response(post);
    }

    private <T extends HttpRequestBase> T newJSONRequest(Class<T> clazz, InputStream inputStream, String contentType, String url) {
        return this.newRequest(clazz, inputStream, contentType, "application/json", url);
    }

    private <T extends HttpRequestBase> T newRequest(Class<T> clazz, InputStream inputStream, String contentType, String accepts, String url) {
        assert (accepts != null);
        try {
            URIBuilder uriBuilder;
            if (url == null) {
                url = this.baseUrl;
            } else if (!url.startsWith(this.host.getSchemeName())) {
                url = this.appendToBaseURL(url);
            }
            try {
                uriBuilder = new URIBuilder(url);
            }
            catch (URISyntaxException e) {
                uriBuilder = new URIBuilder(URL_ENCODER.encode(url));
            }
            HttpRequestBase result = (HttpRequestBase)clazz.getConstructor(URI.class).newInstance(uriBuilder.build());
            result.setHeader("Accept", accepts);
            if (contentType != null) {
                result.setHeader("Content-Type", contentType);
            }
            if (inputStream != null) {
                assert (result instanceof HttpEntityEnclosingRequestBase);
                InputStreamEntity inputStreamEntity = new InputStreamEntity(inputStream, inputStream.available());
                ((HttpEntityEnclosingRequestBase)result).setEntity(new BufferedHttpEntity(inputStreamEntity));
            }
            return (T)result;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected static String append(String url, String ... segments) {
        for (String segment : segments) {
            if (url.endsWith(segment)) continue;
            if (!url.endsWith("/")) {
                url = url + "/";
            }
            if (segment.startsWith("/")) {
                segment = segment.substring(1);
            }
            url = url + segment;
        }
        return url;
    }

    protected String appendToBaseURL(String ... segments) {
        return JSONRestClient.append(this.baseUrl, segments);
    }

    protected String appendToURL(String ... segments) {
        return JSONRestClient.append(this.url, segments);
    }

    protected class Response {
        private final HttpResponse response;
        private byte[] content;
        private String contentString;
        private JSONObject contentJSON;

        protected Response(HttpRequestBase request) {
            try {
                this.response = JSONRestClient.this.httpClient.execute(JSONRestClient.this.host(), (HttpRequest)request, (HttpContext)JSONRestClient.this.httpContext);
                HttpEntity entity = this.response.getEntity();
                if (entity != null) {
                    ByteArrayOutputStream baous = new ByteArrayOutputStream();
                    entity.writeTo(baous);
                    EntityUtils.consumeQuietly(entity);
                    this.content = baous.toByteArray();
                } else {
                    this.content = new byte[0];
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            finally {
                request.releaseConnection();
            }
        }

        public boolean isOK() {
            return this.hasCode(200);
        }

        private int getStatusCode() {
            return this.response.getStatusLine().getStatusCode();
        }

        private boolean hasCode(int statusCode) {
            return this.getStatusCode() == statusCode;
        }

        public JSONObject json() {
            try {
                if (this.contentJSON == null) {
                    this.contentJSON = new JSONObject(this.asString());
                }
                return this.contentJSON;
            }
            catch (JSONException e) {
                throw new RuntimeException(e);
            }
        }

        public String asString() {
            if (this.contentString == null) {
                this.contentString = new String(this.content);
            }
            return this.contentString;
        }

        public String toString() {
            return this.asString();
        }
    }

    protected static interface MediaType {
        public static final String APPLICATION_JSON = "application/json";
        public static final String TEXT_PLAIN = "text/plain;";
    }
}

