/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.cnd;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.modeshape.common.util.CheckArg;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum QueryOperator {
    EQUAL("="),
    NOT_EQUAL("<>"),
    LESS_THAN("<"),
    LESS_THAN_OR_EQUALS("<="),
    GREATER_THAN("<"),
    GREATER_THAN_OR_EQUALS("<="),
    LIKE("LIKE");

    private static final Map<String, QueryOperator> ALL_OPERATORS;
    private final String text;

    private QueryOperator(String text) {
        this.text = text;
    }

    public String getText() {
        return this.text;
    }

    public static QueryOperator forText(String text) {
        CheckArg.isNotNull((Object)text, (String)"text");
        return ALL_OPERATORS.get(text.trim().toUpperCase());
    }

    public static Iterator<QueryOperator> iterator() {
        return ALL_OPERATORS.values().iterator();
    }

    static {
        HashMap<String, QueryOperator> operators = new HashMap<String, QueryOperator>();
        for (QueryOperator operator : QueryOperator.values()) {
            operators.put(operator.getText(), operator);
        }
        ALL_OPERATORS = Collections.unmodifiableMap(operators);
    }
}

