/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.cnd;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.util.HashSet;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.modeshape.cnd.CndImporter;
import org.modeshape.common.collection.Problem;
import org.modeshape.common.collection.Problems;
import org.modeshape.common.collection.SimpleProblems;
import org.modeshape.common.text.ParsingException;
import org.modeshape.graph.ExecutionContext;
import org.modeshape.graph.Graph;
import org.modeshape.graph.IsNodeWithProperty;
import org.modeshape.graph.JcrLexicon;
import org.modeshape.graph.Location;
import org.modeshape.graph.Node;
import org.modeshape.graph.connector.RepositorySource;
import org.modeshape.graph.connector.inmemory.InMemoryRepositorySource;
import org.modeshape.graph.io.Destination;
import org.modeshape.graph.io.GraphBatchDestination;
import org.modeshape.graph.property.Name;
import org.modeshape.graph.property.Path;
import org.modeshape.graph.property.Property;

public class CndImporterTest {
    public static final String CND_FILE_PATH = "src/test/resources/cnd/";
    private ExecutionContext context;
    private InMemoryRepositorySource repository;
    private Graph graph;
    private Destination destination;
    private Path rootPath;
    private CndImporter importer;
    private SimpleProblems problems;
    public static final String[] NO_DEFAULTS = new String[0];
    public static final String[] NO_SUPERTYPES = new String[0];
    public static final String[] NO_VALUE_CONSTRAINTS = new String[0];
    public static final String NO_PRIMARY_NAME = null;

    @Before
    public void beforeEach() {
        this.problems = new SimpleProblems();
        this.context = new ExecutionContext();
        this.context.getNamespaceRegistry().register("mode", "http://www.modeshape.org/1.0");
        this.context.getNamespaceRegistry().register("jcr", "http://www.jcp.org/jcr/1.0");
        this.context.getNamespaceRegistry().register("nt", "http://www.jcp.org/jcr/nt/1.0");
        this.repository = new InMemoryRepositorySource();
        this.repository.setName("NodeTypes");
        this.graph = Graph.create((RepositorySource)this.repository, (ExecutionContext)this.context);
        this.rootPath = (Path)this.context.getValueFactories().getPathFactory().create("/a");
        this.graph.create(this.rootPath).and();
        this.destination = new GraphBatchDestination(this.graph.batch());
        this.importer = new CndImporter(this.destination, this.rootPath);
    }

    protected Name name(String name) {
        return (Name)this.context.getValueFactories().getNameFactory().create(name);
    }

    protected void printProblems() {
        for (Problem problem : this.problems) {
            System.out.println(problem);
        }
    }

    protected Node node(String pathToNode, String childNodeName, String nameValue) {
        Node a = this.graph.getNodeAt("/a/" + pathToNode);
        List children = a.getChildren();
        for (Location childLocation : a.getChildren()) {
            Node child;
            Property nameProp;
            if (!childLocation.getPath().getLastSegment().getName().equals(this.name(childNodeName)) || (nameProp = (child = this.graph.getNodeAt(childLocation)).getProperty(JcrLexicon.NAME)) == null || !nameProp.getFirstValue().equals(this.name(nameValue))) continue;
            return child;
        }
        return null;
    }

    protected Node node(String pathToNode) {
        return this.graph.getNodeAt("/a/" + pathToNode);
    }

    protected InputStream openCndStream(String cndFileName) throws IOException {
        return this.getClass().getClassLoader().getResourceAsStream("cnd/" + cndFileName);
    }

    protected File openCndFile(String cndFileName) throws IOException, URISyntaxException {
        File result = new File(CND_FILE_PATH + cndFileName);
        Assert.assertThat((Object)result.exists(), (Matcher)Is.is((Object)true));
        return result;
    }

    @Test(expected=ParsingException.class)
    public void shouldReportErrorIfTheNodeTypeNameIsEmpty() {
        String cnd = "<ns = 'http://namespace.com/ns'> [] abstract";
        this.importer.parse(cnd);
    }

    @Test(expected=ParsingException.class)
    public void shouldReportErrorIfTheNodeTypeNameIsBlank() {
        String cnd = "<ns = 'http://namespace.com/ns'> [ ] abstract";
        this.importer.parse(cnd);
    }

    @Test(expected=ParsingException.class)
    public void shouldReportErrorIfTheNodeTypeNameIsNotFollowedByClosingBracket() {
        String cnd = "<ns = 'http://namespace.com/ns'> [  abstract";
        this.importer.parse(cnd);
    }

    @Test(expected=ParsingException.class)
    public void shouldReportErrorIfTheNodeTypeNameUsesInvalidNamespace() {
        String cnd = "<ns = 'http://namespace.com/ns'> [xyz:acme] abstract";
        this.importer.parse(cnd);
    }

    @Test
    public void shouldParseNamespaceDeclarationWithQuotedUriAndQuotedPrefix() {
        String cnd = "<'ns' = 'http://namespace.com/ns'>";
        this.importer.parse(cnd);
    }

    @Test
    public void shouldParseNamespaceDeclarationWithUnquotedUriAndQuotedPrefix() {
        String cnd = "<'ns' = http_namespace.com_ns>";
        this.importer.parse(cnd);
    }

    @Test
    public void shouldParseNamespaceDeclarationWithQuotedUriAndUnquotedPrefix() {
        String cnd = "<ns = 'http://namespace.com/ns'>";
        this.importer.parse(cnd);
    }

    @Test
    public void shouldParseNamespaceDeclarationWithUnquotedUriAndUnquotedPrefix() {
        String cnd = "<ns = http_namespace.com_ns>";
        this.importer.parse(cnd);
    }

    @Test
    public void shouldParseMinimalNodeDefinition() {
        String cnd = "[nodeTypeName]";
        this.importer.parse(cnd);
    }

    @Test
    public void shouldParseMinimalNodeDefinitionWithSupertype() {
        String cnd = "[nodeTypeName] > supertype";
        this.importer.parse(cnd);
    }

    @Test
    public void shouldParseMinimalNodeDefinitionWithSupertypes() {
        String cnd = "[nodeTypeName] > supertype1, supertype2";
        this.importer.parse(cnd);
    }

    @Test
    public void shouldParseNodeDefinitionWithNameThatIsKeyword() {
        String cnd = "[abstract] > supertype1, supertype2";
        this.importer.parse(cnd);
    }

    @Test
    public void shouldImportCndThatUsesAllFeatures() throws IOException {
        String cnd = "<ex = 'http://namespace.com/ns'>\n[ex:NodeType] > ex:ParentType1, ex:ParentType2 abstract orderable mixin noquery primaryitem ex:property\n- ex:property (STRING) = 'default1', 'default2' mandatory autocreated protected multiple VERSION\n queryops '=, <>, <, <=, >, >=, LIKE' nofulltext noqueryorder < 'constraint1', 'constraint2'+ ex:node (ex:reqType1, ex:reqType2) = ex:defaultType mandatory autocreated protected sns version";
        this.importer.importFrom(cnd, (Problems)this.problems, "string");
        this.context.getNamespaceRegistry().register("ex", "http://namespace.com/ns");
        Node nodeType = this.node("ex:NodeType");
        Assert.assertThat((Object)nodeType, (Matcher)IsNodeWithProperty.hasProperty((Name)JcrLexicon.IS_ABSTRACT, (Object[])new Object[]{true}));
        Node prop = this.node("ex:NodeType/jcr:propertyDefinition");
        Assert.assertThat((Object)prop, (Matcher)IsNodeWithProperty.hasProperty((Name)JcrLexicon.NAME, (Object[])new Object[]{this.name("ex:property")}));
        Assert.assertThat((Object)prop, (Matcher)IsNodeWithProperty.hasProperty((Name)JcrLexicon.REQUIRED_TYPE, (Object[])new Object[]{"STRING"}));
        Assert.assertThat((Object)prop, (Matcher)IsNodeWithProperty.hasProperty((Name)JcrLexicon.DEFAULT_VALUES, (Object[])new Object[]{"default1", "default2"}));
        Assert.assertThat((Object)prop, (Matcher)IsNodeWithProperty.hasProperty((Name)JcrLexicon.AUTO_CREATED, (Object[])new Object[]{true}));
        Assert.assertThat((Object)prop, (Matcher)IsNodeWithProperty.hasProperty((Name)JcrLexicon.MANDATORY, (Object[])new Object[]{true}));
        Assert.assertThat((Object)prop, (Matcher)IsNodeWithProperty.hasProperty((Name)JcrLexicon.PROTECTED, (Object[])new Object[]{true}));
        Assert.assertThat((Object)prop, (Matcher)IsNodeWithProperty.hasProperty((Name)JcrLexicon.MULTIPLE, (Object[])new Object[]{true}));
        Assert.assertThat((Object)prop, (Matcher)IsNodeWithProperty.hasProperty((Name)JcrLexicon.ON_PARENT_VERSION, (Object[])new Object[]{"VERSION"}));
        Assert.assertThat((Object)prop, (Matcher)IsNodeWithProperty.hasProperty((Name)JcrLexicon.VALUE_CONSTRAINTS, (Object[])new Object[]{"constraint1", "constraint2"}));
        Assert.assertThat((Object)prop, (Matcher)IsNodeWithProperty.hasProperty((Name)JcrLexicon.IS_FULL_TEXT_SEARCHABLE, (Object[])new Object[]{false}));
        Assert.assertThat((Object)prop, (Matcher)IsNodeWithProperty.hasProperty((Name)JcrLexicon.IS_QUERY_ORDERABLE, (Object[])new Object[]{false}));
        Node node = this.node("ex:NodeType/jcr:childNodeDefinition");
        Assert.assertThat((Object)node, (Matcher)IsNodeWithProperty.hasProperty((Name)JcrLexicon.NAME, (Object[])new Object[]{this.name("ex:node")}));
        Assert.assertThat((Object)node, (Matcher)IsNodeWithProperty.hasProperty((Name)JcrLexicon.REQUIRED_PRIMARY_TYPES, (Object[])new Object[]{this.name("ex:reqType1"), this.name("ex:reqType2")}));
        Assert.assertThat((Object)node, (Matcher)IsNodeWithProperty.hasProperty((Name)JcrLexicon.DEFAULT_PRIMARY_TYPE, (Object[])new Object[]{this.name("ex:defaultType")}));
        Assert.assertThat((Object)node, (Matcher)IsNodeWithProperty.hasProperty((Name)JcrLexicon.AUTO_CREATED, (Object[])new Object[]{true}));
        Assert.assertThat((Object)node, (Matcher)IsNodeWithProperty.hasProperty((Name)JcrLexicon.MANDATORY, (Object[])new Object[]{true}));
        Assert.assertThat((Object)node, (Matcher)IsNodeWithProperty.hasProperty((Name)JcrLexicon.PROTECTED, (Object[])new Object[]{true}));
        Assert.assertThat((Object)node, (Matcher)IsNodeWithProperty.hasProperty((Name)JcrLexicon.SAME_NAME_SIBLINGS, (Object[])new Object[]{true}));
        Assert.assertThat((Object)node, (Matcher)IsNodeWithProperty.hasProperty((Name)JcrLexicon.ON_PARENT_VERSION, (Object[])new Object[]{"VERSION"}));
    }

    @Test
    public void shouldImportCndThatIsOnOneLine() throws IOException {
        String cnd = "<ns = 'http://namespace.com/ns'> [ns:NodeType] > ns:ParentType1, ns:ParentType2 abstract orderable mixin noquery primaryitem ex:property - ex:property (STRING) = 'default1', 'default2' mandatory autocreated protected multiple VERSION < 'constraint1', 'constraint2'  queryops '=, <>, <, <=, >, >=, LIKE' nofulltext noqueryorder + ns:node (ns:reqType1, ns:reqType2) = ns:defaultType mandatory autocreated protected sns version";
    }

    @Test
    public void shouldImportCndThatHasNoChildren() throws IOException {
        String cnd = "<ns = 'http://namespace.com/ns'>\n[ns:NodeType] > ns:ParentType1, ns:ParentType2 abstract orderable mixin noquery primaryitem ex:property\n- ex:property (STRING) = 'default1', 'default2' mandatory autocreated protected multiple VERSION < 'constraint1', 'constraint2'\n queryops '=, <>, <, <=, >, >=, LIKE' nofulltext noqueryorder";
    }

    @Test
    public void shouldImportJcrBuiltinNodeTypesForJSR170() throws Exception {
        this.importer.importFrom(this.openCndFile("jcr-builtins-170.cnd"), (Problems)this.problems);
        if (this.problems.size() != 0) {
            this.printProblems();
        }
        Assert.assertThat((Object)this.problems.size(), (Matcher)Is.is((Object)0));
        this.assertNodeType("nt:base", NO_SUPERTYPES, NO_PRIMARY_NAME, new NodeOptions[0]);
        this.assertProperty("nt:base", "jcr:primaryType", "Name", NO_DEFAULTS, new PropertyOptions[]{PropertyOptions.Mandatory, PropertyOptions.Autocreated, PropertyOptions.Protected}, OnParentVersion.Compute, new String[0]);
        this.assertProperty("nt:base", "jcr:mixinTypes", "Name", NO_DEFAULTS, new PropertyOptions[]{PropertyOptions.Multiple, PropertyOptions.Protected}, OnParentVersion.Compute, new String[0]);
        this.assertNodeType("nt:unstructured", NO_SUPERTYPES, NO_PRIMARY_NAME, NodeOptions.Ordered);
        this.assertProperty("nt:unstructured", "*", "Undefined", NO_DEFAULTS, PropertyOptions.Multiple);
        this.assertChild("nt:unstructured", "*", "nt:base", "nt:unstructured", OnParentVersion.Version, ChildOptions.Multiple);
        this.assertNodeType("mix:referenceable", NO_SUPERTYPES, NO_PRIMARY_NAME, NodeOptions.Mixin);
        this.assertProperty("mix:referenceable", "jcr:uuid", "String", NO_DEFAULTS, OnParentVersion.Initialize, PropertyOptions.Mandatory, PropertyOptions.Autocreated, PropertyOptions.Protected);
        this.assertNodeType("mix:lockable", new String[]{"mix:referenceable"}, NO_PRIMARY_NAME, NodeOptions.Mixin);
        this.assertProperty("mix:lockable", "jcr:lockOwner", "String", NO_DEFAULTS, OnParentVersion.Ignore, PropertyOptions.Protected);
        this.assertProperty("mix:lockable", "jcr:lockIsDeep", "Boolean", NO_DEFAULTS, OnParentVersion.Ignore, PropertyOptions.Protected);
        this.assertNodeType("nt:propertyDefinition", NO_SUPERTYPES, NO_PRIMARY_NAME, new NodeOptions[0]);
        this.assertProperty("nt:propertyDefinition", "jcr:name", "Name", NO_DEFAULTS, new PropertyOptions[0]);
        this.assertProperty("nt:propertyDefinition", "jcr:autoCreated", "Boolean", NO_DEFAULTS, PropertyOptions.Mandatory);
        this.assertProperty("nt:propertyDefinition", "jcr:mandatory", "Boolean", NO_DEFAULTS, PropertyOptions.Mandatory);
        this.assertProperty("nt:propertyDefinition", "jcr:onParentVersion", "String", NO_DEFAULTS, new PropertyOptions[]{PropertyOptions.Mandatory}, null, "COPY", "VERSION", "INITIALIZE", "COMPUTE", "IGNORE", "ABORT");
        this.assertProperty("nt:propertyDefinition", "jcr:protected", "Boolean", NO_DEFAULTS, PropertyOptions.Mandatory);
        this.assertProperty("nt:propertyDefinition", "jcr:requiredType", "String", NO_DEFAULTS, new PropertyOptions[]{PropertyOptions.Mandatory}, null, "STRING", "BINARY", "LONG", "DOUBLE", "BOOLEAN", "DATE", "NAME", "PATH", "REFERENCE", "UNDEFINED");
        this.assertProperty("nt:propertyDefinition", "jcr:valueConstraints", "String", NO_DEFAULTS, PropertyOptions.Multiple);
        this.assertProperty("nt:propertyDefinition", "jcr:defaultValues", "Undefined", NO_DEFAULTS, PropertyOptions.Multiple);
        this.assertProperty("nt:propertyDefinition", "jcr:multiple", "Boolean", NO_DEFAULTS, PropertyOptions.Mandatory);
    }

    @Test
    public void shouldImportJcrBuiltinNodeTypesForJSR283() throws Exception {
        this.importer.importFrom(this.openCndFile("jcr-builtins-283-early-draft.cnd"), (Problems)this.problems);
        if (this.problems.size() != 0) {
            this.printProblems();
        }
        Assert.assertThat((Object)this.problems.size(), (Matcher)Is.is((Object)0));
        this.assertNodeType("nt:base", new String[]{"mode:defined"}, NO_PRIMARY_NAME, NodeOptions.Abstract);
        this.assertProperty("nt:base", "jcr:primaryType", "Name", NO_DEFAULTS, new PropertyOptions[]{PropertyOptions.Mandatory, PropertyOptions.Autocreated, PropertyOptions.Protected}, OnParentVersion.Compute, new String[0]);
        this.assertProperty("nt:base", "jcr:mixinTypes", "Name", NO_DEFAULTS, new PropertyOptions[]{PropertyOptions.Multiple, PropertyOptions.Protected}, OnParentVersion.Compute, new String[0]);
        this.assertNodeType("nt:unstructured", NO_SUPERTYPES, NO_PRIMARY_NAME, NodeOptions.Ordered);
        this.assertProperty("nt:unstructured", "*", "Undefined", NO_DEFAULTS, PropertyOptions.Multiple);
        this.assertChild("nt:unstructured", "*", "nt:base", "nt:unstructured", OnParentVersion.Version, ChildOptions.Multiple);
        this.assertNodeType("mix:referenceable", NO_SUPERTYPES, NO_PRIMARY_NAME, NodeOptions.Mixin);
        this.assertProperty("mix:referenceable", "jcr:uuid", "String", NO_DEFAULTS, OnParentVersion.Initialize, PropertyOptions.Mandatory, PropertyOptions.Autocreated, PropertyOptions.Protected);
        this.assertNodeType("mix:lockable", NO_SUPERTYPES, NO_PRIMARY_NAME, NodeOptions.Mixin);
        this.assertProperty("mix:lockable", "jcr:lockOwner", "String", NO_DEFAULTS, OnParentVersion.Ignore, PropertyOptions.Protected);
        this.assertProperty("mix:lockable", "jcr:lockIsDeep", "Boolean", NO_DEFAULTS, OnParentVersion.Ignore, PropertyOptions.Protected);
        this.assertNodeType("nt:propertyDefinition", NO_SUPERTYPES, NO_PRIMARY_NAME, new NodeOptions[0]);
        this.assertProperty("nt:propertyDefinition", "jcr:name", "Name", NO_DEFAULTS, new PropertyOptions[0]);
        this.assertProperty("nt:propertyDefinition", "jcr:autoCreated", "Boolean", NO_DEFAULTS, PropertyOptions.Mandatory);
        this.assertProperty("nt:propertyDefinition", "jcr:mandatory", "Boolean", NO_DEFAULTS, PropertyOptions.Mandatory);
        this.assertProperty("nt:propertyDefinition", "jcr:onParentVersion", "String", NO_DEFAULTS, new PropertyOptions[]{PropertyOptions.Mandatory}, null, "COPY", "VERSION", "INITIALIZE", "COMPUTE", "IGNORE", "ABORT");
        this.assertProperty("nt:propertyDefinition", "jcr:protected", "Boolean", NO_DEFAULTS, PropertyOptions.Mandatory);
        this.assertProperty("nt:propertyDefinition", "jcr:requiredType", "String", NO_DEFAULTS, new PropertyOptions[]{PropertyOptions.Mandatory}, null, "STRING", "BINARY", "LONG", "DOUBLE", "BOOLEAN", "DATE", "NAME", "PATH", "REFERENCE", "UNDEFINED");
        this.assertProperty("nt:propertyDefinition", "jcr:valueConstraints", "String", NO_DEFAULTS, PropertyOptions.Multiple);
        this.assertProperty("nt:propertyDefinition", "jcr:defaultValues", "Undefined", NO_DEFAULTS, PropertyOptions.Multiple);
        this.assertProperty("nt:propertyDefinition", "jcr:multiple", "Boolean", NO_DEFAULTS, PropertyOptions.Mandatory);
    }

    @Test
    public void shouldImportCndThatIsEmpty() throws Exception {
        this.importer.importFrom(this.openCndFile("empty.cnd"), (Problems)this.problems);
        if (this.problems.size() != 0) {
            this.printProblems();
        }
        Assert.assertThat((Object)this.problems.size(), (Matcher)Is.is((Object)0));
    }

    @Test
    public void shouldImportCndForImageSequencer() throws Exception {
        this.importer.importFrom(this.openCndFile("images.cnd"), (Problems)this.problems);
        if (this.problems.size() != 0) {
            this.printProblems();
        }
        Assert.assertThat((Object)this.problems.size(), (Matcher)Is.is((Object)0));
    }

    @Test
    public void shouldImportCndForMp3Sequencer() throws Exception {
        this.importer.importFrom(this.openCndFile("mp3.cnd"), (Problems)this.problems);
        if (this.problems.size() != 0) {
            this.printProblems();
        }
        Assert.assertThat((Object)this.problems.size(), (Matcher)Is.is((Object)0));
    }

    @Test
    public void shouldNotImportFileThatIsNotAValidCnd() throws Exception {
        this.importer.importFrom(this.openCndFile("invalid.cnd"), (Problems)this.problems);
        Assert.assertThat((Object)this.problems.size(), (Matcher)Is.is((Object)1));
    }

    @Test
    public void shouldImportCndForAircraft() throws Exception {
        this.importer.importFrom(this.openCndFile("aircraft.cnd"), (Problems)this.problems);
        if (this.problems.size() != 0) {
            this.printProblems();
        }
        Assert.assertThat((Object)this.problems.size(), (Matcher)Is.is((Object)0));
    }

    @Test
    public void shouldImportCndForCars() throws Exception {
        this.importer.importFrom(this.openCndFile("cars.cnd"), (Problems)this.problems);
        if (this.problems.size() != 0) {
            this.printProblems();
        }
        Assert.assertThat((Object)this.problems.size(), (Matcher)Is.is((Object)0));
    }

    @Test
    public void shouldImportCndForJavaSequencer() throws Exception {
        this.importer.importFrom(this.openCndFile("javaSource.cnd"), (Problems)this.problems);
        if (this.problems.size() != 0) {
            this.printProblems();
        }
        Assert.assertThat((Object)this.problems.size(), (Matcher)Is.is((Object)0));
    }

    protected void assertNodeType(String name, String[] superTypes, String primaryItemName, NodeOptions ... nodeOptions) {
        HashSet<NodeOptions> options = new HashSet<NodeOptions>();
        for (NodeOptions option : nodeOptions) {
            options.add(option);
        }
        Node nodeType = this.node(name);
        Assert.assertThat((Object)nodeType, (Matcher)IsNodeWithProperty.hasProperty((Name)JcrLexicon.IS_MIXIN, (Object[])new Object[]{options.contains((Object)NodeOptions.Mixin)}));
        Assert.assertThat((Object)nodeType, (Matcher)IsNodeWithProperty.hasProperty((Name)JcrLexicon.IS_ABSTRACT, (Object[])new Object[]{options.contains((Object)NodeOptions.Abstract)}));
        Assert.assertThat((Object)nodeType, (Matcher)IsNodeWithProperty.hasProperty((Name)JcrLexicon.HAS_ORDERABLE_CHILD_NODES, (Object[])new Object[]{options.contains((Object)NodeOptions.Ordered)}));
        Assert.assertThat((Object)nodeType, (Matcher)IsNodeWithProperty.hasProperty((Name)JcrLexicon.IS_QUERYABLE, (Object[])new Object[]{!options.contains((Object)NodeOptions.Queryable)}));
        if (primaryItemName != null) {
            Assert.assertThat((Object)nodeType, (Matcher)IsNodeWithProperty.hasProperty((Name)JcrLexicon.PRIMARY_ITEM_NAME, (Object[])new Object[]{this.name(primaryItemName)}));
        } else {
            Assert.assertThat((Object)nodeType.getPropertiesByName().containsKey(JcrLexicon.PRIMARY_ITEM_NAME), (Matcher)Is.is((Object)false));
        }
        if (superTypes.length != 0) {
            Name[] superTypeNames = new Name[superTypes.length];
            for (int i = 0; i != superTypes.length; ++i) {
                String requiredType = superTypes[i];
                superTypeNames[i] = this.name(requiredType);
            }
            Assert.assertThat((Object)nodeType, (Matcher)IsNodeWithProperty.hasProperty((Name)JcrLexicon.SUPERTYPES, (Object[])superTypeNames));
        } else {
            Assert.assertThat((Object)nodeType.getProperty(JcrLexicon.SUPERTYPES), (Matcher)Is.is((Matcher)IsNull.nullValue()));
        }
    }

    protected void assertProperty(String nodeTypeName, String propertyName, String requiredType, String[] defaultValues, PropertyOptions ... propertyOptions) {
        this.assertProperty(nodeTypeName, propertyName, requiredType, defaultValues, propertyOptions, null, new String[0]);
    }

    protected void assertProperty(String nodeTypeName, String propertyName, String requiredType, String[] defaultValues, OnParentVersion onParentVersion, PropertyOptions ... propertyOptions) {
        this.assertProperty(nodeTypeName, propertyName, requiredType, defaultValues, propertyOptions, onParentVersion, new String[0]);
    }

    protected void assertProperty(String nodeTypeName, String propertyName, String requiredType, String[] defaultValues, PropertyOptions[] propertyOptions, OnParentVersion onParentVersioning, String ... valueConstraints) {
        HashSet<PropertyOptions> options = new HashSet<PropertyOptions>();
        for (PropertyOptions option : propertyOptions) {
            options.add(option);
        }
        Node nodeType = this.node(nodeTypeName, "jcr:propertyDefinition", propertyName);
        Assert.assertThat((Object)nodeType, (Matcher)IsNodeWithProperty.hasProperty((Name)JcrLexicon.REQUIRED_TYPE, (Object[])new Object[]{requiredType.toUpperCase()}));
        Assert.assertThat((Object)nodeType, (Matcher)IsNodeWithProperty.hasProperty((Name)JcrLexicon.MULTIPLE, (Object[])new Object[]{options.contains((Object)PropertyOptions.Multiple)}));
        Assert.assertThat((Object)nodeType, (Matcher)IsNodeWithProperty.hasProperty((Name)JcrLexicon.MANDATORY, (Object[])new Object[]{options.contains((Object)PropertyOptions.Mandatory)}));
        Assert.assertThat((Object)nodeType, (Matcher)IsNodeWithProperty.hasProperty((Name)JcrLexicon.AUTO_CREATED, (Object[])new Object[]{options.contains((Object)PropertyOptions.Autocreated)}));
        Assert.assertThat((Object)nodeType, (Matcher)IsNodeWithProperty.hasProperty((Name)JcrLexicon.PROTECTED, (Object[])new Object[]{options.contains((Object)PropertyOptions.Protected)}));
        if (onParentVersioning != null) {
            switch (onParentVersioning) {
                case Abort: {
                    Assert.assertThat((Object)nodeType, (Matcher)IsNodeWithProperty.hasProperty((Name)JcrLexicon.ON_PARENT_VERSION, (Object[])new Object[]{"ABORT"}));
                    break;
                }
                case Compute: {
                    Assert.assertThat((Object)nodeType, (Matcher)IsNodeWithProperty.hasProperty((Name)JcrLexicon.ON_PARENT_VERSION, (Object[])new Object[]{"COMPUTE"}));
                    break;
                }
                case Copy: {
                    Assert.assertThat((Object)nodeType, (Matcher)IsNodeWithProperty.hasProperty((Name)JcrLexicon.ON_PARENT_VERSION, (Object[])new Object[]{"COPY"}));
                    break;
                }
                case Ignore: {
                    Assert.assertThat((Object)nodeType, (Matcher)IsNodeWithProperty.hasProperty((Name)JcrLexicon.ON_PARENT_VERSION, (Object[])new Object[]{"IGNORE"}));
                    break;
                }
                case Initialize: {
                    Assert.assertThat((Object)nodeType, (Matcher)IsNodeWithProperty.hasProperty((Name)JcrLexicon.ON_PARENT_VERSION, (Object[])new Object[]{"INITIALIZE"}));
                    break;
                }
                case Version: {
                    Assert.assertThat((Object)nodeType, (Matcher)IsNodeWithProperty.hasProperty((Name)JcrLexicon.ON_PARENT_VERSION, (Object[])new Object[]{"VERSION"}));
                }
            }
        } else {
            Assert.assertThat((Object)nodeType, (Matcher)IsNodeWithProperty.hasProperty((Name)JcrLexicon.ON_PARENT_VERSION, (Object[])new Object[]{"COPY"}));
        }
        Assert.assertThat((Object)nodeType, (Matcher)IsNodeWithProperty.hasProperty((Name)JcrLexicon.IS_FULL_TEXT_SEARCHABLE, (Object[])new Object[]{!options.contains((Object)PropertyOptions.FullTextSearchable)}));
        Assert.assertThat((Object)nodeType, (Matcher)IsNodeWithProperty.hasProperty((Name)JcrLexicon.IS_QUERY_ORDERABLE, (Object[])new Object[]{!options.contains((Object)PropertyOptions.QueryOrderable)}));
        if (valueConstraints.length != 0) {
            Assert.assertThat((Object)nodeType, (Matcher)IsNodeWithProperty.hasProperty((Name)JcrLexicon.VALUE_CONSTRAINTS, (Object[])valueConstraints));
        } else {
            Assert.assertThat((Object)nodeType.getProperty(JcrLexicon.VALUE_CONSTRAINTS), (Matcher)Is.is((Matcher)IsNull.nullValue()));
        }
        if (defaultValues.length != 0) {
            Assert.assertThat((Object)nodeType, (Matcher)IsNodeWithProperty.hasProperty((Name)JcrLexicon.DEFAULT_VALUES, (Object[])defaultValues));
        } else {
            Assert.assertThat((Object)nodeType.getProperty(JcrLexicon.DEFAULT_VALUES), (Matcher)Is.is((Matcher)IsNull.nullValue()));
        }
    }

    protected void assertChild(String nodeTypeName, String childName, String requiredType, String defaultPrimaryType, ChildOptions[] childOptions, OnParentVersion onParentVersioning) {
        this.assertChild(nodeTypeName, childName, new String[]{requiredType}, defaultPrimaryType, childOptions, onParentVersioning);
    }

    protected void assertChild(String nodeTypeName, String childName, String requiredType, String defaultPrimaryType, OnParentVersion onParentVersioning, ChildOptions ... childOptions) {
        this.assertChild(nodeTypeName, childName, new String[]{requiredType}, defaultPrimaryType, childOptions, onParentVersioning);
    }

    protected void assertChild(String nodeTypeName, String childName, String[] requiredTypes, String defaultPrimaryType, ChildOptions[] childOptions, OnParentVersion onParentVersioning) {
        HashSet<ChildOptions> options = new HashSet<ChildOptions>();
        for (ChildOptions option : childOptions) {
            options.add(option);
        }
        Node nodeType = this.node(nodeTypeName, "jcr:childNodeDefinition", childName);
        Assert.assertThat((Object)nodeType, (Matcher)IsNodeWithProperty.hasProperty((Name)JcrLexicon.DEFAULT_PRIMARY_TYPE, (Object[])new Object[]{this.name(defaultPrimaryType)}));
        Assert.assertThat((Object)nodeType, (Matcher)IsNodeWithProperty.hasProperty((Name)JcrLexicon.SAME_NAME_SIBLINGS, (Object[])new Object[]{options.contains((Object)ChildOptions.Multiple)}));
        Assert.assertThat((Object)nodeType, (Matcher)IsNodeWithProperty.hasProperty((Name)JcrLexicon.MANDATORY, (Object[])new Object[]{options.contains((Object)ChildOptions.Mandatory)}));
        Assert.assertThat((Object)nodeType, (Matcher)IsNodeWithProperty.hasProperty((Name)JcrLexicon.AUTO_CREATED, (Object[])new Object[]{options.contains((Object)ChildOptions.Autocreated)}));
        Assert.assertThat((Object)nodeType, (Matcher)IsNodeWithProperty.hasProperty((Name)JcrLexicon.PROTECTED, (Object[])new Object[]{options.contains((Object)ChildOptions.Protected)}));
        switch (onParentVersioning) {
            case Abort: {
                Assert.assertThat((Object)nodeType, (Matcher)IsNodeWithProperty.hasProperty((Name)JcrLexicon.ON_PARENT_VERSION, (Object[])new Object[]{"ABORT"}));
                break;
            }
            case Compute: {
                Assert.assertThat((Object)nodeType, (Matcher)IsNodeWithProperty.hasProperty((Name)JcrLexicon.ON_PARENT_VERSION, (Object[])new Object[]{"COMPUTE"}));
                break;
            }
            case Copy: {
                Assert.assertThat((Object)nodeType, (Matcher)IsNodeWithProperty.hasProperty((Name)JcrLexicon.ON_PARENT_VERSION, (Object[])new Object[]{"COPY"}));
                break;
            }
            case Ignore: {
                Assert.assertThat((Object)nodeType, (Matcher)IsNodeWithProperty.hasProperty((Name)JcrLexicon.ON_PARENT_VERSION, (Object[])new Object[]{"IGNORE"}));
                break;
            }
            case Initialize: {
                Assert.assertThat((Object)nodeType, (Matcher)IsNodeWithProperty.hasProperty((Name)JcrLexicon.ON_PARENT_VERSION, (Object[])new Object[]{"INITIALIZE"}));
                break;
            }
            case Version: {
                Assert.assertThat((Object)nodeType, (Matcher)IsNodeWithProperty.hasProperty((Name)JcrLexicon.ON_PARENT_VERSION, (Object[])new Object[]{"VERSION"}));
                break;
            }
            default: {
                Assert.assertThat((Object)nodeType, (Matcher)IsNodeWithProperty.hasProperty((Name)JcrLexicon.ON_PARENT_VERSION, (Object[])new Object[]{Is.is((Matcher)IsNull.nullValue())}));
            }
        }
        if (requiredTypes.length != 0) {
            Name[] requiredTypeNames = new Name[requiredTypes.length];
            for (int i = 0; i != requiredTypes.length; ++i) {
                String requiredType = requiredTypes[i];
                requiredTypeNames[i] = this.name(requiredType);
            }
            Assert.assertThat((Object)nodeType, (Matcher)IsNodeWithProperty.hasProperty((Name)JcrLexicon.REQUIRED_PRIMARY_TYPES, (Object[])requiredTypeNames));
        } else {
            Assert.assertThat((Object)nodeType.getProperty(JcrLexicon.REQUIRED_PRIMARY_TYPES), (Matcher)Is.is((Matcher)IsNull.nullValue()));
        }
    }

    public static enum OnParentVersion {
        Copy,
        Version,
        Initialize,
        Compute,
        Ignore,
        Abort;

    }

    public static enum NodeOptions {
        Abstract,
        Mixin,
        Ordered,
        Queryable;

    }

    public static enum ChildOptions {
        Mandatory,
        Autocreated,
        Protected,
        Multiple;

    }

    public static enum PropertyOptions {
        Mandatory,
        Autocreated,
        Protected,
        Multiple,
        FullTextSearchable,
        QueryOrderable;

    }
}

