/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.common.text;

import java.text.StringCharacterIterator;
import java.util.BitSet;
import org.modeshape.common.text.TextDecoder;
import org.modeshape.common.text.TextEncoder;

public class QuoteEncoder
implements TextDecoder,
TextEncoder {
    private static final BitSet ESCAPE_CHARACTERS = new BitSet(256);
    public static final char ESCAPE_CHARACTER = '\\';

    @Override
    public String decode(String encodedText) {
        if (encodedText == null) {
            return null;
        }
        if (encodedText.length() == 0) {
            return "";
        }
        StringBuilder result = new StringBuilder();
        StringCharacterIterator iter = new StringCharacterIterator(encodedText);
        char c = iter.first();
        while (c != '\uffff') {
            if (c == '\\') {
                char nextChar = iter.next();
                if (nextChar == 'n') {
                    result.append('\n');
                } else if (nextChar == 't') {
                    result.append('\t');
                } else if (nextChar == 'r') {
                    result.append('\r');
                } else if (nextChar == 'f') {
                    result.append('\f');
                } else {
                    result.append(nextChar);
                }
            } else {
                result.append(c);
            }
            c = iter.next();
        }
        return result.toString();
    }

    @Override
    public String encode(String text) {
        StringBuilder result = new StringBuilder();
        StringCharacterIterator iter = new StringCharacterIterator(text);
        int c = iter.first();
        while (c != 65535) {
            if (ESCAPE_CHARACTERS.get(c)) {
                result.append('\\');
                if (c == 10) {
                    c = 110;
                } else if (c == 9) {
                    c = 116;
                } else if (c == 13) {
                    c = 114;
                } else if (c == 12) {
                    c = 102;
                }
            }
            result.append((char)c);
            c = iter.next();
        }
        return result.toString();
    }

    static {
        ESCAPE_CHARACTERS.set(34);
        ESCAPE_CHARACTERS.set(92);
        ESCAPE_CHARACTERS.set(10);
        ESCAPE_CHARACTERS.set(9);
    }
}

