/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.common.collection.ring;

import java.util.Arrays;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.modeshape.common.collection.ring.Cursor;
import org.modeshape.common.collection.ring.Pointer;

public class Pointers {
    private Pointers() {
    }

    public static long getMinimum(Pointer[] pointers, long minimum) {
        for (int i = 0; i != pointers.length; ++i) {
            minimum = Math.min(minimum, pointers[i].get());
        }
        return minimum;
    }

    public static <T> void add(T holder, AtomicReferenceFieldUpdater<T, Pointer[]> updater, Cursor cursor, Pointer ... pointersToAdd) {
        Pointer[] updatedPointers;
        Pointer[] currentPointers;
        long currentPosition = 0L;
        do {
            currentPointers = updater.get(holder);
            updatedPointers = Arrays.copyOf(currentPointers, currentPointers.length + pointersToAdd.length);
            if (cursor != null) {
                currentPosition = cursor.getCurrent();
            }
            int index = currentPointers.length;
            for (Pointer pointer : pointersToAdd) {
                if (cursor != null) {
                    pointer.set(currentPosition);
                }
                updatedPointers[index++] = pointer;
            }
        } while (!updater.compareAndSet(holder, currentPointers, updatedPointers));
        if (cursor != null) {
            currentPosition = cursor.getCurrent();
            for (Pointer pointer : pointersToAdd) {
                pointer.set(currentPosition);
            }
        }
    }

    public static <T> boolean remove(T holder, AtomicReferenceFieldUpdater<T, Pointer[]> updater, Pointer pointer) {
        Pointer[] oldPointers;
        int numToRemove;
        while (0 != (numToRemove = Pointers.countMatching(oldPointers = updater.get(holder), pointer))) {
            int oldSize = oldPointers.length;
            Pointer[] newPointers = new Pointer[oldSize - numToRemove];
            int pos = 0;
            for (int i = 0; i < oldSize; ++i) {
                Pointer testPointer = oldPointers[i];
                if (pointer == testPointer) continue;
                newPointers[pos++] = testPointer;
            }
            if (!updater.compareAndSet(holder, oldPointers, newPointers)) continue;
        }
        return numToRemove != 0;
    }

    private static <T> int countMatching(T[] values, T toMatch) {
        int numToRemove = 0;
        for (T value : values) {
            if (value != toMatch) continue;
            ++numToRemove;
        }
        return numToRemove;
    }
}

