/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.connector.disk;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.modeshape.common.annotation.ThreadSafe;
import org.modeshape.common.i18n.I18n;
import org.modeshape.common.util.Logger;
import org.modeshape.connector.disk.DiskConnectorI18n;
import org.modeshape.connector.disk.DiskNode;
import org.modeshape.connector.disk.DiskSource;
import org.modeshape.connector.disk.DiskTransaction;
import org.modeshape.connector.disk.DiskWorkspace;
import org.modeshape.graph.ExecutionContext;
import org.modeshape.graph.connector.RepositorySourceException;
import org.modeshape.graph.connector.base.BaseRepositorySource;
import org.modeshape.graph.connector.base.Repository;
import org.modeshape.graph.connector.base.Transaction;
import org.modeshape.graph.request.CreateWorkspaceRequest;
import org.modeshape.graph.request.InvalidWorkspaceException;

@ThreadSafe
public class DiskRepository
extends Repository<DiskNode, DiskWorkspace> {
    protected static final Logger LOGGER = Logger.getLogger(DiskRepository.class);
    private static final String LOCK_FILE_NAME = "lock";
    private final File repositoryRoot;
    protected final FileChannel lockFileChannel;
    protected AtomicInteger readLockCount = new AtomicInteger(0);
    private File largeValuesRoot;
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private final Set<String> predefinedWorkspaceNames;
    private final DiskSource diskSource;

    public DiskRepository(DiskSource source) {
        super((BaseRepositorySource)source);
        this.diskSource = source;
        this.repositoryRoot = new File(source.getRepositoryRootPath());
        if (!this.repositoryRoot.exists()) {
            this.repositoryRoot.mkdir();
        }
        File repositoryLockFile = null;
        FileChannel lfc = null;
        if (source.isLockFileUsed()) {
            repositoryLockFile = new File(this.repositoryRoot, LOCK_FILE_NAME);
            try {
                if (!repositoryLockFile.exists()) {
                    FileOutputStream fos = null;
                    fos = new FileOutputStream(repositoryLockFile);
                    fos.write("modeshape".getBytes());
                    fos.close();
                }
                RandomAccessFile raf = new RandomAccessFile(repositoryLockFile, "rw");
                lfc = raf.getChannel();
            }
            catch (IOException ioe) {
                LOGGER.warn((Throwable)ioe, DiskConnectorI18n.couldNotCreateLockFile, new Object[]{source.getName()});
            }
        }
        this.lockFileChannel = lfc;
        if (!this.repositoryRoot.exists()) {
            this.repositoryRoot.mkdirs();
        }
        assert (this.repositoryRoot.exists());
        this.largeValuesRoot = new File(this.repositoryRoot, source.getLargeValuePath());
        if (!this.largeValuesRoot.exists()) {
            this.largeValuesRoot.mkdirs();
        }
        assert (this.largeValuesRoot.exists());
        HashSet<String> workspaceNames = new HashSet<String>();
        for (String workspaceName : source.getPredefinedWorkspaceNames()) {
            workspaceNames.add(workspaceName);
        }
        this.predefinedWorkspaceNames = Collections.unmodifiableSet(workspaceNames);
        this.initialize();
    }

    protected void initialize() {
        super.initialize();
        DiskTransaction txn = this.startTransaction(this.context, false);
        if (this.source.isCreatingWorkspacesAllowed()) {
            try {
                for (File file : this.repositoryRoot.listFiles()) {
                    DiskWorkspace workspace;
                    if (!file.isDirectory()) continue;
                    String workspaceName = file.getName();
                    if ((this.largeValuesRoot == null || !this.largeValuesRoot.getCanonicalPath().startsWith(file.getCanonicalPath())) && (workspace = this.createWorkspace((Transaction<DiskNode, DiskWorkspace>)txn, workspaceName, CreateWorkspaceRequest.CreateConflictBehavior.DO_NOT_CREATE, (String)null)) != null) assert (workspace.getRootNode() != null);
                }
            }
            catch (IOException ioe) {
                txn.rollback();
                throw new RepositorySourceException(this.diskSource.getName(), (Throwable)ioe);
            }
        }
        for (String workspaceName : this.predefinedWorkspaceNames) {
            this.createWorkspace((Transaction<DiskNode, DiskWorkspace>)txn, workspaceName, CreateWorkspaceRequest.CreateConflictBehavior.DO_NOT_CREATE, (String)null);
        }
        txn.commit();
    }

    public DiskWorkspace createWorkspace(Transaction<DiskNode, DiskWorkspace> txn, String name, CreateWorkspaceRequest.CreateConflictBehavior existingWorkspaceBehavior, String nameOfWorkspaceToClone) throws InvalidWorkspaceException {
        DiskWorkspace workspace = (DiskWorkspace)super.createWorkspace(txn, name, existingWorkspaceBehavior, nameOfWorkspaceToClone);
        if (workspace != null && workspace.getRootNode() == null) {
            workspace.putNode(new DiskNode(this.diskSource.getRootNodeUuidObject()));
        }
        return workspace;
    }

    public Set<String> getWorkspaceNames() {
        HashSet<String> names = new HashSet<String>(super.getWorkspaceNames());
        names.addAll(this.predefinedWorkspaceNames);
        return Collections.unmodifiableSet(names);
    }

    protected File getRepositoryRoot() {
        return this.repositoryRoot;
    }

    public DiskTransaction startTransaction(ExecutionContext context, boolean readonly) {
        DiskLock diskLock = readonly ? new DiskBackedReadLock(this.lock) : new DiskBackedWriteLock(this.lock);
        diskLock.lock();
        return new DiskTransaction(context, this, this.getRootNodeUuid(), diskLock);
    }

    DiskSource diskSource() {
        return this.diskSource;
    }

    File largeValuesRoot() {
        return this.largeValuesRoot;
    }

    class DiskBackedWriteLock
    implements DiskLock {
        private final Lock lock;
        private FileLock fileLock;

        public DiskBackedWriteLock(ReadWriteLock lock) {
            this.lock = lock.writeLock();
        }

        @Override
        public void lock() {
            this.lock.lock();
            if (DiskRepository.this.lockFileChannel != null) {
                try {
                    this.fileLock = DiskRepository.this.lockFileChannel.lock(0L, 1L, false);
                }
                catch (Throwable t) {
                    this.lock.unlock();
                    I18n msg = DiskConnectorI18n.problemAcquiringFileLock;
                    throw new IllegalStateException(msg.text(new Object[]{DiskRepository.this.getSourceName()}), t);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void unlock() {
            try {
                if (this.fileLock != null) {
                    try {
                        this.fileLock.release();
                    }
                    catch (IOException ioe) {
                        LOGGER.warn((Throwable)ioe, DiskConnectorI18n.problemReleasingFileLock, new Object[]{DiskRepository.this.getSourceName()});
                    }
                }
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    class DiskBackedReadLock
    implements DiskLock {
        private final Lock lock;
        private FileLock fileLock = null;

        public DiskBackedReadLock(ReadWriteLock lock) {
            this.lock = lock.readLock();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void lock() {
            this.lock.lock();
            if (DiskRepository.this.lockFileChannel != null) {
                try {
                    DiskRepository diskRepository = DiskRepository.this;
                    synchronized (diskRepository) {
                        int count = DiskRepository.this.readLockCount.get();
                        assert (count >= 0);
                        if (count == 0) {
                            this.fileLock = DiskRepository.this.lockFileChannel.lock(0L, 1L, true);
                        }
                        DiskRepository.this.readLockCount.getAndIncrement();
                    }
                }
                catch (Throwable t) {
                    this.lock.unlock();
                    I18n msg = DiskConnectorI18n.problemAcquiringFileLock;
                    throw new IllegalStateException(msg.text(new Object[]{DiskRepository.this.getSourceName()}), t);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void unlock() {
            block10: {
                try {
                    if (this.fileLock == null) break block10;
                    DiskRepository diskRepository = DiskRepository.this;
                    synchronized (diskRepository) {
                        int count = DiskRepository.this.readLockCount.getAndDecrement();
                        assert (count >= 0);
                        if (DiskRepository.this.readLockCount.get() == 0) {
                            try {
                                this.fileLock.release();
                            }
                            catch (IOException ioe) {
                                LOGGER.warn((Throwable)ioe, DiskConnectorI18n.problemReleasingFileLock, new Object[]{DiskRepository.this.getSourceName()});
                            }
                        }
                    }
                }
                finally {
                    this.lock.unlock();
                }
            }
        }
    }

    static interface DiskLock {
        public void lock();

        public void unlock();
    }
}

