/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.connector.jcr;

import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.jcr.Binary;
import javax.jcr.Credentials;
import javax.jcr.ItemNotFoundException;
import javax.jcr.NoSuchWorkspaceException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.PropertyIterator;
import javax.jcr.PropertyType;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import net.jcip.annotations.NotThreadSafe;
import org.modeshape.connector.jcr.JcrConnectorI18n;
import org.modeshape.connector.jcr.JcrNamespaceRegistry;
import org.modeshape.graph.ExecutionContext;
import org.modeshape.graph.JcrLexicon;
import org.modeshape.graph.Location;
import org.modeshape.graph.ModeShapeIntLexicon;
import org.modeshape.graph.ModeShapeLexicon;
import org.modeshape.graph.cache.CachePolicy;
import org.modeshape.graph.observe.Observer;
import org.modeshape.graph.property.DateTime;
import org.modeshape.graph.property.Name;
import org.modeshape.graph.property.NameFactory;
import org.modeshape.graph.property.NamespaceRegistry;
import org.modeshape.graph.property.Path;
import org.modeshape.graph.property.Property;
import org.modeshape.graph.property.PropertyFactory;
import org.modeshape.graph.property.ValueFactories;
import org.modeshape.graph.property.ValueFactory;
import org.modeshape.graph.property.ValueFormatException;
import org.modeshape.graph.request.CacheableRequest;
import org.modeshape.graph.request.CloneBranchRequest;
import org.modeshape.graph.request.CloneWorkspaceRequest;
import org.modeshape.graph.request.CopyBranchRequest;
import org.modeshape.graph.request.CreateNodeRequest;
import org.modeshape.graph.request.CreateWorkspaceRequest;
import org.modeshape.graph.request.DeleteBranchRequest;
import org.modeshape.graph.request.DestroyWorkspaceRequest;
import org.modeshape.graph.request.GetWorkspacesRequest;
import org.modeshape.graph.request.InvalidRequestException;
import org.modeshape.graph.request.InvalidWorkspaceException;
import org.modeshape.graph.request.MoveBranchRequest;
import org.modeshape.graph.request.ReadAllChildrenRequest;
import org.modeshape.graph.request.ReadAllPropertiesRequest;
import org.modeshape.graph.request.ReadNodeRequest;
import org.modeshape.graph.request.UnsupportedRequestException;
import org.modeshape.graph.request.UpdatePropertiesRequest;
import org.modeshape.graph.request.VerifyWorkspaceRequest;
import org.modeshape.graph.request.processor.RequestProcessor;

@NotThreadSafe
public class JcrRequestProcessor
extends RequestProcessor {
    private final Map<String, Workspace> workspaces = new HashMap<String, Workspace>();
    private final Repository repository;
    private final Credentials credentials;

    public JcrRequestProcessor(String sourceName, ExecutionContext context, Repository repository, Observer observer, Credentials credentials, CachePolicy defaultCachePolicy) {
        super(sourceName, context, observer, null, defaultCachePolicy);
        this.repository = repository;
        this.credentials = credentials;
    }

    protected Workspace workspaceFor(String workspaceName) throws RepositoryException {
        Workspace workspace = this.workspaces.get(workspaceName);
        if (workspace == null) {
            Session session = null;
            try {
                session = this.credentials != null ? this.repository.login(this.credentials, workspaceName) : this.repository.login(workspaceName);
            }
            catch (NoSuchWorkspaceException e) {
                throw new InvalidWorkspaceException(e.getLocalizedMessage());
            }
            assert (session != null);
            workspace = new Workspace(session);
            this.workspaces.put(workspaceName, workspace);
            if (workspaceName == null) {
                this.workspaces.put(null, workspace);
            }
        }
        return workspace;
    }

    protected Workspace workspace() throws RepositoryException {
        if (this.workspaces.isEmpty()) {
            return this.workspaceFor(null);
        }
        return this.workspaces.values().iterator().next();
    }

    protected boolean workspaceExistsNamed(String workspaceName) throws RepositoryException {
        if (this.workspaces.containsKey(workspaceName)) {
            return true;
        }
        for (String actualName : this.workspace().session().getWorkspace().getAccessibleWorkspaceNames()) {
            if (actualName == null || !actualName.equals(workspaceName)) continue;
            return true;
        }
        return false;
    }

    public void commit() throws RepositoryException {
        for (Workspace workspace : this.workspaces.values()) {
            workspace.session().save();
        }
    }

    public void rollback() throws RepositoryException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        try {
            RuntimeException problem = null;
            for (Workspace workspace : this.workspaces.values()) {
                try {
                    workspace.session().logout();
                }
                catch (RuntimeException e) {
                    if (problem != null) continue;
                    problem = e;
                }
            }
            if (problem != null) {
                throw problem;
            }
        }
        finally {
            try {
                this.workspaces.clear();
            }
            finally {
                super.close();
            }
        }
    }

    public void process(VerifyWorkspaceRequest request) {
        if (request == null) {
            return;
        }
        try {
            Workspace workspace = this.workspaceFor(request.workspaceName());
            request.setActualWorkspaceName(workspace.name());
            request.setActualRootLocation(workspace.locationForRootNode());
        }
        catch (Throwable e) {
            request.setError(e);
        }
    }

    public void process(GetWorkspacesRequest request) {
        if (request == null) {
            return;
        }
        try {
            HashSet<String> workspaceNames = new HashSet<String>();
            for (String workspaceName : this.workspace().session().getWorkspace().getAccessibleWorkspaceNames()) {
                workspaceNames.add(workspaceName);
            }
            request.setAvailableWorkspaceNames(workspaceNames);
            this.setCacheableInfo((CacheableRequest)request);
        }
        catch (Throwable e) {
            request.setError(e);
        }
    }

    public void process(CreateWorkspaceRequest request) {
        if (request == null) {
            return;
        }
        try {
            String desiredName = request.desiredNameOfNewWorkspace();
            if (this.workspaceExistsNamed(desiredName)) {
                String msg = JcrConnectorI18n.workspaceAlreadyExistsInRepository.text(new Object[]{desiredName, this.getSourceName()});
                request.setError((Throwable)new InvalidWorkspaceException(msg));
            } else {
                String msg = JcrConnectorI18n.unableToCreateWorkspaceInRepository.text(new Object[]{desiredName, this.getSourceName()});
                request.setError((Throwable)new InvalidRequestException(msg));
            }
        }
        catch (Throwable e) {
            request.setError(e);
        }
        assert (request.hasError());
    }

    public void process(CloneWorkspaceRequest request) {
        if (request == null) {
            return;
        }
        try {
            String desiredName = request.desiredNameOfTargetWorkspace();
            if (this.workspaceExistsNamed(desiredName)) {
                switch (request.cloneConflictBehavior()) {
                    case DO_NOT_CLONE: {
                        String msg = JcrConnectorI18n.workspaceAlreadyExistsInRepository.text(new Object[]{desiredName, this.getSourceName()});
                        request.setError((Throwable)new InvalidWorkspaceException(msg));
                        break;
                    }
                    case SKIP_CLONE: {
                        Workspace workspace = this.workspaceFor(desiredName);
                        workspace.session().getWorkspace().clone(request.nameOfWorkspaceToBeCloned(), "/", "/", true);
                        Location actualLocation = workspace.locationForRootNode();
                        request.setActualWorkspaceName(workspace.name());
                        request.setActualRootLocation(actualLocation);
                    }
                }
                return;
            }
            String msg = JcrConnectorI18n.unableToCreateWorkspaceInRepository.text(new Object[]{desiredName, this.getSourceName()});
            request.setError((Throwable)new InvalidRequestException(msg));
        }
        catch (Throwable e) {
            request.setError(e);
        }
    }

    public void process(DestroyWorkspaceRequest request) {
        if (request == null) {
            return;
        }
        String msg = JcrConnectorI18n.unableToDestroyWorkspaceInRepository.text(new Object[]{request.workspaceName(), this.getSourceName()});
        request.setError((Throwable)new UnsupportedRequestException(msg));
    }

    public void process(ReadNodeRequest request) {
        if (request == null) {
            return;
        }
        try {
            Workspace workspace = this.workspaceFor(request.inWorkspace());
            Node node = workspace.node(request.at());
            Location actualLocation = workspace.locationFor(node);
            request.setActualLocationOfNode(actualLocation);
            NodeIterator iter = node.getNodes();
            while (iter.hasNext()) {
                request.addChild(workspace.locationFor(iter.nextNode()));
            }
            iter = node.getProperties();
            while (iter.hasNext()) {
                request.addProperty(workspace.propertyFor(iter.nextProperty()));
            }
            if (actualLocation.hasIdProperties()) {
                request.addProperty(workspace.propertyFor(ModeShapeLexicon.UUID, actualLocation.getUuid()));
            }
            this.setCacheableInfo((CacheableRequest)request);
        }
        catch (Throwable e) {
            request.setError(e);
        }
    }

    public void process(ReadAllChildrenRequest request) {
        if (request == null) {
            return;
        }
        try {
            Workspace workspace = this.workspaceFor(request.inWorkspace());
            Node parent = workspace.node(request.of());
            request.setActualLocationOfNode(workspace.locationFor(parent));
            NodeIterator iter = parent.getNodes();
            while (iter.hasNext()) {
                request.addChild(workspace.locationFor(iter.nextNode()));
            }
            this.setCacheableInfo((CacheableRequest)request);
        }
        catch (Throwable e) {
            request.setError(e);
        }
    }

    public void process(ReadAllPropertiesRequest request) {
        if (request == null) {
            return;
        }
        try {
            NodeIterator childIter;
            int numChildren;
            Workspace workspace = this.workspaceFor(request.inWorkspace());
            Node node = workspace.node(request.at());
            Location actualLocation = workspace.locationFor(node);
            request.setActualLocationOfNode(actualLocation);
            PropertyIterator iter = node.getProperties();
            while (iter.hasNext()) {
                request.addProperty(workspace.propertyFor(iter.nextProperty()));
            }
            if (actualLocation.hasIdProperties()) {
                request.addProperty(workspace.propertyFor(ModeShapeLexicon.UUID, actualLocation.getUuid()));
            }
            if ((numChildren = (int)(childIter = node.getNodes()).getSize()) == -1) {
                numChildren = 0;
                while (childIter.hasNext()) {
                    childIter.nextNode();
                    ++numChildren;
                }
            }
            request.setNumberOfChildren(numChildren);
            this.setCacheableInfo((CacheableRequest)request);
        }
        catch (Throwable e) {
            request.setError(e);
        }
    }

    public void process(CreateNodeRequest request) {
        if (request == null) {
            return;
        }
        try {
            Workspace workspace = this.workspaceFor(request.inWorkspace());
            Node parent = workspace.node(request.under());
            String childName = workspace.stringFor(request.named());
            String primaryTypeName = null;
            for (Property property : request.properties()) {
                if (!property.getName().equals(JcrLexicon.PRIMARY_TYPE)) continue;
                primaryTypeName = workspace.stringFor(property.getFirstValue());
                break;
            }
            Node child = null;
            child = primaryTypeName != null ? parent.addNode(childName, primaryTypeName) : parent.addNode(childName);
            assert (child != null);
            workspace.setProperties(child, (Iterable<Property>)request);
            request.setActualLocationOfNode(workspace.locationFor(child));
        }
        catch (Throwable e) {
            request.setError(e);
        }
    }

    public void process(CloneBranchRequest request) {
        if (request == null) {
            return;
        }
        try {
            String fromWorkspaceName = request.fromWorkspace();
            String intoWorkspaceName = request.intoWorkspace();
            boolean sameWorkspace = fromWorkspaceName.equals(intoWorkspaceName);
            Workspace fromWorkspace = this.workspaceFor(fromWorkspaceName);
            Workspace intoWorkspace = sameWorkspace ? fromWorkspace : this.workspaceFor(intoWorkspaceName);
            Node sourceNode = fromWorkspace.node(request.from());
            Node targetNode = fromWorkspace.node(request.into());
            Location fromLocation = fromWorkspace.locationFor(sourceNode);
            String srcAbsPath = sourceNode.getPath();
            String destAbsPath = targetNode.getPath();
            String copyName = request.desiredName() != null ? intoWorkspace.stringFor(request.desiredName()) : sourceNode.getName();
            destAbsPath = destAbsPath + '/' + copyName;
            javax.jcr.Workspace workspace = intoWorkspace.session().getWorkspace();
            workspace.clone(fromWorkspaceName, srcAbsPath, destAbsPath, request.removeExisting());
            Node last = null;
            NodeIterator iter = targetNode.getNodes(copyName);
            while (iter.hasNext()) {
                last = iter.nextNode();
            }
            Location intoLocation = intoWorkspace.locationFor(last);
            request.setActualLocations(fromLocation, intoLocation);
        }
        catch (Throwable e) {
            request.setError(e);
        }
    }

    public void process(CopyBranchRequest request) {
        if (request == null) {
            return;
        }
        try {
            String fromWorkspaceName = request.fromWorkspace();
            String intoWorkspaceName = request.intoWorkspace();
            boolean sameWorkspace = fromWorkspaceName.equals(intoWorkspaceName);
            Workspace fromWorkspace = this.workspaceFor(fromWorkspaceName);
            Workspace intoWorkspace = sameWorkspace ? fromWorkspace : this.workspaceFor(intoWorkspaceName);
            Node sourceNode = fromWorkspace.node(request.from());
            Node targetNode = fromWorkspace.node(request.into());
            Location fromLocation = fromWorkspace.locationFor(sourceNode);
            String srcAbsPath = sourceNode.getPath();
            String destAbsPath = targetNode.getPath();
            String copyName = request.desiredName() != null ? intoWorkspace.stringFor(request.desiredName()) : sourceNode.getName();
            destAbsPath = destAbsPath + '/' + copyName;
            javax.jcr.Workspace workspace = intoWorkspace.session().getWorkspace();
            if (sameWorkspace) {
                workspace.copy(srcAbsPath, destAbsPath);
            } else {
                workspace.copy(fromWorkspaceName, srcAbsPath, destAbsPath);
            }
            Node last = null;
            NodeIterator iter = targetNode.getNodes(copyName);
            while (iter.hasNext()) {
                last = iter.nextNode();
            }
            Location intoLocation = intoWorkspace.locationFor(last);
            request.setActualLocations(fromLocation, intoLocation);
        }
        catch (Throwable e) {
            request.setError(e);
        }
    }

    public void process(DeleteBranchRequest request) {
        if (request == null) {
            return;
        }
        try {
            Workspace workspace = this.workspaceFor(request.inWorkspace());
            Node node = workspace.node(request.at());
            Location actual = workspace.locationFor(node);
            node.remove();
            request.setActualLocationOfNode(actual);
        }
        catch (Throwable e) {
            request.setError(e);
        }
    }

    public void process(MoveBranchRequest request) {
        if (request == null) {
            return;
        }
        try {
            Workspace workspace = this.workspaceFor(request.inWorkspace());
            Node orig = workspace.node(request.from());
            Node into = request.into() != null ? workspace.node(request.into()) : null;
            Node before = request.before() != null ? workspace.node(request.before()) : null;
            Location originalLocation = workspace.locationFor(orig);
            Location newLocation = workspace.move(orig, into, request.desiredName(), before);
            request.setActualLocations(originalLocation, newLocation);
        }
        catch (Throwable e) {
            request.setError(e);
        }
    }

    public void process(UpdatePropertiesRequest request) {
        if (request == null) {
            return;
        }
        try {
            Workspace workspace = this.workspaceFor(request.inWorkspace());
            Node node = workspace.node(request.on());
            HashSet<Name> newProperties = new HashSet<Name>();
            for (Map.Entry entry : request.properties().entrySet()) {
                javax.jcr.Property existing;
                Name propertyName = (Name)entry.getKey();
                String name = workspace.stringFor(propertyName);
                Property property = (Property)entry.getValue();
                javax.jcr.Property property2 = existing = node.hasProperty(name) ? node.getProperty(name) : null;
                if (!(existing == null || property != null && existing.getDefinition().isMultiple() != property.isSingle() || existing.getDefinition().isProtected())) {
                    existing.remove();
                }
                if (property == null) continue;
                if (property.size() == 1) {
                    try {
                        workspace.setProperty(node, property, false);
                    }
                    catch (ValueFormatException e) {
                        workspace.setProperty(node, property, true);
                    }
                } else {
                    workspace.setProperty(node, property, true);
                }
                if (existing != null) continue;
                newProperties.add(propertyName);
            }
            if (request.removeOtherProperties()) {
                HashSet<String> stringNames = new HashSet<String>();
                for (Name name : request.properties().keySet()) {
                    stringNames.add(workspace.stringFor(name));
                }
                stringNames.add(workspace.stringFor(JcrLexicon.PRIMARY_TYPE));
                stringNames.add(workspace.stringFor(JcrLexicon.MIXIN_TYPES));
                PropertyIterator propertyIter = node.getProperties();
                while (propertyIter.hasNext()) {
                    javax.jcr.Property property = propertyIter.nextProperty();
                    if (stringNames.contains(property.getName()) || property.getDefinition().isProtected()) continue;
                    property.remove();
                }
            }
            request.setActualLocationOfNode(workspace.locationFor(node));
            request.setNewProperties(newProperties);
        }
        catch (Throwable e) {
            request.setError(e);
        }
    }

    protected class Workspace {
        private final Session session;
        private final ExecutionContext context;
        private final ValueFactories factories;
        private final PropertyFactory propertyFactory;
        private final NameFactory nameFactory;
        private final ValueFactory<String> stringFactory;
        private final String name;
        private final javax.jcr.ValueFactory jcrValueFactory;

        protected Workspace(Session jcrSession) throws RepositoryException {
            this.session = jcrSession;
            this.name = this.session.getWorkspace().getName();
            ExecutionContext connectorContext = JcrRequestProcessor.this.getExecutionContext();
            NamespaceRegistry connectorRegistry = connectorContext.getNamespaceRegistry();
            this.context = connectorContext.with((NamespaceRegistry)new JcrNamespaceRegistry(JcrRequestProcessor.this.getSourceName(), this.session, connectorRegistry));
            this.factories = this.context.getValueFactories();
            this.propertyFactory = this.context.getPropertyFactory();
            this.nameFactory = this.factories.getNameFactory();
            this.stringFactory = this.factories.getStringFactory();
            this.jcrValueFactory = this.session.getValueFactory();
        }

        public Location move(Node original, Node newParent, Name newName, Node beforeSibling) throws RepositoryException {
            if (newParent == null && beforeSibling != null) {
                newParent = beforeSibling.getParent();
            }
            if (newName != null || newParent != null && !original.getParent().equals(newParent)) {
                String destAbsPath;
                String string = destAbsPath = newParent != null ? newParent.getPath() : original.getParent().getPath();
                assert (!destAbsPath.endsWith("/"));
                String newNameStr = newName != null ? this.stringFor(newName) : original.getName();
                destAbsPath = destAbsPath + '/' + newNameStr;
                this.session.move(original.getPath(), destAbsPath);
            }
            if (beforeSibling != null) {
                String siblingName = this.nameFor(beforeSibling);
                String originalName = this.nameFor(original);
                original.getParent().orderBefore(originalName, siblingName);
            }
            return this.locationFor(original);
        }

        public String name() {
            return this.name;
        }

        public Session session() {
            return this.session;
        }

        protected String stringFor(Object value) {
            return (String)this.stringFactory.create(value);
        }

        protected String nameFor(Node node) throws RepositoryException {
            String name = node.getName();
            int snsIndex = node.getIndex();
            return snsIndex == 1 ? name : name + '[' + snsIndex + ']';
        }

        public Property propertyFor(Name name, Object ... values) {
            return this.propertyFactory.create(name, values);
        }

        public Property propertyFor(javax.jcr.Property jcrProperty) throws RepositoryException {
            Object[] values = null;
            if (jcrProperty.getDefinition().isMultiple()) {
                Value[] jcrValues = jcrProperty.getValues();
                values = new Object[jcrValues.length];
                for (int i = 0; i < jcrValues.length; ++i) {
                    values[i] = this.convert(jcrValues[i], jcrProperty);
                }
            } else {
                values = new Object[]{this.convert(jcrProperty.getValue(), jcrProperty)};
            }
            Name name = (Name)this.nameFactory.create(jcrProperty.getName());
            return this.propertyFactory.create(name, values);
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public Object convert(Value value, javax.jcr.Property jcrProperty) throws RepositoryException {
            if (value == null) {
                return null;
            }
            switch (value.getType()) {
                case 2: {
                    return this.factories.getBinaryFactory().create(value.getBinary().getStream(), 0L);
                }
                case 6: {
                    return this.factories.getBooleanFactory().create(value.getBoolean());
                }
                case 5: {
                    return this.factories.getDateFactory().create(value.getDate());
                }
                case 4: {
                    return this.factories.getDoubleFactory().create(value.getDouble());
                }
                case 3: {
                    return this.factories.getLongFactory().create(value.getLong());
                }
                case 7: {
                    return this.factories.getNameFactory().create(value.getString());
                }
                case 8: {
                    return this.factories.getPathFactory().create(value.getString());
                }
                case 9: {
                    return this.factories.getReferenceFactory().create(value.getString());
                }
                case 1: {
                    return this.factories.getStringFactory().create(value.getString());
                }
                case 0: {
                    ** GOTO lbl30
                }
                default: {
                    return null;
                }
            }
            {
                catch (ValueFormatException e) {
                    typeName = PropertyType.nameFromValue((int)value.getType());
                    throw new RepositoryException(JcrConnectorI18n.errorConvertingJcrValueOfType.text(new Object[]{value.getString(), typeName}));
                }
lbl30:
                // 1 sources

                try {
                    return this.factories.getNameFactory().create(value.getString());
                }
                catch (ValueFormatException e) {}
                {
                    try {
                        return this.factories.getPathFactory().create(value.getString());
                    }
                    catch (ValueFormatException e2) {
                        return this.factories.getStringFactory().create(value.getString());
                    }
                }
            }
        }

        public Location locationFor(Node node) throws RepositoryException {
            String pathStr = node.getPath();
            Path path = (Path)this.factories.getPathFactory().create(pathStr);
            String uuidStr = node.getIdentifier();
            if (uuidStr != null) {
                try {
                    UUID uuid = UUID.fromString(uuidStr);
                    return Location.create((Path)path, (UUID)uuid);
                }
                catch (IllegalArgumentException e) {
                    // empty catch block
                }
            }
            return Location.create((Path)path);
        }

        public Location locationForRootNode() throws RepositoryException {
            return this.locationFor(this.session.getRootNode());
        }

        public Node node(Location location) throws RepositoryException {
            Node root;
            block9: {
                root = this.session.getRootNode();
                UUID uuid = location.getUuid();
                if (uuid != null) {
                    try {
                        return this.session.getNodeByIdentifier(uuid.toString());
                    }
                    catch (ItemNotFoundException e) {
                        if (location.hasPath()) break block9;
                        String msg = JcrConnectorI18n.unableToFindNodeWithUuid.text(new Object[]{JcrRequestProcessor.this.getSourceName(), uuid});
                        throw new org.modeshape.graph.property.PathNotFoundException(location, this.factories.getPathFactory().createRootPath(), msg);
                    }
                }
            }
            if (location.hasPath()) {
                Path relativePath = location.getPath().relativeToRoot();
                ValueFactory stringFactory = this.factories.getStringFactory();
                String relativePathStr = (String)stringFactory.create(relativePath);
                try {
                    return root.getNode(relativePathStr);
                }
                catch (PathNotFoundException e) {
                    Node node = root;
                    for (Path.Segment segment : relativePath) {
                        try {
                            node = node.getNode((String)stringFactory.create(segment));
                        }
                        catch (PathNotFoundException e2) {
                            String pathStr = (String)stringFactory.create(location.getPath());
                            Path lowestPath = (Path)this.factories.getPathFactory().create(node.getPath());
                            throw new org.modeshape.graph.property.PathNotFoundException(location, lowestPath, JcrConnectorI18n.nodeDoesNotExist.text(new Object[]{JcrRequestProcessor.this.getSourceName(), this.session.getWorkspace().getName(), pathStr}));
                        }
                    }
                }
            }
            String msg = JcrConnectorI18n.unableToFindNodeWithoutPathOrUuid.text(new Object[]{JcrRequestProcessor.this.getSourceName(), location});
            throw new IllegalArgumentException(msg);
        }

        public void setProperties(Node node, Iterable<Property> properties) throws RepositoryException {
            Set<Object> multiValued = null;
            for (Property property : properties) {
                if (!property.getName().equals(ModeShapeIntLexicon.MULTI_VALUED_PROPERTIES)) continue;
                multiValued = this.getMultiValuedProperties(property);
                break;
            }
            if (multiValued == null) {
                multiValued = Collections.emptySet();
            }
            for (Property property : properties) {
                this.setProperty(node, property, multiValued.contains(property.getName()));
            }
        }

        protected Set<Name> getMultiValuedProperties(Property multiValuedProperty) {
            HashSet<Name> multiValued = new HashSet<Name>();
            for (Object value : multiValuedProperty) {
                Name multiValuedPropertyName = (Name)this.nameFactory.create(value);
                if (multiValuedPropertyName == null) continue;
                multiValued.add(multiValuedPropertyName);
            }
            return multiValued;
        }

        protected void setProperty(Node node, Property property, boolean isMultiValued) throws RepositoryException {
            Name name = property.getName();
            if (name.equals(JcrLexicon.PRIMARY_TYPE)) {
                return;
            }
            if (name.equals(ModeShapeIntLexicon.NODE_DEFINITON)) {
                return;
            }
            if (name.equals(ModeShapeIntLexicon.MULTI_VALUED_PROPERTIES)) {
                return;
            }
            if (name.equals(JcrLexicon.MIXIN_TYPES)) {
                for (Object mixinVvalue : property.getValuesAsArray()) {
                    String mixinTypeName = this.stringFor(mixinVvalue);
                    node.addMixin(mixinTypeName);
                }
                return;
            }
            String propertyName = this.stringFor(name);
            if (isMultiValued) {
                Value[] values = new Value[property.size()];
                int index = 0;
                org.modeshape.graph.property.PropertyType propertyType = null;
                for (Object value : property) {
                    if (value == null) continue;
                    if (propertyType == null) {
                        propertyType = org.modeshape.graph.property.PropertyType.discoverType(value);
                    }
                    values[index] = this.convertToJcrValue(propertyType, value);
                    ++index;
                }
                node.setProperty(propertyName, values);
            } else {
                Object firstValue = property.getFirstValue();
                org.modeshape.graph.property.PropertyType propertyType = org.modeshape.graph.property.PropertyType.discoverType((Object)firstValue);
                Value value = this.convertToJcrValue(propertyType, firstValue);
                node.setProperty(propertyName, value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Value convertToJcrValue(org.modeshape.graph.property.PropertyType graphType, Object graphValue) throws RepositoryException {
            if (graphValue == null) {
                return null;
            }
            switch (graphType) {
                case DECIMAL: 
                case NAME: 
                case PATH: 
                case REFERENCE: 
                case UUID: 
                case URI: 
                case STRING: 
                case OBJECT: {
                    String stringValue = (String)this.factories.getStringFactory().create(graphValue);
                    return this.jcrValueFactory.createValue(stringValue);
                }
                case BOOLEAN: {
                    Boolean booleanValue = (Boolean)this.factories.getBooleanFactory().create(graphValue);
                    return this.jcrValueFactory.createValue(booleanValue.booleanValue());
                }
                case DOUBLE: {
                    Double doubleValue = (Double)this.factories.getDoubleFactory().create(graphValue);
                    return this.jcrValueFactory.createValue(doubleValue.doubleValue());
                }
                case LONG: {
                    Long longValue = (Long)this.factories.getLongFactory().create(graphValue);
                    return this.jcrValueFactory.createValue(longValue.longValue());
                }
                case DATE: {
                    Calendar calValue = ((DateTime)this.factories.getDateFactory().create(graphValue)).toCalendar();
                    return this.jcrValueFactory.createValue(calValue);
                }
                case BINARY: {
                    org.modeshape.graph.property.Binary binary = (org.modeshape.graph.property.Binary)this.factories.getBinaryFactory().create(graphValue);
                    try {
                        binary.acquire();
                        Binary jcrBinary = this.jcrValueFactory.createBinary(binary.getStream());
                        Value value = this.jcrValueFactory.createValue(jcrBinary);
                        return value;
                    }
                    finally {
                        binary.release();
                    }
                }
            }
            assert (false);
            return null;
        }
    }
}

