/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.connector.meta.jdbc;

import java.sql.Connection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.infinispan.schematic.document.Document;
import org.modeshape.connector.meta.jdbc.AbstractMetadataRetriever;
import org.modeshape.connector.meta.jdbc.ForeignKeyMetadata;
import org.modeshape.connector.meta.jdbc.JdbcMetadataConnector;
import org.modeshape.connector.meta.jdbc.JdbcMetadataLexicon;
import org.modeshape.connector.meta.jdbc.TableRetriever;
import org.modeshape.jcr.JcrNtLexicon;
import org.modeshape.jcr.federation.spi.DocumentWriter;

public class ForeignKeyRetriever
extends AbstractMetadataRetriever {
    private static final Pattern FK_PATH_PATTERN = Pattern.compile("/([^/]+)/([^/]+)/([^/]+)/tables/([^/]+)/foreignKeys/([^/]+)");
    private static final String FK_PREFIX = "fk";
    private static final Pattern FK_ID_PATTERN = Pattern.compile("([^@]+)@([^@]+)@([^@]+)@([^@]+)@fk@([^@]+)");

    protected ForeignKeyRetriever(JdbcMetadataConnector connector) {
        super(connector);
    }

    @Override
    protected Document getDocumentById(String id, DocumentWriter writer, Connection connection) {
        String schemaId;
        String schema;
        String fkId = this.fkIdFrom(id);
        String tableId = this.tableIdFrom(id);
        String catalogId = this.catalogIdFrom(id);
        String catalog = catalogId;
        if (catalog.equalsIgnoreCase(this.connector.getDefaultCatalogName())) {
            catalog = null;
        }
        if ((schema = (schemaId = this.schemaIdFrom(id))).equalsIgnoreCase(this.connector.getDefaultSchemaName())) {
            schema = null;
        }
        writer.setPrimaryType(JcrNtLexicon.UNSTRUCTURED);
        writer.addMixinType(JdbcMetadataLexicon.FOREIGN_KEY);
        writer.setParent(TableRetriever.documentId("databaseRoot", catalogId, schemaId, tableId, true));
        List<ForeignKeyMetadata> foreignKeyMetadatas = this.connector.getMetadataCollector().getForeignKeys(connection, catalog, schema, tableId, fkId);
        if (!foreignKeyMetadatas.isEmpty()) {
            ForeignKeyMetadata metadata = foreignKeyMetadatas.get(0);
            writer.addProperty(JdbcMetadataLexicon.PRIMARY_KEY_CATALOG_NAME, (Object)metadata.getPrimaryKeyCatalogName());
            writer.addProperty(JdbcMetadataLexicon.PRIMARY_KEY_SCHEMA_NAME, (Object)metadata.getPrimaryKeySchemaName());
            writer.addProperty(JdbcMetadataLexicon.PRIMARY_KEY_TABLE_NAME, (Object)metadata.getPrimaryKeyTableName());
            writer.addProperty(JdbcMetadataLexicon.PRIMARY_KEY_COLUMN_NAME, (Object)metadata.getPrimaryKeyColumnName());
            writer.addProperty(JdbcMetadataLexicon.FOREIGN_KEY_CATALOG_NAME, (Object)metadata.getForeignKeyCatalogName());
            writer.addProperty(JdbcMetadataLexicon.FOREIGN_KEY_SCHEMA_NAME, (Object)metadata.getForeignKeySchemaName());
            writer.addProperty(JdbcMetadataLexicon.FOREIGN_KEY_TABLE_NAME, (Object)metadata.getForeignKeyTableName());
            writer.addProperty(JdbcMetadataLexicon.FOREIGN_KEY_COLUMN_NAME, (Object)metadata.getForeignKeyColumnName());
            writer.addProperty(JdbcMetadataLexicon.SEQUENCE_NR, (Object)metadata.getSequenceNr());
            writer.addProperty(JdbcMetadataLexicon.UPDATE_RULE, (Object)metadata.getUpdateRule());
            writer.addProperty(JdbcMetadataLexicon.DELETE_RULE, (Object)metadata.getDeleteRule());
            writer.addProperty(JdbcMetadataLexicon.FOREIGN_KEY_NAME, (Object)metadata.getForeignKeyName());
            writer.addProperty(JdbcMetadataLexicon.PRIMARY_KEY_NAME, (Object)metadata.getPrimaryKeyName());
            writer.addProperty(JdbcMetadataLexicon.DEFERRABILITY, (Object)metadata.getDeferrability());
        }
        return writer.document();
    }

    private String fkIdFrom(String id) {
        Matcher matcher = FK_ID_PATTERN.matcher(id);
        return matcher.matches() ? matcher.group(5) : null;
    }

    private String tableIdFrom(String id) {
        Matcher matcher = FK_ID_PATTERN.matcher(id);
        return matcher.matches() ? matcher.group(4) : null;
    }

    private String schemaIdFrom(String id) {
        Matcher matcher = FK_ID_PATTERN.matcher(id);
        return matcher.matches() ? matcher.group(3) : null;
    }

    private String catalogIdFrom(String id) {
        Matcher matcher = FK_ID_PATTERN.matcher(id);
        return matcher.matches() ? matcher.group(2) : null;
    }

    @Override
    protected String idFrom(String path) {
        Matcher fkMatcher = FK_PATH_PATTERN.matcher(path);
        if (fkMatcher.matches()) {
            return ForeignKeyRetriever.documentId(fkMatcher.group(1), fkMatcher.group(2), fkMatcher.group(3), fkMatcher.group(4), fkMatcher.group(5));
        }
        return null;
    }

    @Override
    protected boolean canHandle(String id) {
        return FK_ID_PATTERN.matcher(id).matches();
    }

    static String documentId(String databaseId, String catalogId, String schemaId, String tableId, String fkId) {
        return ForeignKeyRetriever.generateId(databaseId, catalogId, schemaId, tableId, FK_PREFIX, fkId);
    }
}

