/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.connector.svn;

import org.modeshape.connector.scm.ScmAction;
import org.modeshape.connector.scm.ScmActionExecutor;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.io.ISVNEditor;
import org.tmatesoft.svn.core.io.SVNRepository;

public class SvnActionExecutor
implements ScmActionExecutor {
    private final SVNRepository repository;

    public SvnActionExecutor(SVNRepository repository) {
        this.repository = repository;
    }

    public SVNRepository getRepository() {
        return this.repository;
    }

    public void execute(ScmAction action, String message) throws SVNException {
        ISVNEditor editor = this.repository.getCommitEditor(message, null);
        editor.openRoot(-1L);
        try {
            action.applyAction(editor);
        }
        catch (Exception e) {
            SVNErrorMessage err = SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.UNKNOWN, (String)"This error is appeared: '{0}'", (Object)e.getMessage());
            throw new SVNException(err, (Throwable)e);
        }
        editor.closeDir();
        editor.closeEdit();
    }
}

