/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.connector.svn;

import java.util.Map;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.modeshape.connector.svn.SvnRepositorySource;
import org.modeshape.graph.ExecutionContext;
import org.modeshape.graph.Graph;
import org.modeshape.graph.Location;
import org.modeshape.graph.Node;
import org.modeshape.graph.Subgraph;
import org.modeshape.graph.connector.RepositoryConnection;
import org.modeshape.graph.connector.RepositoryConnectionFactory;
import org.modeshape.graph.connector.RepositoryContext;
import org.modeshape.graph.connector.RepositorySource;
import org.modeshape.graph.connector.RepositorySourceException;
import org.modeshape.graph.observe.Observer;

public class SvnIntegrationTest {
    private ExecutionContext context;
    private SvnRepositorySource source;
    private String repositoryUrl;
    private String[] predefinedWorkspaceNames;

    @Before
    public void beforeEach() {
        this.repositoryUrl = "http://anonsvn.jboss.org/repos/modeshape/";
        this.predefinedWorkspaceNames = new String[]{"trunk", "tags", "branches"};
        this.context = new ExecutionContext();
        this.source = new SvnRepositorySource();
        this.source.setName("svn repository source");
        this.source.setRepositoryRootUrl(this.repositoryUrl);
        this.source.setUsername("anonymous");
        this.source.setPassword("");
        this.source.setCreatingWorkspacesAllowed(true);
        this.source.setPredefinedWorkspaceNames(this.predefinedWorkspaceNames);
        this.source.setDefaultWorkspaceName(this.predefinedWorkspaceNames[0]);
        this.source.setCreatingWorkspacesAllowed(false);
        this.source.initialize(new RepositoryContext(){

            public Subgraph getConfiguration(int depth) {
                return null;
            }

            public ExecutionContext getExecutionContext() {
                return SvnIntegrationTest.this.context;
            }

            public Observer getObserver() {
                return null;
            }

            public RepositoryConnectionFactory getRepositoryConnectionFactory() {
                return new RepositoryConnectionFactory(){

                    public RepositoryConnection createConnection(String sourceName) throws RepositorySourceException {
                        return null;
                    }
                };
            }
        });
    }

    @Test
    public void shouldConnectAndReadRootNode() {
        Graph graph = Graph.create((RepositorySource)this.source, (ExecutionContext)this.context);
        Map properties = (Map)graph.getPropertiesByName().on("/");
        Assert.assertThat((Object)properties, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Node root = graph.getNodeAt("/");
        Assert.assertThat((Object)root, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)root.getLocation(), (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)root.getChildren().isEmpty(), (Matcher)Is.is((Object)false));
        for (Location childLocation : root.getChildren()) {
            Assert.assertThat((Object)childLocation.getPath().getParent().isRoot(), (Matcher)Is.is((Object)true));
        }
    }
}

