/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.connector.svn;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.modeshape.connector.svn.SvnActionExecutor;
import org.modeshape.connector.svn.SvnRepositoryConnectorI18n;
import org.modeshape.connector.svn.SvnRepositorySource;
import org.modeshape.connector.svn.SvnRepositoryUtil;
import org.modeshape.connector.svn.mgnt.AddDirectory;
import org.modeshape.connector.svn.mgnt.AddFile;
import org.modeshape.connector.svn.mgnt.DeleteEntry;
import org.modeshape.connector.svn.mgnt.UpdateFile;
import org.modeshape.graph.ExecutionContext;
import org.modeshape.graph.JcrLexicon;
import org.modeshape.graph.JcrNtLexicon;
import org.modeshape.graph.ModeShapeIntLexicon;
import org.modeshape.graph.ModeShapeLexicon;
import org.modeshape.graph.NodeConflictBehavior;
import org.modeshape.graph.connector.RepositorySourceException;
import org.modeshape.graph.connector.path.AbstractWritablePathWorkspace;
import org.modeshape.graph.connector.path.DefaultPathNode;
import org.modeshape.graph.connector.path.PathNode;
import org.modeshape.graph.connector.path.PathRepositorySource;
import org.modeshape.graph.connector.path.WritablePathRepository;
import org.modeshape.graph.connector.path.WritablePathWorkspace;
import org.modeshape.graph.connector.path.cache.WorkspaceCache;
import org.modeshape.graph.property.Binary;
import org.modeshape.graph.property.BinaryFactory;
import org.modeshape.graph.property.DateTimeFactory;
import org.modeshape.graph.property.Name;
import org.modeshape.graph.property.NameFactory;
import org.modeshape.graph.property.NamespaceRegistry;
import org.modeshape.graph.property.Path;
import org.modeshape.graph.property.PathFactory;
import org.modeshape.graph.property.Property;
import org.modeshape.graph.property.PropertyFactory;
import org.modeshape.graph.request.InvalidRequestException;
import org.tmatesoft.svn.core.SVNDirEntry;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationManager;
import org.tmatesoft.svn.core.internal.io.dav.DAVRepositoryFactory;
import org.tmatesoft.svn.core.internal.io.fs.FSRepositoryFactory;
import org.tmatesoft.svn.core.internal.io.svn.SVNRepositoryFactoryImpl;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.core.wc.SVNWCUtil;

public class SvnRepository
extends WritablePathRepository {
    private static final String DEFAULT_MIME_TYPE = "application/octet-stream";
    protected static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    protected final SvnRepositorySource source;

    public SvnRepository(SvnRepositorySource source) {
        super((PathRepositorySource)source);
        this.source = source;
        this.initialize();
    }

    protected void initialize() {
        ExecutionContext context = this.source.getRepositoryContext().getExecutionContext();
        for (String workspaceName : this.source.getPredefinedWorkspaceNames()) {
            this.doCreateWorkspace(context, workspaceName);
        }
        String defaultWorkspaceName = this.source.getDefaultWorkspaceName();
        if (defaultWorkspaceName != null && !this.workspaces.containsKey(defaultWorkspaceName)) {
            this.doCreateWorkspace(context, defaultWorkspaceName);
        }
    }

    public WorkspaceCache getCache(String workspaceName) {
        return this.source.getPathRepositoryCache().getCache(workspaceName);
    }

    private WritablePathWorkspace doCreateWorkspace(ExecutionContext context, String name) {
        SvnWorkspace workspace = new SvnWorkspace(name, this.source.getRootNodeUuid());
        this.workspaces.putIfAbsent(name, workspace);
        return (WritablePathWorkspace)this.workspaces.get(name);
    }

    protected WritablePathWorkspace createWorkspace(ExecutionContext context, String name) {
        if (!this.source.isCreatingWorkspacesAllowed()) {
            String msg = SvnRepositoryConnectorI18n.unableToCreateWorkspaces.text(new Object[]{this.getSourceName(), name});
            throw new InvalidRequestException(msg);
        }
        return this.doCreateWorkspace(context, name);
    }

    static {
        DAVRepositoryFactory.setup();
        FSRepositoryFactory.setup();
        SVNRepositoryFactoryImpl.setup();
    }

    static class 1 {
        static final /* synthetic */ int[] $SwitchMap$org$modeshape$graph$NodeConflictBehavior;

        static {
            $SwitchMap$org$modeshape$graph$NodeConflictBehavior = new int[NodeConflictBehavior.values().length];
            try {
                1.$SwitchMap$org$modeshape$graph$NodeConflictBehavior[NodeConflictBehavior.APPEND.ordinal()] = 1;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$org$modeshape$graph$NodeConflictBehavior[NodeConflictBehavior.REPLACE.ordinal()] = 2;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$org$modeshape$graph$NodeConflictBehavior[NodeConflictBehavior.UPDATE.ordinal()] = 3;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$org$modeshape$graph$NodeConflictBehavior[NodeConflictBehavior.DO_NOT_REPLACE.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
        }
    }

    class SvnWorkspace
    extends AbstractWritablePathWorkspace {
        private final Set<Name> ALLOWABLE_PROPERTIES_FOR_CONTENT;
        private final Set<Name> ALLOWABLE_PROPERTIES_FOR_FILE_OR_FOLDER;
        private final SVNRepository workspaceRoot;

        public SvnWorkspace(String name, UUID rootNodeUuid) {
            super(name, rootNodeUuid);
            this.ALLOWABLE_PROPERTIES_FOR_CONTENT = Collections.unmodifiableSet(new HashSet<Name>(Arrays.asList(JcrLexicon.PRIMARY_TYPE, JcrLexicon.DATA, JcrLexicon.ENCODED, JcrLexicon.MIMETYPE, JcrLexicon.LAST_MODIFIED, JcrLexicon.UUID, ModeShapeIntLexicon.NODE_DEFINITON)));
            this.ALLOWABLE_PROPERTIES_FOR_FILE_OR_FOLDER = Collections.unmodifiableSet(new HashSet<Name>(Arrays.asList(JcrLexicon.PRIMARY_TYPE, JcrLexicon.CREATED, JcrLexicon.UUID, ModeShapeIntLexicon.NODE_DEFINITON)));
            this.workspaceRoot = this.getWorkspaceDirectory(name);
            ISVNAuthenticationManager authManager = SVNWCUtil.createDefaultAuthenticationManager((String)SvnRepository.this.source.getUsername(), (String)SvnRepository.this.source.getPassword());
            this.workspaceRoot.setAuthenticationManager(authManager);
        }

        public Path getLowestExistingPath(Path path) {
            do {
                if (this.getNode(path = path.getParent()) == null) continue;
                return path;
            } while (path != null);
            assert (false) : "workspace root path was not a valid path";
            return null;
        }

        public PathNode getNode(Path path) {
            WorkspaceCache cache = SvnRepository.this.getCache(this.getName());
            PathNode node = cache.get(path);
            if (node != null) {
                return node;
            }
            ExecutionContext context = SvnRepository.this.source.getRepositoryContext().getExecutionContext();
            LinkedList<Property> properties = new LinkedList<Property>();
            LinkedList<Path.Segment> children = new LinkedList<Path.Segment>();
            try {
                boolean result = this.readNode(context, this.getName(), path, properties, children);
                if (!result) {
                    return null;
                }
            }
            catch (SVNException ex) {
                return null;
            }
            UUID uuid = path.isRoot() ? SvnRepository.this.source.getRootNodeUuid() : null;
            node = new DefaultPathNode(path, uuid, properties, children);
            cache.set(node);
            return node;
        }

        /*
         * Unable to fully structure code
         */
        public PathNode createNode(ExecutionContext context, PathNode parentNode, Name name, Map<Name, Property> properties, NodeConflictBehavior conflictBehavior) {
            registry = context.getNamespaceRegistry();
            nameFactory = context.getValueFactories().getNameFactory();
            pathFactory = context.getValueFactories().getPathFactory();
            newName = name.getString(registry);
            primaryTypeProp = properties.get(JcrLexicon.PRIMARY_TYPE);
            primaryType = primaryTypeProp == null ? null : (Name)nameFactory.create(primaryTypeProp.getFirstValue());
            parentPath = parentNode.getPath();
            parentPathAsString = parentPath.getString(registry);
            newPath = pathFactory.create(parentPath, new Name[]{name});
            newChildPath = null;
            if (JcrNtLexicon.FILE.equals(primaryType)) {
                this.ensureValidProperties(context, properties.values(), this.ALLOWABLE_PROPERTIES_FOR_FILE_OR_FOLDER);
                skipWrite = false;
                if (parentPath.isRoot()) {
                    newChildPath = !SvnRepository.this.source.getRepositoryRootUrl().equals(this.getName()) ? newName : "/" + newName;
                } else {
                    newChildPath = newPath.getString(registry);
                    if (!SvnRepository.this.source.getRepositoryRootUrl().equals(this.getName())) {
                        newChildPath = newChildPath.substring(1);
                    }
                }
                try {
                    if (SvnRepositoryUtil.exists(this.workspaceRoot, newChildPath)) {
                        if (conflictBehavior.equals((Object)NodeConflictBehavior.APPEND)) {
                            throw new InvalidRequestException(SvnRepositoryConnectorI18n.sameNameSiblingsAreNotAllowed.text(new Object[0]));
                        }
                        if (conflictBehavior.equals((Object)NodeConflictBehavior.DO_NOT_REPLACE)) {
                            skipWrite = true;
                        }
                    }
                }
                catch (SVNException e1) {
                    throw new RepositorySourceException(SvnRepository.this.getSourceName(), e1.getMessage());
                }
                if (!skipWrite && newChildPath != null) {
                    try {
                        rootPath = null;
                        rootPath = parentPath.isRoot() != false ? "" : parentPathAsString;
                        this.newFile(rootPath, newName, SvnRepository.EMPTY_BYTE_ARRAY, null, this.getName(), this.workspaceRoot);
                    }
                    catch (SVNException e) {
                        msg = SvnRepositoryConnectorI18n.couldNotCreateFile;
                        throw new RepositorySourceException(SvnRepository.this.getSourceName(), msg.text(new Object[]{parentPathAsString, this.getName(), SvnRepository.this.getSourceName(), e.getMessage()}), (Throwable)e);
                    }
                }
            } else if (JcrNtLexicon.RESOURCE.equals(primaryType) || ModeShapeLexicon.RESOURCE.equals(primaryType)) {
                this.ensureValidProperties(context, properties.values(), this.ALLOWABLE_PROPERTIES_FOR_CONTENT);
                if (parentPath.isRoot()) {
                    newChildPath = parentPathAsString;
                    if (!SvnRepository.this.source.getRepositoryRootUrl().equals(this.getName())) {
                        newChildPath = parentPathAsString.substring(1);
                    }
                } else {
                    newChildPath = parentPathAsString;
                    if (!SvnRepository.this.source.getRepositoryRootUrl().equals(this.getName())) {
                        newChildPath = newChildPath.substring(1);
                    }
                }
                if (!JcrLexicon.CONTENT.equals(name)) {
                    msg = SvnRepositoryConnectorI18n.invalidNameForResource;
                    throw new RepositorySourceException(SvnRepository.this.getSourceName(), msg.text(new Object[]{parentPathAsString, this.getName(), SvnRepository.this.getSourceName(), newName}));
                }
                parentPrimaryType = parentNode.getProperty(JcrLexicon.PRIMARY_TYPE);
                v0 = parentPrimaryTypeName = parentPrimaryType == null ? null : (Name)nameFactory.create(parentPrimaryType.getFirstValue());
                if (!JcrNtLexicon.FILE.equals(parentPrimaryTypeName)) {
                    msg = SvnRepositoryConnectorI18n.invalidPathForResource;
                    throw new RepositorySourceException(SvnRepository.this.getSourceName(), msg.text(new Object[]{parentPathAsString, this.getName(), SvnRepository.this.getSourceName()}));
                }
                updateFileContent = true;
                switch (1.$SwitchMap$org$modeshape$graph$NodeConflictBehavior[conflictBehavior.ordinal()]) {
                    case 1: 
                    case 2: 
                    case 3: {
                        break;
                    }
                    case 4: {
                        updateFileContent = false;
                    }
                }
                dataProperty = properties.get(JcrLexicon.DATA);
                if (dataProperty == null) {
                    updateFileContent = false;
                }
                if (updateFileContent) {
                    binaryFactory = context.getValueFactories().getBinaryFactory();
                    binary = (Binary)binaryFactory.create(properties.get(JcrLexicon.DATA).getFirstValue());
                    contents = new ByteArrayOutputStream();
                    svnProperties = new SVNProperties();
                    try {
                        this.workspaceRoot.getFile(newChildPath, -1L, svnProperties, (OutputStream)contents);
                        oldData = contents.toByteArray();
                        if (oldData == null) ** GOTO lbl94
                        pathToFile = parentPath.isRoot() != false ? "" : parentPath.getParent().getString(registry);
                        fileName = parentPath.getLastSegment().getString(registry);
                        this.modifyFile(pathToFile, fileName, oldData, binary.getBytes(), null, this.getName(), this.workspaceRoot);
                    }
                    catch (SVNException e) {
                        msg = SvnRepositoryConnectorI18n.couldNotReadData;
                        throw new RepositorySourceException(SvnRepository.this.getSourceName(), msg.text(new Object[]{parentPathAsString, this.getName(), SvnRepository.this.getSourceName(), e.getMessage()}), (Throwable)e);
                    }
                }
            } else if (JcrNtLexicon.FOLDER.equals(primaryType) || primaryType == null) {
                this.ensureValidProperties(context, properties.values(), this.ALLOWABLE_PROPERTIES_FOR_FILE_OR_FOLDER);
                try {
                    this.mkdir(parentPathAsString, newName, null, this.getName(), this.workspaceRoot);
                }
                catch (SVNException e) {
                    msg = SvnRepositoryConnectorI18n.couldNotCreateFile;
                    throw new RepositorySourceException(SvnRepository.this.getSourceName(), msg.text(new Object[]{parentPathAsString, this.getName(), SvnRepository.this.getSourceName(), e.getMessage()}), (Throwable)e);
                }
            } else {
                msg = SvnRepositoryConnectorI18n.unsupportedPrimaryType;
                throw new RepositorySourceException(SvnRepository.this.getSourceName(), msg.text(new Object[]{primaryType.getString(registry), parentPathAsString, this.getName(), SvnRepository.this.getSourceName()}));
            }
lbl94:
            // 6 sources

            node = this.getNode(newPath);
            newChildren = new ArrayList<Path.Segment>(parentNode.getChildSegments().size() + 1);
            newChildren.addAll(parentNode.getChildSegments());
            newChildren.add(node.getPath().getLastSegment());
            cache = SvnRepository.this.getCache(this.getName());
            cache.set((PathNode)new DefaultPathNode(parentNode.getPath(), parentNode.getUuid(), parentNode.getProperties(), newChildren));
            cache.set(node);
            return node;
        }

        private void mkdir(String rootDirPath, String childDirPath, String comment, String inWorkspace, SVNRepository currentRepository) throws SVNException {
            String tempParentPath = rootDirPath;
            if (!SvnRepository.this.source.getRepositoryRootUrl().equals(inWorkspace)) {
                if (!tempParentPath.equals("/") && tempParentPath.startsWith("/")) {
                    tempParentPath = tempParentPath.substring(1);
                } else if (tempParentPath.equals("/")) {
                    tempParentPath = "";
                }
            }
            String checkPath = tempParentPath.length() == 0 ? childDirPath : tempParentPath + "/" + childDirPath;
            SVNNodeKind nodeKind = null;
            try {
                nodeKind = currentRepository.checkPath(checkPath, -1L);
            }
            catch (SVNException e) {
                SVNErrorMessage err = SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.UNKNOWN, (String)"May be a Connecting problem to the repository or a user's authentication failure: {0}", (Object)e.getMessage());
                throw new SVNException(err);
            }
            if (nodeKind == null || nodeKind != SVNNodeKind.NONE) {
                SVNErrorMessage err = SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.UNKNOWN, (String)"Node with name '{0}' can't be created", (Object)childDirPath);
                throw new SVNException(err);
            }
            AddDirectory addNodeAction = new AddDirectory(rootDirPath, childDirPath);
            SvnActionExecutor executor = new SvnActionExecutor(currentRepository);
            comment = comment == null ? "Create a new file " + childDirPath : comment;
            executor.execute(addNodeAction, comment);
        }

        private void newFile(String rootDirPath, String childFilePath, byte[] content, String comment, String inWorkspace, SVNRepository currentRepository) throws SVNException {
            String tempParentPath = rootDirPath;
            if (!SvnRepository.this.source.getRepositoryRootUrl().equals(inWorkspace) && !tempParentPath.equals("/") && tempParentPath.startsWith("/")) {
                tempParentPath = tempParentPath.substring(1);
            }
            String checkPath = tempParentPath + "/" + childFilePath;
            SVNNodeKind nodeKind = null;
            try {
                nodeKind = currentRepository.checkPath(checkPath, -1L);
            }
            catch (SVNException e) {
                SVNErrorMessage err = SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.UNKNOWN, (String)"May be a Connecting problem to the repository or a user's authentication failure: {0}", (Object)e.getMessage());
                throw new SVNException(err);
            }
            if (nodeKind == null || nodeKind != SVNNodeKind.NONE) {
                SVNErrorMessage err = SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.UNKNOWN, (String)"Item with name '{0}' can't be created (already exist)", (Object)childFilePath);
                throw new SVNException(err);
            }
            AddFile addFileNodeAction = new AddFile(rootDirPath, childFilePath, content);
            SvnActionExecutor executor = new SvnActionExecutor(currentRepository);
            comment = comment == null ? "Create a new file " + childFilePath : comment;
            executor.execute(addFileNodeAction, comment);
        }

        private void modifyFile(String rootPath, String fileName, byte[] oldData, byte[] newData, String comment, String inWorkspace, SVNRepository currentRepository) throws SVNException {
            assert (rootPath != null);
            assert (fileName != null);
            assert (oldData != null);
            assert (inWorkspace != null);
            assert (currentRepository != null);
            try {
                if (!SvnRepository.this.source.getRepositoryRootUrl().equals(inWorkspace)) {
                    rootPath = rootPath.equals("/") ? "" : rootPath.substring(1) + "/";
                } else if (!rootPath.equals("/")) {
                    rootPath = rootPath + "/";
                }
                String path = rootPath + fileName;
                SVNNodeKind nodeKind = currentRepository.checkPath(path, -1L);
                if (nodeKind == SVNNodeKind.NONE || nodeKind == SVNNodeKind.UNKNOWN) {
                    SVNErrorMessage err = SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.ENTRY_NOT_FOUND, (String)"Item with name '{0}' can't be found", (Object)path);
                    throw new SVNException(err);
                }
                UpdateFile modifyFileAction = new UpdateFile(rootPath, fileName, oldData, newData);
                SvnActionExecutor executor = new SvnActionExecutor(currentRepository);
                comment = comment == null ? "modify the " + fileName : comment;
                executor.execute(modifyFileAction, comment);
            }
            catch (SVNException e) {
                SVNErrorMessage err = SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.UNKNOWN, (String)("This error is appeared: " + e.getMessage()));
                throw new SVNException(err, (Throwable)e);
            }
        }

        private void eraseEntry(String path, String comment, String inWorkspace, SVNRepository currentRepository) throws SVNException {
            assert (path != null);
            assert (inWorkspace != null);
            if (path.equals("/") || path.equals("")) {
                SVNErrorMessage err = SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.BAD_URL, (String)"The root directory cannot be deleted");
                throw new SVNException(err);
            }
            try {
                DeleteEntry deleteEntryAction = new DeleteEntry(path);
                SvnActionExecutor executor = new SvnActionExecutor(currentRepository);
                comment = comment == null ? "Delete the " + path : comment;
                executor.execute(deleteEntryAction, comment);
            }
            catch (SVNException e) {
                SVNErrorMessage err = SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.UNKNOWN, (String)"unknow error during delete action: {0)", (Object)e.getMessage());
                throw new SVNException(err);
            }
        }

        public boolean removeNode(ExecutionContext context, Path nodePath) {
            NamespaceRegistry registry = context.getNamespaceRegistry();
            boolean isContentNode = !nodePath.isRoot() && JcrLexicon.CONTENT.equals(nodePath.getLastSegment().getName());
            Path actualPath = isContentNode ? nodePath.getParent() : nodePath;
            try {
                SVNNodeKind kind = this.getNodeKind(context, actualPath, SvnRepository.this.source.getRepositoryRootUrl());
                if (kind == SVNNodeKind.NONE) {
                    return false;
                }
                if (isContentNode) {
                    String rootPath = actualPath.getParent().getString(registry);
                    String fileName = actualPath.getLastSegment().getString(registry);
                    this.modifyFile(rootPath, fileName, EMPTY_BYTE_ARRAY, EMPTY_BYTE_ARRAY, null, this.getName(), this.workspaceRoot);
                } else {
                    this.eraseEntry(actualPath.getString(registry), null, this.getName(), this.workspaceRoot);
                }
            }
            catch (SVNException e) {
                throw new RepositorySourceException(SvnRepository.this.getSourceName(), SvnRepositoryConnectorI18n.deleteFailed.text(new Object[]{nodePath, SvnRepository.this.getSourceName()}));
            }
            SvnRepository.this.getCache(this.getName()).invalidate(nodePath);
            return true;
        }

        public PathNode setProperties(ExecutionContext context, Path nodePath, Map<Name, Property> properties) {
            Name primaryTypeName;
            PathNode targetNode = this.getNode(nodePath);
            if (targetNode == null) {
                return null;
            }
            NameFactory nameFactory = context.getValueFactories().getNameFactory();
            Property primaryTypeProperty = targetNode.getProperty(JcrLexicon.PRIMARY_TYPE);
            Name name = primaryTypeName = primaryTypeProperty == null ? null : (Name)nameFactory.create(primaryTypeProperty.getFirstValue());
            if (ModeShapeLexicon.RESOURCE.equals(primaryTypeName)) {
                for (Map.Entry<Name, Property> entry : properties.entrySet()) {
                    byte[] data;
                    if (!JcrLexicon.DATA.equals(entry.getKey())) continue;
                    NamespaceRegistry registry = context.getNamespaceRegistry();
                    if (entry.getValue() == null) {
                        data = EMPTY_BYTE_ARRAY;
                    } else {
                        BinaryFactory binaryFactory = context.getValueFactories().getBinaryFactory();
                        data = ((Binary)binaryFactory.create(entry.getValue().getFirstValue())).getBytes();
                    }
                    try {
                        Path actualPath = nodePath.getParent();
                        this.modifyFile(actualPath.getParent().getString(registry), actualPath.getLastSegment().getString(registry), EMPTY_BYTE_ARRAY, data, "", this.getName(), this.workspaceRoot);
                        PathNode node = this.getNode(nodePath);
                        SvnRepository.this.getCache(this.getName()).set(node);
                        return node;
                    }
                    catch (SVNException ex) {
                        throw new RepositorySourceException(SvnRepository.this.getSourceName(), SvnRepositoryConnectorI18n.deleteFailed.text(new Object[]{nodePath, SvnRepository.this.getSourceName()}), (Throwable)ex);
                    }
                }
            }
            return targetNode;
        }

        protected boolean readNode(ExecutionContext context, String workspaceName, Path requestedPath, List<Property> properties, List<Path.Segment> children) throws SVNException {
            PathFactory pathFactory = context.getValueFactories().getPathFactory();
            NamespaceRegistry registry = context.getNamespaceRegistry();
            if (requestedPath.isRoot()) {
                if (children != null) {
                    Collection<SVNDirEntry> entries = SvnRepositoryUtil.getDir(this.workspaceRoot, "");
                    for (SVNDirEntry entry : entries) {
                        children.add(pathFactory.createSegment(entry.getName()));
                    }
                }
            } else {
                PropertyFactory factory = context.getPropertyFactory();
                DateTimeFactory dateFactory = context.getValueFactories().getDateFactory();
                SVNNodeKind kind = this.getNodeKind(context, requestedPath, SvnRepository.this.source.getRepositoryRootUrl());
                if (kind == SVNNodeKind.NONE) {
                    return false;
                }
                if (kind == SVNNodeKind.DIR) {
                    String directoryPath = requestedPath.getString(registry);
                    if (!SvnRepository.this.source.getRepositoryRootUrl().equals(workspaceName)) {
                        directoryPath = directoryPath.substring(1);
                    }
                    if (children != null) {
                        Collection<SVNDirEntry> dirEntries = SvnRepositoryUtil.getDir(this.workspaceRoot, directoryPath);
                        for (SVNDirEntry entry : dirEntries) {
                            children.add(pathFactory.createSegment(entry.getName()));
                        }
                    }
                    if (properties != null) {
                        properties.add(factory.create(JcrLexicon.PRIMARY_TYPE, new Object[]{JcrNtLexicon.FOLDER}));
                        SVNDirEntry entry = this.getEntryInfo(this.workspaceRoot, directoryPath);
                        if (entry != null) {
                            properties.add(factory.create(JcrLexicon.CREATED, new Object[]{dateFactory.create(entry.getDate())}));
                        }
                    }
                } else if (requestedPath.endsWith(JcrLexicon.CONTENT)) {
                    if (properties != null) {
                        SVNDirEntry entry;
                        String contentPath = requestedPath.getParent().getString(registry);
                        if (!SvnRepository.this.source.getRepositoryRootUrl().equals(workspaceName)) {
                            contentPath = contentPath.substring(1);
                        }
                        if ((entry = this.getEntryInfo(this.workspaceRoot, contentPath)) != null) {
                            properties.add(factory.create(JcrLexicon.PRIMARY_TYPE, new Object[]{ModeShapeLexicon.RESOURCE}));
                            properties.add(factory.create(JcrLexicon.LAST_MODIFIED, new Object[]{dateFactory.create(entry.getDate())}));
                        }
                        ByteArrayOutputStream os = new ByteArrayOutputStream();
                        SVNProperties fileProperties = new SVNProperties();
                        this.getData(contentPath, fileProperties, os);
                        String mimeType = fileProperties.getStringValue("svn:mime-type");
                        if (mimeType == null) {
                            mimeType = SvnRepository.DEFAULT_MIME_TYPE;
                        }
                        properties.add(factory.create(JcrLexicon.MIMETYPE, new Object[]{mimeType}));
                        if (os.toByteArray().length > 0) {
                            BinaryFactory binaryFactory = context.getValueFactories().getBinaryFactory();
                            properties.add(factory.create(JcrLexicon.DATA, new Object[]{binaryFactory.create(os.toByteArray())}));
                        }
                    }
                } else {
                    String filePath = requestedPath.getString(registry);
                    if (!SvnRepository.this.source.getRepositoryRootUrl().equals(workspaceName)) {
                        filePath = filePath.substring(1);
                    }
                    if (children != null) {
                        children.add(pathFactory.createSegment(JcrLexicon.CONTENT));
                    }
                    if (properties != null) {
                        properties.add(factory.create(JcrLexicon.PRIMARY_TYPE, new Object[]{JcrNtLexicon.FILE}));
                        ByteArrayOutputStream os = new ByteArrayOutputStream();
                        SVNProperties fileProperties = new SVNProperties();
                        this.getData(filePath, fileProperties, os);
                        String created = fileProperties.getStringValue("svn:entry:committed-date");
                        properties.add(factory.create(JcrLexicon.CREATED, new Object[]{dateFactory.create(created)}));
                    }
                }
            }
            return true;
        }

        protected SVNDirEntry getEntryInfo(SVNRepository repos, String path) {
            assert (path != null);
            SVNDirEntry entry = null;
            try {
                entry = repos.info(path, -1L);
            }
            catch (SVNException e) {
                throw new RepositorySourceException(SvnRepository.this.getSourceName(), SvnRepositoryConnectorI18n.connectingFailureOrUserAuthenticationProblem.text(new Object[]{SvnRepository.this.getSourceName()}));
            }
            return entry;
        }

        protected void getData(String path, SVNProperties properties, OutputStream os) throws SVNException {
            this.workspaceRoot.getFile(path, -1L, properties, os);
        }

        protected SVNNodeKind getNodeKind(ExecutionContext context, Path path, String repositoryRootUrl) throws SVNException {
            String absolutePath;
            SVNNodeKind kind;
            assert (path != null);
            assert (repositoryRootUrl != null);
            if (path.endsWith(JcrLexicon.CONTENT)) {
                path = path.getParent();
            }
            String pathAsString = path.getString(context.getNamespaceRegistry());
            if (!repositoryRootUrl.equals(this.getName())) {
                pathAsString = pathAsString.substring(1);
            }
            if ((kind = this.workspaceRoot.checkPath(absolutePath = pathAsString, -1L)) == SVNNodeKind.UNKNOWN) {
                throw new RepositorySourceException(SvnRepository.this.getSourceName(), SvnRepositoryConnectorI18n.nodeIsActuallyUnknow.text(new Object[]{pathAsString}));
            }
            return kind;
        }

        protected SVNRepository getWorkspaceDirectory(String workspaceName) {
            if (workspaceName == null) {
                workspaceName = SvnRepository.this.source.getDefaultWorkspaceName();
            }
            workspaceName = SvnRepository.this.source.getRepositoryRootUrl() + workspaceName;
            SVNRepository repository = null;
            SVNRepository repos = SvnRepositoryUtil.createRepository(workspaceName, SvnRepository.this.source.getUsername(), SvnRepository.this.source.getPassword());
            if (!SvnRepositoryUtil.isDirectory(repos, "")) {
                return null;
            }
            repository = repos;
            return repository;
        }

        protected void ensureValidProperties(ExecutionContext context, Collection<Property> properties, Set<Name> validPropertyNames) {
            LinkedList<String> invalidNames = new LinkedList<String>();
            NamespaceRegistry registry = context.getNamespaceRegistry();
            for (Property property : properties) {
                if (validPropertyNames.contains(property.getName())) continue;
                invalidNames.add(property.getName().getString(registry));
            }
            if (!invalidNames.isEmpty()) {
                throw new RepositorySourceException(SvnRepository.this.getSourceName(), SvnRepositoryConnectorI18n.invalidPropertyNames.text(new Object[]{((Object)invalidNames).toString()}));
            }
        }
    }
}

