/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.util.jna;

import com.sun.jna.Memory;
import com.sun.jna.NativeLong;
import com.sun.jna.Pointer;
import com.sun.jna.WString;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.internal.util.SVNBase64;
import org.tmatesoft.svn.core.internal.util.jna.ISVNSecurityLibrary;
import org.tmatesoft.svn.core.internal.util.jna.JNALibraryLoader;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.util.SVNLogType;

public class SVNWinSecurity {
    public static boolean isNativeLibraryAvailable() {
        return JNALibraryLoader.getSecurityLibrary() != null;
    }

    public static SVNNTSecurityParameters getSecurityParams(String userName, String password, String ntDomain) {
        ISVNSecurityLibrary.SecHandle crdHandle = SVNWinSecurity.getCredentialsHandle(userName, password, ntDomain);
        if (crdHandle == null) {
            return null;
        }
        SVNNTSecurityParameters secParams = new SVNNTSecurityParameters();
        secParams.myUsername = userName;
        secParams.myPassword = password;
        secParams.myNTDomain = ntDomain;
        secParams.myState = 0;
        secParams.myCrdHandle = crdHandle;
        return secParams;
    }

    public static String getAuthHeader(String token, SVNNTSecurityParameters params) throws SVNException {
        byte[] nextTokenBytes;
        byte[] input = null;
        if (token != null) {
            StringBuffer tokenBuffer = new StringBuffer(token);
            byte[] tmp = new byte[tokenBuffer.length()];
            StringBuffer sb = SVNBase64.normalizeBase64(tokenBuffer);
            int resultLength = SVNBase64.base64ToByteArray(sb, tmp);
            input = new byte[resultLength];
            System.arraycopy(tmp, 0, input, 0, resultLength);
        }
        if ((nextTokenBytes = SVNWinSecurity.getNextToken(params, input)) == null) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "Internal authentication error");
            SVNErrorManager.error(err, SVNLogType.DEFAULT);
        }
        return SVNBase64.byteArrayToBase64(nextTokenBytes);
    }

    private static byte[] getNextToken(SVNNTSecurityParameters params, byte[] lastToken) {
        ISVNSecurityLibrary library = JNALibraryLoader.getSecurityLibrary();
        if (library == null) {
            return null;
        }
        ISVNSecurityLibrary.SecHandle newContext = null;
        ISVNSecurityLibrary.SecHandle pContext = params.myCtxHandle;
        if (pContext == null) {
            newContext = new ISVNSecurityLibrary.SecHandle();
            newContext.dwLower = new NativeLong(0L);
            newContext.dwUpper = new NativeLong(0L);
            newContext.write();
            params.myCtxHandle = newContext;
        } else {
            newContext = pContext;
        }
        ISVNSecurityLibrary.SecBuffer outSecBuffer = new ISVNSecurityLibrary.SecBuffer();
        outSecBuffer.cbBuffer = new NativeLong(512L);
        outSecBuffer.BufferType = new NativeLong(2L);
        outSecBuffer.pvBuffer = new Memory(512L);
        outSecBuffer.write();
        ISVNSecurityLibrary.SecBufferDesc outBufferDescription = new ISVNSecurityLibrary.SecBufferDesc();
        outBufferDescription.ulVersion = new NativeLong(0L);
        outBufferDescription.cBuffers = new NativeLong(1L);
        outBufferDescription.pBuffers = outSecBuffer.getPointer();
        outBufferDescription.write();
        ISVNSecurityLibrary.SecBufferDesc inBufferDescription = null;
        ISVNSecurityLibrary.SecBuffer inSecBuffer = null;
        if (lastToken != null) {
            inSecBuffer = new ISVNSecurityLibrary.SecBuffer();
            inSecBuffer.cbBuffer = new NativeLong((long)lastToken.length);
            inSecBuffer.BufferType = new NativeLong(2L);
            inSecBuffer.pvBuffer = new Memory(lastToken.length);
            inSecBuffer.pvBuffer.write(0L, lastToken, 0, lastToken.length);
            inSecBuffer.write();
            inBufferDescription = new ISVNSecurityLibrary.SecBufferDesc();
            inBufferDescription.ulVersion = new NativeLong(0L);
            inBufferDescription.cBuffers = new NativeLong(1L);
            inBufferDescription.pBuffers = inSecBuffer.getPointer();
            inBufferDescription.write();
        }
        Memory contextAttributes = new Memory(NativeLong.SIZE);
        ISVNSecurityLibrary.TimeStamp ltime = new ISVNSecurityLibrary.TimeStamp();
        ltime.HighPart = new NativeLong(0L);
        ltime.LowPart = new NativeLong(0L);
        ltime.write();
        int securityStatus = library.InitializeSecurityContextW(params.myCrdHandle.getPointer(), pContext != null ? pContext.getPointer() : Pointer.NULL, null, new NativeLong(0L), new NativeLong(0L), new NativeLong(16L), lastToken != null ? inBufferDescription.getPointer() : Pointer.NULL, new NativeLong(0L), newContext.getPointer(), outBufferDescription.getPointer(), contextAttributes, ltime.getPointer());
        if (securityStatus < 0) {
            SVNWinSecurity.endSequence(params);
            return null;
        }
        newContext.read();
        params.myCtxHandle.read();
        if (securityStatus == 590611 || securityStatus == 590612) {
            outBufferDescription.read();
            securityStatus = library.CompleteAuthToken(params.myCtxHandle.getPointer(), outBufferDescription.getPointer());
            if (securityStatus < 0) {
                SVNWinSecurity.endSequence(params);
                return null;
            }
        }
        byte[] result = null;
        outBufferDescription.read();
        outSecBuffer.read();
        boolean sequenceIsEnded = false;
        if (outSecBuffer.cbBuffer.intValue() > 0) {
            result = outSecBuffer.pvBuffer.getByteArray(0L, outSecBuffer.cbBuffer.intValue());
            if (lastToken != null) {
                SVNWinSecurity.endSequence(params);
                sequenceIsEnded = true;
            }
        }
        if (securityStatus != 590610 && securityStatus == 590612 && !sequenceIsEnded) {
            SVNWinSecurity.endSequence(params);
        }
        return result;
    }

    private static ISVNSecurityLibrary.SecHandle getCredentialsHandle(String user, String password, String domain) {
        ISVNSecurityLibrary library = JNALibraryLoader.getSecurityLibrary();
        if (library == null) {
            return null;
        }
        ISVNSecurityLibrary.SEC_WINNT_AUTH_IDENTITY authIdentity = null;
        if (user != null || password != null || domain != null) {
            authIdentity = new ISVNSecurityLibrary.SEC_WINNT_AUTH_IDENTITY();
            if (user != null) {
                authIdentity.User = new WString(user);
                authIdentity.UserLength = new NativeLong((long)user.length());
            }
            if (password != null) {
                authIdentity.Password = new WString(password);
                authIdentity.PasswordLength = new NativeLong((long)password.length());
            }
            if (domain != null) {
                authIdentity.Domain = new WString(domain);
                authIdentity.DomainLength = new NativeLong((long)domain.length());
            }
            authIdentity.Flags = new NativeLong(2L);
            authIdentity.write();
        }
        ISVNSecurityLibrary.SecHandle pCred = new ISVNSecurityLibrary.SecHandle();
        pCred.dwLower = new NativeLong(0L);
        pCred.dwUpper = new NativeLong(0L);
        pCred.write();
        ISVNSecurityLibrary.TimeStamp ltime = new ISVNSecurityLibrary.TimeStamp();
        ltime.HighPart = new NativeLong(0L);
        ltime.LowPart = new NativeLong(0L);
        ltime.write();
        int securityStatus = library.AcquireCredentialsHandleW(null, new WString("NTLM"), new NativeLong(2L), Pointer.NULL, authIdentity != null ? authIdentity.getPointer() : Pointer.NULL, Pointer.NULL, Pointer.NULL, pCred.getPointer(), ltime.getPointer());
        if (securityStatus == 0) {
            pCred.read();
            return pCred;
        }
        return null;
    }

    private static void endSequence(SVNNTSecurityParameters params) {
        ISVNSecurityLibrary library = JNALibraryLoader.getSecurityLibrary();
        if (library == null) {
            return;
        }
        if (params.myCrdHandle != null) {
            library.FreeCredentialsHandle(params.myCrdHandle.getPointer());
            params.myCrdHandle = null;
        }
        if (params.myCtxHandle != null) {
            library.DeleteSecurityContext(params.myCtxHandle.getPointer());
            params.myCtxHandle = null;
        }
    }

    public static class SVNNTSecurityParameters {
        public String myUsername;
        public String myPassword;
        public String myNTDomain;
        public int myState;
        public ISVNSecurityLibrary.SecHandle myCrdHandle;
        public ISVNSecurityLibrary.SecHandle myCtxHandle;
    }
}

