/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.connector.svn;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.modeshape.common.i18n.I18n;
import org.modeshape.connector.scm.ScmAction;
import org.modeshape.connector.svn.SvnRepository;
import org.modeshape.connector.svn.SvnRepositoryConnectorI18n;
import org.modeshape.connector.svn.SvnRepositorySource;
import org.modeshape.connector.svn.SvnRepositoryUtil;
import org.modeshape.connector.svn.mgnt.AddDirectory;
import org.modeshape.connector.svn.mgnt.AddFile;
import org.modeshape.connector.svn.mgnt.DeleteEntry;
import org.modeshape.connector.svn.mgnt.UpdateFile;
import org.modeshape.graph.ExecutionContext;
import org.modeshape.graph.JcrLexicon;
import org.modeshape.graph.JcrNtLexicon;
import org.modeshape.graph.ModeShapeIntLexicon;
import org.modeshape.graph.ModeShapeLexicon;
import org.modeshape.graph.connector.RepositorySourceException;
import org.modeshape.graph.connector.base.PathNode;
import org.modeshape.graph.connector.base.PathWorkspace;
import org.modeshape.graph.mimetype.MimeTypeDetector;
import org.modeshape.graph.property.Binary;
import org.modeshape.graph.property.BinaryFactory;
import org.modeshape.graph.property.DateTimeFactory;
import org.modeshape.graph.property.Name;
import org.modeshape.graph.property.NameFactory;
import org.modeshape.graph.property.NamespaceRegistry;
import org.modeshape.graph.property.Path;
import org.modeshape.graph.property.PathFactory;
import org.modeshape.graph.property.Property;
import org.modeshape.graph.property.PropertyFactory;
import org.tmatesoft.svn.core.SVNCommitInfo;
import org.tmatesoft.svn.core.SVNDirEntry;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationManager;
import org.tmatesoft.svn.core.io.ISVNEditor;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.core.wc.SVNWCUtil;

public class SvnWorkspace
extends PathWorkspace<PathNode> {
    private static final String DEFAULT_MIME_TYPE = "application/octet-stream";
    protected static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    private final Set<Name> ALLOWABLE_PRIMARY_TYPES = Collections.unmodifiableSet(new HashSet<Name>(Arrays.asList(JcrNtLexicon.FOLDER, JcrNtLexicon.FILE, JcrNtLexicon.RESOURCE, ModeShapeLexicon.RESOURCE, null)));
    private final Set<Name> ALLOWABLE_PROPERTIES_FOR_CONTENT = Collections.unmodifiableSet(new HashSet<Name>(Arrays.asList(JcrLexicon.PRIMARY_TYPE, JcrLexicon.DATA, JcrLexicon.ENCODING, JcrLexicon.MIMETYPE, JcrLexicon.LAST_MODIFIED, JcrLexicon.LAST_MODIFIED_BY, JcrLexicon.UUID, ModeShapeIntLexicon.NODE_DEFINITON)));
    private final Set<Name> ALLOWABLE_PROPERTIES_FOR_FILE_OR_FOLDER = Collections.unmodifiableSet(new HashSet<Name>(Arrays.asList(JcrLexicon.PRIMARY_TYPE, JcrLexicon.CREATED, JcrLexicon.CREATED_BY, JcrLexicon.UUID, ModeShapeIntLexicon.NODE_DEFINITON)));
    private final SvnRepository repository;
    private final SVNRepository workspaceRoot;

    public SvnWorkspace(SvnRepository repository, SVNRepository workspaceRoot, String name, UUID rootNodeUuid) {
        super(name, rootNodeUuid);
        this.repository = repository;
        this.workspaceRoot = workspaceRoot;
        ISVNAuthenticationManager authManager = SVNWCUtil.createDefaultAuthenticationManager(repository.source().getUsername(), repository.source().getPassword());
        workspaceRoot.setAuthenticationManager(authManager);
    }

    public SvnWorkspace(String name, SvnWorkspace originalToClone, SVNRepository workspaceRoot) {
        super(name, originalToClone.getRootNodeUuid());
        this.repository = originalToClone.repository;
        this.workspaceRoot = workspaceRoot;
        this.cloneWorkspace(originalToClone);
    }

    private void cloneWorkspace(SvnWorkspace original) {
        I18n msg = SvnRepositoryConnectorI18n.sourceDoesNotSupportCloningWorkspaces;
        throw new UnsupportedOperationException(msg.text(new Object[]{original.source().getName()}));
    }

    private final SvnRepositorySource source() {
        return this.repository.source();
    }

    private final String getSourceName() {
        return this.source().getName();
    }

    private final ExecutionContext context() {
        return this.source().getRepositoryContext().getExecutionContext();
    }

    private final NameFactory nameFactory() {
        return this.context().getValueFactories().getNameFactory();
    }

    private final PathFactory pathFactory() {
        return this.context().getValueFactories().getPathFactory();
    }

    private final Path pathTo(PathNode node) {
        if (node.getParent() == null) {
            return this.pathFactory().createRootPath();
        }
        return this.pathFactory().create(node.getParent(), new Path.Segment[]{node.getName()});
    }

    public PathNode getRootNode() {
        return this.getNode(this.context().getValueFactories().getPathFactory().createRootPath());
    }

    public PathNode getNode(Path path) {
        ExecutionContext context = this.source().getRepositoryContext().getExecutionContext();
        LinkedList<Property> properties = new LinkedList<Property>();
        LinkedList<Path.Segment> children = new LinkedList<Path.Segment>();
        try {
            boolean result = this.readNode(context, this.getName(), path, properties, children);
            if (!result) {
                return null;
            }
        }
        catch (SVNException ex) {
            return null;
        }
        UUID uuid = path.isRoot() ? this.source().getRootNodeUuidObject() : null;
        Path parent = path.isRoot() ? null : path.getParent();
        Path.Segment name = path.isRoot() ? null : path.getLastSegment();
        PathNode node = new PathNode(uuid, parent, name, properties, children);
        return node;
    }

    protected boolean readNode(ExecutionContext context, String workspaceName, Path requestedPath, List<Property> properties, List<Path.Segment> children) throws SVNException {
        PathFactory pathFactory = context.getValueFactories().getPathFactory();
        NamespaceRegistry registry = context.getNamespaceRegistry();
        if (requestedPath.isRoot()) {
            if (children != null) {
                Collection<SVNDirEntry> entries = SvnRepositoryUtil.getDir(this.workspaceRoot, "");
                for (SVNDirEntry entry : entries) {
                    children.add(pathFactory.createSegment(entry.getName()));
                }
            }
        } else {
            PropertyFactory factory = context.getPropertyFactory();
            DateTimeFactory dateFactory = context.getValueFactories().getDateFactory();
            SVNNodeKind kind = this.getNodeKind(context, requestedPath, this.source().getRepositoryRootUrl());
            if (kind == SVNNodeKind.NONE) {
                return false;
            }
            if (kind == SVNNodeKind.DIR) {
                String directoryPath = requestedPath.getString(registry);
                if (!this.source().getRepositoryRootUrl().equals(workspaceName)) {
                    directoryPath = directoryPath.substring(1);
                }
                if (children != null) {
                    Collection<SVNDirEntry> dirEntries = SvnRepositoryUtil.getDir(this.workspaceRoot, directoryPath);
                    for (SVNDirEntry entry : dirEntries) {
                        children.add(pathFactory.createSegment(entry.getName()));
                    }
                }
                if (properties != null) {
                    properties.add(factory.create(JcrLexicon.PRIMARY_TYPE, new Object[]{JcrNtLexicon.FOLDER}));
                    SVNDirEntry entry = this.workspaceRoot.info(directoryPath, -1L);
                    if (entry != null) {
                        properties.add(factory.create(JcrLexicon.CREATED, new Object[]{dateFactory.create(entry.getDate())}));
                    }
                }
            } else if (requestedPath.endsWith(JcrLexicon.CONTENT)) {
                if (properties != null) {
                    SVNDirEntry entry;
                    String contentPath = requestedPath.getParent().getString(registry);
                    if (!this.source().getRepositoryRootUrl().equals(workspaceName)) {
                        contentPath = contentPath.substring(1);
                    }
                    if ((entry = this.workspaceRoot.info(contentPath, -1L)) != null) {
                        properties.add(factory.create(JcrLexicon.PRIMARY_TYPE, new Object[]{JcrNtLexicon.RESOURCE}));
                        properties.add(factory.create(JcrLexicon.LAST_MODIFIED, new Object[]{dateFactory.create(entry.getDate())}));
                    }
                    ByteArrayOutputStream os = new ByteArrayOutputStream();
                    SVNProperties fileProperties = new SVNProperties();
                    this.workspaceRoot.getFile(contentPath, -1L, fileProperties, os);
                    String mimeType = fileProperties.getStringValue("svn:mime-type");
                    if (mimeType == null) {
                        String fileName = requestedPath.getParent().getLastSegment().getString(registry);
                        MimeTypeDetector mimeTypeDetector = context.getMimeTypeDetector();
                        try {
                            mimeType = mimeTypeDetector.mimeTypeOf(fileName, null);
                        }
                        catch (IOException e) {
                            // empty catch block
                        }
                    }
                    if (mimeType == null) {
                        mimeType = DEFAULT_MIME_TYPE;
                    }
                    properties.add(factory.create(JcrLexicon.MIMETYPE, new Object[]{mimeType}));
                    if (os.toByteArray().length > 0) {
                        BinaryFactory binaryFactory = context.getValueFactories().getBinaryFactory();
                        properties.add(factory.create(JcrLexicon.DATA, new Object[]{binaryFactory.create(os.toByteArray())}));
                    }
                }
            } else {
                String filePath = requestedPath.getString(registry);
                if (!this.source().getRepositoryRootUrl().equals(workspaceName)) {
                    filePath = filePath.substring(1);
                }
                if (children != null) {
                    children.add(pathFactory.createSegment(JcrLexicon.CONTENT));
                }
                if (properties != null) {
                    properties.add(factory.create(JcrLexicon.PRIMARY_TYPE, new Object[]{JcrNtLexicon.FILE}));
                    ByteArrayOutputStream os = new ByteArrayOutputStream();
                    SVNProperties fileProperties = new SVNProperties();
                    this.workspaceRoot.getFile(filePath, -1L, fileProperties, os);
                    String created = fileProperties.getStringValue("svn:entry:committed-date");
                    properties.add(factory.create(JcrLexicon.CREATED, new Object[]{dateFactory.create(created)}));
                }
            }
        }
        return true;
    }

    protected SVNNodeKind getNodeKind(ExecutionContext context, Path path, String repositoryRootUrl) throws SVNException {
        String absolutePath;
        SVNNodeKind kind;
        assert (path != null);
        assert (repositoryRootUrl != null);
        if (path.endsWith(JcrLexicon.CONTENT)) {
            path = path.getParent();
        }
        String pathAsString = path.getString(context.getNamespaceRegistry());
        if (!repositoryRootUrl.equals(this.getName())) {
            pathAsString = pathAsString.substring(1);
        }
        if ((kind = this.workspaceRoot.checkPath(absolutePath = pathAsString, -1L)) == SVNNodeKind.UNKNOWN) {
            throw new RepositorySourceException(this.getSourceName(), SvnRepositoryConnectorI18n.nodeIsActuallyUnknow.text(new Object[]{pathAsString}));
        }
        return kind;
    }

    private Name primaryTypeFor(PathNode node) {
        Property primaryTypeProp = node.getProperty(JcrLexicon.PRIMARY_TYPE);
        Name primaryType = primaryTypeProp == null ? null : (Name)this.nameFactory().create(primaryTypeProp.getFirstValue());
        return primaryType;
    }

    protected void validate(PathNode node) {
        Name primaryType = this.primaryTypeFor(node);
        if (!this.ALLOWABLE_PRIMARY_TYPES.contains(primaryType)) {
            I18n msg = SvnRepositoryConnectorI18n.unsupportedPrimaryType;
            NamespaceRegistry registry = this.context().getNamespaceRegistry();
            String path = this.pathTo(node).getString(registry);
            String primaryTypeName = primaryType.getString(registry);
            throw new RepositorySourceException(this.getSourceName(), msg.text(new Object[]{path, this.getName(), this.getSourceName(), primaryTypeName}));
        }
        HashSet invalidPropertyNames = new HashSet(node.getProperties().keySet());
        if (JcrNtLexicon.RESOURCE.equals(primaryType) || ModeShapeLexicon.RESOURCE.equals(primaryType)) {
            invalidPropertyNames.removeAll(this.ALLOWABLE_PROPERTIES_FOR_CONTENT);
        } else {
            invalidPropertyNames.removeAll(this.ALLOWABLE_PROPERTIES_FOR_FILE_OR_FOLDER);
        }
        if (!invalidPropertyNames.isEmpty()) {
            I18n msg = SvnRepositoryConnectorI18n.invalidPropertyNames;
            throw new RepositorySourceException(this.getSourceName(), msg.text(new Object[]{invalidPropertyNames}));
        }
    }

    public PathWorkspace.ChangeCommand<PathNode> createMoveCommand(PathNode source, PathNode target) {
        LinkedList<SvnCommand> commands = new LinkedList<SvnCommand>();
        LinkedList<Path> pathsToCopy = new LinkedList<Path>();
        Path sourceRoot = this.pathTo(source);
        Path targetRoot = this.pathTo(target);
        pathsToCopy.add(sourceRoot);
        while (!pathsToCopy.isEmpty()) {
            Path path = (Path)pathsToCopy.removeFirst();
            PathNode node = this.getNode(path);
            assert (node != null) : path;
            Path oldParent = node.getParent();
            Path newParent = oldParent.relativeTo(sourceRoot).resolveAgainst(targetRoot);
            PathNode newNode = node.clone().withParent(newParent);
            if (path.equals(sourceRoot)) {
                newNode = newNode.withName(target.getName());
            }
            commands.add(this.createPutCommand(null, newNode));
            for (Path.Segment child : node.getChildren()) {
                pathsToCopy.add(this.pathFactory().create(path, new Path.Segment[]{child}));
            }
        }
        commands.add(this.createRemoveCommand(this.pathTo(source)));
        return new SvnCompositeCommand(commands);
    }

    public SvnCommand createPutCommand(PathNode previousNode, PathNode node) {
        byte[] oldContent;
        Name primaryType = this.primaryTypeFor(node);
        if (node.getParent() == null) {
            return null;
        }
        NamespaceRegistry registry = this.context().getNamespaceRegistry();
        String parentPath = node.getParent().getString(registry);
        String name = node.getName().getString(registry);
        if (primaryType == null || JcrNtLexicon.FOLDER.equals(primaryType)) {
            if (previousNode != null) {
                return null;
            }
            return new SvnPutFolderCommand(parentPath, name);
        }
        if (JcrNtLexicon.FILE.equals(primaryType)) {
            if (previousNode != null) {
                return null;
            }
            return new SvnPutFileCommand(parentPath, name, EMPTY_BYTE_ARRAY);
        }
        if (previousNode != null) {
            Property oldContentProp = previousNode.getProperty(JcrLexicon.DATA);
            Binary oldContentBin = oldContentProp == null ? null : (Binary)this.context().getValueFactories().getBinaryFactory().create(oldContentProp.getFirstValue());
            oldContent = oldContentBin == null ? EMPTY_BYTE_ARRAY : oldContentBin.getBytes();
        } else {
            oldContent = EMPTY_BYTE_ARRAY;
        }
        Property contentProp = node.getProperty(JcrLexicon.DATA);
        Binary contentBin = contentProp == null ? null : (Binary)this.context().getValueFactories().getBinaryFactory().create(contentProp.getFirstValue());
        byte[] newContent = contentBin == null ? EMPTY_BYTE_ARRAY : contentBin.getBytes();
        Path filePath = node.getParent();
        String fileDir = filePath.isRoot() ? "/" : filePath.getParent().getString(registry);
        String fileName = filePath.getLastSegment().getString(registry);
        return new SvnPutContentCommand(fileDir, fileName, oldContent, newContent);
    }

    public SvnCommand createRemoveCommand(Path path) {
        String svnPath = path.getString(this.context().getNamespaceRegistry());
        return new SvnRemoveCommand(svnPath);
    }

    public void commit(List<PathWorkspace.ChangeCommand<PathNode>> commands) {
        ISVNEditor editor = null;
        boolean commit = true;
        try {
            editor = this.workspaceRoot.getCommitEditor("ModeShape commit", null);
            editor.openRoot(-1L);
            for (PathWorkspace.ChangeCommand<PathNode> command : commands) {
                if (command == null) continue;
                SvnCommand svnCommand = (SvnCommand)command;
                svnCommand.setEditor(editor);
                svnCommand.apply();
            }
        }
        catch (SVNException ex) {
            commit = false;
            throw new IllegalStateException(ex);
        }
        finally {
            if (editor != null) {
                try {
                    editor.closeDir();
                }
                catch (SVNException ignore) {}
            }
        }
        assert (editor != null);
        if (commit) {
            try {
                SVNCommitInfo info = editor.closeEdit();
                if (info.getErrorMessage() != null) {
                    throw new IllegalStateException(info.getErrorMessage().getFullMessage());
                }
            }
            catch (SVNException ex) {
                throw new IllegalStateException(ex);
            }
        }
    }

    protected class SvnCompositeCommand
    extends SvnCommand {
        List<SvnCommand> commands;

        protected SvnCompositeCommand(List<SvnCommand> commands) {
            super(null);
            this.commands = commands;
        }

        @Override
        public void apply() {
            for (SvnCommand command : this.commands) {
                command.setEditor(this.editor);
                command.apply();
            }
        }

        @Override
        public String toString() {
            return this.commands.toString();
        }
    }

    protected class SvnRemoveCommand
    extends SvnCommand {
        public SvnRemoveCommand(String path) {
            super(new DeleteEntry(path));
        }
    }

    protected class SvnPutFolderCommand
    extends SvnCommand {
        public SvnPutFolderCommand(String parentPath, String childPath) {
            super(new AddDirectory(parentPath, childPath));
        }
    }

    protected class SvnPutContentCommand
    extends SvnCommand {
        public SvnPutContentCommand(String parentPath, String fileName, byte[] oldcontent, byte[] content) {
            super(new UpdateFile(parentPath, fileName, oldcontent, content));
        }
    }

    protected class SvnPutFileCommand
    extends SvnCommand {
        public SvnPutFileCommand(String parentPath, String fileName, byte[] content) {
            super(new AddFile(parentPath, fileName, content));
        }
    }

    protected class SvnCommand
    implements PathWorkspace.ChangeCommand<PathNode> {
        protected ISVNEditor editor;
        private final ScmAction action;

        protected SvnCommand(ScmAction action) {
            this.action = action;
        }

        public void setEditor(ISVNEditor editor) {
            this.editor = editor;
        }

        public void apply() {
            assert (this.editor != null);
            try {
                this.action.applyAction(this.editor);
            }
            catch (Exception ex) {
                throw new IllegalStateException(ex);
            }
        }

        public String toString() {
            return this.getClass().getSimpleName() + " for " + this.action.toString();
        }
    }
}

