/*
 * Decompiled with CFR 0.152.
 */
package de.regnis.q.sequence.line;

import de.regnis.q.sequence.core.QSequenceAssert;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;

class QSequenceLineFileSystemCacheSegment {
    private final long segmentIndex;
    private final int maximumEntryCount;
    private long[] froms;
    private int[] lengths;
    private int[] hashes;

    public QSequenceLineFileSystemCacheSegment(long segmentIndex, int maximumEntryCount) {
        this.segmentIndex = segmentIndex;
        this.maximumEntryCount = maximumEntryCount;
        this.froms = new long[maximumEntryCount];
        this.lengths = new int[maximumEntryCount];
        this.hashes = new int[maximumEntryCount];
    }

    public boolean isLoaded() {
        return this.froms != null;
    }

    public long getFrom(int index) {
        return this.froms[index];
    }

    public int getLength(int index) {
        return this.lengths[index];
    }

    public int getHash(int index) {
        return this.hashes[index];
    }

    public void setFromLengthHash(int index, long from, int length, int hash) {
        this.froms[index] = from;
        this.lengths[index] = length;
        this.hashes[index] = hash;
    }

    public void load(RandomAccessFile file) throws IOException {
        this.froms = new long[this.maximumEntryCount];
        this.lengths = new int[this.maximumEntryCount];
        this.hashes = new int[this.maximumEntryCount];
        byte[] bytes = new byte[this.maximumEntryCount * 16];
        file.seek(this.segmentIndex * (long)this.maximumEntryCount * 16L);
        file.readFully(bytes);
        ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
        DataInputStream is = new DataInputStream(bis);
        for (int index = 0; index < this.maximumEntryCount; ++index) {
            this.froms[index] = is.readLong();
            this.lengths[index] = is.readInt();
            this.hashes[index] = is.readInt();
        }
    }

    public void unload(RandomAccessFile file) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream(this.maximumEntryCount * 16);
        DataOutputStream os = new DataOutputStream(bos);
        for (int index = 0; index < this.maximumEntryCount; ++index) {
            os.writeLong(this.froms[index]);
            os.writeInt(this.lengths[index]);
            os.writeInt(this.hashes[index]);
        }
        byte[] bytes = bos.toByteArray();
        QSequenceAssert.assertEquals(this.maximumEntryCount * 16, bytes.length);
        long offset = this.segmentIndex * (long)this.maximumEntryCount * 16L;
        file.seek(offset);
        file.write(bytes);
        this.froms = null;
        this.lengths = null;
        this.hashes = null;
    }
}

