/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.io.dav.http;

import java.io.File;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.internal.io.dav.http.HTTPConnection;
import org.tmatesoft.svn.core.internal.io.dav.http.IHTTPConnection;
import org.tmatesoft.svn.core.internal.io.dav.http.IHTTPConnectionFactory;
import org.tmatesoft.svn.core.io.SVNRepository;

public class DefaultHTTPConnectionFactory
implements IHTTPConnectionFactory {
    private File mySpoolDirectory;
    private String myHTTPCharset;
    private boolean myIsSpoolAll;
    private boolean myIsUseSendAll;

    public DefaultHTTPConnectionFactory(File spoolDirectory, boolean spoolAll, String httpCharset) {
        this(spoolDirectory, spoolAll, false, httpCharset);
    }

    public DefaultHTTPConnectionFactory(File spoolDirectory, boolean spoolAll, boolean useSendAllForDiff, String httpCharset) {
        this.mySpoolDirectory = spoolDirectory;
        this.myIsSpoolAll = spoolAll;
        this.myHTTPCharset = httpCharset;
        this.myIsUseSendAll = useSendAllForDiff;
    }

    public IHTTPConnection createHTTPConnection(SVNRepository repository) throws SVNException {
        String charset = this.myHTTPCharset != null ? this.myHTTPCharset : System.getProperty("svnkit.http.encoding", "US-ASCII");
        File spoolLocation = this.mySpoolDirectory;
        if (this.mySpoolDirectory != null && !this.mySpoolDirectory.isDirectory()) {
            spoolLocation = null;
        }
        return new HTTPConnection(repository, charset, spoolLocation, this.myIsSpoolAll);
    }

    public boolean useSendAllForDiff(SVNRepository repository) throws SVNException {
        return this.myIsUseSendAll;
    }
}

