/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc.admin;

import java.util.Collection;
import java.util.Iterator;
import java.util.TreeSet;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.SVNPropertyValue;

public abstract class SVNVersionedProperties {
    private SVNProperties myProperties;
    private boolean myIsModified;

    protected SVNVersionedProperties(SVNProperties props) {
        this.myProperties = props;
        this.myIsModified = false;
    }

    public abstract boolean containsProperty(String var1) throws SVNException;

    public abstract SVNPropertyValue getPropertyValue(String var1) throws SVNException;

    public String getStringPropertyValue(String name) throws SVNException {
        SVNPropertyValue value = this.getPropertyValue(name);
        return value == null ? null : value.getString();
    }

    public boolean isModified() {
        return this.myIsModified;
    }

    protected void setModified(boolean modified) {
        this.myIsModified = modified;
    }

    public boolean isEmpty() throws SVNException {
        SVNProperties props = this.loadProperties();
        return props == null || props.isEmpty();
    }

    public Collection getPropertyNames(Collection target) throws SVNException {
        SVNProperties props = this.loadProperties();
        Collection collection = target = target == null ? new TreeSet() : target;
        if (this.isEmpty()) {
            return target;
        }
        Iterator names = props.nameSet().iterator();
        while (names.hasNext()) {
            target.add(names.next());
        }
        return target;
    }

    public void setPropertyValue(String name, SVNPropertyValue value) throws SVNException {
        SVNProperties props = this.loadProperties();
        if (value != null) {
            props.put(name, value);
        } else {
            props.remove(name);
        }
        this.myIsModified = true;
    }

    public SVNVersionedProperties compareTo(SVNVersionedProperties properties) throws SVNException {
        SVNProperties theseProps = this.loadProperties();
        if (theseProps == null) {
            return this.wrap(new SVNProperties());
        }
        return this.wrap(theseProps.compareTo(properties.loadProperties()));
    }

    public void copyTo(SVNVersionedProperties destination) throws SVNException {
        SVNProperties props = this.loadProperties();
        if (this.isEmpty()) {
            destination.removeAll();
        } else {
            destination.put(props);
        }
    }

    public void removeAll() throws SVNException {
        SVNProperties props = this.loadProperties();
        if (!this.isEmpty()) {
            props.clear();
            this.myIsModified = true;
        }
    }

    public boolean equals(SVNVersionedProperties props) throws SVNException {
        return this.compareTo(props).isEmpty();
    }

    public SVNProperties asMap() throws SVNException {
        return this.loadProperties() != null ? new SVNProperties(this.loadProperties()) : new SVNProperties();
    }

    protected void put(SVNProperties props) throws SVNException {
        SVNProperties thisProps = this.loadProperties();
        thisProps.clear();
        thisProps.putAll(props);
        this.myIsModified = true;
    }

    protected SVNProperties getProperties() {
        return this.myProperties;
    }

    protected void setPropertiesMap(SVNProperties props) {
        this.myProperties = props;
    }

    protected abstract SVNVersionedProperties wrap(SVNProperties var1);

    protected abstract SVNProperties loadProperties() throws SVNException;
}

