/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.connector.svn;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Collection;
import org.modeshape.common.util.FileUtil;
import org.modeshape.common.util.Logger;
import org.tmatesoft.svn.core.SVNDirEntry;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationManager;
import org.tmatesoft.svn.core.internal.io.dav.DAVRepositoryFactory;
import org.tmatesoft.svn.core.internal.io.fs.FSRepositoryFactory;
import org.tmatesoft.svn.core.internal.io.svn.SVNRepositoryFactoryImpl;
import org.tmatesoft.svn.core.internal.wc.DefaultSVNOptions;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.core.io.SVNRepositoryFactory;
import org.tmatesoft.svn.core.wc.SVNWCUtil;

public class SvnConnectorTestUtil {
    private static final Logger LOGGER = Logger.getLogger(SvnConnectorTestUtil.class);

    public static void main(String[] args) throws Exception {
        try {
            System.out.println("My repos. ......");
            String svnUrl = SvnConnectorTestUtil.createTestRepoURL();
            String username = "sp";
            String password = "";
            System.out.println(svnUrl);
            SVNRepository trunkWorkspace = SvnConnectorTestUtil.createRepository(svnUrl + "/trunk", username, password);
            System.out.println("Repository location: " + trunkWorkspace.getLocation().toString());
            System.out.println("Repository Root: " + trunkWorkspace.getRepositoryRoot(true));
            System.out.println("Repository UUID: " + trunkWorkspace.getRepositoryUUID(true));
            System.out.println("location: " + trunkWorkspace.getLocation().getPath());
            System.out.println("decoded location: " + trunkWorkspace.getLocation().toDecodedString());
            System.out.println("last seg: " + SvnConnectorTestUtil.getRepositoryWorspaceName(trunkWorkspace));
            Collection dirEntries = trunkWorkspace.getDir("", -1L, null, (Collection)null);
            for (SVNDirEntry dirEntry : dirEntries) {
                System.out.println("name: " + dirEntry.getName());
            }
        }
        catch (SVNException e) {
            e.printStackTrace();
        }
    }

    public static SVNRepository createRepository(String url, String username, String password) throws SVNException {
        DAVRepositoryFactory.setup();
        FSRepositoryFactory.setup();
        SVNRepositoryFactoryImpl.setup();
        if (!url.endsWith("/")) {
            url = url + "/";
        }
        SVNRepository repository = SVNRepositoryFactory.create((SVNURL)SVNURL.parseURIDecoded((String)url));
        ISVNAuthenticationManager authManager = SVNWCUtil.createDefaultAuthenticationManager((String)username, (String)password);
        DefaultSVNOptions options = SVNWCUtil.createDefaultOptions((boolean)false);
        options.setPropertyValue("svn:eol-style", "native");
        repository.setAuthenticationManager(authManager);
        return repository;
    }

    public static String createTestRepoURL() throws IOException, SVNException, URISyntaxException {
        String dstRepoPath;
        String srcRepoPath = "dummy_svn_repos";
        File srcRepoRepo = new File(SvnConnectorTestUtil.class.getClassLoader().getResource(srcRepoPath).toURI());
        File srcRepoParentDir = new File(srcRepoRepo.getParent());
        File dstRepoDir = new File(srcRepoParentDir, dstRepoPath = "copyOf_" + srcRepoPath);
        if (dstRepoDir.exists() && !FileUtil.delete((File)dstRepoDir)) {
            LOGGER.debug("Cannot delete directory " + dstRepoDir, new Object[0]);
            dstRepoDir = new File(srcRepoParentDir, dstRepoPath + "_" + System.currentTimeMillis());
        }
        dstRepoDir.deleteOnExit();
        FileUtil.copy((File)srcRepoRepo, (File)dstRepoDir);
        String url = dstRepoDir.getCanonicalFile().toURI().toURL().toExternalForm();
        url = url.replaceFirst("file:/", "file://localhost/");
        SVNURL encodedUrl = SVNURL.parseURIEncoded((String)url);
        url = encodedUrl.toDecodedString();
        return url;
    }

    public static void listEntries(SVNRepository workspace, String path) throws SVNException {
        Collection entries = workspace.getDir(path, -1L, null, (Collection)null);
        for (SVNDirEntry entry : entries) {
            System.out.println("/" + (path.equals("") ? "" : path + "/") + entry.getName() + " ( author: '" + entry.getAuthor() + "'; revision: " + entry.getRevision() + "; date: " + entry.getDate() + ")");
            if (entry.getKind() != SVNNodeKind.DIR) continue;
            SvnConnectorTestUtil.listEntries(workspace, path.equals("") ? entry.getName() : path + "/" + entry.getName());
        }
    }

    public static String getRepositoryWorspaceName(SVNRepository repository) {
        String[] segments = repository.getLocation().getPath().split("/");
        return segments[segments.length - 1];
    }

    private SvnConnectorTestUtil() {
    }
}

