/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph;

import java.util.UUID;
import net.jcip.annotations.Immutable;
import org.modeshape.graph.Location;
import org.modeshape.graph.LocationWithPathAndProperty;
import org.modeshape.graph.ModeShapeLexicon;
import org.modeshape.graph.property.Path;
import org.modeshape.graph.property.Property;
import org.modeshape.graph.property.basic.BasicSingleValueProperty;

@Immutable
final class LocationWithPathAndUuid
extends LocationWithPathAndProperty {
    private static final long serialVersionUID = 1L;
    private final UUID uuid;

    LocationWithPathAndUuid(Path path, UUID uuid) {
        super(path, new BasicSingleValueProperty(ModeShapeLexicon.UUID, uuid));
        assert (uuid != null);
        this.uuid = uuid;
    }

    public final UUID getUuid() {
        return this.uuid;
    }

    public Location with(Property idProperty) {
        if (idProperty == null || idProperty.isEmpty()) {
            return this;
        }
        if (ModeShapeLexicon.UUID.equals(idProperty.getName())) {
            if (idProperty.isSingle() && this.uuid.equals(idProperty.getFirstValue())) {
                return this;
            }
            return Location.create(this.getPath(), idProperty);
        }
        return Location.create(this.getPath(), this.getIdProperties().get(0), idProperty);
    }

    public Location with(Path path) {
        if (path == null) {
            return Location.create(this.uuid);
        }
        if (this.getPath().equals(path)) {
            return this;
        }
        return Location.create(path, this.uuid);
    }

    public Location with(UUID uuid) {
        if (uuid == null) {
            return Location.create(this.getPath());
        }
        if (uuid.equals(this.uuid)) {
            return this;
        }
        return Location.create(this.getPath(), uuid);
    }
}

