/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.connector;

import java.security.AccessController;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import javax.transaction.xa.XAResource;
import net.jcip.annotations.GuardedBy;
import net.jcip.annotations.ThreadSafe;
import org.modeshape.common.util.CheckArg;
import org.modeshape.common.util.Logger;
import org.modeshape.graph.ExecutionContext;
import org.modeshape.graph.GraphI18n;
import org.modeshape.graph.cache.CachePolicy;
import org.modeshape.graph.connector.RepositoryConnection;
import org.modeshape.graph.connector.RepositorySource;
import org.modeshape.graph.connector.RepositorySourceException;
import org.modeshape.graph.request.Request;

@ThreadSafe
public class RepositoryConnectionPool {
    public static final int DEFAULT_CORE_POOL_SIZE = 1;
    public static final int DEFAULT_MAXIMUM_POOL_SIZE = 10;
    public static final long DEFAULT_KEEP_ALIVE_TIME_IN_SECONDS = 30L;
    private static final RuntimePermission shutdownPerm = new RuntimePermission("modifyThread");
    private final RepositorySource source;
    private final ReentrantLock mainLock = new ReentrantLock();
    private final Condition termination = this.mainLock.newCondition();
    @GuardedBy(value="mainLock")
    private final BlockingQueue<ConnectionWrapper> availableConnections = new LinkedBlockingQueue<ConnectionWrapper>();
    @GuardedBy(value="mainLock")
    private final Set<ConnectionWrapper> inUseConnections = new HashSet<ConnectionWrapper>();
    private volatile long keepAliveTime;
    @GuardedBy(value="mainLock")
    private volatile int corePoolSize;
    @GuardedBy(value="mainLock")
    private volatile int maximumPoolSize;
    @GuardedBy(value="mainLock")
    private volatile int poolSize;
    @GuardedBy(value="mainLock")
    private volatile int runState;
    static final int RUNNING = 0;
    static final int SHUTDOWN = 1;
    static final int STOP = 2;
    static final int TERMINATED = 3;
    private final AtomicBoolean validateConnectionBeforeUse = new AtomicBoolean(false);
    private final AtomicLong pingTimeout = new AtomicLong(0L);
    private final AtomicInteger maxFailedAttemptsBeforeError = new AtomicInteger(10);
    private final AtomicLong totalConnectionsCreated = new AtomicLong(0L);
    private final AtomicLong totalConnectionsUsed = new AtomicLong(0L);
    private final Logger logger = Logger.getLogger(this.getClass());

    public RepositoryConnectionPool(RepositorySource source) {
        this(source, 1, 10, 30L, TimeUnit.SECONDS);
    }

    public RepositoryConnectionPool(RepositorySource source, int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit) {
        CheckArg.isNonNegative((int)corePoolSize, (String)"corePoolSize");
        CheckArg.isPositive((int)maximumPoolSize, (String)"maximumPoolSize");
        CheckArg.isNonNegative((long)keepAliveTime, (String)"keepAliveTime");
        CheckArg.isNotNull((Object)source, (String)"source");
        if (maximumPoolSize < corePoolSize) {
            throw new IllegalArgumentException(GraphI18n.maximumPoolSizeMayNotBeSmallerThanCorePoolSize.text(new Object[0]));
        }
        this.source = source;
        this.corePoolSize = corePoolSize;
        this.maximumPoolSize = maximumPoolSize;
        this.keepAliveTime = unit.toNanos(keepAliveTime);
        this.setPingTimeout(100L, TimeUnit.MILLISECONDS);
    }

    public final RepositorySource getRepositorySource() {
        return this.source;
    }

    protected String getSourceName() {
        return this.source.getName();
    }

    public boolean getValidateConnectionBeforeUse() {
        return this.validateConnectionBeforeUse.get();
    }

    public void setValidateConnectionBeforeUse(boolean validateConnectionBeforeUse) {
        this.validateConnectionBeforeUse.set(validateConnectionBeforeUse);
    }

    public long getPingTimeoutInNanos() {
        return this.pingTimeout.get();
    }

    public void setPingTimeout(long pingTimeout, TimeUnit unit) {
        CheckArg.isNonNegative((long)pingTimeout, (String)"time");
        this.pingTimeout.set(unit.toNanos(pingTimeout));
    }

    public int getMaxFailedAttemptsBeforeError() {
        return this.maxFailedAttemptsBeforeError.get();
    }

    public void setMaxFailedAttemptsBeforeError(int maxFailedAttemptsBeforeError) {
        this.maxFailedAttemptsBeforeError.set(maxFailedAttemptsBeforeError);
    }

    public void setKeepAliveTime(long time, TimeUnit unit) {
        CheckArg.isNonNegative((long)time, (String)"time");
        this.keepAliveTime = unit.toNanos(time);
    }

    public long getKeepAliveTime(TimeUnit unit) {
        assert (unit != null);
        return unit.convert(this.keepAliveTime, TimeUnit.NANOSECONDS);
    }

    public int getMaximumPoolSize() {
        return this.maximumPoolSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMaximumPoolSize(int maximumPoolSize) {
        CheckArg.isPositive((int)maximumPoolSize, (String)"maximum pool size");
        if (maximumPoolSize < this.corePoolSize) {
            throw new IllegalArgumentException(GraphI18n.maximumPoolSizeMayNotBeSmallerThanCorePoolSize.text(new Object[0]));
        }
        ReentrantLock mainLock = this.mainLock;
        try {
            mainLock.lock();
            int extra = this.maximumPoolSize - maximumPoolSize;
            this.maximumPoolSize = maximumPoolSize;
            if (extra > 0 && this.poolSize > maximumPoolSize) {
                this.drainUnusedConnections(extra);
            }
        }
        finally {
            mainLock.unlock();
        }
    }

    public int getCorePoolSize() {
        return this.corePoolSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCorePoolSize(int corePoolSize) throws RepositorySourceException, InterruptedException {
        CheckArg.isNonNegative((int)corePoolSize, (String)"core pool size");
        if (this.maximumPoolSize < corePoolSize) {
            throw new IllegalArgumentException(GraphI18n.maximumPoolSizeMayNotBeSmallerThanCorePoolSize.text(new Object[0]));
        }
        ReentrantLock mainLock = this.mainLock;
        try {
            mainLock.lock();
            int extra = this.corePoolSize - corePoolSize;
            this.corePoolSize = corePoolSize;
            if (extra < 0) {
                this.addConnectionsIfUnderCorePoolSize();
            } else if (extra > 0 && this.poolSize > corePoolSize) {
                this.drainUnusedConnections(extra);
            }
        }
        finally {
            mainLock.unlock();
        }
    }

    public int getPoolSize() {
        return this.poolSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getInUseCount() {
        ReentrantLock mainLock = this.mainLock;
        try {
            mainLock.lock();
            int n = this.inUseConnections.size();
            return n;
        }
        finally {
            mainLock.unlock();
        }
    }

    public long getTotalConnectionsCreated() {
        return this.totalConnectionsCreated.get();
    }

    public long getTotalConnectionsUsed() {
        return this.totalConnectionsUsed.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean prestartCoreConnection() throws RepositorySourceException, InterruptedException {
        ReentrantLock mainLock = this.mainLock;
        try {
            mainLock.lock();
            boolean bl = this.addConnectionIfUnderCorePoolSize();
            return bl;
        }
        finally {
            mainLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int prestartAllCoreConnections() throws RepositorySourceException, InterruptedException {
        ReentrantLock mainLock = this.mainLock;
        try {
            mainLock.lock();
            int n = this.addConnectionsIfUnderCorePoolSize();
            return n;
        }
        finally {
            mainLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            AccessController.checkPermission(shutdownPerm);
        }
        this.logger.debug("Shutting down repository connection pool for {0}", new Object[]{this.getSourceName()});
        boolean fullyTerminated = false;
        ReentrantLock mainLock = this.mainLock;
        try {
            mainLock.lock();
            int state = this.runState;
            if (state == 0) {
                this.runState = 1;
            }
            if (!this.availableConnections.isEmpty()) {
                this.drainUnusedConnections(this.availableConnections.size());
            }
            if (this.inUseConnections.isEmpty()) {
                fullyTerminated = true;
                this.logger.trace("Signalling termination of repository connection pool for {0}", new Object[]{this.getSourceName()});
                this.runState = 3;
                this.termination.signalAll();
                this.logger.debug("Terminated repository connection pool for {0}", new Object[]{this.getSourceName()});
            }
        }
        finally {
            mainLock.unlock();
        }
        if (fullyTerminated) {
            this.terminated();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdownNow() {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            AccessController.checkPermission(shutdownPerm);
        }
        this.logger.debug("Shutting down (immediately) repository connection pool for {0}", new Object[]{this.getSourceName()});
        boolean fullyTerminated = false;
        ReentrantLock mainLock = this.mainLock;
        try {
            mainLock.lock();
            int state = this.runState;
            if (state != 3) {
                this.runState = 2;
            }
            if (!this.availableConnections.isEmpty()) {
                this.drainUnusedConnections(this.availableConnections.size());
            }
            if (!this.inUseConnections.isEmpty()) {
                for (ConnectionWrapper connectionInUse : this.inUseConnections) {
                    this.logger.trace("Closing repository connection to {0}", new Object[]{this.getSourceName()});
                    connectionInUse.getOriginal().close();
                }
                this.poolSize -= this.inUseConnections.size();
            } else {
                fullyTerminated = true;
                this.logger.trace("Signalling termination of repository connection pool for {0}", new Object[]{this.getSourceName()});
                this.runState = 3;
                this.termination.signalAll();
                this.logger.debug("Terminated repository connection pool for {0}", new Object[]{this.getSourceName()});
            }
        }
        finally {
            mainLock.unlock();
        }
        if (fullyTerminated) {
            this.terminated();
        }
    }

    public boolean isRunning() {
        return this.runState == 0;
    }

    public boolean isShutdown() {
        return this.runState != 0;
    }

    public boolean isTerminating() {
        return this.runState == 2;
    }

    public boolean isTerminated() {
        return this.runState == 3;
    }

    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        this.logger.trace("Awaiting termination", new Object[0]);
        long nanos = unit.toNanos(timeout);
        ReentrantLock mainLock = this.mainLock;
        try {
            mainLock.lock();
            while (true) {
                if (this.runState == 3) {
                    boolean bl = true;
                    return bl;
                }
                if (nanos <= 0L) {
                    boolean bl = false;
                    return bl;
                }
                nanos = this.termination.awaitNanos(nanos);
            }
        }
        finally {
            mainLock.unlock();
            this.logger.trace("Finished awaiting termination", new Object[0]);
        }
    }

    protected void terminated() {
    }

    protected void finalize() {
        this.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RepositoryConnection getConnection() throws RepositorySourceException {
        int attemptsAllowed = this.maxFailedAttemptsBeforeError.get();
        ConnectionWrapper connection = null;
        int attemptsRemaining = attemptsAllowed;
        while (connection == null && attemptsRemaining > 0) {
            --attemptsRemaining;
            ReentrantLock mainLock = this.mainLock;
            try {
                mainLock.lock();
                if (this.runState != 0) {
                    throw new IllegalStateException(GraphI18n.repositoryConnectionPoolIsNotRunning.text(new Object[0]));
                }
                if (this.poolSize < this.corePoolSize) {
                    connection = this.newWrappedConnection();
                } else if (this.availableConnections.peek() != null) {
                    try {
                        connection = this.availableConnections.take();
                    }
                    catch (InterruptedException e) {
                        this.logger.trace("Cancelled obtaining a repository connection from pool {0}", new Object[]{this.getSourceName()});
                        Thread.interrupted();
                        throw new RepositorySourceException(this.getSourceName(), e);
                    }
                } else if (this.poolSize < this.maximumPoolSize) {
                    connection = this.newWrappedConnection();
                }
                if (connection != null) {
                    this.inUseConnections.add(connection);
                }
            }
            finally {
                mainLock.unlock();
            }
            if (connection == null) {
                this.logger.trace("Waiting for a repository connection from pool {0}", new Object[]{this.getSourceName()});
                try {
                    connection = this.availableConnections.take();
                }
                catch (InterruptedException e) {
                    this.logger.trace("Cancelled obtaining a repository connection from pool {0}", new Object[]{this.getSourceName()});
                    Thread.interrupted();
                    throw new RepositorySourceException(this.getSourceName(), e);
                }
                mainLock = this.mainLock;
                mainLock.lock();
                try {
                    if (connection != null) {
                        this.inUseConnections.add(connection);
                    }
                }
                finally {
                    mainLock.unlock();
                }
                this.logger.trace("Recieved a repository connection from pool {0}", new Object[]{this.getSourceName()});
            }
            if (connection == null || !this.validateConnectionBeforeUse.get()) continue;
            try {
                connection = this.validateConnection(connection);
            }
            catch (InterruptedException e) {
                this.logger.trace("Cancelled validating a repository connection obtained from pool {0}", new Object[]{this.getSourceName()});
                this.returnConnection(connection);
                Thread.interrupted();
                throw new RepositorySourceException(this.getSourceName(), e);
            }
        }
        if (connection == null) {
            throw new RepositorySourceException(GraphI18n.unableToObtainValidRepositoryAfterAttempts.text(new Object[]{attemptsAllowed}));
        }
        this.totalConnectionsUsed.incrementAndGet();
        return connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void returnConnection(ConnectionWrapper wrapper) {
        assert (wrapper != null);
        ConnectionWrapper wrapperToClose = null;
        ReentrantLock mainLock = this.mainLock;
        try {
            mainLock.lock();
            boolean removed = this.inUseConnections.remove(wrapper);
            assert (removed);
            if (this.runState != 0) {
                wrapperToClose = wrapper;
            } else if (this.poolSize > this.maximumPoolSize) {
                wrapperToClose = wrapper;
            } else if (!this.availableConnections.offer(new ConnectionWrapper(wrapper.getOriginal()))) {
                wrapperToClose = wrapper;
            }
        }
        finally {
            mainLock.unlock();
        }
        if (wrapperToClose != null) {
            this.closeConnection(wrapperToClose);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ConnectionWrapper validateConnection(ConnectionWrapper connection) throws InterruptedException {
        assert (connection != null);
        ConnectionWrapper invalidConnection = null;
        try {
            if (!connection.ping(this.pingTimeout.get(), TimeUnit.NANOSECONDS)) {
                invalidConnection = connection;
            }
        }
        finally {
            if (invalidConnection != null) {
                try {
                    this.mainLock.lock();
                    connection = null;
                    --this.poolSize;
                    this.inUseConnections.remove(connection);
                }
                finally {
                    this.mainLock.unlock();
                }
            }
        }
        return connection;
    }

    @GuardedBy(value="mainLock")
    protected ConnectionWrapper newWrappedConnection() throws RepositorySourceException {
        RepositoryConnection connection = this.source.getConnection();
        ++this.poolSize;
        this.totalConnectionsCreated.incrementAndGet();
        return new ConnectionWrapper(connection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeConnection(ConnectionWrapper wrapper) {
        Object v1;
        ReentrantLock mainLock2;
        block9: {
            assert (wrapper != null);
            RepositoryConnection original = wrapper.getOriginal();
            assert (original != null);
            try {
                this.logger.debug("Closing repository connection to {0} ({1} open connections remain)", new Object[]{this.getSourceName(), this.poolSize});
                original.close();
                Object var4_3 = null;
                mainLock2 = this.mainLock;
            }
            catch (Throwable throwable) {
                Object v0;
                Object var4_4 = null;
                ReentrantLock mainLock2 = this.mainLock;
                try {
                    mainLock2.lock();
                    --this.poolSize;
                    if ((this.runState == 1 || this.runState == 2) && this.poolSize <= 0) {
                        this.logger.trace("Signalling termination of repository connection pool for {0}", new Object[]{this.getSourceName()});
                        this.runState = 3;
                        this.termination.signalAll();
                        this.logger.trace("Terminated repository connection pool for {0}", new Object[]{this.getSourceName()});
                    }
                    v0 = null;
                }
                catch (Throwable throwable2) {
                    v0 = null;
                }
                Object var7_10 = v0;
                mainLock2.unlock();
                throw throwable;
            }
            try {
                mainLock2.lock();
                --this.poolSize;
                if ((this.runState == 1 || this.runState == 2) && this.poolSize <= 0) {
                    this.logger.trace("Signalling termination of repository connection pool for {0}", new Object[]{this.getSourceName()});
                    this.runState = 3;
                    this.termination.signalAll();
                    this.logger.trace("Terminated repository connection pool for {0}", new Object[]{this.getSourceName()});
                }
                v1 = null;
                break block9;
            }
            catch (Throwable throwable) {
                v1 = null;
            }
            {
            }
        }
        Object var7_9 = v1;
        mainLock2.unlock();
    }

    @GuardedBy(value="mainLock")
    protected int drainUnusedConnections(int count) {
        if (count <= 0) {
            return 0;
        }
        this.logger.trace("Draining up to {0} unused repository connections to {1}", new Object[]{count, this.getSourceName()});
        LinkedList extraConnections = new LinkedList();
        this.availableConnections.drainTo(extraConnections, count);
        for (ConnectionWrapper connection : extraConnections) {
            this.logger.trace("Closing repository connection to {0}", new Object[]{this.getSourceName()});
            connection.getOriginal().close();
        }
        int numClosed = extraConnections.size();
        this.poolSize -= numClosed;
        this.logger.trace("Drained {0} unused connections ({1} open connections remain)", new Object[]{numClosed, this.poolSize});
        return numClosed;
    }

    @GuardedBy(value="mainLock")
    protected boolean addConnectionIfUnderCorePoolSize() throws RepositorySourceException {
        if (this.poolSize < this.corePoolSize) {
            this.availableConnections.offer(this.newWrappedConnection());
            this.logger.trace("Added connection to {0} in undersized pool", new Object[]{this.getSourceName()});
            return true;
        }
        return false;
    }

    @GuardedBy(value="mainLock")
    protected int addConnectionsIfUnderCorePoolSize() throws RepositorySourceException {
        int n = 0;
        while (this.poolSize < this.corePoolSize) {
            this.availableConnections.offer(this.newWrappedConnection());
            ++n;
        }
        this.logger.trace("Added {0} connection(s) to {1} in undersized pool", new Object[]{n, this.getSourceName()});
        return n;
    }

    protected class ConnectionWrapper
    implements RepositoryConnection {
        private final RepositoryConnection original;
        private final long timeCreated;
        private long lastUsed;
        private boolean closed = false;

        protected ConnectionWrapper(RepositoryConnection connection) {
            assert (connection != null);
            this.original = connection;
            this.timeCreated = System.currentTimeMillis();
        }

        protected RepositoryConnection getOriginal() {
            return this.original;
        }

        public long getTimeLastUsed() {
            return this.lastUsed;
        }

        public long getTimeCreated() {
            return this.timeCreated;
        }

        public String getSourceName() {
            return this.original.getSourceName();
        }

        public XAResource getXAResource() {
            if (this.closed) {
                throw new IllegalStateException(GraphI18n.closedConnectionMayNotBeUsed.text(new Object[0]));
            }
            return this.original.getXAResource();
        }

        public CachePolicy getDefaultCachePolicy() {
            if (this.closed) {
                throw new IllegalStateException(GraphI18n.closedConnectionMayNotBeUsed.text(new Object[0]));
            }
            return this.original.getDefaultCachePolicy();
        }

        public void execute(ExecutionContext context, Request request) throws RepositorySourceException {
            if (this.closed) {
                throw new IllegalStateException(GraphI18n.closedConnectionMayNotBeUsed.text(new Object[0]));
            }
            this.original.execute(context, request);
        }

        public boolean ping(long time, TimeUnit unit) throws InterruptedException {
            if (this.closed) {
                throw new IllegalStateException(GraphI18n.closedConnectionMayNotBeUsed.text(new Object[0]));
            }
            return this.original.ping(time, unit);
        }

        public void close() {
            if (!this.closed) {
                this.lastUsed = System.currentTimeMillis();
                this.closed = true;
                RepositoryConnectionPool.this.returnConnection(this);
            }
        }
    }
}

