/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.connector.federation;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import javax.transaction.xa.XAResource;
import org.modeshape.common.statistic.Stopwatch;
import org.modeshape.common.util.Logger;
import org.modeshape.graph.ExecutionContext;
import org.modeshape.graph.cache.CachePolicy;
import org.modeshape.graph.connector.RepositoryConnection;
import org.modeshape.graph.connector.RepositorySourceException;
import org.modeshape.graph.connector.federation.FederatedRepository;
import org.modeshape.graph.connector.federation.FederatedRequest;
import org.modeshape.graph.connector.federation.ForkRequestProcessor;
import org.modeshape.graph.connector.federation.JoinRequestProcessor;
import org.modeshape.graph.connector.federation.NoMoreFederatedRequests;
import org.modeshape.graph.observe.Observer;
import org.modeshape.graph.property.DateTime;
import org.modeshape.graph.request.CompositeRequest;
import org.modeshape.graph.request.Request;
import org.modeshape.graph.request.processor.RequestProcessor;

class FederatedRepositoryConnection
implements RepositoryConnection {
    private final FederatedRepository repository;
    private final Stopwatch stopwatch;
    private final Logger logger;
    private final Observer observer;

    FederatedRepositoryConnection(FederatedRepository repository, Observer observer) {
        this.repository = repository;
        this.logger = Logger.getLogger(this.getClass());
        this.stopwatch = this.logger.isTraceEnabled() ? new Stopwatch() : null;
        this.observer = observer;
    }

    FederatedRepository getRepository() {
        return this.repository;
    }

    public CachePolicy getDefaultCachePolicy() {
        return this.repository.getDefaultCachePolicy();
    }

    public String getSourceName() {
        return this.repository.getSourceName();
    }

    public XAResource getXAResource() {
        return null;
    }

    public boolean ping(long time, TimeUnit unit) {
        return true;
    }

    protected boolean shouldProcessSynchronously(Request request) {
        if (request instanceof CompositeRequest) {
            CompositeRequest composite = (CompositeRequest)request;
            return composite.size() == 1;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void execute(ExecutionContext context, final Request request) throws RepositorySourceException {
        RequestProcessor processorWithEvents;
        boolean abort;
        block33: {
            DateTime nowInUtc = context.getValueFactories().getDateFactory().createUtc();
            boolean synchronousStep1 = this.shouldProcessSynchronously(request);
            boolean awaitAllSubtasks = false;
            if (this.stopwatch != null) {
                this.stopwatch.start();
            }
            abort = false;
            processorWithEvents = null;
            try {
                try {
                    final LinkedBlockingQueue<FederatedRequest> requests = new LinkedBlockingQueue<FederatedRequest>();
                    final ForkRequestProcessor fork = new ForkRequestProcessor(this.repository, context, nowInUtc, requests);
                    if (synchronousStep1) {
                        try {
                            fork.process(request);
                            Object var11_14 = null;
                            fork.close();
                        }
                        catch (Throwable throwable) {
                            Object var11_15 = null;
                            fork.close();
                            throw throwable;
                        }
                        requests.add(new NoMoreFederatedRequests());
                    } else {
                        this.repository.getExecutor().submit(new Runnable(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            public void run() {
                                try {
                                    fork.process(request);
                                    Object var2_1 = null;
                                    fork.close();
                                }
                                catch (Throwable throwable) {
                                    Object var2_2 = null;
                                    fork.close();
                                    throw throwable;
                                }
                                requests.add(new NoMoreFederatedRequests());
                            }
                        });
                    }
                    JoinRequestProcessor join = new JoinRequestProcessor(this.repository, context, this.observer, nowInUtc);
                    try {
                        try {
                            join.process((BlockingQueue<FederatedRequest>)requests);
                        }
                        catch (RuntimeException e) {
                            abort = true;
                            throw e;
                        }
                        Object var13_19 = null;
                    }
                    catch (Throwable throwable) {
                        Object var13_20 = null;
                        fork.await();
                        join.close();
                        processorWithEvents = join;
                        throw throwable;
                    }
                    fork.await();
                    join.close();
                    processorWithEvents = join;
                    if (request instanceof CompositeRequest) {
                        ((CompositeRequest)request).checkForErrors();
                    }
                    if (request.hasError() && !request.isReadOnly()) {
                        abort = true;
                    }
                }
                catch (InterruptedException e) {
                    abort = true;
                    request.setError(e);
                    Object var15_23 = null;
                    if (this.stopwatch != null) {
                        this.stopwatch.stop();
                    }
                    if (abort) {
                        return;
                    }
                    assert (processorWithEvents != null);
                    processorWithEvents.notifyObserverOfChanges();
                    return;
                }
                catch (ExecutionException e) {
                    abort = true;
                    request.setError(e);
                    Object var15_24 = null;
                    if (this.stopwatch != null) {
                        this.stopwatch.stop();
                    }
                    if (abort) {
                        return;
                    }
                    assert (processorWithEvents != null);
                    processorWithEvents.notifyObserverOfChanges();
                    return;
                }
                catch (CancellationException e) {
                    abort = true;
                    request.cancel();
                    Object var15_25 = null;
                    if (this.stopwatch != null) {
                        this.stopwatch.stop();
                    }
                    if (abort) {
                        return;
                    }
                    assert (processorWithEvents != null);
                    processorWithEvents.notifyObserverOfChanges();
                    return;
                }
                catch (RuntimeException e) {
                    abort = true;
                    throw e;
                }
                Object var15_22 = null;
                if (this.stopwatch == null) break block33;
            }
            catch (Throwable throwable) {
                Object var15_26 = null;
                if (this.stopwatch != null) {
                    this.stopwatch.stop();
                }
                if (abort) {
                    throw throwable;
                }
                assert (processorWithEvents != null);
                processorWithEvents.notifyObserverOfChanges();
                throw throwable;
            }
            this.stopwatch.stop();
        }
        if (abort) {
            return;
        }
        assert (processorWithEvents != null);
        processorWithEvents.notifyObserverOfChanges();
    }

    public void close() {
        if (this.stopwatch != null) {
            this.logger.trace("Processing federated requests:\n" + this.stopwatch.getDetailedStatistics(), new Object[0]);
        }
    }
}

