/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.connector.federation;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import javax.naming.spi.ObjectFactory;
import net.jcip.annotations.GuardedBy;
import net.jcip.annotations.NotThreadSafe;
import org.modeshape.common.i18n.I18n;
import org.modeshape.common.util.CheckArg;
import org.modeshape.common.util.HashCode;
import org.modeshape.common.util.NamedThreadFactory;
import org.modeshape.graph.ExecutionContext;
import org.modeshape.graph.GraphI18n;
import org.modeshape.graph.Location;
import org.modeshape.graph.ModeShapeLexicon;
import org.modeshape.graph.Node;
import org.modeshape.graph.Subgraph;
import org.modeshape.graph.SubgraphNode;
import org.modeshape.graph.cache.BasicCachePolicy;
import org.modeshape.graph.cache.CachePolicy;
import org.modeshape.graph.connector.RepositoryConnection;
import org.modeshape.graph.connector.RepositoryConnectionFactory;
import org.modeshape.graph.connector.RepositoryContext;
import org.modeshape.graph.connector.RepositorySource;
import org.modeshape.graph.connector.RepositorySourceCapabilities;
import org.modeshape.graph.connector.RepositorySourceException;
import org.modeshape.graph.connector.federation.FederatedRepository;
import org.modeshape.graph.connector.federation.FederatedRepositoryConnection;
import org.modeshape.graph.connector.federation.FederatedWorkspace;
import org.modeshape.graph.connector.federation.Projection;
import org.modeshape.graph.connector.federation.ProjectionParser;
import org.modeshape.graph.observe.Observer;
import org.modeshape.graph.property.NamespaceRegistry;
import org.modeshape.graph.property.Path;
import org.modeshape.graph.property.Property;
import org.modeshape.graph.property.ValueFactories;
import org.modeshape.graph.property.ValueFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NotThreadSafe
public class FederatedRepositorySource
implements RepositorySource,
ObjectFactory {
    public static final int DEFAULT_RETRY_LIMIT = 0;
    protected static final String SOURCE_NAME = "sourceName";
    protected static final String RETRY_LIMIT = "retryLimit";
    private static final long serialVersionUID = 1L;
    private volatile String name;
    private volatile int retryLimit;
    private volatile RepositorySourceCapabilities capabilities = new RepositorySourceCapabilities(true, true, false, false, true);
    private volatile transient FederatedRepository configuration;
    private volatile transient RepositoryContext context;

    @Override
    public String getName() {
        return this.name;
    }

    public synchronized void setName(String name) {
        if (this.name == name || this.name != null && this.name.equals(name)) {
            return;
        }
        this.name = name;
        this.changeConfiguration();
    }

    @Override
    public int getRetryLimit() {
        return this.retryLimit;
    }

    @Override
    public synchronized void setRetryLimit(int limit) {
        this.retryLimit = limit < 0 ? 0 : limit;
        this.changeConfiguration();
    }

    @Override
    public RepositorySourceCapabilities getCapabilities() {
        return this.capabilities;
    }

    @Override
    public synchronized void initialize(RepositoryContext context) throws RepositorySourceException {
        this.context = context;
        this.changeConfiguration();
    }

    RepositoryContext getRepositoryContext() {
        return this.context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RepositoryConnection getConnection() throws RepositorySourceException {
        FederatedRepository config = this.configuration;
        if (config == null) {
            FederatedRepositorySource federatedRepositorySource = this;
            synchronized (federatedRepositorySource) {
                if (this.configuration == null) {
                    String name = this.getName();
                    if (name == null) {
                        I18n msg = GraphI18n.namePropertyIsRequiredForFederatedRepositorySource;
                        throw new RepositorySourceException(this.getName(), msg.text(new Object[]{"name"}));
                    }
                    RepositoryContext repositoryContext = this.getRepositoryContext();
                    if (repositoryContext == null) {
                        I18n msg = GraphI18n.federatedRepositorySourceMustBeInitialized;
                        throw new RepositorySourceException(this.getName(), msg.text(new Object[]{"name", name}));
                    }
                    this.configuration = this.loadRepository(name, repositoryContext);
                }
                config = this.configuration;
            }
        }
        Observer observer = this.context != null ? this.context.getObserver() : null;
        return new FederatedRepositoryConnection(config, observer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        FederatedRepositorySource federatedRepositorySource = this;
        synchronized (federatedRepositorySource) {
            if (this.configuration != null) {
                if (this.configuration.getExecutor() != null) {
                    this.configuration.getExecutor().shutdown();
                }
                this.configuration = null;
            }
        }
    }

    @Override
    public Reference getReference() {
        String className = this.getClass().getName();
        String factoryClassName = this.getClass().getName();
        Reference ref = new Reference(className, factoryClassName, null);
        ref.add(new StringRefAddr(SOURCE_NAME, this.getName()));
        ref.add(new StringRefAddr(RETRY_LIMIT, Integer.toString(this.getRetryLimit())));
        return ref;
    }

    @Override
    public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable<?, ?> environment) throws Exception {
        if (obj instanceof Reference) {
            HashMap<String, String> values = new HashMap<String, String>();
            Reference ref = (Reference)obj;
            Enumeration<RefAddr> en = ref.getAll();
            while (en.hasMoreElements()) {
                RefAddr subref = en.nextElement();
                if (!(subref instanceof StringRefAddr)) continue;
                String key = subref.getType();
                Object value = subref.getContent();
                if (value == null) continue;
                values.put(key, value.toString());
            }
            String sourceName = (String)values.get(SOURCE_NAME);
            String retryLimit = (String)values.get(RETRY_LIMIT);
            FederatedRepositorySource source = new FederatedRepositorySource();
            if (sourceName != null) {
                source.setName(sourceName);
            }
            if (retryLimit != null) {
                source.setRetryLimit(Integer.parseInt(retryLimit));
            }
            return source;
        }
        return null;
    }

    public int hashCode() {
        return HashCode.compute((Object[])new Object[]{this.getName()});
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof FederatedRepositorySource) {
            FederatedRepositorySource that = (FederatedRepositorySource)obj;
            return !(this.getName() == null ? that.getName() != null : !this.getName().equals(that.getName()));
        }
        return false;
    }

    @GuardedBy(value="this")
    protected void changeConfiguration() {
        this.configuration = null;
    }

    protected FederatedRepository loadRepository(String name, RepositoryContext repositoryContext) throws RepositorySourceException {
        ExecutionContext executionContext = repositoryContext.getExecutionContext();
        RepositoryConnectionFactory connectionFactory = repositoryContext.getRepositoryConnectionFactory();
        ValueFactories valueFactories = executionContext.getValueFactories();
        ValueFactory<String> strings = valueFactories.getStringFactory();
        ValueFactory<Long> longs = valueFactories.getLongFactory();
        ProjectionParser projectionParser = ProjectionParser.getInstance();
        NamespaceRegistry registry = executionContext.getNamespaceRegistry();
        try {
            SubgraphNode workspacesNode;
            Subgraph repositories = repositoryContext.getConfiguration(5);
            String defaultWorkspaceName = null;
            Property defaultWorkspaceNameProperty = repositories.getRoot().getProperty(ModeShapeLexicon.DEFAULT_WORKSPACE_NAME);
            if (defaultWorkspaceNameProperty != null) {
                defaultWorkspaceName = strings.create(defaultWorkspaceNameProperty.getFirstValue());
            }
            CachePolicy defaultCachePolicy = null;
            Property timeToExpire = repositories.getRoot().getProperty(ModeShapeLexicon.TIME_TO_EXPIRE);
            if (timeToExpire != null && !timeToExpire.isEmpty()) {
                long timeToCacheInMillis = longs.create(timeToExpire.getFirstValue());
                defaultCachePolicy = new BasicCachePolicy(timeToCacheInMillis, TimeUnit.MILLISECONDS).getUnmodifiable();
            }
            if ((workspacesNode = repositories.getNode(ModeShapeLexicon.WORKSPACES)) == null) {
                I18n msg = GraphI18n.requiredNodeDoesNotExistRelativeToNode;
                throw new RepositorySourceException(msg.text(new Object[]{ModeShapeLexicon.WORKSPACES.getString(registry), repositories.getLocation().getPath().getString(registry), repositories.getGraph().getCurrentWorkspaceName(), repositories.getGraph().getSourceName()}));
            }
            LinkedList<FederatedWorkspace> workspaces = new LinkedList<FederatedWorkspace>();
            for (Location workspace : workspacesNode) {
                SubgraphNode projectionsNode;
                String workspaceName = null;
                SubgraphNode workspaceNode = (SubgraphNode)repositories.getNode(workspace);
                Property workspaceNameProperty = workspaceNode.getProperty(ModeShapeLexicon.WORKSPACE_NAME);
                if (workspaceNameProperty != null) {
                    workspaceName = strings.create(workspaceNameProperty.getFirstValue());
                }
                if (workspaceName == null) {
                    workspaceName = workspace.getPath().getLastSegment().getName().getLocalName();
                }
                if ((projectionsNode = workspaceNode.getNode(ModeShapeLexicon.PROJECTIONS)) == null) {
                    I18n msg = GraphI18n.requiredNodeDoesNotExistRelativeToNode;
                    throw new RepositorySourceException(this.getName(), msg.text(new Object[]{ModeShapeLexicon.PROJECTIONS.getString(registry), workspaceNode.getLocation().getPath().getString(registry), repositories.getGraph().getCurrentWorkspaceName(), repositories.getGraph().getSourceName()}));
                }
                LinkedList<Projection> sourceProjections = new LinkedList<Projection>();
                for (Location projection : projectionsNode) {
                    Object projectionNode = repositories.getNode(projection);
                    sourceProjections.add(this.createProjection(executionContext, projectionParser, (Node)projectionNode));
                }
                FederatedWorkspace space = new FederatedWorkspace(repositoryContext, name, workspaceName, sourceProjections, defaultCachePolicy);
                if (workspaceName.equals(defaultWorkspaceName)) {
                    workspaces.addFirst(space);
                    continue;
                }
                workspaces.add(space);
            }
            ExecutorService executor = Executors.newCachedThreadPool((ThreadFactory)new NamedThreadFactory(name));
            return new FederatedRepository(name, connectionFactory, workspaces, defaultCachePolicy, executor);
        }
        catch (RepositorySourceException t) {
            throw t;
        }
        catch (Throwable t) {
            I18n msg = GraphI18n.errorReadingConfigurationForFederatedRepositorySource;
            throw new RepositorySourceException(this.getName(), msg.text(new Object[]{name}), t);
        }
    }

    public synchronized FederatedWorkspace addWorkspace(String workspaceName, Iterable<Projection> projections, boolean isDefault) {
        CheckArg.isNotNull((Object)workspaceName, (String)"workspaceName");
        CheckArg.isNotNull(projections, (String)"projections");
        String name = this.getName();
        if (name == null) {
            I18n msg = GraphI18n.namePropertyIsRequiredForFederatedRepositorySource;
            throw new RepositorySourceException(this.getName(), msg.text(new Object[]{"name"}));
        }
        RepositoryContext context = this.getRepositoryContext();
        if (context == null) {
            I18n msg = GraphI18n.federatedRepositorySourceMustBeInitialized;
            throw new RepositorySourceException(this.getName(), msg.text(new Object[]{"name", name}));
        }
        RepositoryConnectionFactory connectionFactory = null;
        ExecutorService executor = null;
        LinkedList<FederatedWorkspace> workspaces = new LinkedList<FederatedWorkspace>();
        CachePolicy defaultCachePolicy = null;
        if (this.configuration != null) {
            connectionFactory = this.configuration.getConnectionFactory();
            executor = this.configuration.getExecutor();
            defaultCachePolicy = this.configuration.getDefaultCachePolicy();
            for (String existingWorkspaceName : this.configuration.getWorkspaceNames()) {
                if (existingWorkspaceName.equals(workspaceName)) continue;
                workspaces.add(this.configuration.getWorkspace(existingWorkspaceName));
            }
        } else {
            connectionFactory = context.getRepositoryConnectionFactory();
            executor = Executors.newCachedThreadPool((ThreadFactory)new NamedThreadFactory(name));
        }
        FederatedWorkspace newWorkspace = new FederatedWorkspace(context, name, workspaceName, projections, defaultCachePolicy);
        if (isDefault) {
            workspaces.addFirst(newWorkspace);
        } else {
            workspaces.add(newWorkspace);
        }
        this.configuration = new FederatedRepository(name, connectionFactory, workspaces, defaultCachePolicy, executor);
        return newWorkspace;
    }

    public synchronized boolean removeWorkspace(String workspaceName) {
        CheckArg.isNotNull((Object)workspaceName, (String)"workspaceName");
        if (this.configuration == null) {
            return false;
        }
        FederatedWorkspace workspace = this.configuration.getWorkspace(workspaceName);
        if (workspace == null) {
            return false;
        }
        LinkedList<FederatedWorkspace> workspaces = new LinkedList<FederatedWorkspace>();
        for (String existingWorkspaceName : this.configuration.getWorkspaceNames()) {
            if (existingWorkspaceName.equals(workspaceName)) continue;
            workspaces.add(this.configuration.getWorkspace(existingWorkspaceName));
        }
        RepositoryConnectionFactory connectionFactory = this.configuration.getConnectionFactory();
        ExecutorService executor = this.configuration.getExecutor();
        CachePolicy defaultCachePolicy = this.configuration.getDefaultCachePolicy();
        this.configuration = new FederatedRepository(this.name, connectionFactory, workspaces, defaultCachePolicy, executor);
        return true;
    }

    public synchronized boolean hasWorkspace(String workspaceName) {
        CheckArg.isNotNull((Object)workspaceName, (String)"workspaceName");
        return this.configuration != null && this.configuration.getWorkspaceNames().contains(workspaceName);
    }

    protected Projection createProjection(ExecutionContext context, ProjectionParser projectionParser, Node node) {
        String[] projectionRuleStrs;
        ValueFactory<String> strings = context.getValueFactories().getStringFactory();
        Path path = node.getLocation().getPath();
        String sourceName = path.getLastSegment().getName().getLocalName();
        Property sourceNameProperty = node.getProperty(ModeShapeLexicon.SOURCE_NAME);
        if (sourceNameProperty != null && !sourceNameProperty.isEmpty()) {
            sourceName = strings.create(sourceNameProperty.getFirstValue());
        }
        assert (sourceName != null);
        String workspaceName = null;
        Property workspaceNameProperty = node.getProperty(ModeShapeLexicon.WORKSPACE_NAME);
        if (workspaceNameProperty != null && !workspaceNameProperty.isEmpty()) {
            workspaceName = strings.create(workspaceNameProperty.getFirstValue());
        }
        Projection.Rule[] projectionRules = null;
        Property projectionRulesProperty = node.getProperty(ModeShapeLexicon.PROJECTION_RULES);
        if (projectionRulesProperty != null && !projectionRulesProperty.isEmpty() && (projectionRuleStrs = strings.create(projectionRulesProperty.getValuesAsArray())) != null && projectionRuleStrs.length != 0) {
            projectionRules = projectionParser.rulesFromStrings(context, projectionRuleStrs);
        }
        boolean readOnly = false;
        Property readOnlyProperty = node.getProperty(ModeShapeLexicon.READ_ONLY);
        if (readOnlyProperty != null && !readOnlyProperty.isEmpty()) {
            readOnly = context.getValueFactories().getBooleanFactory().create(readOnlyProperty.getFirstValue());
        }
        return new Projection(sourceName, workspaceName, readOnly, projectionRules);
    }
}

