/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.connector.path.cache;

import java.lang.ref.SoftReference;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.jcip.annotations.ThreadSafe;
import org.modeshape.graph.connector.path.PathNode;
import org.modeshape.graph.connector.path.cache.CacheStatistics;
import org.modeshape.graph.connector.path.cache.DefaultCacheStatistics;
import org.modeshape.graph.connector.path.cache.PathCachePolicy;
import org.modeshape.graph.connector.path.cache.WorkspaceCache;
import org.modeshape.graph.property.Path;

@ThreadSafe
public class InMemoryWorkspaceCache
implements WorkspaceCache {
    private final ConcurrentMap<Path, CacheEntry> nodesByPath = new ConcurrentHashMap<Path, CacheEntry>();
    private PathCachePolicy policy = null;
    private DefaultCacheStatistics statistics = new DefaultCacheStatistics();

    public void initialize(PathCachePolicy policy, String workspaceName) {
        if (this.policy != null) {
            throw new IllegalStateException();
        }
        this.policy = policy;
    }

    protected PathCachePolicy policy() {
        return this.policy;
    }

    public void clearStatistics() {
        this.statistics = new DefaultCacheStatistics();
    }

    public CacheStatistics getStatistics() {
        return this.statistics;
    }

    public PathNode get(Path path) {
        assert (path != null);
        CacheEntry entry = (CacheEntry)this.nodesByPath.get(path);
        if (entry == null) {
            this.statistics.incrementMisses();
            return null;
        }
        PathNode node = entry.getNode();
        if (node != null) {
            this.statistics.incrementHits();
            return node;
        }
        this.nodesByPath.remove(path, entry);
        this.statistics.incrementExpirations();
        return null;
    }

    public void set(PathNode node) {
        assert (node != null);
        if (!this.policy.shouldCache(node)) {
            return;
        }
        this.statistics.incrementWrites();
        this.nodesByPath.put(node.getPath(), new CacheEntry(node));
    }

    public void invalidate(Path path) {
        assert (path != null);
        Iterator iter = this.nodesByPath.keySet().iterator();
        while (iter.hasNext()) {
            Path key = (Path)iter.next();
            if (!key.isAtOrBelow(path)) continue;
            iter.remove();
        }
    }

    public void close() {
        assert (this.statistics != null) : "Attempt to close an already-closed cache";
        this.nodesByPath.clear();
        this.statistics = null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class InMemoryCachePolicy
    implements PathCachePolicy {
        private static final long serialVersionUID = 1L;
        private final long cacheTimeToLiveInSeconds;

        public InMemoryCachePolicy(long cacheTimeToLiveInSeconds) {
            this.cacheTimeToLiveInSeconds = cacheTimeToLiveInSeconds;
        }

        @Override
        public boolean shouldCache(PathNode node) {
            return true;
        }

        @Override
        public long getTimeToLive() {
            return this.cacheTimeToLiveInSeconds;
        }

        @Override
        public Class<? extends WorkspaceCache> getCacheClass() {
            return InMemoryWorkspaceCache.class;
        }
    }

    class CacheEntry {
        private final SoftReference<PathNode> ref;
        private final long expiryTime;

        CacheEntry(PathNode node) {
            this.ref = new SoftReference<PathNode>(node);
            this.expiryTime = System.currentTimeMillis() + InMemoryWorkspaceCache.this.policy().getTimeToLive() * 1000L;
        }

        PathNode getNode() {
            if (System.currentTimeMillis() > this.expiryTime) {
                return null;
            }
            return this.ref.get();
        }
    }
}

