/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.property.basic;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.jcip.annotations.Immutable;
import org.modeshape.common.text.Inflector;
import org.modeshape.common.util.CheckArg;
import org.modeshape.graph.GraphI18n;
import org.modeshape.graph.property.InvalidPathException;
import org.modeshape.graph.property.Path;
import org.modeshape.graph.property.basic.AbstractPath;
import org.modeshape.graph.property.basic.RootPath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
public class BasicPath
extends AbstractPath {
    private static final long serialVersionUID = 1L;
    private static final List<Path.Segment> EMPTY_SEGMENTS = Collections.emptyList();
    public static final Path EMPTY_RELATIVE = new BasicPath(EMPTY_SEGMENTS, false);
    public static final Path SELF_PATH = new BasicPath(Collections.singletonList(Path.SELF_SEGMENT), false);
    public static final Path PARENT_PATH = new BasicPath(Collections.singletonList(Path.PARENT_SEGMENT), false);
    private final List<Path.Segment> segments;
    private final boolean absolute;
    private final boolean normalized;

    public BasicPath(List<Path.Segment> segments, boolean absolute) {
        assert (segments != null);
        this.segments = Collections.unmodifiableList(segments);
        this.absolute = absolute;
        this.normalized = this.isNormalized(this.segments);
    }

    @Override
    public Path getAncestor(int degree) {
        CheckArg.isNonNegative((int)degree, (String)"degree");
        if (degree == 0) {
            return this;
        }
        int endIndex = this.segments.size() - degree;
        if (endIndex == 0) {
            return this.isAbsolute() ? RootPath.INSTANCE : null;
        }
        if (endIndex < 0) {
            String msg = GraphI18n.pathAncestorDegreeIsInvalid.text(new Object[]{this.getString(), Inflector.getInstance().ordinalize(degree)});
            throw new InvalidPathException(msg);
        }
        return this.subpath(0, endIndex);
    }

    @Override
    protected Iterator<Path.Segment> getSegmentsOfParent() {
        int size = this.segments.size();
        if (size == 1) {
            return EMPTY_PATH_ITERATOR;
        }
        return this.segments.subList(0, size - 1).iterator();
    }

    @Override
    public List<Path.Segment> getSegmentsList() {
        return this.segments;
    }

    @Override
    public boolean isAbsolute() {
        return this.absolute;
    }

    @Override
    public boolean isNormalized() {
        return this.normalized;
    }

    @Override
    public boolean isRoot() {
        return false;
    }

    @Override
    public int size() {
        return this.segments.size();
    }
}

